/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.relocated.okhttp3.internal.http1;

import com.apollographql.apollo.relocated.okhttp3.Headers;
import com.apollographql.apollo.relocated.okhttp3.HttpUrl;
import com.apollographql.apollo.relocated.okhttp3.OkHttpClient;
import com.apollographql.apollo.relocated.okhttp3.Request;
import com.apollographql.apollo.relocated.okhttp3.Response;
import com.apollographql.apollo.relocated.okhttp3.Response$Builder;
import com.apollographql.apollo.relocated.okhttp3.internal.Util;
import com.apollographql.apollo.relocated.okhttp3.internal.connection.RealConnection;
import com.apollographql.apollo.relocated.okhttp3.internal.http.ExchangeCodec;
import com.apollographql.apollo.relocated.okhttp3.internal.http.HttpHeaders;
import com.apollographql.apollo.relocated.okhttp3.internal.http.StatusLine;
import com.apollographql.apollo.relocated.okhttp3.internal.http.StatusLine$Companion;
import com.apollographql.apollo.relocated.okhttp3.internal.http1.HeadersReader;
import com.apollographql.apollo.relocated.okhttp3.internal.http1.Http1ExchangeCodec$ChunkedSink;
import com.apollographql.apollo.relocated.okhttp3.internal.http1.Http1ExchangeCodec$ChunkedSource;
import com.apollographql.apollo.relocated.okhttp3.internal.http1.Http1ExchangeCodec$FixedLengthSource;
import com.apollographql.apollo.relocated.okhttp3.internal.http1.Http1ExchangeCodec$KnownLengthSink;
import com.apollographql.apollo.relocated.okhttp3.internal.http1.Http1ExchangeCodec$UnknownLengthSource;
import com.apollographql.apollo.relocated.okio.BufferedSink;
import com.apollographql.apollo.relocated.okio.BufferedSource;
import com.apollographql.apollo.relocated.okio.RealBufferedSink;
import com.apollographql.apollo.relocated.okio.RealBufferedSource;
import com.apollographql.apollo.relocated.okio.Sink;
import com.apollographql.apollo.relocated.okio.Source;
import java.io.EOFException;
import java.io.IOException;
import java.net.Proxy;
import java.net.Socket;

public final class Http1ExchangeCodec
implements ExchangeCodec {
    public final OkHttpClient client;
    public final RealConnection connection;
    public final BufferedSource source;
    public final BufferedSink sink;
    public int state;
    public final HeadersReader headersReader;
    public Headers trailers;

    @Override
    public final RealConnection getConnection() {
        return this.connection;
    }

    @Override
    public final Sink createRequestBody(Request request, long l) {
        Object object;
        if ("chunked".equalsIgnoreCase(request.headers.get("Transfer-Encoding"))) {
            if (((Http1ExchangeCodec)object).state == 1) {
                ((Http1ExchangeCodec)object).state = 2;
                return new Http1ExchangeCodec$ChunkedSink((Http1ExchangeCodec)object);
            }
            object = "state: " + ((Http1ExchangeCodec)object).state;
            throw new IllegalStateException(object.toString());
        }
        if (l != -1L) {
            if (((Http1ExchangeCodec)object).state == 1) {
                ((Http1ExchangeCodec)object).state = 2;
                return new Http1ExchangeCodec$KnownLengthSink((Http1ExchangeCodec)object);
            }
            object = "state: " + ((Http1ExchangeCodec)object).state;
            throw new IllegalStateException(object.toString());
        }
        throw new IllegalStateException("Cannot stream a request body without chunked encoding or a known content length!");
    }

    @Override
    public final void cancel() {
        Socket socket = ((Http1ExchangeCodec)((Object)socket)).connection.rawSocket;
        if (socket != null) {
            Util.closeQuietly(socket);
            return;
        }
    }

    @Override
    public final void writeRequestHeaders(Request request) {
        StringBuilder stringBuilder;
        Object object = ((Http1ExchangeCodec)((Object)string)).connection.route.proxy.type();
        ((Object)object).getClass();
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder2();
        stringBuilder.append(request.method);
        stringBuilder.append(' ');
        Object object2 = request.url;
        if (!((HttpUrl)object2).isHttps && object == Proxy.Type.HTTP) {
            stringBuilder2.append(object2);
        } else {
            HttpUrl httpUrl = object2;
            object = httpUrl.encodedPath();
            object2 = httpUrl.encodedQuery();
            if (object2 != null) {
                object = (String)object + '?' + (String)object2;
            }
            stringBuilder2.append((String)object);
        }
        Http1ExchangeCodec http1ExchangeCodec = string;
        StringBuilder stringBuilder3 = stringBuilder2;
        stringBuilder3.append(" HTTP/1.1");
        String string = stringBuilder3.toString();
        http1ExchangeCodec.writeRequest(request.headers, string);
    }

    @Override
    public final long reportedContentLength(Response response2) {
        if (!HttpHeaders.promisesBody(response2)) {
            return 0L;
        }
        String string = "chunked";
        String string2 = null;
        String string3 = response2.headers.get("Transfer-Encoding");
        if (string3 != null) {
            string2 = string3;
        }
        if (string.equalsIgnoreCase(string2)) {
            return -1L;
        }
        return Util.headersContentLength(response2);
    }

    @Override
    public final Source openResponseBodySource(Response object) {
        Object object2;
        if (!HttpHeaders.promisesBody((Response)object)) {
            return ((Http1ExchangeCodec)object2).newFixedLengthSource(0L);
        }
        String string = "chunked";
        String string2 = null;
        String string3 = ((Response)object).headers.get("Transfer-Encoding");
        if (string3 != null) {
            string2 = string3;
        }
        if (string.equalsIgnoreCase(string2)) {
            object = ((Response)object).request.url;
            if (((Http1ExchangeCodec)object2).state == 4) {
                ((Http1ExchangeCodec)object2).state = 5;
                return new Http1ExchangeCodec$ChunkedSource((Http1ExchangeCodec)object2, (HttpUrl)object);
            }
            object2 = "state: " + ((Http1ExchangeCodec)object2).state;
            throw new IllegalStateException(object2.toString());
        }
        long l = Util.headersContentLength((Response)object);
        if (l != -1L) {
            return ((Http1ExchangeCodec)object2).newFixedLengthSource(l);
        }
        if (((Http1ExchangeCodec)object2).state == 4) {
            ((Http1ExchangeCodec)object2).state = 5;
            object = ((Http1ExchangeCodec)object2).connection;
            synchronized (object) {
                ((RealConnection)object).noNewExchanges = true;
                return new Http1ExchangeCodec$UnknownLengthSource((Http1ExchangeCodec)object2);
            }
        }
        object2 = "state: " + ((Http1ExchangeCodec)object2).state;
        throw new IllegalStateException(object2.toString());
    }

    @Override
    public final void flushRequest() {
        this.sink.flush();
    }

    @Override
    public final void finishRequest() {
        this.sink.flush();
    }

    public final void writeRequest(Headers headers, String string) {
        if (((Http1ExchangeCodec)((Object)string2)).state == 0) {
            BufferedSink bufferedSink;
            ((Http1ExchangeCodec)((Object)string2)).sink.writeUtf8(string).writeUtf8("\r\n");
            int n = 0;
            int n2 = headers.namesAndValues.length / 2;
            while (true) {
                bufferedSink = ((Http1ExchangeCodec)((Object)string2)).sink;
                if (n >= n2) break;
                bufferedSink.writeUtf8(headers.namesAndValues[n * 2]).writeUtf8(": ").writeUtf8(headers.value(n)).writeUtf8("\r\n");
                ++n;
            }
            bufferedSink.writeUtf8("\r\n");
            ((Http1ExchangeCodec)((Object)string2)).state = 1;
            return;
        }
        String string2 = "state: " + ((Http1ExchangeCodec)((Object)string2)).state;
        throw new IllegalStateException(string2.toString());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final Response$Builder readResponseHeaders(boolean bl) {
        EOFException eOFException2;
        Object object;
        block11: {
            int n;
            Object object2;
            block10: {
                Response$Builder response$Builder;
                long l;
                Object object3;
                boolean bl2;
                int n2 = ((Http1ExchangeCodec)object).state;
                if (n2 != 1 && n2 != 2 && n2 != 3) {
                    object = "state: " + ((Http1ExchangeCodec)object).state;
                    throw new IllegalStateException(object.toString());
                }
                try {
                    bl2 = bl;
                    object3 = ((Http1ExchangeCodec)object).headersReader;
                    object2 = ((HeadersReader)object3).source.readUtf8LineStrict(((HeadersReader)object3).headerLimit);
                    HeadersReader headersReader = object3;
                    HeadersReader headersReader2 = headersReader;
                    l = headersReader.headerLimit - (long)((String)object2).length();
                }
                catch (EOFException eOFException2) {}
                headersReader2.headerLimit = l;
                object3 = StatusLine$Companion.parse((String)object2);
                object2 = response$Builder;
                ((Response$Builder)object2)();
                ((Response$Builder)object2).protocol = ((StatusLine)object3).protocol;
                ((Response$Builder)object2).code = ((StatusLine)object3).code;
                ((Response$Builder)object2).message = ((StatusLine)object3).message;
                response$Builder.headers = ((Http1ExchangeCodec)object).headersReader.readHeaders().newBuilder();
                if (bl2 && ((StatusLine)object3).code == 100) {
                    return null;
                }
                n = ((StatusLine)object3).code;
                if (n != 100) break block10;
                ((Http1ExchangeCodec)object).state = 3;
                return object2;
                break block11;
            }
            if (102 <= n && n < 200) {
                ((Http1ExchangeCodec)object).state = 3;
                return object2;
            }
            ((Http1ExchangeCodec)object).state = 4;
            return object2;
        }
        object = ((Http1ExchangeCodec)object).connection.route.address.url.redact();
        throw new IOException("unexpected end of stream on ".concat((String)object), eOFException2);
    }

    public final Http1ExchangeCodec$FixedLengthSource newFixedLengthSource(long l) {
        if (((Http1ExchangeCodec)((Object)string)).state == 4) {
            ((Http1ExchangeCodec)((Object)string)).state = 5;
            return new Http1ExchangeCodec$FixedLengthSource((Http1ExchangeCodec)((Object)string), l);
        }
        String string = "state: " + ((Http1ExchangeCodec)((Object)string)).state;
        throw new IllegalStateException(string.toString());
    }

    public Http1ExchangeCodec(OkHttpClient okHttpClient, RealConnection realConnection, RealBufferedSource realBufferedSource, RealBufferedSink realBufferedSink) {
        HeadersReader headersReader;
        realBufferedSource.getClass();
        realBufferedSink.getClass();
        ((Http1ExchangeCodec)((Object)headersReader2)).client = okHttpClient;
        ((Http1ExchangeCodec)((Object)headersReader2)).connection = realConnection;
        ((Http1ExchangeCodec)((Object)headersReader2)).source = realBufferedSource;
        ((Http1ExchangeCodec)((Object)headersReader2)).sink = realBufferedSink;
        HeadersReader headersReader2 = headersReader;
        headersReader = new HeadersReader(realBufferedSource);
        v1.headersReader = headersReader2;
    }
}

