/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.relocated.okhttp3.internal.connection;

import com.apollographql.apollo.relocated.kotlin.collections.CollectionsKt__MutableCollectionsKt;
import com.apollographql.apollo.relocated.kotlin.jvm.internal.Intrinsics;
import com.apollographql.apollo.relocated.okhttp3.Call;
import com.apollographql.apollo.relocated.okhttp3.EventListener;
import com.apollographql.apollo.relocated.okhttp3.Interceptor;
import com.apollographql.apollo.relocated.okhttp3.OkHttpClient;
import com.apollographql.apollo.relocated.okhttp3.Request;
import com.apollographql.apollo.relocated.okhttp3.Response;
import com.apollographql.apollo.relocated.okhttp3.internal.Util;
import com.apollographql.apollo.relocated.okhttp3.internal.cache.CacheInterceptor;
import com.apollographql.apollo.relocated.okhttp3.internal.connection.ConnectInterceptor;
import com.apollographql.apollo.relocated.okhttp3.internal.connection.Exchange;
import com.apollographql.apollo.relocated.okhttp3.internal.connection.ExchangeFinder;
import com.apollographql.apollo.relocated.okhttp3.internal.connection.RealCall$CallReference;
import com.apollographql.apollo.relocated.okhttp3.internal.connection.RealCall$timeout$1;
import com.apollographql.apollo.relocated.okhttp3.internal.connection.RealConnection;
import com.apollographql.apollo.relocated.okhttp3.internal.connection.RealConnectionPool;
import com.apollographql.apollo.relocated.okhttp3.internal.http.BridgeInterceptor;
import com.apollographql.apollo.relocated.okhttp3.internal.http.CallServerInterceptor;
import com.apollographql.apollo.relocated.okhttp3.internal.http.RealInterceptorChain;
import com.apollographql.apollo.relocated.okhttp3.internal.http.RetryAndFollowUpInterceptor;
import com.apollographql.apollo.relocated.okhttp3.internal.platform.Platform;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.ref.Reference;
import java.net.Socket;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public final class RealCall
implements Call {
    public final OkHttpClient client;
    public final Request originalRequest;
    public final boolean forWebSocket;
    public final RealConnectionPool connectionPool;
    public final EventListener eventListener;
    public final RealCall$timeout$1 timeout;
    public final AtomicBoolean executed;
    public Object callStackTrace;
    public ExchangeFinder exchangeFinder;
    public RealConnection connection;
    public boolean timeoutEarlyExit;
    public Exchange interceptorScopedExchange;
    public boolean requestBodyOpen;
    public boolean responseBodyOpen;
    public boolean expectMoreExchanges;
    public volatile boolean canceled;
    public volatile Exchange exchange;
    public volatile RealConnection connectionToCancel;

    public RealCall(OkHttpClient okHttpClient, Request request, boolean bl) {
        RealCall realCall = object;
        object.client = okHttpClient;
        object.originalRequest = request;
        object.forWebSocket = bl;
        object.connectionPool = okHttpClient.connectionPool.delegate;
        realCall.eventListener = okHttpClient.eventListenerFactory.create((Call)object);
        RealCall$timeout$1 realCall$timeout$1 = new RealCall$timeout$1((RealCall)object);
        Object object = TimeUnit.MILLISECONDS;
        realCall$timeout$1.timeout(0L, (TimeUnit)((Object)object));
        realCall.timeout = realCall$timeout$1;
        realCall.executed = new AtomicBoolean();
        realCall.expectMoreExchanges = true;
    }

    public static final String access$toLoggableString(RealCall realCall) {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder();
        String string = realCall.canceled ? "canceled " : "";
        stringBuilder2 = stringBuilder2.append(string);
        string = realCall.forWebSocket ? "web socket" : "call";
        return stringBuilder2.append(string).append(" to ").append(realCall.originalRequest.url.redact()).toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public final IOException callDone(IOException iOException) {
        IOException iOException2;
        RealConnection realConnection;
        boolean bl = Util.assertionsEnabled;
        if (bl) {
            if (Thread.holdsLock(eventListener)) throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST NOT hold lock on " + eventListener));
        }
        if ((realConnection = ((RealCall)((Object)eventListener)).connection) != null) {
            if (bl) {
                if (Thread.holdsLock(realConnection)) throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST NOT hold lock on " + realConnection));
            }
            // MONITORENTER : realConnection
            Socket socket = ((RealCall)((Object)eventListener)).releaseConnectionNoEvents$okhttp();
            if (((RealCall)((Object)eventListener)).connection == null) {
                if (socket != null) {
                    Util.closeQuietly(socket);
                }
                ((RealCall)((Object)eventListener)).eventListener.getClass();
            } else if (socket != null) throw new IllegalStateException("Check failed.");
        }
        if (((RealCall)((Object)eventListener)).timeoutEarlyExit || !((RealCall)((Object)eventListener)).timeout.exit()) {
            iOException2 = iOException;
        } else {
            InterruptedIOException interruptedIOException;
            iOException2 = interruptedIOException;
            interruptedIOException = new InterruptedIOException("timeout");
            if (iOException != null) {
                iOException2.initCause(iOException);
            }
        }
        EventListener eventListener = ((RealCall)((Object)eventListener)).eventListener;
        if (iOException != null) {
            iOException2.getClass();
            eventListener.getClass();
            return iOException2;
        }
        eventListener.getClass();
        return iOException2;
    }

    public final void cancel() {
        if (this.canceled) {
            return;
        }
        this.canceled = true;
        Object object = this.exchange;
        if (object != null) {
            ((Exchange)object).codec.cancel();
        }
        if ((object = this.connectionToCancel) != null && (object = ((RealConnection)object).rawSocket) != null) {
            Util.closeQuietly((Socket)object);
        }
        this.eventListener.getClass();
    }

    public final Response execute() {
        if (this.executed.compareAndSet(false, true)) {
            Response response2;
            RealCall realCall = this;
            realCall.timeout.enter();
            realCall.callStackTrace = Platform.platform.getStackTraceForCloseable();
            realCall.eventListener.getClass();
            try {
                realCall.client.dispatcher.executed$okhttp(this);
                response2 = realCall.getResponseWithInterceptorChain$okhttp();
                this.client.dispatcher.finished$okhttp(this);
            }
            catch (Throwable throwable) {
                this.client.dispatcher.finished$okhttp(this);
                throw throwable;
            }
            return response2;
        }
        throw new IllegalStateException("Already Executed");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final Response getResponseWithInterceptorChain$okhttp() {
        Throwable throwable;
        boolean bl;
        block13: {
            IOException iOException22;
            block14: {
                Object object;
                block12: {
                    ArrayList<Interceptor> arrayList;
                    ArrayList<Interceptor> arrayList2 = arrayList;
                    arrayList2();
                    CollectionsKt__MutableCollectionsKt.addAll(arrayList, this.client.interceptors);
                    arrayList.add(new RetryAndFollowUpInterceptor(this.client));
                    arrayList.add(new BridgeInterceptor(this.client.cookieJar));
                    arrayList.add(new CacheInterceptor());
                    arrayList.add(ConnectInterceptor.INSTANCE);
                    if (!this.forWebSocket) {
                        CollectionsKt__MutableCollectionsKt.addAll(arrayList2, this.client.networkInterceptors);
                    }
                    arrayList2.add(new CallServerInterceptor(this.forWebSocket));
                    RealCall realCall = this;
                    object = realCall.originalRequest;
                    OkHttpClient okHttpClient = realCall.client;
                    int n = okHttpClient.connectTimeoutMillis;
                    int n2 = okHttpClient.readTimeoutMillis;
                    int n3 = okHttpClient.writeTimeoutMillis;
                    bl = false;
                    try {
                        object = new RealInterceptorChain(realCall, arrayList2, 0, null, (Request)object, n, n2, n3).proceed((Request)object);
                        if (this.canceled) break block12;
                        this.noMoreExchanges$okhttp(null);
                        return object;
                    }
                    catch (Throwable throwable2) {
                        break block13;
                    }
                    catch (IOException iOException22) {
                        break block14;
                    }
                }
                try {
                    ((Response)object).close();
                    throw new IOException("Canceled");
                }
                catch (Exception exception) {}
                throw new IOException("Canceled");
                catch (RuntimeException runtimeException) {
                    throw runtimeException;
                }
            }
            boolean bl2 = true;
            try {
                IOException iOException3 = this.noMoreExchanges$okhttp(iOException22);
                IOException iOException4 = iOException3;
                iOException3.getClass();
                throw iOException4;
            }
            catch (Throwable throwable3) {
                bl = bl2;
                throwable = throwable3;
            }
        }
        if (bl) throw throwable;
        this.noMoreExchanges$okhttp(null);
        throw throwable;
    }

    public final void acquireConnectionNoEvents(RealConnection realConnection) {
        if (Util.assertionsEnabled && !Thread.holdsLock(realConnection)) {
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST hold lock on " + realConnection));
        }
        if (this.connection == null) {
            this.connection = realConnection;
            RealCall realCall = this;
            realConnection.calls.add(new RealCall$CallReference(realCall, realCall.callStackTrace));
            return;
        }
        throw new IllegalStateException("Check failed.");
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final IOException messageDone$okhttp(Exchange var1_1, boolean var2_4, boolean var3_5, IOException var4_6) {
        var1_1.getClass();
        if (!var1_1.equals(this.exchange)) {
            return var4_6;
        }
        var1_2 = false;
        var5_7 = false;
        synchronized (this) {
            block16: {
                block14: {
                    if (var2_4) {
                        try {
                            if (this.requestBodyOpen) break block14;
                        }
                        catch (Throwable v0) {
                            ** break block15
                        }
                    }
                    if (!var3_5 || !this.responseBodyOpen) break block16;
                }
                if (var2_4) {
                    this.requestBodyOpen = false;
                }
                if (var3_5) {
                    this.responseBodyOpen = false;
                }
                var2_4 = (var1_2 = this.requestBodyOpen) == false && this.responseBodyOpen == false;
                var5_7 = var1_2 == false && this.responseBodyOpen == false && this.expectMoreExchanges == false ? (var1_2 = true) : (var1_2 = false);
                var1_2 = var2_4;
            }
            ** if (!var1_2) goto lbl30
        }
lbl-1000:
        // 1 sources

        {
            this.exchange = null;
            var1_3 = this.connection;
            if (var1_3 != null) {
                var1_3.incrementSuccessCount$okhttp();
            }
        }
lbl30:
        // 4 sources

        if (var5_7 == false) return var4_6;
        return this.callDone(var4_6);
lbl-1000:
        // 1 sources

        {
            throw v0;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final IOException noMoreExchanges$okhttp(IOException iOException) {
        RealCall realCall = this;
        boolean bl = false;
        synchronized (realCall) {
            Throwable throwable2;
            block6: {
                try {
                    if (realCall.expectMoreExchanges) {
                        this.expectMoreExchanges = false;
                        bl = !this.requestBodyOpen && !this.responseBodyOpen;
                    }
                }
                catch (Throwable throwable2) {
                    break block6;
                }
                // ** MonitorExit[this] (shouldn't be in output)
                if (bl) {
                    return this.callDone(iOException);
                }
                return iOException;
            }
            // ** MonitorExit[this] (shouldn't be in output)
            throw throwable2;
        }
    }

    public final Socket releaseConnectionNoEvents$okhttp() {
        int n;
        ArrayList arrayList;
        RealConnection realConnection;
        block9: {
            realConnection = ((RealCall)((Object)realConnectionPool)).connection;
            realConnection.getClass();
            if (Util.assertionsEnabled && !Thread.holdsLock(realConnection)) {
                throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST hold lock on " + realConnection));
            }
            arrayList = realConnection.calls;
            n = 0;
            int n2 = 0;
            int n3 = arrayList.size();
            while (n2 < n3) {
                Object e = arrayList.get(n2);
                ++n2;
                if (!Intrinsics.areEqual(((Reference)e).get(), realConnectionPool)) {
                    ++n;
                    continue;
                }
                break block9;
            }
            n = -1;
        }
        if (n != -1) {
            arrayList.remove(n);
            ((RealCall)((Object)realConnectionPool)).connection = null;
            if (arrayList.isEmpty()) {
                realConnection.idleAtNs = System.nanoTime();
                RealConnectionPool realConnectionPool = ((RealCall)((Object)realConnectionPool)).connectionPool;
                realConnectionPool.getClass();
                if (Util.assertionsEnabled && !Thread.holdsLock(realConnection)) {
                    throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST hold lock on " + realConnection));
                }
                if (!realConnection.noNewExchanges) {
                    realConnectionPool.cleanupQueue.schedule(realConnectionPool.cleanupTask, 0L);
                } else {
                    RealConnectionPool realConnectionPool2 = realConnectionPool;
                    realConnection.noNewExchanges = true;
                    realConnectionPool2.connections.remove(realConnection);
                    if (realConnectionPool2.connections.isEmpty()) {
                        realConnectionPool.cleanupQueue.cancelAll();
                    }
                    Socket socket = realConnection.socket;
                    socket.getClass();
                    return socket;
                }
            }
            return null;
        }
        throw new IllegalStateException("Check failed.");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void exitNetworkInterceptorExchange$okhttp(boolean bl) {
        RealCall realCall = this;
        synchronized (realCall) {
            Throwable throwable2;
            block5: {
                Exchange exchange;
                boolean bl2;
                try {
                    if (!realCall.expectMoreExchanges) break block5;
                    bl2 = bl;
                    RealCall realCall2 = this;
                }
                catch (Throwable throwable2) {}
                if (bl2 && (exchange = this.exchange) != null) {
                    Exchange exchange2 = exchange;
                    exchange2.codec.cancel();
                    exchange2.call.messageDone$okhttp(exchange, true, true, null);
                }
                this.interceptorScopedExchange = null;
                return;
            }
            String string = "released";
            throw new IllegalStateException(string);
            throw throwable2;
        }
    }

    public final Object clone() {
        RealCall realCall = cloneable;
        Cloneable cloneable = realCall.client;
        Request request = realCall.originalRequest;
        boolean bl = realCall.forWebSocket;
        return new RealCall((OkHttpClient)cloneable, request, bl);
    }
}

