/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.relocated.kotlin.time;

import com.apollographql.apollo.relocated.kotlin.ranges.RangesKt___RangesKt;
import com.apollographql.apollo.relocated.kotlin.text.StringsKt__StringsKt;
import com.apollographql.apollo.relocated.kotlin.time.DurationJvmKt;
import com.apollographql.apollo.relocated.kotlin.time.DurationKt;
import com.apollographql.apollo.relocated.kotlin.time.DurationUnit;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class Duration
implements Comparable {
    public static final long ZERO = Duration.constructor-impl(0L);
    public static final long INFINITE = DurationKt.durationOfMillis(0x3FFFFFFFFFFFFFFFL);
    public static final long NEG_INFINITE = DurationKt.durationOfMillis(-4611686018427387903L);
    public static final /* synthetic */ int $r8$clinit;
    public final long rawValue;

    public final String toString() {
        StringBuilder stringBuilder;
        long l = this.rawValue;
        if (l == 0L) {
            return "0s";
        }
        if (l == INFINITE) {
            return "Infinity";
        }
        if (l == NEG_INFINITE) {
            return "-Infinity";
        }
        boolean bl = Duration.isNegative-impl(l);
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder();
        if (bl) {
            stringBuilder2.append('-');
        }
        if (Duration.isNegative-impl(l)) {
            int n = (int)l & 1;
            l = Duration.constructor-impl((-(l >> 1) << 1) + (long)n);
        }
        long l2 = l;
        long l3 = Duration.toLong-impl(l2, DurationUnit.DAYS);
        int n = Duration.isInfinite-impl(l2) ? 0 : (int)(Duration.toLong-impl(l, DurationUnit.HOURS) % 24L);
        int n2 = Duration.isInfinite-impl(l) ? 0 : (int)(Duration.toLong-impl(l, DurationUnit.MINUTES) % 60L);
        int n3 = Duration.isInfinite-impl(l) ? 0 : (int)(Duration.toLong-impl(l, DurationUnit.SECONDS) % 60L);
        int n4 = Duration.isInfinite-impl(l) ? 0 : (((int)l & 1) == 1 ? (int)((l >> 1) % 1000L * 1000000L) : (int)((l >> 1) % 1000000000L));
        boolean bl2 = l3 != 0L;
        boolean bl3 = n != 0;
        boolean bl4 = n2 != 0;
        boolean bl5 = n3 != 0 || n4 != 0;
        int n5 = 0;
        if (bl2) {
            stringBuilder2.append(l3).append('d');
            n5 = 1;
        }
        if (bl3 || bl2 && (bl4 || bl5)) {
            if (n5++ > 0) {
                stringBuilder2.append(' ');
            }
            stringBuilder2.append(n).append('h');
        }
        if (bl4 || bl5 && (bl3 || bl2)) {
            if (n5++ > 0) {
                stringBuilder2.append(' ');
            }
            stringBuilder2.append(n2).append('m');
        }
        if (bl5) {
            if (n5++ > 0) {
                stringBuilder2.append(' ');
            }
            if (!(n3 != 0 || bl2 || bl3 || bl4)) {
                if (n4 >= 1000000) {
                    int n6 = n4;
                    n4 = n6 / 1000000;
                    Duration.appendFractional-impl(stringBuilder2, n4, n6 % 1000000, 6, "ms", false);
                } else if (n4 >= 1000) {
                    int n7 = n4;
                    n4 = n7 / 1000;
                    Duration.appendFractional-impl(stringBuilder2, n4, n7 % 1000, 3, "us", false);
                } else {
                    stringBuilder2.append(n4).append("ns");
                }
            } else {
                Duration.appendFractional-impl(stringBuilder2, n3, n4, 9, "s", false);
            }
        }
        if (bl && n5 > 1) {
            stringBuilder2.insert(1, '(').append(')');
        }
        return stringBuilder2.toString();
    }

    public final int hashCode() {
        return Long.hashCode(this.rawValue);
    }

    public final boolean equals(Object object) {
        long l = this.rawValue;
        if (!(object instanceof Duration)) {
            return false;
        }
        return l == ((Duration)object).rawValue;
    }

    public final int compareTo(Object object) {
        long l = this.rawValue;
        long l2 = ((Duration)object).rawValue;
        long l3 = l ^ l2;
        if (l3 >= 0L && ((int)l3 & 1) != 0) {
            long l4 = l;
            int n = ((int)l4 & 1) - ((int)l2 & 1);
            if (Duration.isNegative-impl(l4)) {
                return -n;
            }
            return n;
        }
        if (l < l2) {
            return -1;
        }
        if (l == l2) {
            return 0;
        }
        return 1;
    }

    public static final long plus-LRDsOJo(long l, long l2) {
        if (Duration.isInfinite-impl(l)) {
            if (Duration.isInfinite-impl(l2) && (l ^ l2) < 0L) {
                throw new IllegalArgumentException("Summing infinite durations of different signs yields an undefined result.");
            }
            return l;
        }
        if (Duration.isInfinite-impl(l2)) {
            return l2;
        }
        int n = (int)l & 1;
        if (n == ((int)l2 & 1)) {
            l = (l >> 1) + (l2 >> 1);
            if (n == 0) {
                if (-4611686018426999999L <= l && l < 4611686018427000000L) {
                    return Duration.constructor-impl(l << 1);
                }
                return DurationKt.durationOfMillis(l / 1000000L);
            }
            if (-4611686018426L <= l && l < 4611686018427L) {
                return Duration.constructor-impl(l * 1000000L << 1);
            }
            return DurationKt.durationOfMillis(RangesKt___RangesKt.coerceIn(l));
        }
        if (n == 1) {
            long l3 = (l >> 1) + (l2 = (l = l2 >> 1) / 1000000L);
            if (-4611686018426L <= l3 && l3 < 4611686018427L) {
                return Duration.constructor-impl(l3 * 1000000L + (l -= l2 * 1000000L) << 1);
            }
            return DurationKt.durationOfMillis(RangesKt___RangesKt.coerceIn(l3));
        }
        long l4 = (l2 >> 1) + (l2 = (l >>= 1) / 1000000L);
        if (-4611686018426L <= l4 && l4 < 4611686018427L) {
            return Duration.constructor-impl(l4 * 1000000L + (l -= l2 * 1000000L) << 1);
        }
        return DurationKt.durationOfMillis(RangesKt___RangesKt.coerceIn(l4));
    }

    public static final boolean isNegative-impl(long l) {
        return l < 0L;
    }

    public static final boolean isInfinite-impl(long l) {
        return l == INFINITE || l == NEG_INFINITE;
        {
        }
    }

    public static final long toLong-impl(long l, DurationUnit durationUnit) {
        if (l == INFINITE) {
            return Long.MAX_VALUE;
        }
        if (l == NEG_INFINITE) {
            return Long.MIN_VALUE;
        }
        long l2 = l;
        l = l2 >> 1;
        DurationUnit durationUnit2 = ((int)l2 & 1) == 0 ? DurationUnit.NANOSECONDS : DurationUnit.MILLISECONDS;
        return durationUnit.timeUnit.convert(l, durationUnit2.timeUnit);
    }

    public /* synthetic */ Duration(long l) {
        this.rawValue = l;
    }

    public static long constructor-impl(long l) {
        if (DurationJvmKt.durationAssertionsEnabled) {
            if (((int)l & 1) == 0) {
                long l2 = l >> 1;
                if (-4611686018426999999L > l2 || l2 >= 4611686018427000000L) {
                    StringBuilder stringBuilder;
                    StringBuilder stringBuilder2 = stringBuilder;
                    stringBuilder2();
                    throw new AssertionError((Object)stringBuilder.append(l2).append(" ns is out of nanoseconds range").toString());
                }
            } else {
                long l3 = l >> 1;
                if (-4611686018427387903L <= l3 && l3 < 0x4000000000000000L) {
                    if (-4611686018426L <= l3 && l3 < 4611686018427L) {
                        StringBuilder stringBuilder;
                        StringBuilder stringBuilder3 = stringBuilder;
                        stringBuilder3();
                        throw new AssertionError((Object)stringBuilder.append(l3).append(" ms is denormalized").toString());
                    }
                } else {
                    StringBuilder stringBuilder;
                    StringBuilder stringBuilder4 = stringBuilder;
                    stringBuilder4();
                    throw new AssertionError((Object)stringBuilder.append(l3).append(" ms is out of milliseconds range").toString());
                }
            }
        }
        return l;
    }

    public static final void appendFractional-impl(StringBuilder stringBuilder, int n, int n2, int n3, String string, boolean bl) {
        stringBuilder.append(n);
        if (n2 != 0) {
            stringBuilder.append('.');
            String string2 = StringsKt__StringsKt.padStart(String.valueOf(n2), n3);
            n2 = string2.length() + -1;
            if (n2 >= 0) {
                while (true) {
                    int n4 = n2;
                    n3 = n4 + -1;
                    if (string2.charAt(n4) == '0') {
                        if (n3 < 0) break;
                        n2 = n3;
                        continue;
                    }
                    break;
                }
            } else {
                n2 = -1;
            }
            n3 = n2 + 1;
            if (!bl && n3 < 3) {
                stringBuilder.append(string2, 0, n3);
            } else {
                stringBuilder.append(string2, 0, (n2 + 3) / 3 * 3);
            }
        }
        stringBuilder.append(string);
    }
}

