/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.relocated.kotlin.ranges;

import com.apollographql.apollo.relocated.kotlin.internal.ProgressionUtilKt;
import com.apollographql.apollo.relocated.kotlin.jvm.internal.markers.KMappedMarker;
import com.apollographql.apollo.relocated.kotlin.ranges.IntProgressionIterator;
import java.util.Iterator;

public class IntProgression
implements Iterable,
KMappedMarker {
    public final int first;
    public final int last;
    public final int step;

    public IntProgression(int n, int n2, int n3) {
        if (n3 != 0) {
            if (n3 != Integer.MIN_VALUE) {
                this.first = n;
                this.last = ProgressionUtilKt.getProgressionLastElement(n, n2, n3);
                this.step = n3;
                return;
            }
            throw new IllegalArgumentException("Step must be greater than Int.MIN_VALUE to avoid overflow on negation.");
        }
        throw new IllegalArgumentException("Step must be non-zero.");
    }

    public boolean isEmpty() {
        int n = this.first;
        if (this.step > 0) {
            return n > this.last;
        }
        return n < this.last;
    }

    public boolean equals(Object object) {
        block2: {
            block3: {
                if (!(object instanceof IntProgression)) break block2;
                if (this.isEmpty() && ((IntProgression)object).isEmpty()) break block3;
                object = (IntProgression)object;
                if (this.first != ((IntProgression)object).first || this.last != ((IntProgression)object).last || this.step != ((IntProgression)object).step) break block2;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        if (this.isEmpty()) {
            return -1;
        }
        return (this.first * 31 + this.last) * 31 + this.step;
    }

    public String toString() {
        int n = this.first;
        if (this.step > 0) {
            return n + ".." + this.last + " step " + this.step;
        }
        return n + " downTo " + this.last + " step " + -this.step;
    }

    public final Iterator iterator() {
        IntProgression intProgression = this;
        int n = intProgression.first;
        int n2 = intProgression.last;
        int n3 = intProgression.step;
        return new IntProgressionIterator(n, n2, n3);
    }
}

