/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.relocated.okhttp3;

import com.apollographql.apollo.relocated.kotlin.collections.CollectionsKt___CollectionsKt;
import com.apollographql.apollo.relocated.kotlin.comparisons.NaturalOrderComparator;
import com.apollographql.apollo.relocated.kotlin.jvm.internal.Intrinsics;
import com.apollographql.apollo.relocated.okhttp3.CipherSuite;
import com.apollographql.apollo.relocated.okhttp3.CipherSuite$Companion$ORDER_BY_NAME$1;
import com.apollographql.apollo.relocated.okhttp3.ConnectionSpec$Builder;
import com.apollographql.apollo.relocated.okhttp3.TlsVersion;
import com.apollographql.apollo.relocated.okhttp3.internal.Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.net.ssl.SSLSocket;

public final class ConnectionSpec {
    public static final ConnectionSpec MODERN_TLS;
    public static final ConnectionSpec CLEARTEXT;
    public final boolean isTls;
    public final boolean supportsTlsExtensions;
    public final String[] cipherSuitesAsString;
    public final String[] tlsVersionsAsString;

    public ConnectionSpec(boolean bl, boolean bl2, String[] stringArray, String[] stringArray2) {
        this.isTls = bl;
        this.supportsTlsExtensions = bl2;
        this.cipherSuitesAsString = stringArray;
        this.tlsVersionsAsString = stringArray2;
    }

    static {
        Object object = CipherSuite.TLS_AES_128_GCM_SHA256;
        Object object2 = CipherSuite.TLS_AES_256_GCM_SHA384;
        String[] stringArray = CipherSuite.TLS_CHACHA20_POLY1305_SHA256;
        CipherSuite cipherSuite = CipherSuite.TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256;
        CipherSuite cipherSuite2 = CipherSuite.TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256;
        CipherSuite cipherSuite3 = CipherSuite.TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384;
        CipherSuite cipherSuite4 = CipherSuite.TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384;
        CipherSuite cipherSuite5 = CipherSuite.TLS_ECDHE_ECDSA_WITH_CHACHA20_POLY1305_SHA256;
        CipherSuite cipherSuite6 = CipherSuite.TLS_ECDHE_RSA_WITH_CHACHA20_POLY1305_SHA256;
        CipherSuite[] cipherSuiteArray = new CipherSuite[9];
        CipherSuite[] cipherSuiteArray2 = cipherSuiteArray;
        cipherSuiteArray[0] = object;
        cipherSuiteArray[1] = object2;
        cipherSuiteArray[2] = stringArray;
        cipherSuiteArray[3] = cipherSuite;
        cipherSuiteArray[4] = cipherSuite2;
        cipherSuiteArray[5] = cipherSuite3;
        cipherSuiteArray[6] = cipherSuite4;
        cipherSuiteArray[7] = cipherSuite5;
        cipherSuiteArray[8] = cipherSuite6;
        CipherSuite[] cipherSuiteArray3 = new CipherSuite[16];
        CipherSuite[] cipherSuiteArray4 = cipherSuiteArray3;
        cipherSuiteArray3[0] = object;
        cipherSuiteArray3[1] = object2;
        cipherSuiteArray3[2] = stringArray;
        cipherSuiteArray3[3] = cipherSuite;
        cipherSuiteArray3[4] = cipherSuite2;
        cipherSuiteArray3[5] = cipherSuite3;
        cipherSuiteArray3[6] = cipherSuite4;
        cipherSuiteArray3[7] = cipherSuite5;
        cipherSuiteArray3[8] = cipherSuite6;
        cipherSuiteArray3[9] = CipherSuite.TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA;
        cipherSuiteArray3[10] = CipherSuite.TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA;
        cipherSuiteArray3[11] = CipherSuite.TLS_RSA_WITH_AES_128_GCM_SHA256;
        cipherSuiteArray3[12] = CipherSuite.TLS_RSA_WITH_AES_256_GCM_SHA384;
        cipherSuiteArray3[13] = CipherSuite.TLS_RSA_WITH_AES_128_CBC_SHA;
        cipherSuiteArray3[14] = CipherSuite.TLS_RSA_WITH_AES_256_CBC_SHA;
        cipherSuiteArray3[15] = CipherSuite.TLS_RSA_WITH_3DES_EDE_CBC_SHA;
        object = TlsVersion.TLS_1_3;
        object2 = TlsVersion.TLS_1_2;
        stringArray = new ConnectionSpec$Builder().cipherSuites(Arrays.copyOf(cipherSuiteArray2, 9)).tlsVersions(new TlsVersion[]{object, object2});
        boolean bl = true;
        if (stringArray.tls) {
            stringArray.supportsTlsExtensions = bl;
            stringArray = new ConnectionSpec$Builder().cipherSuites(Arrays.copyOf(cipherSuiteArray4, 16)).tlsVersions(new TlsVersion[]{object, object2});
            bl = true;
            boolean bl2 = stringArray.tls;
            if (bl2) {
                stringArray.supportsTlsExtensions = bl;
                stringArray = stringArray.cipherSuites;
                String[] stringArray2 = stringArray.tlsVersions;
                MODERN_TLS = new ConnectionSpec(bl2, bl, stringArray, stringArray2);
                object = new ConnectionSpec$Builder().cipherSuites(Arrays.copyOf(cipherSuiteArray4, 16)).tlsVersions(new TlsVersion[]{object, object2, TlsVersion.TLS_1_1, TlsVersion.TLS_1_0});
                boolean bl3 = true;
                if (((ConnectionSpec$Builder)object).tls) {
                    ((ConnectionSpec$Builder)object).supportsTlsExtensions = bl3;
                    object = null;
                    String[] stringArray3 = null;
                    boolean bl4 = false;
                    bl = false;
                    CLEARTEXT = new ConnectionSpec(bl, bl4, stringArray3, (String[])object);
                    return;
                }
                throw new IllegalArgumentException("no TLS extensions for cleartext connections");
            }
            throw new IllegalArgumentException("no TLS extensions for cleartext connections");
        }
        throw new IllegalArgumentException("no TLS extensions for cleartext connections");
    }

    public final List tlsVersions() {
        block13: {
            ArrayList<String> arrayList;
            String[] stringArray = stringArray.tlsVersionsAsString;
            if (stringArray.tlsVersionsAsString == null) break block13;
            ArrayList<String> arrayList2 = arrayList;
            arrayList = new ArrayList<String>(stringArray.length);
            for (Object object : stringArray) {
                block16: {
                    block17: {
                        block14: {
                            block15: {
                                Intrinsics.checkNotNullParameter(object, "javaName");
                                int n = object.hashCode();
                                if (n == 79201641) break block14;
                                if (n == 79923350) break block15;
                                switch (n) {
                                    default: {
                                        break block16;
                                    }
                                    case -503070501: {
                                        if (object.equals("TLSv1.3")) {
                                            object = TlsVersion.TLS_1_3;
                                            break;
                                        }
                                        break block16;
                                    }
                                    case -503070502: {
                                        if (object.equals("TLSv1.2")) {
                                            object = TlsVersion.TLS_1_2;
                                            break;
                                        }
                                        break block16;
                                    }
                                    case -503070503: {
                                        if (object.equals("TLSv1.1")) {
                                            object = TlsVersion.TLS_1_1;
                                            break;
                                        }
                                        break block16;
                                    }
                                }
                                break block17;
                            }
                            if (!object.equals("TLSv1")) break block16;
                            object = TlsVersion.TLS_1_0;
                            break block17;
                        }
                        if (!object.equals("SSLv3")) break block16;
                        object = TlsVersion.SSL_3_0;
                    }
                    arrayList2.add((String)object);
                    continue;
                }
                throw new IllegalArgumentException("Unexpected TLS version: ".concat((String)object));
            }
            return CollectionsKt___CollectionsKt.toList(arrayList2);
        }
        return null;
    }

    public final void apply$okhttp(SSLSocket sSLSocket, boolean bl) {
        List list;
        ConnectionSpec connectionSpec;
        ConnectionSpec$Builder connectionSpec$Builder;
        int n;
        String[] stringArray;
        String[] stringArray2;
        String[] stringArray3;
        block12: {
            if (((ConnectionSpec)((Object)connectionSpec$Builder3)).cipherSuitesAsString != null) {
                String[] stringArray4 = sSLSocket.getEnabledCipherSuites();
                Intrinsics.checkNotNullExpressionValue(stringArray4, "sslSocket.enabledCipherSuites");
                stringArray3 = Util.intersect(stringArray4, ((ConnectionSpec)((Object)connectionSpec$Builder3)).cipherSuitesAsString, CipherSuite.ORDER_BY_NAME);
            } else {
                stringArray3 = sSLSocket.getEnabledCipherSuites();
            }
            if (((ConnectionSpec)((Object)connectionSpec$Builder3)).tlsVersionsAsString != null) {
                String[] stringArray5 = sSLSocket.getEnabledProtocols();
                Intrinsics.checkNotNullExpressionValue(stringArray5, "sslSocket.enabledProtocols");
                stringArray2 = Util.intersect(stringArray5, ((ConnectionSpec)((Object)connectionSpec$Builder3)).tlsVersionsAsString, NaturalOrderComparator.INSTANCE);
            } else {
                stringArray2 = sSLSocket.getEnabledProtocols();
            }
            stringArray = sSLSocket.getSupportedCipherSuites();
            Intrinsics.checkNotNullExpressionValue(stringArray, "supportedCipherSuites");
            String string = "TLS_FALLBACK_SCSV";
            CipherSuite$Companion$ORDER_BY_NAME$1 cipherSuite$Companion$ORDER_BY_NAME$1 = CipherSuite.ORDER_BY_NAME;
            int n2 = stringArray.length;
            for (n = 0; n < n2; ++n) {
                if (cipherSuite$Companion$ORDER_BY_NAME$1.compare(stringArray[n], string) != 0) {
                    continue;
                }
                break block12;
            }
            n = -1;
        }
        if (bl && n != -1) {
            Intrinsics.checkNotNullExpressionValue(stringArray3, "cipherSuitesIntersection");
            String string = stringArray[n];
            Intrinsics.checkNotNullExpressionValue(string, "supportedCipherSuites[indexOfFallbackScsv]");
            String[] stringArray6 = Arrays.copyOf(stringArray3, stringArray3.length + 1);
            Intrinsics.checkNotNullExpressionValue(stringArray6, "copyOf(this, newSize)");
            stringArray3 = stringArray6;
            stringArray6[stringArray6.length - 1] = string;
        }
        Object object = connectionSpec$Builder;
        ((ConnectionSpec$Builder)object)((ConnectionSpec)((Object)connectionSpec$Builder3));
        Intrinsics.checkNotNullExpressionValue(stringArray3, "cipherSuitesIntersection");
        ConnectionSpec$Builder connectionSpec$Builder2 = connectionSpec$Builder.cipherSuites(Arrays.copyOf(stringArray3, stringArray3.length));
        Intrinsics.checkNotNullExpressionValue(stringArray2, "tlsVersionsIntersection");
        ConnectionSpec$Builder connectionSpec$Builder3 = connectionSpec$Builder2.tlsVersions(Arrays.copyOf(stringArray2, stringArray2.length));
        object = connectionSpec;
        ConnectionSpec$Builder connectionSpec$Builder4 = connectionSpec$Builder3;
        boolean bl2 = connectionSpec$Builder4.tls;
        int n3 = connectionSpec$Builder4.supportsTlsExtensions;
        stringArray2 = connectionSpec$Builder4.cipherSuites;
        stringArray = connectionSpec$Builder4.tlsVersions;
        if (new ConnectionSpec(bl2, n3 != 0, stringArray2, stringArray).tlsVersions() != null) {
            sSLSocket.setEnabledProtocols(stringArray);
        }
        if (stringArray2 != null) {
            ArrayList<CipherSuite> arrayList;
            ArrayList<CipherSuite> arrayList2 = arrayList;
            arrayList = new ArrayList<CipherSuite>(stringArray2.length);
            int n4 = stringArray2.length;
            for (n3 = 0; n3 < n4; ++n3) {
                arrayList2.add(CipherSuite.Companion.forJavaName(stringArray2[n3]));
            }
            list = CollectionsKt___CollectionsKt.toList(arrayList2);
        } else {
            list = null;
        }
        if (list != null) {
            sSLSocket.setEnabledCipherSuites(((ConnectionSpec)object).cipherSuitesAsString);
            return;
        }
    }

    public final boolean isCompatible(SSLSocket sSLSocket) {
        if (!stringArray2.isTls) {
            return false;
        }
        String[] stringArray = stringArray2.tlsVersionsAsString;
        if (stringArray2.tlsVersionsAsString != null && !Util.hasIntersection(stringArray, sSLSocket.getEnabledProtocols(), NaturalOrderComparator.INSTANCE)) {
            return false;
        }
        String[] stringArray2 = stringArray2.cipherSuitesAsString;
        return stringArray2.cipherSuitesAsString == null || Util.hasIntersection(stringArray2, sSLSocket.getEnabledCipherSuites(), CipherSuite.ORDER_BY_NAME);
    }

    public final boolean equals(Object object) {
        if (!(object instanceof ConnectionSpec)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        boolean bl = this.isTls;
        object = (ConnectionSpec)object;
        if (bl != ((ConnectionSpec)object).isTls) {
            return false;
        }
        if (bl) {
            if (!Arrays.equals(this.cipherSuitesAsString, ((ConnectionSpec)object).cipherSuitesAsString)) {
                return false;
            }
            if (!Arrays.equals(this.tlsVersionsAsString, ((ConnectionSpec)object).tlsVersionsAsString)) {
                return false;
            }
            if (this.supportsTlsExtensions != ((ConnectionSpec)object).supportsTlsExtensions) {
                return false;
            }
        }
        return true;
    }

    public final int hashCode() {
        int n = 17;
        if (this.isTls) {
            n = 527;
            Object[] objectArray = this.cipherSuitesAsString;
            int n2 = this.cipherSuitesAsString != null ? Arrays.hashCode(objectArray) : 0;
            n = (n + n2) * 31;
            Object[] objectArray2 = this.tlsVersionsAsString;
            int n3 = this.tlsVersionsAsString != null ? Arrays.hashCode(objectArray2) : 0;
            return (n + n3) * 31 + (this.supportsTlsExtensions ^ 1);
        }
        return n;
    }

    public final String toString() {
        List list;
        StringBuilder stringBuilder;
        if (!this.isTls) {
            return "ConnectionSpec()";
        }
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder("ConnectionSpec(cipherSuites=");
        String[] stringArray = this.cipherSuitesAsString;
        if (this.cipherSuitesAsString != null) {
            ArrayList<CipherSuite> arrayList;
            ArrayList<CipherSuite> arrayList2 = arrayList;
            arrayList = new ArrayList<CipherSuite>(stringArray.length);
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                arrayList2.add(CipherSuite.Companion.forJavaName(stringArray[i]));
            }
            list = CollectionsKt___CollectionsKt.toList(arrayList2);
        } else {
            list = null;
        }
        return stringBuilder2.append(Objects.toString(list, "[all enabled]")).append(", tlsVersions=").append(Objects.toString(this.tlsVersions(), "[all enabled]")).append(", supportsTlsExtensions=").append(this.supportsTlsExtensions).append(')').toString();
    }
}

