/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.relocated.kotlinx.serialization.descriptors;

import com.apollographql.apollo.relocated.kotlin.jvm.JvmClassMappingKt;
import com.apollographql.apollo.relocated.kotlin.jvm.internal.ClassReference;
import com.apollographql.apollo.relocated.kotlin.jvm.internal.Intrinsics;
import com.apollographql.apollo.relocated.kotlinx.serialization.descriptors.SerialDescriptor;
import com.apollographql.apollo.relocated.kotlinx.serialization.descriptors.SerialDescriptorImpl;
import com.apollographql.apollo.relocated.kotlinx.serialization.descriptors.SerialKind;
import java.util.List;

public final class ContextDescriptor
implements SerialDescriptor {
    public final SerialDescriptorImpl original;
    public final ClassReference kClass;
    public final String serialName;

    public ContextDescriptor(SerialDescriptorImpl serialDescriptorImpl, ClassReference classReference) {
        ContextDescriptor contextDescriptor = this;
        this.original = serialDescriptorImpl;
        contextDescriptor.kClass = classReference;
        contextDescriptor.serialName = serialDescriptorImpl.serialName + '<' + classReference.getSimpleName() + '>';
    }

    @Override
    public final List getAnnotations() {
        return this.original.annotations;
    }

    @Override
    public final int getElementsCount() {
        return this.original.elementsCount;
    }

    @Override
    public final boolean isInline() {
        return false;
    }

    @Override
    public final boolean isNullable() {
        return false;
    }

    @Override
    public final SerialKind getKind() {
        return this.original.kind;
    }

    @Override
    public final List getElementAnnotations(int n) {
        return this.original.elementAnnotations[n];
    }

    @Override
    public final SerialDescriptor getElementDescriptor(int n) {
        return this.original.elementDescriptors[n];
    }

    @Override
    public final int getElementIndex(String string) {
        Intrinsics.checkNotNullParameter(string, "name");
        return this.original.getElementIndex(string);
    }

    @Override
    public final String getElementName(int n) {
        return this.original.elementNames[n];
    }

    @Override
    public final String getSerialName() {
        return this.serialName;
    }

    public final boolean equals(Object object) {
        if ((object = object instanceof ContextDescriptor ? (ContextDescriptor)object : null) == null) {
            return false;
        }
        return this.original.equals(((ContextDescriptor)object).original) && ((ContextDescriptor)object).kClass.equals(this.kClass);
    }

    public final int hashCode() {
        ContextDescriptor contextDescriptor = this;
        int n = JvmClassMappingKt.getJavaObjectType(contextDescriptor.kClass).hashCode() * 31;
        return contextDescriptor.serialName.hashCode() + n;
    }

    public final String toString() {
        return "ContextDescriptor(kClass: " + this.kClass + ", original: " + this.original + ')';
    }
}

