/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.relocated.okhttp3.internal.platform;

import com.apollographql.apollo.relocated.kotlin.jvm.internal.Intrinsics;
import com.apollographql.apollo.relocated.okhttp3.internal.platform.OpenJSSEPlatform$Companion;
import com.apollographql.apollo.relocated.okhttp3.internal.platform.Platform;
import com.apollographql.apollo.relocated.okhttp3.internal.platform.Platform$Companion;
import java.security.KeyStore;
import java.security.Provider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.openjsse.javax.net.ssl.SSLSocket;
import org.openjsse.net.ssl.OpenJSSE;

public final class OpenJSSEPlatform
extends Platform {
    public static final boolean isSupported;
    public final Provider provider = (Provider)new OpenJSSE();

    static {
        boolean bl;
        String string = "org.openjsse.net.ssl.OpenJSSE";
        try {
            Class.forName(string, false, OpenJSSEPlatform$Companion.class.getClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            bl = false;
        }
        bl = true;
        isSupported = bl;
    }

    @Override
    public final SSLContext newSSLContext() {
        SSLContext sSLContext = SSLContext.getInstance("TLSv1.3", this.provider);
        Intrinsics.checkNotNullExpressionValue(sSLContext, "getInstance(\"TLSv1.3\", provider)");
        return sSLContext;
    }

    @Override
    public final X509TrustManager platformTrustManager() {
        Object object;
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm(), ((OpenJSSEPlatform)object2).provider);
        trustManagerFactory.init((KeyStore)null);
        Object object2 = trustManagerFactory.getTrustManagers();
        Intrinsics.checkNotNull(object2);
        if (((TrustManager[])object2).length == 1 && (object = object2[0]) instanceof X509TrustManager) {
            Object object3 = object;
            Intrinsics.checkNotNull(object3, "null cannot be cast to non-null type javax.net.ssl.X509TrustManager");
            return (X509TrustManager)object3;
        }
        object2 = Arrays.toString((Object[])object2);
        Intrinsics.checkNotNullExpressionValue(object2, "toString(this)");
        object2 = "Unexpected default trust managers: ".concat((String)object2);
        throw new IllegalStateException(object2.toString());
    }

    @Override
    public final void configureTlsExtensions(javax.net.ssl.SSLSocket object, String string, List list) {
        Intrinsics.checkNotNullParameter(list, "protocols");
        if (object instanceof SSLSocket) {
            Object object2 = (SSLSocket)object;
            if ((object = object2.getSSLParameters()) instanceof org.openjsse.javax.net.ssl.SSLParameters) {
                OpenJSSEPlatform openJSSEPlatform = object2;
                Object object3 = object;
                object2 = Platform$Companion.alpnProtocolNames(list);
                ((org.openjsse.javax.net.ssl.SSLParameters)object3).setApplicationProtocols(((ArrayList)object2).toArray(new String[0]));
                openJSSEPlatform.setSSLParameters((SSLParameters)object3);
                return;
            }
            return;
        }
        super.configureTlsExtensions((javax.net.ssl.SSLSocket)object, string, list);
    }

    @Override
    public final String getSelectedProtocol(javax.net.ssl.SSLSocket sSLSocket) {
        if (sSLSocket instanceof SSLSocket) {
            String string = ((SSLSocket)sSLSocket).getApplicationProtocol();
            if (string == null ? true : Intrinsics.areEqual(string, "")) {
                return null;
            }
            return string;
        }
        return null;
    }
}

