/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.relocated.okhttp3;

import com.apollographql.apollo.relocated.kotlin.jvm.internal.Intrinsics;
import com.apollographql.apollo.relocated.kotlin.text.StringsKt__StringsKt;
import com.apollographql.apollo.relocated.okhttp3.HttpUrl$Builder;
import com.apollographql.apollo.relocated.okhttp3.HttpUrl$Companion;
import com.apollographql.apollo.relocated.okhttp3.internal.Util;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.regex.Pattern;

public final class HttpUrl {
    public static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    public final String scheme;
    public final String username;
    public final String password;
    public final String host;
    public final int port;
    public final ArrayList queryNamesAndValues;
    public final String fragment;
    public final String url;
    public final boolean isHttps;

    public HttpUrl(String string, String string2, String string3, String string4, int n, ArrayList arrayList, ArrayList arrayList2, String string5, String string6) {
        Intrinsics.checkNotNullParameter(string, "scheme");
        Intrinsics.checkNotNullParameter(string4, "host");
        this.scheme = string;
        this.username = string2;
        this.password = string3;
        this.host = string4;
        this.port = n;
        this.queryNamesAndValues = arrayList2;
        this.fragment = string5;
        this.url = string6;
        this.isHttps = string.equals("https");
    }

    public final URI uri() {
        Object object;
        String string;
        HttpUrl$Builder httpUrl$Builder;
        HttpUrl$Builder httpUrl$Builder2 = httpUrl$Builder;
        httpUrl$Builder2();
        httpUrl$Builder.scheme = ((HttpUrl)object).scheme;
        if (((HttpUrl)object).username.length() == 0) {
            string = "";
        } else {
            HttpUrl httpUrl = object;
            int n = httpUrl.scheme.length() + 3;
            String string2 = httpUrl.url;
            int n2 = string2.length();
            n2 = Util.delimiterOffset(string2, ":@", n, n2);
            string = httpUrl.url.substring(n, n2);
            Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String\u2026ing(startIndex, endIndex)");
        }
        HttpUrl httpUrl = object;
        httpUrl$Builder2.encodedUsername = string;
        httpUrl$Builder2.encodedPassword = ((HttpUrl)object).encodedPassword();
        httpUrl$Builder2.host = ((HttpUrl)object).host;
        int n = httpUrl.port;
        String string3 = httpUrl.scheme;
        Intrinsics.checkNotNullParameter(string3, "scheme");
        int n3 = string3.equals("http") ? 80 : (string3.equals("https") ? 443 : -1);
        n = n != n3 ? ((HttpUrl)object).port : -1;
        HttpUrl$Builder httpUrl$Builder3 = httpUrl$Builder2;
        httpUrl$Builder3.port = n;
        httpUrl$Builder3.encodedPathSegments.clear();
        httpUrl$Builder3.encodedPathSegments.addAll(((HttpUrl)object).encodedPathSegments());
        ArrayList arrayList = ((HttpUrl)object).encodedQuery();
        arrayList = arrayList != null ? HttpUrl$Companion.toQueryNamesAndValues$okhttp(HttpUrl$Companion.canonicalize$okhttp$default((String)((Object)arrayList), 0, 0, " \"'<>#", 211)) : null;
        httpUrl$Builder2.encodedQueryNamesAndValues = arrayList;
        if (((HttpUrl)object).fragment == null) {
            object = null;
        } else {
            HttpUrl httpUrl2 = object;
            int n4 = StringsKt__StringsKt.indexOf$default((CharSequence)httpUrl2.url, '#', 0, 6) + 1;
            object = httpUrl2.url.substring(n4);
            Intrinsics.checkNotNullExpressionValue(object, "this as java.lang.String).substring(startIndex)");
        }
        httpUrl$Builder2.encodedFragment = object;
        object = httpUrl$Builder2.host;
        if (object != null) {
            Pattern pattern = Pattern.compile("[\"<>^`{|}]");
            Intrinsics.checkNotNullExpressionValue(pattern, "compile(...)");
            object = "";
            object = pattern.matcher((CharSequence)object).replaceAll((String)object);
            Intrinsics.checkNotNullExpressionValue(object, "replaceAll(...)");
        } else {
            object = null;
        }
        httpUrl$Builder2.host = object;
        int n5 = httpUrl$Builder2.encodedPathSegments.size();
        for (int i = 0; i < n5; ++i) {
            ArrayList arrayList2 = httpUrl$Builder2.encodedPathSegments;
            arrayList2.set(i, HttpUrl$Companion.canonicalize$okhttp$default((String)arrayList2.get(i), 0, 0, "[]", 227));
        }
        Object object2 = httpUrl$Builder2.encodedQueryNamesAndValues;
        if (object2 != null) {
            n3 = object2.size();
            for (n5 = 0; n5 < n3; ++n5) {
                String string4 = (String)object2.get(n5);
                string4 = string4 != null ? HttpUrl$Companion.canonicalize$okhttp$default(string4, 0, 0, "\\^`{|}", 195) : null;
                object2.set(n5, string4);
            }
        }
        object2 = (object2 = httpUrl$Builder2.encodedFragment) != null ? HttpUrl$Companion.canonicalize$okhttp$default((String)object2, 0, 0, " \"#<>\\^`{|}", 163) : null;
        httpUrl$Builder2.encodedFragment = object2;
        object2 = httpUrl$Builder2.toString();
        try {
            return new URI((String)object2);
        }
        catch (URISyntaxException uRISyntaxException) {
            Pattern pattern;
            try {
                pattern = Pattern.compile("[\\u0000-\\u001F\\u007F-\\u009F\\p{javaWhitespace}]");
            }
            catch (Exception exception) {
                throw new RuntimeException(uRISyntaxException);
            }
            Object object3 = object2;
            Intrinsics.checkNotNullExpressionValue(pattern, "compile(...)");
            object2 = "";
            String string5 = pattern.matcher((CharSequence)object3).replaceAll((String)object2);
            Intrinsics.checkNotNullExpressionValue(string5, "replaceAll(...)");
            URI uRI = URI.create(string5);
            Intrinsics.checkNotNullExpressionValue(uRI, "{\n      // Unlikely edge\u2026Unexpected!\n      }\n    }");
            return uRI;
        }
    }

    public final String encodedPassword() {
        if (this.password.length() == 0) {
            return "";
        }
        HttpUrl httpUrl = this;
        int n = StringsKt__StringsKt.indexOf$default((CharSequence)httpUrl.url, ':', this.scheme.length() + 3, 4) + 1;
        int n2 = StringsKt__StringsKt.indexOf$default((CharSequence)httpUrl.url, '@', 0, 6);
        String string = httpUrl.url.substring(n, n2);
        Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String\u2026ing(startIndex, endIndex)");
        return string;
    }

    public final String encodedPath() {
        HttpUrl httpUrl = this;
        int n = StringsKt__StringsKt.indexOf$default((CharSequence)httpUrl.url, '/', this.scheme.length() + 3, 4);
        String string = httpUrl.url;
        int n2 = string.length();
        n2 = Util.delimiterOffset(string, "?#", n, n2);
        String string2 = httpUrl.url.substring(n, n2);
        Intrinsics.checkNotNullExpressionValue(string2, "this as java.lang.String\u2026ing(startIndex, endIndex)");
        return string2;
    }

    public final String encodedQuery() {
        if (this.queryNamesAndValues == null) {
            return null;
        }
        HttpUrl httpUrl = this;
        int n = StringsKt__StringsKt.indexOf$default((CharSequence)httpUrl.url, '?', 0, 6) + 1;
        String string = httpUrl.url;
        int n2 = string.length();
        n2 = Util.delimiterOffset(string, '#', n, n2);
        String string2 = httpUrl.url.substring(n, n2);
        Intrinsics.checkNotNullExpressionValue(string2, "this as java.lang.String\u2026ing(startIndex, endIndex)");
        return string2;
    }

    public final String redact() {
        Object object;
        String string = "/...";
        try {
            object = new HttpUrl$Builder().parse$okhttp((HttpUrl)object, string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            object = null;
        }
        HttpUrl httpUrl = object;
        Intrinsics.checkNotNull(httpUrl);
        ((HttpUrl$Builder)((Object)httpUrl)).encodedUsername = HttpUrl$Companion.canonicalize$okhttp$default("", 0, 0, " \"':;<=>@[]^`{}|/\\?#", 251);
        ((HttpUrl$Builder)((Object)httpUrl)).encodedPassword = HttpUrl$Companion.canonicalize$okhttp$default("", 0, 0, " \"':;<=>@[]^`{}|/\\?#", 251);
        return ((HttpUrl$Builder)((Object)httpUrl)).build().url;
    }

    public final boolean equals(Object object) {
        return object instanceof HttpUrl && Intrinsics.areEqual(((HttpUrl)object).url, this.url);
    }

    public final int hashCode() {
        return this.url.hashCode();
    }

    public final String toString() {
        return this.url;
    }

    public final ArrayList encodedPathSegments() {
        ArrayList<String> arrayList;
        HttpUrl httpUrl = this;
        int n = StringsKt__StringsKt.indexOf$default((CharSequence)httpUrl.url, '/', this.scheme.length() + 3, 4);
        String string = httpUrl.url;
        int n2 = string.length();
        n2 = Util.delimiterOffset(string, "?#", n, n2);
        ArrayList<String> arrayList2 = arrayList;
        arrayList = new ArrayList<String>();
        while (n < n2) {
            HttpUrl httpUrl2 = this;
            int n3 = Util.delimiterOffset(httpUrl2.url, '/', ++n, n2);
            String string2 = httpUrl2.url.substring(n, n3);
            Intrinsics.checkNotNullExpressionValue(string2, "this as java.lang.String\u2026ing(startIndex, endIndex)");
            arrayList2.add(string2);
            n = n3;
        }
        return arrayList2;
    }
}

