/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.relocated.kotlinx.serialization.internal;

import com.apollographql.apollo.relocated.kotlin.collections.EmptyList;
import com.apollographql.apollo.relocated.kotlin.jvm.internal.Intrinsics;
import com.apollographql.apollo.relocated.kotlin.text.StringsKt__StringNumberConversionsKt;
import com.apollographql.apollo.relocated.kotlinx.serialization.descriptors.SerialDescriptor;
import com.apollographql.apollo.relocated.kotlinx.serialization.descriptors.SerialKind;
import com.apollographql.apollo.relocated.kotlinx.serialization.descriptors.StructureKind$LIST;
import java.util.List;

public abstract class ListLikeDescriptor
implements SerialDescriptor {
    public final SerialDescriptor elementDescriptor;

    public ListLikeDescriptor(SerialDescriptor serialDescriptor) {
        this.elementDescriptor = serialDescriptor;
    }

    @Override
    public final SerialKind getKind() {
        return StructureKind$LIST.INSTANCE;
    }

    @Override
    public final int getElementsCount() {
        return 1;
    }

    @Override
    public final String getElementName(int n) {
        return String.valueOf(n);
    }

    @Override
    public final int getElementIndex(String string) {
        String string2 = string;
        Intrinsics.checkNotNullParameter(string2, "name");
        Integer n = StringsKt__StringNumberConversionsKt.toIntOrNull(string2);
        if (n != null) {
            return n;
        }
        throw new IllegalArgumentException(string.concat(" is not a valid list index"));
    }

    @Override
    public final List getElementAnnotations(int n) {
        if (n >= 0) {
            return EmptyList.INSTANCE;
        }
        String string = "Illegal index " + n + ", " + string.getSerialName() + " expects only non-negative indices";
        throw new IllegalArgumentException(string.toString());
    }

    @Override
    public final SerialDescriptor getElementDescriptor(int n) {
        if (n >= 0) {
            return ((ListLikeDescriptor)((Object)string)).elementDescriptor;
        }
        String string = "Illegal index " + n + ", " + string.getSerialName() + " expects only non-negative indices";
        throw new IllegalArgumentException(string.toString());
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ListLikeDescriptor)) {
            return false;
        }
        object = (ListLikeDescriptor)object;
        return Intrinsics.areEqual(this.elementDescriptor, ((ListLikeDescriptor)object).elementDescriptor) && Intrinsics.areEqual(this.getSerialName(), object.getSerialName());
    }

    public final int hashCode() {
        ListLikeDescriptor listLikeDescriptor = this;
        int n = listLikeDescriptor.elementDescriptor.hashCode() * 31;
        return listLikeDescriptor.getSerialName().hashCode() + n;
    }

    public final String toString() {
        return this.getSerialName() + '(' + this.elementDescriptor + ')';
    }

    @Override
    public final boolean isNullable() {
        return false;
    }

    @Override
    public final boolean isInline() {
        return false;
    }

    @Override
    public final List getAnnotations() {
        return EmptyList.INSTANCE;
    }
}

