/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.relocated.okhttp3.internal.platform;

import com.apollographql.apollo.relocated.kotlin.jvm.internal.Intrinsics;
import com.apollographql.apollo.relocated.okhttp3.internal.platform.BouncyCastlePlatform$Companion;
import com.apollographql.apollo.relocated.okhttp3.internal.platform.Platform;
import com.apollographql.apollo.relocated.okhttp3.internal.platform.Platform$Companion;
import java.security.KeyStore;
import java.security.Provider;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.bouncycastle.jsse.BCSSLParameters;
import org.bouncycastle.jsse.BCSSLSocket;
import org.bouncycastle.jsse.provider.BouncyCastleJsseProvider;

public final class BouncyCastlePlatform
extends Platform {
    public static final boolean isSupported;
    public final Provider provider = (Provider)new BouncyCastleJsseProvider();

    static {
        boolean bl;
        String string = "org.bouncycastle.jsse.provider.BouncyCastleJsseProvider";
        try {
            Class.forName(string, false, BouncyCastlePlatform$Companion.class.getClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            bl = false;
        }
        bl = true;
        isSupported = bl;
    }

    @Override
    public final SSLContext newSSLContext() {
        SSLContext sSLContext = SSLContext.getInstance("TLS", this.provider);
        Intrinsics.checkNotNullExpressionValue(sSLContext, "getInstance(\"TLS\", provider)");
        return sSLContext;
    }

    @Override
    public final X509TrustManager platformTrustManager() {
        Object object;
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("PKIX", "BCJSSE");
        trustManagerFactory.init((KeyStore)null);
        Object object2 = trustManagerFactory.getTrustManagers();
        Intrinsics.checkNotNull(object2);
        if (((TrustManager[])object2).length == 1 && (object = object2[0]) instanceof X509TrustManager) {
            Object object3 = object;
            Intrinsics.checkNotNull(object3, "null cannot be cast to non-null type javax.net.ssl.X509TrustManager");
            return (X509TrustManager)object3;
        }
        object2 = Arrays.toString((Object[])object2);
        Intrinsics.checkNotNullExpressionValue(object2, "toString(this)");
        object2 = "Unexpected default trust managers: ".concat((String)object2);
        throw new IllegalStateException(object2.toString());
    }

    @Override
    public final void configureTlsExtensions(SSLSocket sSLSocket, String string, List list) {
        Intrinsics.checkNotNullParameter(list, "protocols");
        if (sSLSocket instanceof BCSSLSocket) {
            BCSSLSocket bCSSLSocket = (BCSSLSocket)sSLSocket;
            BCSSLParameters bCSSLParameters = bCSSLSocket.getParameters();
            bCSSLParameters.setApplicationProtocols(Platform$Companion.alpnProtocolNames(list).toArray(new String[0]));
            bCSSLSocket.setParameters(bCSSLParameters);
            return;
        }
        super.configureTlsExtensions(sSLSocket, string, list);
    }

    @Override
    public final String getSelectedProtocol(SSLSocket sSLSocket) {
        if (sSLSocket instanceof BCSSLSocket) {
            String string = ((BCSSLSocket)sSLSocket).getApplicationProtocol();
            if (string == null ? true : Intrinsics.areEqual(string, "")) {
                return null;
            }
            return string;
        }
        return null;
    }
}

