/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.relocated.okhttp3.internal.platform;

import android.os.Build;
import android.security.NetworkSecurityPolicy;
import com.apollographql.apollo.relocated.kotlin.collections.CollectionsKt__CollectionsKt;
import com.apollographql.apollo.relocated.kotlin.jvm.internal.Intrinsics;
import com.apollographql.apollo.relocated.okhttp3.internal.platform.AndroidPlatform$CustomTrustRootIndex;
import com.apollographql.apollo.relocated.okhttp3.internal.platform.Platform;
import com.apollographql.apollo.relocated.okhttp3.internal.platform.Platform$Companion;
import com.apollographql.apollo.relocated.okhttp3.internal.platform.android.AndroidCertificateChainCleaner;
import com.apollographql.apollo.relocated.okhttp3.internal.platform.android.AndroidCertificateChainCleaner$Companion;
import com.apollographql.apollo.relocated.okhttp3.internal.platform.android.AndroidSocketAdapter;
import com.apollographql.apollo.relocated.okhttp3.internal.platform.android.BouncyCastleSocketAdapter;
import com.apollographql.apollo.relocated.okhttp3.internal.platform.android.CloseGuard;
import com.apollographql.apollo.relocated.okhttp3.internal.platform.android.ConscryptSocketAdapter;
import com.apollographql.apollo.relocated.okhttp3.internal.platform.android.DeferredSocketAdapter;
import com.apollographql.apollo.relocated.okhttp3.internal.platform.android.SocketAdapter;
import com.apollographql.apollo.relocated.okhttp3.internal.platform.android.StandardAndroidSocketAdapter;
import com.apollographql.apollo.relocated.okhttp3.internal.tls.BasicCertificateChainCleaner;
import com.apollographql.apollo.relocated.okhttp3.internal.tls.CertificateChainCleaner;
import com.apollographql.apollo.relocated.okhttp3.internal.tls.TrustRootIndex;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.X509TrustManager;

public final class AndroidPlatform
extends Platform {
    public static final boolean isSupported;
    public final ArrayList socketAdapters;
    public final CloseGuard closeGuard;

    public AndroidPlatform() {
        CloseGuard closeGuard;
        ArrayList arrayList;
        DeferredSocketAdapter deferredSocketAdapter;
        DeferredSocketAdapter deferredSocketAdapter2;
        DeferredSocketAdapter deferredSocketAdapter3;
        StandardAndroidSocketAdapter standardAndroidSocketAdapter;
        Object object = ".SSLParametersImpl";
        Object object2 = ".OpenSSLSocketFactoryImpl";
        Object object32 = Class.forName("com.android.org.conscrypt".concat(".OpenSSLSocketImpl"));
        object2 = Class.forName("com.android.org.conscrypt".concat((String)object2));
        object = Class.forName("com.android.org.conscrypt".concat((String)object));
        StandardAndroidSocketAdapter standardAndroidSocketAdapter2 = standardAndroidSocketAdapter;
        try {
            standardAndroidSocketAdapter = new StandardAndroidSocketAdapter((Class)object32, (Class)object2, (Class)object);
        }
        catch (Exception exception) {
            Platform.platform.getClass();
            Platform.log("unable to load android socket classes", 5, exception);
            standardAndroidSocketAdapter2 = null;
        }
        object = deferredSocketAdapter3;
        deferredSocketAdapter3 = new DeferredSocketAdapter(AndroidSocketAdapter.playProviderFactory);
        object2 = deferredSocketAdapter2;
        deferredSocketAdapter2 = new DeferredSocketAdapter(ConscryptSocketAdapter.factory);
        object32 = deferredSocketAdapter;
        deferredSocketAdapter = new DeferredSocketAdapter(BouncyCastleSocketAdapter.factory);
        Object[] objectArray = new SocketAdapter[]{standardAndroidSocketAdapter2, object, object2, object32};
        object = arrayList;
        arrayList = new ArrayList();
        for (Object object32 : CollectionsKt__CollectionsKt.listOfNotNull(objectArray)) {
            if (!((SocketAdapter)object32).isSupported()) continue;
            ((ArrayList)object).add(object32);
        }
        ((AndroidPlatform)((Object)closeGuard2)).socketAdapters = object;
        Class<?> clazz = Class.forName("dalvik.system.CloseGuard");
        Class<?> clazz2 = clazz;
        Class<?> clazz3 = clazz;
        object = clazz.getMethod("get", null);
        object2 = clazz3.getMethod("open", String.class);
        try {
            object32 = clazz2.getMethod("warnIfOpen", null);
        }
        catch (Exception exception) {
            object = null;
            object2 = null;
            object32 = null;
        }
        AndroidPlatform androidPlatform = closeGuard2;
        CloseGuard closeGuard2 = closeGuard;
        closeGuard = new CloseGuard((Method)object, (Method)object2, (Method)object32);
        androidPlatform.closeGuard = closeGuard2;
    }

    /*
     * Enabled aggressive block sorting
     */
    static {
        boolean bl;
        if (!Platform$Companion.isAndroid() || Build.VERSION.SDK_INT >= 30) {
            bl = false;
        } else {
            if (Build.VERSION.SDK_INT < 21) {
                String string = "Expected Android API level 21+ but was " + Build.VERSION.SDK_INT;
                throw new IllegalStateException(string.toString());
            }
            bl = true;
        }
        isSupported = bl;
    }

    @Override
    public final void connectSocket(Socket socket, InetSocketAddress inetSocketAddress, int n) {
        Intrinsics.checkNotNullParameter(inetSocketAddress, "address");
        try {
            socket.connect(inetSocketAddress, n);
            return;
        }
        catch (ClassCastException classCastException) {
            if (Build.VERSION.SDK_INT == 26) {
                throw new IOException("Exception in connect", classCastException);
            }
            throw classCastException;
        }
    }

    @Override
    public final void configureTlsExtensions(SSLSocket sSLSocket, String string, List list) {
        Object var4_4;
        block2: {
            Intrinsics.checkNotNullParameter(list, "protocols");
            for (Object e : ((AndroidPlatform)((Object)socketAdapter)).socketAdapters) {
                var4_4 = e;
                if (!((SocketAdapter)e).matchesSocket(sSLSocket)) continue;
                break block2;
            }
            var4_4 = null;
        }
        SocketAdapter socketAdapter = var4_4;
        if (socketAdapter != null) {
            socketAdapter.configureTlsExtensions(sSLSocket, string, list);
            return;
        }
    }

    @Override
    public final String getSelectedProtocol(SSLSocket sSLSocket) {
        Object var2_2;
        block2: {
            for (Object e : ((AndroidPlatform)((Object)socketAdapter)).socketAdapters) {
                var2_2 = e;
                if (!((SocketAdapter)e).matchesSocket(sSLSocket)) continue;
                break block2;
            }
            var2_2 = null;
        }
        SocketAdapter socketAdapter = var2_2;
        if (socketAdapter != null) {
            return socketAdapter.getSelectedProtocol(sSLSocket);
        }
        return null;
    }

    @Override
    public final Object getStackTraceForCloseable() {
        Object[] objectArray = objectArray.closeGuard;
        objectArray.getClass();
        Object object = objectArray.getMethod;
        if (object != null) {
            try {
                object = ((Method)object).invoke(null, null);
            }
            catch (Exception exception) {}
            Method method = objectArray.openMethod;
            Object object2 = object;
            Intrinsics.checkNotNull(method);
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = "response.body().close()";
            method.invoke(object2, objectArray);
            return object;
        }
        return null;
    }

    @Override
    public final void logCloseableLeak(String string, Object object) {
        Intrinsics.checkNotNullParameter(string, "message");
        CloseGuard closeGuard = ((AndroidPlatform)((Object)closeGuard)).closeGuard;
        closeGuard.getClass();
        if (object != null) {
            try {
                Method method = closeGuard.warnIfOpenMethod;
                Intrinsics.checkNotNull(method);
                method.invoke(object, null);
            }
            catch (Exception exception) {}
            return;
        }
        Platform.log(string, 5, null);
    }

    @Override
    public final boolean isCleartextTrafficPermitted(String string) {
        Intrinsics.checkNotNullParameter(string, "hostname");
        if (Build.VERSION.SDK_INT >= 24) {
            return NetworkSecurityPolicy.getInstance().isCleartextTrafficPermitted(string);
        }
        if (Build.VERSION.SDK_INT >= 23) {
            return NetworkSecurityPolicy.getInstance().isCleartextTrafficPermitted();
        }
        return true;
    }

    @Override
    public final CertificateChainCleaner buildCertificateChainCleaner(X509TrustManager x509TrustManager) {
        AndroidCertificateChainCleaner androidCertificateChainCleaner = AndroidCertificateChainCleaner$Companion.buildIfSupported(x509TrustManager);
        if (androidCertificateChainCleaner != null) {
            return androidCertificateChainCleaner;
        }
        return new BasicCertificateChainCleaner(this.buildTrustRootIndex(x509TrustManager));
    }

    @Override
    public final TrustRootIndex buildTrustRootIndex(X509TrustManager x509TrustManager) {
        Method method;
        try {
            method = x509TrustManager.getClass().getDeclaredMethod("findTrustAnchorByIssuerAndSignature", X509Certificate.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return super.buildTrustRootIndex(x509TrustManager);
        }
        method.setAccessible(true);
        return new AndroidPlatform$CustomTrustRootIndex(x509TrustManager, method);
    }
}

