/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.relocated.okhttp3.internal.http2;

import com.apollographql.apollo.relocated.kotlin.jvm.internal.Intrinsics;
import com.apollographql.apollo.relocated.kotlin.jvm.internal.Intrinsics$$ExternalSyntheticCheckNotZero0;
import com.apollographql.apollo.relocated.kotlin.jvm.internal.Intrinsics$$ExternalSyntheticCheckNotZero1;
import com.apollographql.apollo.relocated.okhttp3.Headers;
import com.apollographql.apollo.relocated.okhttp3.internal.Util;
import com.apollographql.apollo.relocated.okhttp3.internal.http2.Http2Connection;
import com.apollographql.apollo.relocated.okhttp3.internal.http2.Http2Stream$FramingSink;
import com.apollographql.apollo.relocated.okhttp3.internal.http2.Http2Stream$FramingSource;
import com.apollographql.apollo.relocated.okhttp3.internal.http2.Http2Stream$StreamTimeout;
import com.apollographql.apollo.relocated.okhttp3.internal.http2.StreamResetException;
import java.io.Closeable;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayDeque;

public final class Http2Stream {
    public final int id;
    public final Http2Connection connection;
    public long readBytesTotal;
    public long readBytesAcknowledged;
    public long writeBytesTotal;
    public long writeBytesMaximum;
    public final ArrayDeque headersQueue;
    public boolean hasResponseHeaders;
    public final Http2Stream$FramingSource source;
    public final Http2Stream$FramingSink sink;
    public final Http2Stream$StreamTimeout readTimeout;
    public final Http2Stream$StreamTimeout writeTimeout;
    public int errorCode;
    public IOException errorException;

    public Http2Stream(int n, Http2Connection http2Connection, boolean bl, boolean bl2, Headers headers) {
        ArrayDeque<Headers> arrayDeque;
        Http2Stream http2Stream = this;
        Intrinsics.checkNotNullParameter(http2Connection, "connection");
        this.id = n;
        this.connection = http2Connection;
        http2Stream.writeBytesMaximum = http2Connection.peerSettings.getInitialWindowSize();
        ArrayDeque<Headers> arrayDeque2 = arrayDeque;
        http2Stream.headersQueue = new ArrayDeque<Headers>();
        http2Stream.source = new Http2Stream$FramingSource(this, http2Connection.okHttpSettings.getInitialWindowSize(), bl2);
        http2Stream.sink = new Http2Stream$FramingSink(this, bl);
        http2Stream.readTimeout = new Http2Stream$StreamTimeout(this);
        http2Stream.writeTimeout = new Http2Stream$StreamTimeout(this);
        if (headers != null) {
            if (!this.isLocallyInitiated()) {
                arrayDeque2.add(headers);
                return;
            }
            throw new IllegalStateException("locally-initiated streams shouldn't have headers yet");
        }
        if (this.isLocallyInitiated()) {
            return;
        }
        throw new IllegalStateException("remotely-initiated streams should have headers");
    }

    public final synchronized boolean isOpen() {
        if (this.errorCode != 0) {
            return false;
        }
        Closeable closeable = this.source;
        if (closeable.finished || closeable.closed) {
            closeable = this.sink;
            if ((((Http2Stream$FramingSink)closeable).finished || ((Http2Stream$FramingSink)closeable).closed) && this.hasResponseHeaders) {
                return false;
            }
        }
        return true;
    }

    public final boolean isLocallyInitiated() {
        boolean bl = (this.id & 1) == 1;
        this.connection.getClass();
        return true == bl;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public final synchronized Headers takeHeaders() {
        Throwable throwable2222;
        block7: {
            block8: {
                this.readTimeout.enter();
                while (this.headersQueue.isEmpty() && this.errorCode == 0) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        try {
                            Thread.currentThread().interrupt();
                            throw new InterruptedIOException();
                        }
                        catch (Throwable throwable2222) {
                            break block7;
                        }
                    }
                }
                Http2Stream http2Stream = this;
                http2Stream.readTimeout.exitAndThrowIfTimedOut();
                if (http2Stream.headersQueue.isEmpty()) break block8;
                Object e = this.headersQueue.removeFirst();
                Intrinsics.checkNotNullExpressionValue(e, "headersQueue.removeFirst()");
                return (Headers)e;
            }
            IOException iOException = this.errorException;
            if (iOException == null) {
                StreamResetException streamResetException;
                iOException = streamResetException;
                int n = this.errorCode;
                Intrinsics$$ExternalSyntheticCheckNotZero1.m(n);
                streamResetException = new StreamResetException(n);
            }
            throw iOException;
        }
        this.readTimeout.exitAndThrowIfTimedOut();
        throw throwable2222;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void receiveHeaders(Headers headers, boolean bl) {
        Intrinsics.checkNotNullParameter(headers, "headers");
        if (Util.assertionsEnabled && Thread.holdsLock(this)) {
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST NOT hold lock on " + this));
        }
        Http2Stream http2Stream = this;
        synchronized (http2Stream) {
            Throwable throwable2;
            block10: {
                block9: {
                    block8: {
                        block7: {
                            try {
                                if (!http2Stream.hasResponseHeaders || !bl) break block7;
                                this.source.getClass();
                            }
                            catch (Throwable throwable2) {}
                            break block8;
                        }
                        this.hasResponseHeaders = true;
                        this.headersQueue.add(headers);
                    }
                    if (!bl) break block9;
                    this.source.finished = true;
                    break block10;
                }
                boolean bl2 = this.isOpen();
                Http2Stream http2Stream2 = this;
                http2Stream2.notifyAll();
                // ** MonitorExit[v2] (shouldn't be in output)
                if (!bl2) {
                    this.connection.removeStream$okhttp(this.id);
                    return;
                }
                return;
            }
            // ** MonitorExit[this] (shouldn't be in output)
            throw throwable2;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void cancelStreamIfNecessary$okhttp() {
        if (Util.assertionsEnabled && Thread.holdsLock(this)) {
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST NOT hold lock on " + this));
        }
        Http2Stream http2Stream = this;
        synchronized (http2Stream) {
            Throwable throwable2;
            block10: {
                boolean bl;
                block9: {
                    block8: {
                        try {
                            Closeable closeable = http2Stream.source;
                            if (closeable.finished || !closeable.closed) break block8;
                            closeable = this.sink;
                            if (!((Http2Stream$FramingSink)closeable).finished && !((Http2Stream$FramingSink)closeable).closed) break block8;
                            bl = true;
                            break block9;
                        }
                        catch (Throwable throwable2) {
                            break block10;
                        }
                    }
                    bl = false;
                }
                boolean bl2 = bl;
                Http2Stream http2Stream2 = this;
                bl = http2Stream2.isOpen();
                // ** MonitorExit[v2] (shouldn't be in output)
                if (bl2) {
                    this.close(9, null);
                    return;
                }
                if (!bl) {
                    this.connection.removeStream$okhttp(this.id);
                    return;
                }
                return;
            }
            // ** MonitorExit[this] (shouldn't be in output)
            throw throwable2;
        }
    }

    public final void checkOutNotClosed$okhttp() {
        Object object = this.sink;
        if (!((Http2Stream$FramingSink)object).closed) {
            if (!((Http2Stream$FramingSink)object).finished) {
                if (this.errorCode != 0) {
                    object = this.errorException;
                    if (object == null) {
                        StreamResetException streamResetException;
                        object = streamResetException;
                        int n = this.errorCode;
                        Intrinsics$$ExternalSyntheticCheckNotZero1.m(n);
                        streamResetException = new StreamResetException(n);
                    }
                    throw object;
                }
                return;
            }
            throw new IOException("stream finished");
        }
        throw new IOException("stream closed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final Http2Stream$FramingSink getSink() {
        Http2Stream http2Stream = this;
        synchronized (http2Stream) {
            Throwable throwable2;
            block4: {
                try {
                    if (!http2Stream.hasResponseHeaders && !this.isLocallyInitiated()) {
                        String string = "reply before requesting the sink";
                        throw new IllegalStateException(string);
                    }
                }
                catch (Throwable throwable2) {
                    break block4;
                }
                Http2Stream http2Stream2 = this;
                // ** MonitorExit[v2] (shouldn't be in output)
                return http2Stream2.sink;
            }
            // ** MonitorExit[this] (shouldn't be in output)
            throw throwable2;
        }
    }

    public final synchronized void receiveRstStream() {
        int n = 8;
        Intrinsics$$ExternalSyntheticCheckNotZero0.m(8, "errorCode");
        if (this.errorCode == 0) {
            this.errorCode = n;
            this.notifyAll();
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final boolean closeInternal(int n, IOException iOException) {
        if (Util.assertionsEnabled && Thread.holdsLock(this)) {
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST NOT hold lock on " + this));
        }
        Http2Stream http2Stream = this;
        synchronized (http2Stream) {
            Throwable throwable2;
            block8: {
                block7: {
                    block6: {
                        try {
                            if (http2Stream.errorCode == 0) break block6;
                        }
                        catch (Throwable throwable2) {}
                        return false;
                    }
                    Http2Stream http2Stream2 = this;
                    this.errorCode = n;
                    http2Stream2.errorException = iOException;
                    http2Stream2.notifyAll();
                    if (!http2Stream2.source.finished || !this.sink.finished) break block7;
                    // ** MonitorExit[this] (shouldn't be in output)
                    return false;
                }
                Http2Stream http2Stream3 = this;
                Http2Stream http2Stream4 = http2Stream3;
                Http2Stream http2Stream5 = http2Stream3;
                break block8;
                // ** MonitorExit[v3] (shouldn't be in output)
                http2Stream5.connection.removeStream$okhttp(this.id);
                return true;
            }
            // ** MonitorExit[this] (shouldn't be in output)
            throw throwable2;
        }
    }

    public final synchronized int getErrorCode$okhttp() {
        return this.errorCode;
    }

    public final void close(int n, IOException iOException) {
        int n2 = n;
        Intrinsics$$ExternalSyntheticCheckNotZero0.m(n2, "rstStatusCode");
        if (!this.closeInternal(n2, iOException)) {
            return;
        }
        Http2Connection http2Connection = this.connection;
        int n3 = this.id;
        http2Connection.getClass();
        http2Connection.writer.rstStream(n3, n);
    }
}

