/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.relocated.okhttp3.internal.ws;

import com.apollographql.apollo.relocated.com.squareup.kotlinpoet.CodeWriter$Companion$$ExternalSyntheticOutline0;
import com.apollographql.apollo.relocated.kotlin.collections.EmptyList$$ExternalSyntheticOutline0;
import com.apollographql.apollo.relocated.kotlin.jvm.internal.Intrinsics;
import com.apollographql.apollo.relocated.kotlin.text.Charsets;
import com.apollographql.apollo.relocated.okhttp3.internal.ws.MessageInflater;
import com.apollographql.apollo.relocated.okhttp3.internal.ws.RealWebSocket;
import com.apollographql.apollo.relocated.okio.Buffer;
import com.apollographql.apollo.relocated.okio.RealBufferedSource;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.net.ProtocolException;
import java.nio.charset.Charset;
import java.util.concurrent.TimeUnit;

public final class WebSocketReader
implements Closeable {
    public final RealBufferedSource source;
    public final RealWebSocket frameCallback;
    public final boolean perMessageDeflate;
    public final boolean noContextTakeover;
    public boolean closed;
    public int opcode;
    public long frameLength;
    public boolean isFinalFrame;
    public boolean isControlFrame;
    public boolean readingCompressedMessage;
    public final Buffer controlFrameBuffer;
    public final Buffer messageFrameBuffer;
    public MessageInflater messageInflater;
    public final byte[] maskKey;

    public WebSocketReader(RealBufferedSource realBufferedSource, RealWebSocket realWebSocket, boolean bl, boolean bl2) {
        WebSocketReader webSocketReader = this;
        Intrinsics.checkNotNullParameter(realBufferedSource, "source");
        this.source = realBufferedSource;
        this.frameCallback = realWebSocket;
        this.perMessageDeflate = bl;
        webSocketReader.noContextTakeover = bl2;
        webSocketReader.controlFrameBuffer = new Buffer();
        webSocketReader.messageFrameBuffer = new Buffer();
        webSocketReader.maskKey = null;
    }

    @Override
    public final void close() {
        Closeable closeable = closeable.messageInflater;
        if (closeable != null) {
            ((MessageInflater)closeable).inflaterSource.close();
            return;
        }
    }

    /*
     * Unable to fully structure code
     */
    public final void readHeader() {
        block21: {
            block23: {
                block22: {
                    if (this.closed) break block21;
                    var1_1 = this.source.source.timeout().timeoutNanos();
                    this.source.source.timeout().clearTimeout();
                    v0 = this.source;
                    v0.require(1L);
                    var3_4 = v0.bufferField.readByte();
                    ** try [egrp 1[TRYBLOCK] [1 : 57->60)] { 
lbl10:
                    // 1 sources

                    this.source.source.timeout().timeout(var1_1, TimeUnit.NANOSECONDS);
                    this.opcode = var1_2 = var3_4 & 15;
                    var2_8 = (var3_4 & 128) != 0;
                    this.isFinalFrame = var2_8;
                    var4_10 = (var3_4 & 8) != 0 ? 1 : 0;
                    this.isControlFrame = var4_10;
                    if (var4_10 != 0 && !var2_8) {
                        throw new ProtocolException("Control frames must be final.");
                    }
                    var2_8 = (var3_4 & 64) != 0;
                    if (var1_2 == 1 || var1_2 == 2) break block22;
                    if (var2_8) {
                        throw new ProtocolException("Unexpected rsv1 flag");
                    }
                    break block23;
                }
                if (!var2_8) ** GOTO lbl31
                if (this.perMessageDeflate) {
                    var1_2 = 1;
                } else {
                    throw new ProtocolException("Unexpected rsv1 flag");
lbl31:
                    // 1 sources

                    var1_2 = 0;
                }
                this.readingCompressedMessage = var1_2;
            }
            if ((var3_4 & 32) == 0) {
                if ((var3_4 & 16) == 0) {
                    v1 = this.source;
                    v1.require(1L);
                    v2 = v1.bufferField.readByte();
                    var1_2 = v2;
                    var2_8 = (v2 & 128) != 0;
                    if (!var2_8) {
                        this.frameLength = var3_5 = (long)(var1_2 & 127);
                        if (var3_5 == 126L) {
                            v3 = this.source;
                            v3.require(2L);
                            this.frameLength = var3_5 = (long)(v3.bufferField.readShort() & 65535);
                        } else if (var3_5 == 127L) {
                            v4 = this.source;
                            v4.require(8L);
                            this.frameLength = var3_5 = v4.bufferField.readLong();
                            if (var3_5 < 0L) {
                                v5 = new StringBuilder("Frame length 0x");
                                v6 = Long.toHexString(this.frameLength);
                                Intrinsics.checkNotNullExpressionValue(v6, "toHexString(this)");
                                throw new ProtocolException(v5.append(v6).append(" > 0x7FFFFFFFFFFFFFFF").toString());
                            }
                        }
                        if (this.isControlFrame && this.frameLength > 125L) {
                            throw new ProtocolException("Control frame must be less than 125B.");
                        }
                        if (var2_8) {
                            var1_3 = this.source;
                            this = this.maskKey;
                            Intrinsics.checkNotNull(this.maskKey);
                            var1_3.getClass();
                            try {
                                v7 = ((Object)this).length;
                            }
                            catch (EOFException var2_9) {
                                block20: {
                                    var3_6 = 0;
                                    while (true) {
                                        var4_11 = var1_3.bufferField;
                                        var5_12 = var4_11.size;
                                        if (var5_12 <= 0L) break block20;
                                        var4_10 = (int)var5_12;
                                        if ((var4_10 = var4_11.read((byte[])this, var3_6, var4_10)) == -1) break;
                                        var3_6 += var4_10;
                                    }
                                    throw new AssertionError();
                                }
                                throw var2_9;
                            }
                            var1_3.require(v7);
                            var1_3.bufferField.readFully((byte[])this);
                            return;
                        }
                        return;
                    }
                    throw new ProtocolException("Server-sent frames must not be masked.");
                }
                throw new ProtocolException("Unexpected rsv3 flag");
            }
            throw new ProtocolException("Unexpected rsv2 flag");
lbl88:
            // 2 sources

            catch (Throwable var3_7) {
                this.source.source.timeout().timeout(var1_1, TimeUnit.NANOSECONDS);
                throw var3_7;
            }
        }
        throw new IOException("closed");
    }

    public final void readControlFrame() {
        long l = ((WebSocketReader)((Object)string)).frameLength;
        if (l > 0L) {
            ((WebSocketReader)((Object)string)).source.readFully(((WebSocketReader)((Object)string)).controlFrameBuffer, l);
        }
        switch (((WebSocketReader)((Object)string)).opcode) {
            default: {
                String string = Integer.toHexString(((WebSocketReader)((Object)string)).opcode);
                Intrinsics.checkNotNullExpressionValue(string, "toHexString(this)");
                throw new ProtocolException("Unknown control opcode: ".concat(string));
            }
            case 10: {
                RealWebSocket realWebSocket = ((WebSocketReader)((Object)string)).frameCallback;
                Buffer buffer = ((WebSocketReader)((Object)string)).controlFrameBuffer;
                synchronized (realWebSocket) {
                    Intrinsics.checkNotNullParameter(buffer.readByteString(buffer.size), "payload");
                    realWebSocket.awaitingPong = false;
                    return;
                }
            }
            case 9: {
                Buffer buffer = ((WebSocketReader)((Object)string)).controlFrameBuffer;
                ((WebSocketReader)((Object)string)).frameCallback.onReadPing(buffer.readByteString(buffer.size));
                return;
            }
            case 8: 
        }
        int n = 1005;
        String string = "";
        Object object = ((WebSocketReader)((Object)string)).controlFrameBuffer;
        long l2 = ((Buffer)object).size;
        if (l2 != 1L) {
            if (l2 != 0L) {
                short s = ((Buffer)object).readShort();
                n = s;
                Buffer buffer = ((WebSocketReader)((Object)string)).controlFrameBuffer;
                long l3 = buffer.size;
                Charset charset = Charsets.UTF_8;
                string = buffer.readString(l3, charset);
                object = s >= 1000 && n < 5000 ? (1004 <= n && n < 1007 || 1015 <= n && n < 3000 ? CodeWriter$Companion$$ExternalSyntheticOutline0.m("Code ", n, " is reserved and may not be used.") : null) : EmptyList$$ExternalSyntheticOutline0.m("Code must be in range [1000,5000): ", n);
                if (object != null) {
                    throw new ProtocolException((String)object);
                }
            }
            ((WebSocketReader)((Object)string)).frameCallback.onReadClose(n, string);
            ((WebSocketReader)((Object)string)).closed = true;
            return;
        }
        throw new ProtocolException("Malformed close payload length of 1.");
    }
}

