/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.relocated.okhttp3.internal.platform;

import com.apollographql.apollo.relocated.kotlin.jvm.internal.Intrinsics;
import com.apollographql.apollo.relocated.okhttp3.OkHttpClient;
import com.apollographql.apollo.relocated.okhttp3.internal.platform.Android10Platform;
import com.apollographql.apollo.relocated.okhttp3.internal.platform.AndroidPlatform;
import com.apollographql.apollo.relocated.okhttp3.internal.platform.BouncyCastlePlatform;
import com.apollographql.apollo.relocated.okhttp3.internal.platform.ConscryptPlatform;
import com.apollographql.apollo.relocated.okhttp3.internal.platform.Jdk8WithJettyBootPlatform;
import com.apollographql.apollo.relocated.okhttp3.internal.platform.Jdk9Platform;
import com.apollographql.apollo.relocated.okhttp3.internal.platform.OpenJSSEPlatform;
import com.apollographql.apollo.relocated.okhttp3.internal.platform.Platform$Companion;
import com.apollographql.apollo.relocated.okhttp3.internal.platform.android.AndroidLog;
import com.apollographql.apollo.relocated.okhttp3.internal.tls.BasicCertificateChainCleaner;
import com.apollographql.apollo.relocated.okhttp3.internal.tls.BasicTrustRootIndex;
import com.apollographql.apollo.relocated.okhttp3.internal.tls.CertificateChainCleaner;
import com.apollographql.apollo.relocated.okhttp3.internal.tls.TrustRootIndex;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class Platform {
    public static volatile Platform platform;
    public static final Logger logger;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static {
        Object object;
        block28: {
            block31: {
                block30: {
                    block29: {
                        block27: {
                            if (!Platform$Companion.isAndroid()) break block27;
                            for (Map.Entry entry : AndroidLog.knownLoggers.entrySet()) {
                                AndroidLog.enableLogging((String)entry.getKey(), (String)entry.getValue());
                            }
                            if (Android10Platform.isSupported) {
                                Android10Platform android10Platform;
                                object = android10Platform;
                                android10Platform = new Android10Platform();
                            } else {
                                object = null;
                            }
                            if (object == null) {
                                if (AndroidPlatform.isSupported) {
                                    AndroidPlatform androidPlatform;
                                    object = androidPlatform;
                                    androidPlatform = new AndroidPlatform();
                                } else {
                                    object = null;
                                }
                                Intrinsics.checkNotNull(object);
                            }
                            break block28;
                        }
                        if (!"Conscrypt".equals(Security.getProviders()[0].getName())) break block29;
                        if (ConscryptPlatform.isSupported) {
                            ConscryptPlatform conscryptPlatform;
                            object = conscryptPlatform;
                            conscryptPlatform = new ConscryptPlatform();
                        } else {
                            object = null;
                        }
                        if (object != null) break block28;
                    }
                    if (!"BC".equals(Security.getProviders()[0].getName())) break block30;
                    if (BouncyCastlePlatform.isSupported) {
                        BouncyCastlePlatform bouncyCastlePlatform;
                        object = bouncyCastlePlatform;
                        bouncyCastlePlatform = new BouncyCastlePlatform();
                    } else {
                        object = null;
                    }
                    if (object != null) break block28;
                }
                if (!"OpenJSSE".equals(Security.getProviders()[0].getName())) break block31;
                if (OpenJSSEPlatform.isSupported) {
                    OpenJSSEPlatform openJSSEPlatform;
                    object = openJSSEPlatform;
                    openJSSEPlatform = new OpenJSSEPlatform();
                } else {
                    object = null;
                }
                if (object != null) break block28;
            }
            if (Jdk9Platform.isAvailable) {
                Jdk9Platform jdk9Platform;
                object = jdk9Platform;
                jdk9Platform = new Jdk9Platform();
            } else {
                object = null;
            }
            if (object == null) {
                block26: {
                    block25: {
                        Jdk8WithJettyBootPlatform jdk8WithJettyBootPlatform;
                        block24: {
                            String string = System.getProperty("java.specification.version", "unknown");
                            try {
                                Intrinsics.checkNotNullExpressionValue(string, "jvmVersion");
                                if (Integer.parseInt(string) < 9) break block24;
                                break block25;
                            }
                            catch (NumberFormatException numberFormatException) {}
                        }
                        object = null;
                        Class<?> clazz = Class.forName("org.eclipse.jetty.alpn.ALPN", true, (ClassLoader)object);
                        object = Class.forName("org.eclipse.jetty.alpn.ALPN$Provider", true, null);
                        Class<?> clazz2 = Class.forName("org.eclipse.jetty.alpn.ALPN$ClientProvider", true, null);
                        Class<?> clazz3 = Class.forName("org.eclipse.jetty.alpn.ALPN$ServerProvider", true, null);
                        object = clazz.getMethod("put", new Class[]{SSLSocket.class, object});
                        Method method = clazz.getMethod("get", SSLSocket.class);
                        Method method2 = clazz.getMethod("remove", SSLSocket.class);
                        Jdk8WithJettyBootPlatform jdk8WithJettyBootPlatform2 = jdk8WithJettyBootPlatform;
                        try {
                            Intrinsics.checkNotNullExpressionValue(object, "putMethod");
                            Intrinsics.checkNotNullExpressionValue(method, "getMethod");
                            Intrinsics.checkNotNullExpressionValue(method2, "removeMethod");
                            Intrinsics.checkNotNullExpressionValue(clazz2, "clientProviderClass");
                            Intrinsics.checkNotNullExpressionValue(clazz3, "serverProviderClass");
                            jdk8WithJettyBootPlatform = new Jdk8WithJettyBootPlatform((Method)object, method, method2, clazz2, clazz3);
                            object = jdk8WithJettyBootPlatform2;
                            break block26;
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                        }
                        catch (ClassNotFoundException classNotFoundException) {}
                    }
                    object = null;
                }
                if (object == null) {
                    Platform platform;
                    object = platform;
                    platform = new Platform();
                }
            }
        }
        platform = object;
        logger = Logger.getLogger(OkHttpClient.class.getName());
    }

    public static void log(String string, int n, Throwable throwable) {
        Intrinsics.checkNotNullParameter(string, "message");
        Level level = n == 5 ? Level.WARNING : Level.INFO;
        logger.log(level, string, throwable);
    }

    public SSLContext newSSLContext() {
        SSLContext sSLContext = SSLContext.getInstance("TLS");
        Intrinsics.checkNotNullExpressionValue(sSLContext, "getInstance(\"TLS\")");
        return sSLContext;
    }

    public X509TrustManager platformTrustManager() {
        Object object;
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init((KeyStore)null);
        Object object2 = trustManagerFactory.getTrustManagers();
        Intrinsics.checkNotNull(object2);
        if (((TrustManager[])object2).length == 1 && (object = object2[0]) instanceof X509TrustManager) {
            Object object3 = object;
            Intrinsics.checkNotNull(object3, "null cannot be cast to non-null type javax.net.ssl.X509TrustManager");
            return (X509TrustManager)object3;
        }
        object2 = Arrays.toString((Object[])object2);
        Intrinsics.checkNotNullExpressionValue(object2, "toString(this)");
        object2 = "Unexpected default trust managers: ".concat((String)object2);
        throw new IllegalStateException(object2.toString());
    }

    public void configureTlsExtensions(SSLSocket sSLSocket, String string, List list) {
        Intrinsics.checkNotNullParameter(list, "protocols");
    }

    public void afterHandshake(SSLSocket sSLSocket) {
    }

    public String getSelectedProtocol(SSLSocket sSLSocket) {
        return null;
    }

    public void connectSocket(Socket socket, InetSocketAddress inetSocketAddress, int n) {
        Intrinsics.checkNotNullParameter(inetSocketAddress, "address");
        socket.connect(inetSocketAddress, n);
    }

    public boolean isCleartextTrafficPermitted(String string) {
        Intrinsics.checkNotNullParameter(string, "hostname");
        return true;
    }

    public Object getStackTraceForCloseable() {
        String string = "response.body().close()";
        if (logger.isLoggable(Level.FINE)) {
            return new Throwable(string);
        }
        return null;
    }

    public void logCloseableLeak(String string, Object object) {
        Intrinsics.checkNotNullParameter(string, "message");
        if (object == null) {
            string = string.concat(" To see where this was allocated, set the OkHttpClient logger level to FINE: Logger.getLogger(OkHttpClient.class.getName()).setLevel(Level.FINE);");
        }
        Platform.log(string, 5, (Throwable)object);
    }

    public CertificateChainCleaner buildCertificateChainCleaner(X509TrustManager x509TrustManager) {
        return new BasicCertificateChainCleaner(this.buildTrustRootIndex(x509TrustManager));
    }

    public TrustRootIndex buildTrustRootIndex(X509TrustManager x509TrustManager) {
        X509Certificate[] x509CertificateArray = x509TrustManager.getAcceptedIssuers();
        Intrinsics.checkNotNullExpressionValue(x509CertificateArray, "trustManager.acceptedIssuers");
        return new BasicTrustRootIndex(Arrays.copyOf(x509CertificateArray, x509CertificateArray.length));
    }

    public SSLSocketFactory newSslSocketFactory(X509TrustManager x509TrustManager) {
        SSLContext sSLContext;
        try {
            sSLContext = this.newSSLContext();
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new AssertionError("No System TLS: " + generalSecurityException, generalSecurityException);
        }
        sSLContext.init(null, new TrustManager[]{x509TrustManager}, null);
        SSLSocketFactory sSLSocketFactory = sSLContext.getSocketFactory();
        Intrinsics.checkNotNullExpressionValue(sSLSocketFactory, "newSSLContext().apply {\n\u2026ll)\n      }.socketFactory");
        return sSLSocketFactory;
    }

    public final String toString() {
        return this.getClass().getSimpleName();
    }
}

