/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.relocated.kotlin.collections;

import com.apollographql.apollo.relocated.kotlin.collections.CollectionsKt__CollectionsJVMKt;
import com.apollographql.apollo.relocated.kotlin.collections.EmptyList;
import com.apollographql.apollo.relocated.kotlin.jvm.internal.Intrinsics;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public abstract class CollectionsKt__CollectionsKt
extends CollectionsKt__CollectionsJVMKt {
    public static List listOf(Object ... objectArray) {
        Intrinsics.checkNotNullParameter(objectArray, "elements");
        if (objectArray.length > 0) {
            List<Object> list = Arrays.asList(objectArray);
            Intrinsics.checkNotNullExpressionValue(list, "asList(...)");
            return list;
        }
        return EmptyList.INSTANCE;
    }

    public static List listOfNotNull(Object object) {
        if (object != null) {
            List<Object> list = Collections.singletonList(object);
            Intrinsics.checkNotNullExpressionValue(list, "singletonList(...)");
            return list;
        }
        return EmptyList.INSTANCE;
    }

    public static final List optimizeReadOnlyList(List list) {
        int n = list.size();
        if (n != 0) {
            if (n != 1) {
                return list;
            }
            List list2 = Collections.singletonList(list.get(0));
            Intrinsics.checkNotNullExpressionValue(list2, "singletonList(...)");
            return list2;
        }
        return EmptyList.INSTANCE;
    }

    public static void throwIndexOverflow() {
        throw new ArithmeticException("Index overflow has happened.");
    }

    public static ArrayList listOfNotNull(Object ... objectArray) {
        ArrayList<Object> arrayList;
        ArrayList<Object> arrayList2 = arrayList;
        arrayList = new ArrayList<Object>();
        for (Object object : objectArray) {
            if (object == null) continue;
            arrayList2.add(object);
        }
        return arrayList2;
    }
}

