/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.relocated.com.squareup.javapoet;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Modifier;

public abstract class Util {
    public static void checkArgument(boolean bl, String string, Object ... objectArray) {
        if (bl) {
            return;
        }
        throw new IllegalArgumentException(String.format(string, objectArray));
    }

    public static Object checkNotNull(Object object, String string, Object ... objectArray) {
        if (object != null) {
            return object;
        }
        throw new NullPointerException(String.format(string, objectArray));
    }

    public static void checkState(boolean bl, String string, Object ... objectArray) {
        if (bl) {
            return;
        }
        throw new IllegalStateException(String.format(string, objectArray));
    }

    public static List immutableList(AbstractCollection abstractCollection) {
        return Collections.unmodifiableList(new ArrayList(abstractCollection));
    }

    public static Set immutableSet(List list) {
        return Collections.unmodifiableSet(new LinkedHashSet(list));
    }

    public static LinkedHashSet union(Set set, Set set2) {
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        linkedHashSet.addAll(set);
        linkedHashSet.addAll(set2);
        return linkedHashSet;
    }

    public static void requireExactlyOneOf(Set set, Modifier ... object) {
        int n = 0;
        int n2 = ((Modifier[])object).length;
        for (int i = 0; i < n2; ++i) {
            if (!set.contains((Object)object[i])) continue;
            ++n;
        }
        object = Arrays.toString((Object[])object);
        Object[] objectArray = new Object[2];
        Object[] objectArray2 = objectArray;
        objectArray[0] = set;
        objectArray[1] = object;
        Util.checkArgument(n == 1, "modifiers %s must contain one of %s", objectArray2);
    }

    public static String stringLiteralWithDoubleQuotes(String string, String string2) {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder;
        new StringBuilder(string.length() + 2).append('\"');
        for (int i = 0; i < string.length(); ++i) {
            Object object;
            char c = string.charAt(i);
            if (c == '\'') {
                stringBuilder2.append("'");
                continue;
            }
            if (c == '\"') {
                stringBuilder2.append("\\\"");
                continue;
            }
            switch (c) {
                default: {
                    if (Character.isISOControl(c)) {
                        object = (int)c;
                        Object[] objectArray = new Object[1];
                        Object[] objectArray2 = objectArray;
                        objectArray[0] = object;
                        object = String.format("\\u%04x", objectArray2);
                        break;
                    }
                    object = Character.toString(c);
                    break;
                }
                case '\\': {
                    object = "\\\\";
                    break;
                }
                case '\'': {
                    object = "\\'";
                    break;
                }
                case '\"': {
                    object = "\"";
                    break;
                }
                case '\r': {
                    object = "\\r";
                    break;
                }
                case '\f': {
                    object = "\\f";
                    break;
                }
                case '\n': {
                    object = "\\n";
                    break;
                }
                case '\t': {
                    object = "\\t";
                    break;
                }
                case '\b': {
                    object = "\\b";
                }
            }
            stringBuilder2.append((String)object);
            if (c != '\n' || i + 1 >= string.length()) continue;
            stringBuilder2.append("\"\n").append(string2).append(string2).append("+ \"");
        }
        StringBuilder stringBuilder3 = stringBuilder2;
        stringBuilder3.append('\"');
        return stringBuilder3.toString();
    }
}

