/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.relocated.com.squareup.javapoet;

import com.apollographql.apollo.relocated.com.squareup.javapoet.CodeBlock;
import com.apollographql.apollo.relocated.com.squareup.javapoet.CodeBlock$Builder;
import com.apollographql.apollo.relocated.com.squareup.javapoet.CodeWriter;
import com.apollographql.apollo.relocated.com.squareup.javapoet.FieldSpec$Builder;
import com.apollographql.apollo.relocated.com.squareup.javapoet.TypeName;
import com.apollographql.apollo.relocated.com.squareup.javapoet.Util;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Modifier;

public final class FieldSpec {
    public final TypeName type;
    public final String name;
    public final CodeBlock javadoc;
    public final List annotations;
    public final Set modifiers;
    public final CodeBlock initializer;

    public static FieldSpec$Builder builder(TypeName typeName, String string, Modifier ... modifierArray) {
        Util.checkNotNull(typeName, "type == null", new Object[0]);
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = objectArray;
        objectArray[0] = string;
        Util.checkArgument(SourceVersion.isName(string), "not a valid name: %s", objectArray2);
        return new FieldSpec$Builder(typeName, string).addModifiers(modifierArray);
    }

    public FieldSpec(FieldSpec$Builder object) {
        FieldSpec$Builder fieldSpec$Builder = object;
        FieldSpec$Builder fieldSpec$Builder2 = object;
        FieldSpec$Builder fieldSpec$Builder3 = object;
        this.type = (TypeName)Util.checkNotNull(((FieldSpec$Builder)object).type, "type == null", new Object[0]);
        this.name = (String)Util.checkNotNull(((FieldSpec$Builder)object).name, "name == null", new Object[0]);
        object = ((FieldSpec$Builder)object).javadoc;
        object.getClass();
        this.javadoc = new CodeBlock((CodeBlock$Builder)object);
        object = fieldSpec$Builder3.annotations;
        this.annotations = Collections.unmodifiableList(new ArrayList(object));
        object = fieldSpec$Builder2.modifiers;
        this.modifiers = Collections.unmodifiableSet(new LinkedHashSet(object));
        object = fieldSpec$Builder.initializer;
        if (object == null) {
            CodeBlock codeBlock;
            CodeBlock$Builder codeBlock$Builder;
            object = codeBlock$Builder;
            codeBlock$Builder = new CodeBlock$Builder();
            CodeBlock codeBlock2 = codeBlock;
            codeBlock = new CodeBlock((CodeBlock$Builder)object);
            object = codeBlock2;
        }
        this.initializer = object;
    }

    public final boolean hasModifier(Modifier modifier) {
        return this.modifiers.contains((Object)modifier);
    }

    public final void emit(CodeWriter codeWriter, Set object) {
        CodeWriter codeWriter2 = codeWriter;
        codeWriter.emitJavadoc(this.javadoc);
        codeWriter.emitAnnotations(this.annotations, false);
        codeWriter2.emitModifiers(this.modifiers, (Set)object);
        FieldSpec fieldSpec = this;
        object = fieldSpec.type;
        String string = fieldSpec.name;
        codeWriter2.emit(CodeBlock.of("$T $L", object, string), false);
        if (!this.initializer.formatParts.isEmpty()) {
            codeWriter.emitAndIndent(" = ");
            codeWriter.emit(this.initializer, false);
        }
        codeWriter.emitAndIndent(";\n");
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (FieldSpec.class != object.getClass()) {
            return false;
        }
        return this.toString().equals(object.toString());
    }

    public final int hashCode() {
        return this.toString().hashCode();
    }

    public final String toString() {
        StringBuilder stringBuilder;
        FieldSpec fieldSpec = stringBuilder2;
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder();
        try {
            fieldSpec.emit(new CodeWriter(stringBuilder2), Collections.emptySet());
            return stringBuilder2.toString();
        }
        catch (IOException iOException) {
            throw new AssertionError();
        }
    }
}

