/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.gradle.internal;

import com.apollographql.apollo.compiler.FileUtils;
import com.apollographql.apollo.compiler.pqm.PqmOperation;
import com.apollographql.apollo.relocated.com.apollographql.apollo.tooling.CannotModifyOperationBody;
import com.apollographql.apollo.relocated.com.apollographql.apollo.tooling.GraphNotFound;
import com.apollographql.apollo.relocated.com.apollographql.apollo.tooling.PermissionError;
import com.apollographql.apollo.relocated.com.apollographql.apollo.tooling.PersistedQueriesUploaderKt;
import com.apollographql.apollo.relocated.com.apollographql.apollo.tooling.PersistedQuery;
import com.apollographql.apollo.relocated.com.apollographql.apollo.tooling.PublishOperationsSuccess;
import com.apollographql.apollo.relocated.com.apollographql.apollo.tooling.RegisterOperations;
import com.apollographql.apollo.relocated.kotlin.collections.CollectionsKt__IterablesKt;
import com.apollographql.apollo.relocated.kotlin.jvm.internal.Intrinsics;
import java.io.File;
import java.util.ArrayList;
import kotlin.Metadata;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0007R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u0007R\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u0007R\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0007R\u0014\u0010\u0010\u001a\u00020\u00118gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0016"}, d2={"Lcom/apollographql/apollo/gradle/internal/ApolloRegisterOperationsTask;", "Lorg/gradle/api/DefaultTask;", "()V", "graph", "Lorg/gradle/api/provider/Property;", "", "getGraph", "()Lorg/gradle/api/provider/Property;", "graphVariant", "getGraphVariant", "key", "getKey", "listId", "getListId", "operationManifestFormat", "getOperationManifestFormat", "operationOutput", "Lorg/gradle/api/file/RegularFileProperty;", "getOperationOutput", "()Lorg/gradle/api/file/RegularFileProperty;", "taskAction", "", "apollo-gradle-plugin-external"})
public abstract class ApolloRegisterOperationsTask
extends DefaultTask {
    @InputFile
    @Optional
    public abstract RegularFileProperty getOperationOutput();

    @Input
    @Optional
    public abstract Property<String> getOperationManifestFormat();

    @Input
    @Optional
    public abstract Property<String> getListId();

    @Input
    public abstract Property<String> getKey();

    @Input
    public abstract Property<String> getGraph();

    @Input
    @Optional
    public abstract Property<String> getGraphVariant();

    @TaskAction
    public final void taskAction() {
        if (this.getListId().isPresent()) {
            if (Intrinsics.areEqual(this.getOperationManifestFormat().get(), "persistedQueryManifest")) {
                ArrayList<PersistedQuery> arrayList;
                ApolloRegisterOperationsTask apolloRegisterOperationsTask = this;
                Object object = apolloRegisterOperationsTask.getListId().get();
                Intrinsics.checkNotNullExpressionValue(object, "get(...)");
                Object object2 = (String)object;
                File file = ((RegularFile)apolloRegisterOperationsTask.getOperationOutput().get()).getAsFile();
                Intrinsics.checkNotNullExpressionValue(file, "getAsFile(...)");
                Object object3 = FileUtils.readPersistedQueryManifest(file).getOperations();
                ArrayList<PersistedQuery> arrayList2 = arrayList;
                arrayList = new ArrayList<PersistedQuery>(CollectionsKt__IterablesKt.collectionSizeOrDefault(object3));
                object3 = object3.iterator();
                while (object3.hasNext()) {
                    Object object4 = (PqmOperation)object3.next();
                    PqmOperation pqmOperation = object4;
                    object4 = pqmOperation.getName();
                    String string = pqmOperation.getId();
                    String string2 = pqmOperation.getBody();
                    String string3 = pqmOperation.getType();
                    arrayList2.add(new PersistedQuery((String)object4, string, string2, string3));
                }
                String string = object2;
                ApolloRegisterOperationsTask apolloRegisterOperationsTask2 = this;
                Object object5 = apolloRegisterOperationsTask2.getKey().get();
                Intrinsics.checkNotNullExpressionValue(object5, "get(...)");
                object2 = (String)object5;
                object2 = PersistedQueriesUploaderKt.publishOperations(string, arrayList2, (String)object2, (String)apolloRegisterOperationsTask2.getGraph().get());
                if (object2 instanceof PublishOperationsSuccess) {
                    this.getLogger().info("Apollo: persisted query list uploaded successfully");
                    return;
                }
                if (!(object2 instanceof CannotModifyOperationBody)) {
                    if (!Intrinsics.areEqual(object2, GraphNotFound.INSTANCE)) {
                        if (!(object2 instanceof PermissionError)) {
                            return;
                        }
                        throw new IllegalStateException(("Cannot upload persisted query list: permission error ('" + ((PermissionError)object2).getMessage() + "')").toString());
                    }
                    throw new IllegalStateException(("Cannot upload persisted query list: graph '" + this.getGraph() + "' not found").toString());
                }
                throw new IllegalStateException(("Cannot upload persisted query list: cannot modify operation body ('" + ((CannotModifyOperationBody)object2).getMessage() + "')").toString());
            }
            throw new IllegalStateException("Apollo: registering operations to a persisted query list requires operationManifestFormat = \"persistedQueryManifest\":\napollo {\n  service(\"service\") {\n    operationManifestFormat.set(\"persistedQueryManifest\")\n  }\n}");
        }
        ApolloRegisterOperationsTask apolloRegisterOperationsTask = this;
        apolloRegisterOperationsTask.getLogger().warn("Apollo: registering operations without a listId is deprecated");
        if (Intrinsics.areEqual(apolloRegisterOperationsTask.getOperationManifestFormat().get(), "operationOutput")) {
            String string = (String)this.getKey().get();
            if (string != null) {
                String string4 = (String)this.getGraph().get();
                if (string4 != null) {
                    String string5 = (String)this.getGraphVariant().get();
                    if (string5 != null) {
                        File file = ((RegularFile)this.getOperationOutput().get()).getAsFile();
                        Intrinsics.checkNotNullExpressionValue(file, "getAsFile(...)");
                        RegisterOperations.registerOperations(string, string4, string5, FileUtils.readOperationOutput(file));
                        return;
                    }
                    throw new IllegalStateException("graphVariant is required to register operations");
                }
                throw new IllegalStateException("graphID is required to register operations");
            }
            throw new IllegalStateException("key is required to register operations");
        }
        throw new IllegalStateException("Apollo: registering legacy operations requires operationManifestFormat = \"operationOutput\":\napollo {\n  service(\"service\") {\n    operationManifestFormat.set(\"operationOutput\")\n  }\n}");
    }
}

