/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.relocated.kotlinx.serialization.json.internal;

import com.apollographql.apollo.relocated.kotlin.jvm.internal.Intrinsics;
import com.apollographql.apollo.relocated.kotlinx.serialization.descriptors.SerialDescriptor;
import com.apollographql.apollo.relocated.kotlinx.serialization.json.Json;
import com.apollographql.apollo.relocated.kotlinx.serialization.json.JsonArray;
import com.apollographql.apollo.relocated.kotlinx.serialization.json.JsonElement;
import com.apollographql.apollo.relocated.kotlinx.serialization.json.internal.AbstractJsonTreeDecoder;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class JsonTreeListDecoder
extends AbstractJsonTreeDecoder {
    public final JsonArray value;
    public final int size;
    public int currentIndex;

    public JsonTreeListDecoder(Json json, JsonArray jsonArray) {
        Intrinsics.checkNotNullParameter(json, "json");
        Intrinsics.checkNotNullParameter(jsonArray, "value");
        super(json, 0);
        this.value = jsonArray;
        this.size = this.getValue().size();
        this.currentIndex = -1;
    }

    @Override
    public final JsonArray getValue() {
        return this.value;
    }

    @Override
    public final String elementName(SerialDescriptor serialDescriptor, int n) {
        Intrinsics.checkNotNullParameter(serialDescriptor, "descriptor");
        return String.valueOf(n);
    }

    @Override
    public final JsonElement currentElement(String string) {
        Intrinsics.checkNotNullParameter(string, "tag");
        JsonArray jsonArray = ((JsonTreeListDecoder)((Object)jsonArray)).value;
        return (JsonElement)jsonArray.content.get(Integer.parseInt(string));
    }

    @Override
    public final int decodeElementIndex(SerialDescriptor serialDescriptor) {
        Intrinsics.checkNotNullParameter(serialDescriptor, "descriptor");
        int n = this.currentIndex;
        if (n < this.size - 1) {
            this.currentIndex = n + 1;
            return this.currentIndex;
        }
        return -1;
    }

    @Override
    public final JsonElement getValue() {
        return this.value;
    }
}

