/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.relocated.okhttp3.internal.platform;

import com.apollographql.apollo.relocated.kotlin.jvm.internal.Intrinsics;
import com.apollographql.apollo.relocated.okhttp3.OkHttpClient;
import com.apollographql.apollo.relocated.okhttp3.internal.platform.Android10Platform;
import com.apollographql.apollo.relocated.okhttp3.internal.platform.AndroidPlatform;
import com.apollographql.apollo.relocated.okhttp3.internal.platform.BouncyCastlePlatform;
import com.apollographql.apollo.relocated.okhttp3.internal.platform.ConscryptPlatform;
import com.apollographql.apollo.relocated.okhttp3.internal.platform.Jdk8WithJettyBootPlatform;
import com.apollographql.apollo.relocated.okhttp3.internal.platform.Jdk9Platform;
import com.apollographql.apollo.relocated.okhttp3.internal.platform.OpenJSSEPlatform;
import com.apollographql.apollo.relocated.okhttp3.internal.platform.Platform$Companion;
import com.apollographql.apollo.relocated.okhttp3.internal.platform.android.AndroidLog;
import com.apollographql.apollo.relocated.okhttp3.internal.tls.BasicCertificateChainCleaner;
import com.apollographql.apollo.relocated.okhttp3.internal.tls.BasicTrustRootIndex;
import com.apollographql.apollo.relocated.okhttp3.internal.tls.CertificateChainCleaner;
import com.apollographql.apollo.relocated.okhttp3.internal.tls.TrustRootIndex;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class Platform {
    public static volatile Platform platform;
    public static final Logger logger;

    static {
        Object object;
        block38: {
            block41: {
                block40: {
                    block39: {
                        block37: {
                            new Platform$Companion();
                            if (!Platform$Companion.isAndroid()) break block37;
                            for (Map.Entry entry : AndroidLog.knownLoggers.entrySet()) {
                                AndroidLog.enableLogging((String)entry.getKey(), (String)entry.getValue());
                            }
                            if (Android10Platform.isSupported) {
                                Android10Platform android10Platform;
                                object = android10Platform;
                                android10Platform = new Android10Platform();
                            } else {
                                object = null;
                            }
                            if (object == null) {
                                if (AndroidPlatform.isSupported) {
                                    AndroidPlatform androidPlatform;
                                    object = androidPlatform;
                                    androidPlatform = new AndroidPlatform();
                                } else {
                                    object = null;
                                }
                                Intrinsics.checkNotNull(object);
                            }
                            break block38;
                        }
                        if (!Intrinsics.areEqual("Conscrypt", Security.getProviders()[0].getName())) break block39;
                        if (ConscryptPlatform.isSupported) {
                            ConscryptPlatform conscryptPlatform;
                            object = conscryptPlatform;
                            conscryptPlatform = new ConscryptPlatform();
                        } else {
                            object = null;
                        }
                        if (object != null) break block38;
                    }
                    if (!Intrinsics.areEqual("BC", Security.getProviders()[0].getName())) break block40;
                    if (BouncyCastlePlatform.isSupported) {
                        BouncyCastlePlatform bouncyCastlePlatform;
                        object = bouncyCastlePlatform;
                        bouncyCastlePlatform = new BouncyCastlePlatform();
                    } else {
                        object = null;
                    }
                    if (object != null) break block38;
                }
                if (!Intrinsics.areEqual("OpenJSSE", Security.getProviders()[0].getName())) break block41;
                if (OpenJSSEPlatform.isSupported) {
                    OpenJSSEPlatform openJSSEPlatform;
                    object = openJSSEPlatform;
                    openJSSEPlatform = new OpenJSSEPlatform();
                } else {
                    object = null;
                }
                if (object != null) break block38;
            }
            if (Jdk9Platform.isAvailable) {
                Jdk9Platform jdk9Platform;
                object = jdk9Platform;
                jdk9Platform = new Jdk9Platform();
            } else {
                object = null;
            }
            if (object == null) {
                block36: {
                    block35: {
                        Jdk8WithJettyBootPlatform jdk8WithJettyBootPlatform;
                        block34: {
                            String string = System.getProperty("java.specification.version", "unknown");
                            try {
                                Intrinsics.checkNotNullExpressionValue(string, "jvmVersion");
                                if (Integer.parseInt(string) < 9) break block34;
                                break block35;
                            }
                            catch (NumberFormatException numberFormatException) {}
                        }
                        Object object2 = object = "org.eclipse.jetty.alpn.ALPN";
                        Class<?> clazz = Class.forName((String)object2, true, null);
                        Class<?> clazz2 = clazz;
                        Class<?> clazz3 = clazz;
                        Class<?> clazz4 = clazz;
                        GenericDeclaration genericDeclaration = Class.forName(Intrinsics.stringPlus("$Provider", (String)object), true, null);
                        Class<?> clazz5 = Class.forName(Intrinsics.stringPlus("$ClientProvider", (String)object), true, null);
                        object = Class.forName(Intrinsics.stringPlus("$ServerProvider", (String)object), true, null);
                        String string = "put";
                        Class[] classArray = new Class[2];
                        classArray[0] = SSLSocket.class;
                        classArray[1] = genericDeclaration;
                        genericDeclaration = clazz3.getMethod(string, classArray);
                        String string2 = "get";
                        Class[] classArray2 = new Class[1];
                        classArray2[0] = SSLSocket.class;
                        Method method = clazz4.getMethod(string2, classArray2);
                        String string3 = "remove";
                        Class[] classArray3 = new Class[1];
                        classArray3[0] = SSLSocket.class;
                        Method method2 = clazz2.getMethod(string3, classArray3);
                        Jdk8WithJettyBootPlatform jdk8WithJettyBootPlatform2 = jdk8WithJettyBootPlatform;
                        try {
                            Intrinsics.checkNotNullExpressionValue(genericDeclaration, "putMethod");
                            Intrinsics.checkNotNullExpressionValue(method, "getMethod");
                            Intrinsics.checkNotNullExpressionValue(method2, "removeMethod");
                            Intrinsics.checkNotNullExpressionValue(clazz5, "clientProviderClass");
                            Intrinsics.checkNotNullExpressionValue(object, "serverProviderClass");
                            jdk8WithJettyBootPlatform = new Jdk8WithJettyBootPlatform((Method)genericDeclaration, method, method2, clazz5, (Class)object);
                            object = jdk8WithJettyBootPlatform2;
                            break block36;
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                        }
                        catch (ClassNotFoundException classNotFoundException) {}
                    }
                    object = null;
                }
                if (object == null) {
                    Platform platform;
                    object = platform;
                    platform = new Platform();
                }
            }
        }
        platform = object;
        logger = Logger.getLogger(OkHttpClient.class.getName());
    }

    public static void log(int n, String string, Throwable throwable) {
        Intrinsics.checkNotNullParameter(string, "message");
        Level level = n == 5 ? Level.WARNING : Level.INFO;
        logger.log(level, string, throwable);
    }

    public SSLContext newSSLContext() {
        SSLContext sSLContext = SSLContext.getInstance("TLS");
        Intrinsics.checkNotNullExpressionValue(sSLContext, "getInstance(\"TLS\")");
        return sSLContext;
    }

    public X509TrustManager platformTrustManager() {
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init((KeyStore)null);
        Object object = trustManagerFactory.getTrustManagers();
        Intrinsics.checkNotNull(object);
        if (((TrustManager[])object).length == 1 && object[0] instanceof X509TrustManager) {
            if ((object = object[0]) != null) {
                return (X509TrustManager)object;
            }
            throw new NullPointerException("null cannot be cast to non-null type javax.net.ssl.X509TrustManager");
        }
        String string = Arrays.toString((Object[])object);
        Intrinsics.checkNotNullExpressionValue(string, "toString(this)");
        object = Intrinsics.stringPlus(string, "Unexpected default trust managers: ");
        throw new IllegalStateException(object.toString());
    }

    public void configureTlsExtensions(SSLSocket sSLSocket, String string, List list) {
        Intrinsics.checkNotNullParameter(list, "protocols");
    }

    public void afterHandshake(SSLSocket sSLSocket) {
    }

    public String getSelectedProtocol(SSLSocket sSLSocket) {
        return null;
    }

    public void connectSocket(Socket socket, InetSocketAddress inetSocketAddress, int n) {
        Intrinsics.checkNotNullParameter(inetSocketAddress, "address");
        socket.connect(inetSocketAddress, n);
    }

    public boolean isCleartextTrafficPermitted(String string) {
        Intrinsics.checkNotNullParameter(string, "hostname");
        return true;
    }

    public Object getStackTraceForCloseable() {
        Throwable throwable;
        String string = "response.body().close()";
        if (logger.isLoggable(Level.FINE)) {
            Throwable throwable2;
            throwable = throwable2;
            throwable2 = new Throwable(string);
        } else {
            throwable = null;
        }
        return throwable;
    }

    public void logCloseableLeak(Object object, String string) {
        Intrinsics.checkNotNullParameter(string, "message");
        if (object == null) {
            string = Intrinsics.stringPlus(" To see where this was allocated, set the OkHttpClient logger level to FINE: Logger.getLogger(OkHttpClient.class.getName()).setLevel(Level.FINE);", string);
        }
        Throwable throwable = (Throwable)object;
        Platform.log(5, string, throwable);
    }

    public CertificateChainCleaner buildCertificateChainCleaner(X509TrustManager x509TrustManager) {
        return new BasicCertificateChainCleaner(this.buildTrustRootIndex(x509TrustManager));
    }

    public TrustRootIndex buildTrustRootIndex(X509TrustManager x509TrustManager) {
        X509Certificate[] x509CertificateArray = x509TrustManager.getAcceptedIssuers();
        Intrinsics.checkNotNullExpressionValue(x509CertificateArray, "trustManager.acceptedIssuers");
        return new BasicTrustRootIndex(Arrays.copyOf(x509CertificateArray, x509CertificateArray.length));
    }

    public SSLSocketFactory newSslSocketFactory(X509TrustManager x509TrustManager) {
        SSLContext sSLContext;
        try {
            sSLContext = this.newSSLContext();
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new AssertionError(Intrinsics.stringPlus(generalSecurityException, "No System TLS: "), generalSecurityException);
        }
        TrustManager[] trustManagerArray = new TrustManager[1];
        trustManagerArray[0] = x509TrustManager;
        sSLContext.init(null, trustManagerArray, null);
        SSLSocketFactory sSLSocketFactory = sSLContext.getSocketFactory();
        Intrinsics.checkNotNullExpressionValue(sSLSocketFactory, "newSSLContext().apply {\n\u2026ll)\n      }.socketFactory");
        return sSLSocketFactory;
    }

    public final String toString() {
        return this.getClass().getSimpleName();
    }
}

