/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.relocated.okhttp3.internal.connection;

import com.apollographql.apollo.relocated.kotlin.jvm.internal.Intrinsics;
import com.apollographql.apollo.relocated.okhttp3.Address;
import com.apollographql.apollo.relocated.okhttp3.internal.Util;
import com.apollographql.apollo.relocated.okhttp3.internal.concurrent.TaskQueue;
import com.apollographql.apollo.relocated.okhttp3.internal.concurrent.TaskRunner;
import com.apollographql.apollo.relocated.okhttp3.internal.connection.RealCall;
import com.apollographql.apollo.relocated.okhttp3.internal.connection.RealCall$CallReference;
import com.apollographql.apollo.relocated.okhttp3.internal.connection.RealConnection;
import com.apollographql.apollo.relocated.okhttp3.internal.connection.RealConnectionPool$cleanupTask$1;
import com.apollographql.apollo.relocated.okhttp3.internal.platform.Platform;
import java.lang.ref.Reference;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;

public final class RealConnectionPool {
    public final int maxIdleConnections;
    public final long keepAliveDurationNs;
    public final TaskQueue cleanupQueue;
    public final RealConnectionPool$cleanupTask$1 cleanupTask;
    public final ConcurrentLinkedQueue connections;

    public RealConnectionPool(TaskRunner object, TimeUnit timeUnit) {
        RealConnectionPool realConnectionPool = this;
        Intrinsics.checkNotNullParameter(object, "taskRunner");
        Intrinsics.checkNotNullParameter((Object)timeUnit, "timeUnit");
        this.maxIdleConnections = 5;
        this.keepAliveDurationNs = timeUnit.toNanos(5L);
        realConnectionPool.cleanupQueue = ((TaskRunner)object).newQueue();
        object = Intrinsics.stringPlus(" ConnectionPool", Util.okHttpName);
        realConnectionPool.cleanupTask = new RealConnectionPool$cleanupTask$1(this, (String)object);
        realConnectionPool.connections = new ConcurrentLinkedQueue();
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public final boolean callAcquirePooledConnection(Address var1_1, RealCall var2_2, List var3_3, boolean var4_4) {
        block6: {
            Intrinsics.checkNotNullParameter(var1_1, "address");
            Intrinsics.checkNotNullParameter(var2_2, "call");
            this = this.connections.iterator();
            while (this.hasNext() != false) {
                block7: {
                    var5_5 = (RealConnection)this.next();
                    Intrinsics.checkNotNullExpressionValue(var5_5, "connection");
                    // MONITORENTER : var5_5
                    if (!var4_4) ** GOTO lbl11
                    if (!var5_5.isMultiplexed$okhttp()) break block7;
lbl11:
                    // 2 sources

                    if (var5_5.isEligible$okhttp(var1_1, var3_3)) break block6;
                }
                v0 = var5_5;
            }
            return false;
        }
        var2_2.acquireConnectionNoEvents(var5_5);
        // MONITOREXIT : var5_5
        return true;
    }

    public final void put(RealConnection realConnection) {
        if (Util.assertionsEnabled && !Thread.holdsLock(realConnection)) {
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST hold lock on " + realConnection));
        }
        RealConnectionPool realConnectionPool = this;
        realConnectionPool.connections.add(realConnection);
        realConnectionPool.cleanupQueue.schedule(this.cleanupTask, 0L);
    }

    /*
     * Unable to fully structure code
     */
    public final long cleanup(long var1_1) {
        var3_2 = 0;
        var4_3 = 0;
        var5_4 = null;
        var6_5 = -9223372036854775808L;
        for (RealConnection var9_8 : this.connections) {
            Intrinsics.checkNotNullExpressionValue(var9_8, "connection");
            synchronized (var9_8) {
                block16: {
                    block17: {
                        if (this.pruneAndGetAllocationCount(var9_8, var1_1) > 0) {
                            ++var3_2;
                            break block16;
                        }
                        ++var4_3;
                        var10_9 = var1_1 - var9_8.getIdleAtNs$okhttp();
                        if (var10_9 <= var6_5) break block17;
                        var6_5 = var10_9;
                        var5_4 = var9_8;
                    }
                    ** try [egrp 2[TRYBLOCK] [2 : 93->96)] { 
lbl22:
                    // 1 sources

                }
            }
        }
        var8_7 = this.keepAliveDurationNs;
        if (var6_5 < var8_7 && var4_3 <= this.maxIdleConnections) {
            if (var4_3 > 0) {
                return var8_7 - var6_5;
            }
            if (var3_2 > 0) {
                return var8_7;
            }
            return -1L;
        }
        v1 = var5_4;
        Intrinsics.checkNotNull(v1);
        synchronized (v1) {
            block19: {
                block18: {
                    if (!(v1.getCalls().isEmpty() ^ true)) break block18;
                    return 0L;
                }
                if (var5_4.getIdleAtNs$okhttp() + var6_5 == var1_1) break block19;
                // ** MonitorExit[var5_4] (shouldn't be in output)
                return 0L;
            }
            v3 = this;
            v4 = var5_4;
            v5 = v4;
            v6 = v4;
            var5_4.setNoNewExchanges();
            this.connections.remove(var5_4);
            Util.closeQuietly(v6.socket());
            if (v3.connections.isEmpty()) {
                this.cleanupQueue.cancelAll();
            }
            return 0L;
        }
    }

    public final int pruneAndGetAllocationCount(RealConnection realConnection, long l) {
        if (Util.assertionsEnabled && !Thread.holdsLock(realConnection)) {
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST hold lock on " + realConnection));
        }
        ArrayList arrayList = realConnection.calls;
        int n = 0;
        while (n < arrayList.size()) {
            Object object = (Reference)arrayList.get(n);
            if (((Reference)object).get() != null) {
                ++n;
                continue;
            }
            RealCall$CallReference realCall$CallReference = (RealCall$CallReference)object;
            object = "A connection to " + realConnection.route.address.url + " was leaked. Did you forget to close a response body?";
            Platform.platform.logCloseableLeak(realCall$CallReference.callStackTrace, (String)object);
            arrayList.remove(n);
            realConnection.noNewExchanges = true;
            if (!arrayList.isEmpty()) continue;
            realConnection.idleAtNs = l - this.keepAliveDurationNs;
            return 0;
        }
        return arrayList.size();
    }
}

