/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.relocated.kotlinx.serialization.internal;

import com.apollographql.apollo.relocated.kotlin.LazyKt__LazyKt;
import com.apollographql.apollo.relocated.kotlin.SynchronizedLazyImpl;
import com.apollographql.apollo.relocated.kotlin.jvm.internal.Intrinsics;
import com.apollographql.apollo.relocated.kotlinx.serialization.KSerializer;
import com.apollographql.apollo.relocated.kotlinx.serialization.SerializationException;
import com.apollographql.apollo.relocated.kotlinx.serialization.descriptors.SerialDescriptor;
import com.apollographql.apollo.relocated.kotlinx.serialization.encoding.Decoder;
import com.apollographql.apollo.relocated.kotlinx.serialization.encoding.Encoder;
import com.apollographql.apollo.relocated.kotlinx.serialization.internal.EnumSerializer$descriptor$2;
import java.util.Arrays;

public final class EnumSerializer
implements KSerializer {
    public final Enum[] values;
    public final SynchronizedLazyImpl descriptor$delegate;

    public EnumSerializer(String string, Enum[] enumArray) {
        EnumSerializer enumSerializer = this;
        enumSerializer.values = enumArray;
        enumSerializer.descriptor$delegate = LazyKt__LazyKt.lazy(new EnumSerializer$descriptor$2(this, string));
    }

    @Override
    public final SerialDescriptor getDescriptor() {
        return (SerialDescriptor)this.descriptor$delegate.getValue();
    }

    public final String toString() {
        return "kotlinx.serialization.internal.EnumSerializer<" + this.getDescriptor().getSerialName() + '>';
    }

    @Override
    public final void serialize(Encoder encoder, Object object) {
        int n;
        block3: {
            object = (Enum)object;
            Intrinsics.checkNotNullParameter(encoder, "encoder");
            Intrinsics.checkNotNullParameter(object, "value");
            Enum[] enumArray = this.values;
            Intrinsics.checkNotNullParameter(enumArray, "<this>");
            int n2 = this.values.length;
            for (n = 0; n < n2; ++n) {
                if (!Intrinsics.areEqual(object, enumArray[n])) {
                    continue;
                }
                break block3;
            }
            n = -1;
        }
        if (n != -1) {
            encoder.encodeEnum(this.getDescriptor(), n);
            return;
        }
        StringBuilder stringBuilder = new StringBuilder().append(object).append(" is not a valid enum ").append(this.getDescriptor().getSerialName()).append(", must be one of ");
        String string = Arrays.toString(this.values);
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        throw new SerializationException(stringBuilder.append(string).toString());
    }

    @Override
    public final Object deserialize(Decoder decoder) {
        Intrinsics.checkNotNullParameter(decoder, "decoder");
        int n = decoder.decodeEnum(this.getDescriptor());
        if (n >= 0 && n < this.values.length) {
            return this.values[n];
        }
        throw new SerializationException(n + " is not among valid " + this.getDescriptor().getSerialName() + " enum values, values size is " + this.values.length);
    }
}

