/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.compiler.internal;

import com.apollographql.apollo.compiler.internal.ValidationScope;
import com.apollographql.apollo.relocated.com.apollographql.apollo.ast.GQLDefinition;
import com.apollographql.apollo.relocated.com.apollographql.apollo.ast.GQLField;
import com.apollographql.apollo.relocated.com.apollographql.apollo.ast.GQLFragmentDefinition;
import com.apollographql.apollo.relocated.com.apollographql.apollo.ast.GQLFragmentSpread;
import com.apollographql.apollo.relocated.com.apollographql.apollo.ast.GQLInlineFragment;
import com.apollographql.apollo.relocated.com.apollographql.apollo.ast.GQLNode;
import com.apollographql.apollo.relocated.com.apollographql.apollo.ast.GQLOperationDefinition;
import com.apollographql.apollo.relocated.com.apollographql.apollo.ast.GQLSelection;
import com.apollographql.apollo.relocated.com.apollographql.apollo.ast.Issue;
import com.apollographql.apollo.relocated.com.apollographql.apollo.ast.UpperCaseField;
import com.apollographql.apollo.relocated.kotlin.NoWhenBranchMatchedException;
import com.apollographql.apollo.relocated.kotlin.collections.CollectionsKt__IterablesKt;
import com.apollographql.apollo.relocated.kotlin.collections.MapsKt__MapsJVMKt;
import com.apollographql.apollo.relocated.kotlin.jvm.internal.Intrinsics;
import com.apollographql.apollo.relocated.kotlin.ranges.RangesKt___RangesKt;
import com.apollographql.apollo.relocated.kotlin.text.StringsKt__IndentKt;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u001a$\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00040\u00012\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u001a\u001a\u0010\u0000\u001a\u00020\u0007*\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0001H\u0002\u001a\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0002\u001a\u0010\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u000f"}, d2={"checkCapitalizedFields", "", "Lcom/apollographql/apollo/ast/Issue;", "definitions", "Lcom/apollographql/apollo/ast/GQLDefinition;", "checkFragmentsOnly", "", "", "Lcom/apollographql/apollo/compiler/internal/ValidationScope;", "selections", "Lcom/apollographql/apollo/ast/GQLSelection;", "isFirstLetterUpperCase", "name", "", "decapitalizeFirstLetter", "apollo-compiler"})
public final class -checkCapitalizedFields {
    public static final List<Issue> checkCapitalizedFields(List<? extends GQLDefinition> object, boolean bl) {
        ValidationScope validationScope;
        Iterator iterator2 = object;
        Intrinsics.checkNotNullParameter(iterator2, "definitions");
        ValidationScope validationScope2 = validationScope;
        validationScope = new ValidationScope((List<? extends GQLDefinition>)((Object)object)){
            private final List<Issue> issues;
            private final Map<String, GQLFragmentDefinition> fragmentsByName;
            {
                LinkedHashMap<K, V> linkedHashMap;
                ArrayList<T> arrayList2;
                ArrayList<T> arrayList3;
                ArrayList<T> arrayList4 = arrayList;
                arrayList = arrayList3;
                arrayList3 = new ArrayList<T>();
                this.issues = arrayList;
                arrayList = arrayList2;
                arrayList2 = new ArrayList<T>();
                for (Object object : arrayList4) {
                    if (!(object instanceof GQLFragmentDefinition)) continue;
                    arrayList.add(object);
                }
                ArrayList<T> arrayList5 = arrayList;
                int n = RangesKt___RangesKt.coerceAtLeast(MapsKt__MapsJVMKt.mapCapacity(CollectionsKt__IterablesKt.collectionSizeOrDefault(arrayList5)));
                LinkedHashMap<K, V> linkedHashMap2 = linkedHashMap;
                linkedHashMap = new LinkedHashMap<K, V>(n);
                for (Object object : arrayList5) {
                    linkedHashMap2.put(((GQLFragmentDefinition)object).getName(), object);
                }
                this.fragmentsByName = linkedHashMap2;
            }

            public List<Issue> getIssues() {
                return this.issues;
            }

            public Map<String, GQLFragmentDefinition> getFragmentsByName() {
                return this.fragmentsByName;
            }
        };
        object = iterator2.iterator();
        while (object.hasNext()) {
            GQLDefinition gQLDefinition = (GQLDefinition)object.next();
            if (gQLDefinition instanceof GQLOperationDefinition && !bl) {
                -checkCapitalizedFields.checkCapitalizedFields(validationScope2, ((GQLOperationDefinition)gQLDefinition).selections);
                continue;
            }
            if (!(gQLDefinition instanceof GQLFragmentDefinition)) continue;
            -checkCapitalizedFields.checkCapitalizedFields(validationScope2, ((GQLFragmentDefinition)gQLDefinition).selections);
        }
        return validationScope2.getIssues();
    }

    private static final void checkCapitalizedFields(ValidationScope validationScope, List<? extends GQLSelection> object) {
        object = object.iterator();
        while (object.hasNext()) {
            GQLNode gQLNode = (GQLSelection)object.next();
            if (gQLNode instanceof GQLField) {
                gQLNode = (GQLField)gQLNode;
                String string = ((GQLField)gQLNode).alias;
                if (string != null) {
                    if (-checkCapitalizedFields.isFirstLetterUpperCase(string)) {
                        string = StringsKt__IndentKt.trimIndent("\n                      Capitalized alias '" + string + "' is not supported as it causes name clashes with the generated models. Use '" + -checkCapitalizedFields.decapitalizeFirstLetter(string) + "' instead.\n                    ");
                        validationScope.getIssues().add(new UpperCaseField(((GQLField)gQLNode).sourceLocation, string));
                    }
                } else if (-checkCapitalizedFields.isFirstLetterUpperCase(((GQLField)gQLNode).name)) {
                    string = StringsKt__IndentKt.trimIndent("\n                      Capitalized field '" + ((GQLField)gQLNode).name + "' is not supported as it causes name clashes with the generated models. Use an alias instead or the 'flattenModels' or 'decapitalizeFields' compiler option.\n                    ");
                    validationScope.getIssues().add(new UpperCaseField(((GQLField)gQLNode).sourceLocation, string));
                }
                -checkCapitalizedFields.checkCapitalizedFields(validationScope, ((GQLField)gQLNode).selections);
                continue;
            }
            if (gQLNode instanceof GQLInlineFragment) {
                -checkCapitalizedFields.checkCapitalizedFields(validationScope, ((GQLInlineFragment)gQLNode).selections);
                continue;
            }
            if (gQLNode instanceof GQLFragmentSpread) {
                gQLNode = validationScope.getFragmentsByName().get(((GQLFragmentSpread)gQLNode).name);
                if (gQLNode == null) continue;
                -checkCapitalizedFields.checkCapitalizedFields(validationScope, ((GQLFragmentDefinition)gQLNode).selections);
                continue;
            }
            throw new NoWhenBranchMatchedException();
        }
    }

    private static final boolean isFirstLetterUpperCase(String object) {
        block1: {
            for (int i = 0; i < object.length(); ++i) {
                char c = object.charAt(i);
                if (!Character.isLetter(c)) continue;
                object = Character.valueOf(c);
                break block1;
            }
            object = null;
        }
        return object != null ? Character.isUpperCase(((Character)object).charValue()) : true;
    }

    private static final String decapitalizeFirstLetter(String string) {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder(string.length());
        boolean bl = false;
        for (int i = 0; i < string.length(); ++i) {
            String string2;
            char c = string.charAt(i);
            if (!bl && Character.isLetter(c)) {
                bl = true;
                string2 = String.valueOf(c).toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue(string2, "toLowerCase(...)");
            } else {
                string2 = String.valueOf(c);
            }
            stringBuilder2.append(string2);
        }
        String string3 = stringBuilder2.toString();
        Intrinsics.checkNotNullExpressionValue(string3, "toString(...)");
        return string3;
    }
}

