/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.relocated.okio;

import com.apollographql.apollo.relocated.kotlin.jvm.internal.Intrinsics;
import com.apollographql.apollo.relocated.kotlin.text.StringsKt___StringsJvmKt;
import com.apollographql.apollo.relocated.okio.-SegmentedByteString;
import com.apollographql.apollo.relocated.okio.Buffer;
import com.apollographql.apollo.relocated.okio.InflaterSource;
import com.apollographql.apollo.relocated.okio.RealBufferedSource;
import com.apollographql.apollo.relocated.okio.Segment;
import com.apollographql.apollo.relocated.okio.Source;
import com.apollographql.apollo.relocated.okio.Timeout;
import java.io.EOFException;
import java.io.IOException;
import java.util.zip.CRC32;
import java.util.zip.Inflater;

public final class GzipSource
implements Source {
    public byte section;
    public final RealBufferedSource source;
    public final Inflater inflater;
    public final InflaterSource inflaterSource;
    public final CRC32 crc;

    public GzipSource(Source object) {
        CRC32 cRC32;
        InflaterSource inflaterSource;
        Inflater inflater;
        RealBufferedSource realBufferedSource;
        Intrinsics.checkNotNullParameter(object, "source");
        Object object2 = realBufferedSource;
        realBufferedSource = new RealBufferedSource((Source)object);
        v1.source = object2;
        object = inflater;
        inflater = new Inflater(true);
        v1.inflater = object;
        InflaterSource inflaterSource2 = inflaterSource;
        inflaterSource = new InflaterSource((RealBufferedSource)object2, (Inflater)object);
        v1.inflaterSource = inflaterSource2;
        object2 = cRC32;
        cRC32 = new CRC32();
        v1.crc = object2;
    }

    public static void checkEqual(int n, int n2, String string) {
        if (n2 == n) {
            return;
        }
        throw new IOException(string + ": actual 0x" + StringsKt___StringsJvmKt.padStart(-SegmentedByteString.toHexString(n2), 8) + " != expected 0x" + StringsKt___StringsJvmKt.padStart(-SegmentedByteString.toHexString(n), 8));
    }

    @Override
    public final long read(Buffer buffer, long l) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter(buffer, "sink");
        if (l >= 0L) {
            if (l == 0L) {
                return 0L;
            }
            if (((GzipSource)object).section == 0) {
                Buffer buffer2;
                Buffer buffer3;
                ((GzipSource)object).source.require(10L);
                byte by = ((GzipSource)object).source.bufferField.getByte(3L);
                boolean bl = (by >> 1 & 1) == 1;
                if (bl) {
                    buffer3 = ((GzipSource)object).source.bufferField;
                    ((GzipSource)object).updateCrc(0L, 10L, buffer3);
                }
                GzipSource.checkEqual(8075, ((GzipSource)object).source.readShort(), "ID1ID2");
                ((GzipSource)object).source.skip(8L);
                if ((by >> 2 & 1) == 1) {
                    ((GzipSource)object).source.require(2L);
                    if (bl) {
                        buffer3 = ((GzipSource)object).source.bufferField;
                        ((GzipSource)object).updateCrc(0L, 2L, buffer3);
                    }
                    long l2 = ((GzipSource)object).source.bufferField.readShortLe() & 0xFFFF;
                    ((GzipSource)object).source.require(l2);
                    if (bl) {
                        buffer2 = ((GzipSource)object).source.bufferField;
                        ((GzipSource)object).updateCrc(0L, l2, buffer2);
                    }
                    ((GzipSource)object).source.skip(l2);
                }
                if ((by >> 3 & 1) == 1) {
                    long l3 = ((GzipSource)object).source.indexOf((byte)0, 0L, Long.MAX_VALUE);
                    if (l3 != -1L) {
                        if (bl) {
                            buffer2 = ((GzipSource)object).source.bufferField;
                            long l4 = l3 + 1L;
                            ((GzipSource)object).updateCrc(0L, l4, buffer2);
                        }
                        ((GzipSource)object).source.skip(l3 + 1L);
                    } else {
                        throw new EOFException();
                    }
                }
                if ((by >> 4 & 1) == 1) {
                    long l5 = ((GzipSource)object).source.indexOf((byte)0, 0L, Long.MAX_VALUE);
                    if (l5 != -1L) {
                        if (bl) {
                            Buffer buffer4 = ((GzipSource)object).source.bufferField;
                            long l6 = l5 + 1L;
                            ((GzipSource)object).updateCrc(0L, l6, buffer4);
                        }
                        ((GzipSource)object).source.skip(l5 + 1L);
                    } else {
                        throw new EOFException();
                    }
                }
                if (bl) {
                    GzipSource.checkEqual(((GzipSource)object).source.readShortLe(), (short)((GzipSource)object).crc.getValue(), "FHCRC");
                    ((GzipSource)object).crc.reset();
                }
                ((GzipSource)object).section = 1;
            }
            if (((GzipSource)object).section == 1) {
                long l7 = buffer.size;
                if ((l = ((GzipSource)object).inflaterSource.read(buffer, l)) != -1L) {
                    ((GzipSource)object).updateCrc(l7, l, buffer);
                    return l;
                }
                ((GzipSource)object).section = (byte)2;
            }
            if (((GzipSource)object).section == 2) {
                GzipSource.checkEqual(((GzipSource)object).source.readIntLe(), (int)((GzipSource)object).crc.getValue(), "CRC");
                GzipSource.checkEqual(((GzipSource)object).source.readIntLe(), (int)((GzipSource)object).inflater.getBytesWritten(), "ISIZE");
                ((GzipSource)object).section = (byte)3;
                if (!((GzipSource)object).source.exhausted()) {
                    throw new IOException("gzip finished without exhausting source");
                }
            }
            return -1L;
        }
        Object object = stringBuilder;
        ((StringBuilder)object)("byteCount < 0: ");
        object = stringBuilder.append(l).toString();
        throw new IllegalArgumentException(object.toString());
    }

    @Override
    public final Timeout timeout() {
        return this.source.source.timeout();
    }

    @Override
    public final void close() {
        this.inflaterSource.close();
    }

    public final void updateCrc(long l, long l2, Buffer object) {
        int n;
        int n2;
        object = ((Buffer)object).head;
        Intrinsics.checkNotNull(object);
        while (l >= (long)((n2 = ((Segment)object).limit) - (n = ((Segment)object).pos))) {
            l -= (long)(n2 - n);
            object = ((Segment)object).next;
            Intrinsics.checkNotNull(object);
        }
        while (l2 > 0L) {
            Object object2 = object;
            int n3 = (int)((long)((Segment)object2).pos + l);
            int n4 = (int)Math.min((long)(((Segment)object2).limit - n3), l2);
            this.crc.update(((Segment)object).data, n3, n4);
            l2 -= (long)n4;
            l = 0L;
            object = ((Segment)object).next;
            Intrinsics.checkNotNull(object);
        }
    }
}

