/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.compiler.ir;

import com.apollographql.apollo.compiler.Annotations;
import com.apollographql.apollo.compiler.ClassNames;
import com.apollographql.apollo.compiler.InputTypeSpecBuilder;
import com.apollographql.apollo.compiler.TestUtilsKt;
import com.apollographql.apollo.compiler.ir.CodeGenerationContext;
import com.apollographql.apollo.compiler.ir.CodeGenerator;
import com.apollographql.apollo.compiler.ir.TypeDeclarationField;
import com.apollographql.apollo.compiler.ir.TypeDeclarationValue;
import com.apollographql.relocated.com.squareup.javapoet.ClassName;
import com.apollographql.relocated.com.squareup.javapoet.CodeBlock;
import com.apollographql.relocated.com.squareup.javapoet.FieldSpec;
import com.apollographql.relocated.com.squareup.javapoet.MethodSpec;
import com.apollographql.relocated.com.squareup.javapoet.ParameterSpec;
import com.apollographql.relocated.com.squareup.javapoet.TypeSpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.lang.model.element.Modifier;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\b\u0018\u0000 '2\u00020\u0001:\u0001'B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0003J\u000f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\n0\u0007H\u00c6\u0003JG\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007H\u00c6\u0001J\b\u0010\u0019\u001a\u00020\u001aH\u0002J\u0013\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u00d6\u0003J\t\u0010\u001f\u001a\u00020 H\u00d6\u0001J\u0010\u0010!\u001a\u00020\u001a2\u0006\u0010\"\u001a\u00020#H\u0002J\t\u0010$\u001a\u00020\u0003H\u00d6\u0001J\u0018\u0010%\u001a\u00020\u001a2\u0006\u0010\"\u001a\u00020#2\u0006\u0010&\u001a\u00020\u001cH\u0016R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\rR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000f\u00a8\u0006("}, d2={"Lcom/apollographql/apollo/compiler/ir/TypeDeclaration;", "Lcom/apollographql/apollo/compiler/ir/CodeGenerator;", "kind", "", "name", "description", "values", "", "Lcom/apollographql/apollo/compiler/ir/TypeDeclarationValue;", "fields", "Lcom/apollographql/apollo/compiler/ir/TypeDeclarationField;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Ljava/util/List;)V", "getDescription", "()Ljava/lang/String;", "getFields", "()Ljava/util/List;", "getKind", "getName", "getValues", "component1", "component2", "component3", "component4", "component5", "copy", "enumTypeToTypeSpec", "Lcom/apollographql/relocated/com/squareup/javapoet/TypeSpec;", "equals", "", "other", "", "hashCode", "", "inputObjectToTypeSpec", "context", "Lcom/apollographql/apollo/compiler/ir/CodeGenerationContext;", "toString", "toTypeSpec", "abstract", "Companion", "apollo-compiler"})
public final class TypeDeclaration
implements CodeGenerator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String kind;
    @NotNull
    private final String name;
    @NotNull
    private final String description;
    @NotNull
    private final List<TypeDeclarationValue> values;
    @NotNull
    private final List<TypeDeclarationField> fields;
    @NotNull
    private static final String KIND_INPUT_OBJECT_TYPE = "InputObjectType";
    @NotNull
    private static final String KIND_ENUM = "EnumType";
    @NotNull
    private static final String KIND_SCALAR_TYPE = "ScalarType";
    @NotNull
    private static final String ENUM_UNKNOWN_CONSTANT = "$UNKNOWN";
    @NotNull
    private static final String ENUM_SAFE_VALUE_OF = "safeValueOf";

    public TypeDeclaration(@NotNull String kind, @NotNull String name, @NotNull String description2, @NotNull List<TypeDeclarationValue> values, @NotNull List<TypeDeclarationField> fields2) {
        Intrinsics.checkParameterIsNotNull((Object)kind, (String)"kind");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)description2, (String)"description");
        Intrinsics.checkParameterIsNotNull(values, (String)"values");
        Intrinsics.checkParameterIsNotNull(fields2, (String)"fields");
        this.kind = kind;
        this.name = name;
        this.description = description2;
        this.values = values;
        this.fields = fields2;
    }

    public /* synthetic */ TypeDeclaration(String string, String string2, String string3, List list, List list2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string3 = "";
        }
        if ((n & 8) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 0x10) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        this(string, string2, string3, list, list2);
    }

    @NotNull
    public final String getKind() {
        return this.kind;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final String getDescription() {
        return this.description;
    }

    @NotNull
    public final List<TypeDeclarationValue> getValues() {
        return this.values;
    }

    @NotNull
    public final List<TypeDeclarationField> getFields() {
        return this.fields;
    }

    @Override
    @NotNull
    public TypeSpec toTypeSpec(@NotNull CodeGenerationContext context, boolean bl) {
        TypeSpec typeSpec;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        String string = this.kind;
        if (Intrinsics.areEqual((Object)string, (Object)KIND_ENUM)) {
            typeSpec = this.enumTypeToTypeSpec();
        } else if (Intrinsics.areEqual((Object)string, (Object)KIND_INPUT_OBJECT_TYPE)) {
            typeSpec = this.inputObjectToTypeSpec(context);
        } else {
            throw new UnsupportedOperationException("unsupported " + this.kind + " type declaration");
        }
        return typeSpec;
    }

    /*
     * WARNING - void declaration
     */
    private final TypeSpec enumTypeToTypeSpec() {
        boolean bl;
        void $this$mapTo$iv$iv;
        Modifier[] $this$map$iv = (Modifier[])this.values;
        boolean $i$f$map22 = false;
        Object object = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Object $this$enumTypeToTypeSpec_u24lambda_u2d2_u24lambda_u2d0;
            void value;
            TypeDeclarationValue typeDeclarationValue = (TypeDeclarationValue)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            Object object2 = new Object[]{value.getName()};
            object2 = TypeSpec.anonymousClassBuilder("$S", (Object[])object2);
            boolean bl3 = false;
            boolean bl4 = false;
            Object object3 = object2;
            String string = value.getName();
            boolean bl5 = false;
            Object[] objectArray = (Object[])value.getDescription();
            boolean bl6 = false;
            bl = false;
            if (!(objectArray == null || objectArray.length() == 0)) {
                objectArray = new Object[]{value.getDescription()};
                ((TypeSpec.Builder)$this$enumTypeToTypeSpec_u24lambda_u2d2_u24lambda_u2d0).addJavadoc("$L\n", objectArray);
            }
            Unit unit = Unit.INSTANCE;
            bl3 = false;
            bl4 = false;
            $this$enumTypeToTypeSpec_u24lambda_u2d2_u24lambda_u2d0 = object2;
            boolean bl7 = false;
            if (value.getDeprecationReason() != null) {
                void $this$enumTypeToTypeSpec_u24lambda_u2d2_u24lambda_u2d1;
                $this$enumTypeToTypeSpec_u24lambda_u2d2_u24lambda_u2d1.addAnnotation(Annotations.INSTANCE.getDEPRECATED());
                objectArray = value.getDeprecationReason();
                bl6 = false;
                bl = false;
                if (!(objectArray == null || StringsKt.isBlank((CharSequence)objectArray))) {
                    objectArray = new Object[]{value.getDeprecationReason()};
                    $this$enumTypeToTypeSpec_u24lambda_u2d2_u24lambda_u2d1.addJavadoc("@deprecated $L\n", objectArray);
                }
            }
            unit = Unit.INSTANCE;
            Pair pair = TuplesKt.to((Object)string, (Object)((TypeSpec.Builder)object2).build());
            collection.add(pair);
        }
        List enumConstants = (List)destination$iv$iv;
        Object[] $i$f$map22 = new Object[]{"$UNKNOWN"};
        TypeSpec.Builder builder = TypeSpec.anonymousClassBuilder("$S", $i$f$map22);
        $i$f$map22 = new Object[]{"Auto generated constant for unknown enum values"};
        TypeSpec unknownConstantTypeSpec = builder.addJavadoc("$L\n", $i$f$map22).build();
        object = new Modifier[]{Modifier.PUBLIC, Modifier.STATIC};
        MethodSpec.Builder builder2 = MethodSpec.methodBuilder(ENUM_SAFE_VALUE_OF).addModifiers((Modifier)((Object)object)).addParameter(ParameterSpec.builder(ClassNames.INSTANCE.getSTRING(), "rawValue", new Modifier[0]).build()).returns(ClassName.get("", StringsKt.capitalize((String)this.name), new String[0]));
        object = new Object[]{StringsKt.capitalize((String)this.name)};
        CodeBlock.Builder builder3 = CodeBlock.builder().beginControlFlow("for ($L enumValue : values())", (Object[])object).beginControlFlow("if (enumValue.rawValue.equals(rawValue))", new Object[0]).addStatement("return enumValue", new Object[0]).endControlFlow().endControlFlow();
        object = new Object[]{StringsKt.capitalize((String)this.name), ENUM_UNKNOWN_CONSTANT};
        MethodSpec safeValueOfMethodSpec = builder2.addCode(builder3.addStatement("return $L.$L", (Object[])object).build()).build();
        Object object4 = new Modifier[]{Modifier.PUBLIC};
        TypeSpec.Builder builder4 = TypeSpec.enumBuilder(StringsKt.capitalize((String)this.name)).addModifiers((Modifier[])object4);
        object4 = new Modifier[]{Modifier.PRIVATE, Modifier.FINAL};
        TypeSpec.Builder builder5 = builder4.addField(FieldSpec.builder(ClassNames.INSTANCE.getSTRING(), "rawValue", (Modifier[])object4).build()).addMethod(MethodSpec.constructorBuilder().addParameter(ParameterSpec.builder(ClassNames.INSTANCE.getSTRING(), "rawValue", new Modifier[0]).build()).addStatement("this.rawValue = rawValue", new Object[0]).build());
        object4 = new Modifier[]{Modifier.PUBLIC};
        object4 = builder5.addMethod(MethodSpec.methodBuilder("rawValue").addModifiers((Modifier[])object4).returns(ClassNames.INSTANCE.getSTRING()).addStatement("return rawValue", new Object[0]).build());
        boolean bl8 = false;
        boolean bl9 = false;
        Object $this$enumTypeToTypeSpec_u24lambda_u2d4 = object4;
        boolean bl10 = false;
        Iterable $this$forEach$iv = enumConstants;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair $dstr$name$typeSpec = (Pair)element$iv;
            boolean bl11 = false;
            String name = (String)$dstr$name$typeSpec.component1();
            TypeSpec typeSpec = (TypeSpec)$dstr$name$typeSpec.component2();
            String string = TestUtilsKt.escapeJavaReservedWord(name);
            bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.toUpperCase();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).toUpperCase()");
            ((TypeSpec.Builder)$this$enumTypeToTypeSpec_u24lambda_u2d4).addEnumConstant(string3, typeSpec);
        }
        object4 = ((TypeSpec.Builder)object4).addEnumConstant(ENUM_UNKNOWN_CONSTANT, unknownConstantTypeSpec);
        bl8 = false;
        bl9 = false;
        Object $this$enumTypeToTypeSpec_u24lambda_u2d5 = object4;
        boolean bl12 = false;
        Object[] objectArray = (Object[])this.getDescription();
        boolean bl13 = false;
        if (objectArray.length() > 0) {
            objectArray = new Object[]{this.getDescription()};
            ((TypeSpec.Builder)$this$enumTypeToTypeSpec_u24lambda_u2d5).addJavadoc("$L\n", objectArray);
        }
        object = ((TypeSpec.Builder)object4).addMethod(safeValueOfMethodSpec).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"enumBuilder(name.capitalize())\n        .addModifiers(Modifier.PUBLIC)\n        .addField(FieldSpec.builder(ClassNames.STRING, \"rawValue\", Modifier.PRIVATE, Modifier.FINAL).build())\n        .addMethod(MethodSpec.constructorBuilder()\n            .addParameter(ParameterSpec.builder(ClassNames.STRING, \"rawValue\").build())\n            .addStatement(\"this.rawValue = rawValue\")\n            .build()\n        )\n        .addMethod(MethodSpec.methodBuilder(\"rawValue\")\n            .addModifiers(Modifier.PUBLIC)\n            .returns(ClassNames.STRING)\n            .addStatement(\"return rawValue\")\n            .build())\n        .apply {\n          enumConstants.forEach { (name, typeSpec) ->\n            addEnumConstant(name.escapeJavaReservedWord().toUpperCase(), typeSpec)\n          }\n        }\n        .addEnumConstant(ENUM_UNKNOWN_CONSTANT, unknownConstantTypeSpec)\n        .apply {\n          if (description.isNotEmpty()) {\n            addJavadoc(\"\\$L\\n\", description)\n          }\n        }\n        .addMethod(safeValueOfMethodSpec)\n        .build()");
        return object;
    }

    private final TypeSpec inputObjectToTypeSpec(CodeGenerationContext context) {
        return new InputTypeSpecBuilder(this.name, this.fields, context).build();
    }

    @NotNull
    public final String component1() {
        return this.kind;
    }

    @NotNull
    public final String component2() {
        return this.name;
    }

    @NotNull
    public final String component3() {
        return this.description;
    }

    @NotNull
    public final List<TypeDeclarationValue> component4() {
        return this.values;
    }

    @NotNull
    public final List<TypeDeclarationField> component5() {
        return this.fields;
    }

    @NotNull
    public final TypeDeclaration copy(@NotNull String kind, @NotNull String name, @NotNull String description2, @NotNull List<TypeDeclarationValue> values, @NotNull List<TypeDeclarationField> fields2) {
        Intrinsics.checkParameterIsNotNull((Object)kind, (String)"kind");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)description2, (String)"description");
        Intrinsics.checkParameterIsNotNull(values, (String)"values");
        Intrinsics.checkParameterIsNotNull(fields2, (String)"fields");
        return new TypeDeclaration(kind, name, description2, values, fields2);
    }

    public static /* synthetic */ TypeDeclaration copy$default(TypeDeclaration typeDeclaration, String string, String string2, String string3, List list, List list2, int n, Object object) {
        if ((n & 1) != 0) {
            string = typeDeclaration.kind;
        }
        if ((n & 2) != 0) {
            string2 = typeDeclaration.name;
        }
        if ((n & 4) != 0) {
            string3 = typeDeclaration.description;
        }
        if ((n & 8) != 0) {
            list = typeDeclaration.values;
        }
        if ((n & 0x10) != 0) {
            list2 = typeDeclaration.fields;
        }
        return typeDeclaration.copy(string, string2, string3, list, list2);
    }

    @NotNull
    public String toString() {
        return "TypeDeclaration(kind=" + this.kind + ", name=" + this.name + ", description=" + this.description + ", values=" + this.values + ", fields=" + this.fields + ')';
    }

    public int hashCode() {
        int result = this.kind.hashCode();
        result = result * 31 + this.name.hashCode();
        result = result * 31 + this.description.hashCode();
        result = result * 31 + ((Object)this.values).hashCode();
        result = result * 31 + ((Object)this.fields).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TypeDeclaration)) {
            return false;
        }
        TypeDeclaration typeDeclaration = (TypeDeclaration)other;
        if (!Intrinsics.areEqual((Object)this.kind, (Object)typeDeclaration.kind)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.name, (Object)typeDeclaration.name)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.description, (Object)typeDeclaration.description)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.values, typeDeclaration.values)) {
            return false;
        }
        return Intrinsics.areEqual(this.fields, typeDeclaration.fields);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0014\u0010\u000b\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0014\u0010\r\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lcom/apollographql/apollo/compiler/ir/TypeDeclaration$Companion;", "", "()V", "ENUM_SAFE_VALUE_OF", "", "getENUM_SAFE_VALUE_OF", "()Ljava/lang/String;", "ENUM_UNKNOWN_CONSTANT", "getENUM_UNKNOWN_CONSTANT", "KIND_ENUM", "getKIND_ENUM", "KIND_INPUT_OBJECT_TYPE", "getKIND_INPUT_OBJECT_TYPE", "KIND_SCALAR_TYPE", "getKIND_SCALAR_TYPE", "apollo-compiler"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getKIND_INPUT_OBJECT_TYPE() {
            return KIND_INPUT_OBJECT_TYPE;
        }

        @NotNull
        public final String getKIND_ENUM() {
            return KIND_ENUM;
        }

        @NotNull
        public final String getKIND_SCALAR_TYPE() {
            return KIND_SCALAR_TYPE;
        }

        @NotNull
        public final String getENUM_UNKNOWN_CONSTANT() {
            return ENUM_UNKNOWN_CONSTANT;
        }

        @NotNull
        public final String getENUM_SAFE_VALUE_OF() {
            return ENUM_SAFE_VALUE_OF;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

