/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.gradle.internal;

import com.apollographql.apollo.compiler.OperationIdGenerator;
import com.apollographql.apollo.compiler.OperationOutputGenerator;
import com.apollographql.apollo.gradle.api.ApolloAttributes;
import com.apollographql.apollo.gradle.api.ApolloExtension;
import com.apollographql.apollo.gradle.api.CompilerParams;
import com.apollographql.apollo.gradle.internal.AndroidTaskConfigurator;
import com.apollographql.apollo.gradle.internal.ApolloCheckDuplicatesTask;
import com.apollographql.apollo.gradle.internal.ApolloConvertSchemaTask;
import com.apollographql.apollo.gradle.internal.ApolloDownloadSchemaCliTask;
import com.apollographql.apollo.gradle.internal.ApolloDownloadSchemaTask;
import com.apollographql.apollo.gradle.internal.ApolloGenerateSourcesTask;
import com.apollographql.apollo.gradle.internal.ApolloPlugin;
import com.apollographql.apollo.gradle.internal.ApolloPlugin$Companion$registerCompilationUnits$1$$special$;
import com.apollographql.apollo.gradle.internal.ApolloPushSchemaTask;
import com.apollographql.apollo.gradle.internal.ApolloVariant;
import com.apollographql.apollo.gradle.internal.BuildDirLayout;
import com.apollographql.apollo.gradle.internal.DefaultApolloExtension;
import com.apollographql.apollo.gradle.internal.DefaultCompilationUnit;
import com.apollographql.apollo.gradle.internal.DefaultIntrospection;
import com.apollographql.apollo.gradle.internal.DefaultService;
import com.apollographql.apollo.gradle.internal.JvmTaskConfigurator;
import com.apollographql.apollo.gradle.internal.KotlinMultiplatformTaskConfigurator;
import com.apollographql.apollo.gradle.internal.ModelNames;
import java.io.File;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.HttpUrl;
import org.gradle.api.Action;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.artifacts.ResolvableDependencies;
import org.gradle.api.artifacts.dsl.ArtifactHandler;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.attributes.Usage;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.initialization.dsl.ScriptHandler;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 \u00072\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\b"}, d2={"Lcom/apollographql/apollo/gradle/internal/ApolloPlugin;", "Lorg/gradle/api/Plugin;", "Lorg/gradle/api/Project;", "()V", "apply", "", "project", "Companion", "apollo-gradle-plugin"})
public class ApolloPlugin
implements Plugin<Project> {
    @NotNull
    public static final String TASK_GROUP = "apollo";
    @NotNull
    public static final String MIN_GRADLE_VERSION = "5.6";
    @NotNull
    public static final String CONFIGURATION_CONSUMER = "apollo";
    @NotNull
    public static final String USAGE_APOLLO_METADATA = "apollo-metadata";
    public static final Companion Companion = new Companion(null);

    public void apply(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        boolean bl = GradleVersion.current().compareTo(GradleVersion.version((String)MIN_GRADLE_VERSION)) >= 0;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "apollo-android requires Gradle version 5.6 or greater";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        Object object = project.getExtensions().create(ApolloExtension.class, "apollo", DefaultApolloExtension.class, new Object[]{project});
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.apollographql.apollo.gradle.internal.DefaultApolloExtension");
        }
        DefaultApolloExtension apolloExtension = (DefaultApolloExtension)object;
        project.getConfigurations().create(ModelNames.INSTANCE.apolloConfiguration(), (Action)new Action<Configuration>(project){
            final /* synthetic */ Project $project;

            public final void execute(Configuration it) {
                Configuration configuration2 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)configuration2, (String)"it");
                configuration2.setCanBeConsumed(false);
                it.setCanBeResolved(false);
                it.attributes((Action)new Action<AttributeContainer>(this){
                    final /* synthetic */ apply.2 this$0;

                    public final void execute(AttributeContainer it) {
                        it.attribute(Usage.USAGE_ATTRIBUTE, (Object)this.this$0.$project.getObjects().named(Usage.class, "apollo-metadata"));
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.$project = project;
            }
        });
        project.afterEvaluate((Action)new Action<Project>(apolloExtension){
            final /* synthetic */ DefaultApolloExtension $apolloExtension;

            public final void execute(Project it) {
                Project project = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"it");
                com.apollographql.apollo.gradle.internal.ApolloPlugin$Companion.access$afterEvaluate(ApolloPlugin.Companion, project, this.$apolloExtension);
            }
            {
                this.$apolloExtension = defaultApolloExtension;
            }
        });
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\b\u0003\b\u0080\u0003\u0018\u00002\u00020\u0001:\u0001(B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u0015J\u001e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u0019\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00172\u0006\u0010\u000e\u001a\u00020\nJ&\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u00172\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020!H\u0002J&\u0010\"\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u001d0\u0017H\u0002J\u0018\u0010$\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u001a\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040&2\u0006\u0010'\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0015\u0010\b\u001a\u00020\t*\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u000b\u00a8\u0006)"}, d2={"Lcom/apollographql/apollo/gradle/internal/ApolloPlugin$Companion;", "", "()V", "CONFIGURATION_CONSUMER", "", "MIN_GRADLE_VERSION", "TASK_GROUP", "USAGE_APOLLO_METADATA", "isKotlinMultiplatform", "", "Lorg/gradle/api/Project;", "(Lorg/gradle/api/Project;)Z", "afterEvaluate", "", "project", "apolloExtension", "Lcom/apollographql/apollo/gradle/internal/DefaultApolloExtension;", "getDeps", "", "Lcom/apollographql/apollo/gradle/internal/ApolloPlugin$Companion$Dep;", "configurations", "Lorg/gradle/api/artifacts/ConfigurationContainer;", "maybeRegisterCheckDuplicates", "Lorg/gradle/api/tasks/TaskProvider;", "Lcom/apollographql/apollo/gradle/internal/ApolloCheckDuplicatesTask;", "rootProject", "compilationUnit", "Lcom/apollographql/apollo/gradle/internal/DefaultCompilationUnit;", "registerCheckVersionsTask", "Lorg/gradle/api/Task;", "registerCodeGenTask", "Lcom/apollographql/apollo/gradle/internal/ApolloGenerateSourcesTask;", "consumerConfiguration", "Lorg/gradle/api/artifacts/Configuration;", "registerCompilationUnits", "checkVersionsTask", "registerDownloadSchemaTasks", "toMap", "", "s", "Dep", "apollo-gradle-plugin"})
    public static final class Companion {
        public final boolean isKotlinMultiplatform(@NotNull Project $this$isKotlinMultiplatform) {
            Intrinsics.checkParameterIsNotNull((Object)$this$isKotlinMultiplatform, (String)"$this$isKotlinMultiplatform");
            return $this$isKotlinMultiplatform.getPluginManager().hasPlugin("org.jetbrains.kotlin.multiplatform");
        }

        private final void registerCompilationUnits(Project project, DefaultApolloExtension apolloExtension, TaskProvider<Task> checkVersionsTask) {
            Object androidExtension = project.getExtensions().findByName("android");
            Configuration apolloConfiguration = project.getConfigurations().getByName(ModelNames.INSTANCE.apolloConfiguration());
            NamedDomainObjectContainer<ApolloVariant> apolloVariants = this.isKotlinMultiplatform(project) ? KotlinMultiplatformTaskConfigurator.INSTANCE.getVariants(project) : (androidExtension != null ? AndroidTaskConfigurator.INSTANCE.getVariants(project, androidExtension) : JvmTaskConfigurator.INSTANCE.getVariants(project));
            TaskProvider rootProvider2 = project.getTasks().register(ModelNames.INSTANCE.generateApolloSources(), (Action)registerCompilationUnits.rootProvider.1.INSTANCE);
            List services = apolloExtension.getServices().isEmpty() ? CollectionsKt.listOf((Object)project.getObjects().newInstance(DefaultService.class, new Object[]{project.getObjects(), "service"})) : apolloExtension.getServices();
            apolloVariants.all((Action)new Action<ApolloVariant>(project, services, apolloExtension, apolloConfiguration, checkVersionsTask, androidExtension, rootProvider2){
                final /* synthetic */ Project $project;
                final /* synthetic */ List $services;
                final /* synthetic */ DefaultApolloExtension $apolloExtension;
                final /* synthetic */ Configuration $apolloConfiguration;
                final /* synthetic */ TaskProvider $checkVersionsTask;
                final /* synthetic */ Object $androidExtension;
                final /* synthetic */ TaskProvider $rootProvider;

                /*
                 * WARNING - void declaration
                 */
                public final void execute(ApolloVariant apolloVariant) {
                    void $this$mapTo$iv$iv;
                    TaskContainer taskContainer = this.$project.getTasks();
                    ApolloVariant apolloVariant2 = apolloVariant;
                    Intrinsics.checkExpressionValueIsNotNull((Object)apolloVariant2, (String)"apolloVariant");
                    TaskProvider variantProvider2 = taskContainer.register(ModelNames.INSTANCE.generateApolloSources(apolloVariant2), (Action)new Action<Task>(apolloVariant){
                        final /* synthetic */ ApolloVariant $apolloVariant;

                        public final void execute(Task it) {
                            Task task = it;
                            Intrinsics.checkExpressionValueIsNotNull((Object)task, (String)"it");
                            task.setGroup("apollo");
                            it.setDescription("Generate Apollo models for all services and variant '" + this.$apolloVariant.getName() + '\'');
                        }
                        {
                            this.$apolloVariant = apolloVariant;
                        }
                    });
                    Iterable $this$map$iv = this.$services;
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        DefaultService defaultService = (DefaultService)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        void v2 = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"it");
                        DefaultCompilationUnit defaultCompilationUnit = DefaultCompilationUnit.Companion.createDefaultCompilationUnit(this.$project, this.$apolloExtension, apolloVariant, (DefaultService)v2);
                        collection.add(defaultCompilationUnit);
                    }
                    List compilationUnits = (List)destination$iv$iv;
                    Iterable $this$forEach$iv = compilationUnits;
                    boolean $i$f$forEach = false;
                    for (E element$iv : $this$forEach$iv) {
                        Configuration consumerConfiguration;
                        DefaultCompilationUnit compilationUnit = (DefaultCompilationUnit)element$iv;
                        boolean bl = false;
                        String producerConfigurationName = ModelNames.INSTANCE.producerConfiguration(compilationUnit);
                        this.$project.getConfigurations().create(producerConfigurationName, (Action)new Action<Configuration>(compilationUnit, this, variantProvider2){
                            final /* synthetic */ DefaultCompilationUnit $compilationUnit;
                            final /* synthetic */ registerCompilationUnits.1 this$0;
                            final /* synthetic */ TaskProvider $variantProvider$inlined;
                            {
                                this.$compilationUnit = defaultCompilationUnit;
                                this.this$0 = var2_2;
                                this.$variantProvider$inlined = taskProvider;
                            }

                            public final void execute(Configuration it) {
                                Configuration configuration2 = it;
                                Intrinsics.checkExpressionValueIsNotNull((Object)configuration2, (String)"it");
                                configuration2.setCanBeConsumed(true);
                                it.setCanBeResolved(false);
                                it.extendsFrom(new Configuration[]{this.this$0.$apolloConfiguration});
                                it.attributes((Action)new Action<AttributeContainer>(this){
                                    final /* synthetic */ Companion$registerCompilationUnits$1$$special$$inlined$forEach$lambda$1 this$0;
                                    {
                                        this.this$0 = var1_1;
                                    }

                                    public final void execute(AttributeContainer it) {
                                        it.attribute(Usage.USAGE_ATTRIBUTE, (Object)this.this$0.this$0.$project.getObjects().named(Usage.class, "apollo-metadata"));
                                        it.attribute(ApolloAttributes.INSTANCE.getAPOLLO_VARIANT_ATTRIBUTE(), (Object)this.this$0.this$0.$project.getObjects().named(ApolloAttributes.Variant.class, this.this$0.$compilationUnit.getVariantName()));
                                        it.attribute(ApolloAttributes.INSTANCE.getAPOLLO_SERVICE_ATTRIBUTE(), (Object)this.this$0.this$0.$project.getObjects().named(ApolloAttributes.Service.class, this.this$0.$compilationUnit.getServiceName()));
                                    }
                                });
                            }
                        });
                        Configuration configuration2 = consumerConfiguration = (Configuration)this.$project.getConfigurations().create(ModelNames.INSTANCE.consumerConfiguration(compilationUnit), (Action)new Action<Configuration>(compilationUnit, this, variantProvider2){
                            final /* synthetic */ DefaultCompilationUnit $compilationUnit;
                            final /* synthetic */ registerCompilationUnits.1 this$0;
                            final /* synthetic */ TaskProvider $variantProvider$inlined;
                            {
                                this.$compilationUnit = defaultCompilationUnit;
                                this.this$0 = var2_2;
                                this.$variantProvider$inlined = taskProvider;
                            }

                            public final void execute(Configuration it) {
                                Configuration configuration2 = it;
                                Intrinsics.checkExpressionValueIsNotNull((Object)configuration2, (String)"it");
                                configuration2.setCanBeResolved(true);
                                it.setCanBeConsumed(false);
                                it.extendsFrom(new Configuration[]{this.this$0.$apolloConfiguration});
                                it.attributes((Action)new Action<AttributeContainer>(this){
                                    final /* synthetic */ Companion$registerCompilationUnits$1$$special$$inlined$forEach$lambda$2 this$0;
                                    {
                                        this.this$0 = var1_1;
                                    }

                                    public final void execute(AttributeContainer it) {
                                        it.attribute(Usage.USAGE_ATTRIBUTE, (Object)this.this$0.this$0.$project.getObjects().named(Usage.class, "apollo-metadata"));
                                        it.attribute(ApolloAttributes.INSTANCE.getAPOLLO_VARIANT_ATTRIBUTE(), (Object)this.this$0.this$0.$project.getObjects().named(ApolloAttributes.Variant.class, this.this$0.$compilationUnit.getVariantName()));
                                        it.attribute(ApolloAttributes.INSTANCE.getAPOLLO_SERVICE_ATTRIBUTE(), (Object)this.this$0.this$0.$project.getObjects().named(ApolloAttributes.Service.class, this.this$0.$compilationUnit.getServiceName()));
                                    }
                                });
                            }
                        });
                        Intrinsics.checkExpressionValueIsNotNull((Object)configuration2, (String)"consumerConfiguration");
                        TaskProvider codegenProvider = com.apollographql.apollo.gradle.internal.ApolloPlugin$Companion.access$registerCodeGenTask(ApolloPlugin.Companion, this.$project, compilationUnit, configuration2);
                        this.$project.artifacts((Action)new Action<ArtifactHandler>(producerConfigurationName, codegenProvider){
                            final /* synthetic */ String $producerConfigurationName;
                            final /* synthetic */ TaskProvider $codegenProvider;

                            public final void execute(ArtifactHandler it) {
                                it.add(this.$producerConfigurationName, (Object)this.$codegenProvider.flatMap((Transformer)registerCompilationUnits.1.1.INSTANCE));
                            }
                            {
                                this.$producerConfigurationName = string;
                                this.$codegenProvider = taskProvider;
                            }
                        });
                        codegenProvider.configure((Action)new Action<ApolloGenerateSourcesTask>(consumerConfiguration, this, variantProvider2){
                            final /* synthetic */ Configuration $consumerConfiguration;
                            final /* synthetic */ registerCompilationUnits.1 this$0;
                            final /* synthetic */ TaskProvider $variantProvider$inlined;
                            {
                                this.$consumerConfiguration = configuration2;
                                this.this$0 = var2_2;
                                this.$variantProvider$inlined = taskProvider;
                            }

                            public final void execute(ApolloGenerateSourcesTask it) {
                                it.dependsOn(new Object[]{this.this$0.$checkVersionsTask});
                                it.dependsOn(new Object[]{this.$consumerConfiguration});
                            }
                        });
                        variantProvider2.configure((Action)new Action<Task>(codegenProvider){
                            final /* synthetic */ TaskProvider $codegenProvider;

                            public final void execute(Task it) {
                                it.dependsOn(new Object[]{this.$codegenProvider});
                            }
                            {
                                this.$codegenProvider = taskProvider;
                            }
                        });
                        Project project = this.$project.getRootProject();
                        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project.rootProject");
                        TaskProvider checkApolloDuplicates = com.apollographql.apollo.gradle.internal.ApolloPlugin$Companion.access$maybeRegisterCheckDuplicates(ApolloPlugin.Companion, project, compilationUnit);
                        Project project2 = this.$project.getRootProject();
                        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project.rootProject");
                        DependencyHandler dependencyHandler = project2.getDependencies();
                        boolean bl2 = false;
                        boolean bl3 = false;
                        DependencyHandler $this$apply = dependencyHandler;
                        boolean bl4 = false;
                        $this$apply.add(ModelNames.INSTANCE.duplicatesConsumerConfiguration(compilationUnit), (Object)$this$apply.project(MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"path", (Object)this.$project.getPath()), TuplesKt.to((Object)"configuration", (Object)producerConfigurationName)})));
                        codegenProvider.configure((Action)new Action<ApolloGenerateSourcesTask>(checkApolloDuplicates){
                            final /* synthetic */ TaskProvider $checkApolloDuplicates;

                            public final void execute(ApolloGenerateSourcesTask it) {
                                it.finalizedBy(new Object[]{this.$checkApolloDuplicates});
                            }
                            {
                                this.$checkApolloDuplicates = taskProvider;
                            }
                        });
                        compilationUnit.getOutputDir().set(codegenProvider.map((Transformer)registerCompilationUnits.1.7.INSTANCE));
                        compilationUnit.getOperationOutputFile().set(codegenProvider.flatMap((Transformer)registerCompilationUnits.1.8.INSTANCE));
                        this.$apolloExtension.getCompilationUnits$apollo_gradle_plugin().add((Object)compilationUnit);
                        if (ApolloPlugin.Companion.isKotlinMultiplatform(this.$project)) {
                            KotlinMultiplatformTaskConfigurator.INSTANCE.registerGeneratedDirectory(this.$project, compilationUnit, (TaskProvider<ApolloGenerateSourcesTask>)codegenProvider);
                            continue;
                        }
                        if (this.$androidExtension != null) {
                            AndroidTaskConfigurator.INSTANCE.registerGeneratedDirectory(this.$project, compilationUnit, (TaskProvider<ApolloGenerateSourcesTask>)codegenProvider);
                            continue;
                        }
                        JvmTaskConfigurator.INSTANCE.registerGeneratedDirectory(this.$project, compilationUnit, (TaskProvider<ApolloGenerateSourcesTask>)codegenProvider);
                    }
                    this.$rootProvider.configure((Action)new Action<Task>(variantProvider2){
                        final /* synthetic */ TaskProvider $variantProvider;

                        public final void execute(Task it) {
                            it.dependsOn(new Object[]{this.$variantProvider});
                        }
                        {
                            this.$variantProvider = taskProvider;
                        }
                    });
                }
                {
                    this.$project = project;
                    this.$services = list;
                    this.$apolloExtension = defaultApolloExtension;
                    this.$apolloConfiguration = configuration2;
                    this.$checkVersionsTask = taskProvider;
                    this.$androidExtension = object;
                    this.$rootProvider = taskProvider2;
                }
            });
        }

        private final TaskProvider<ApolloCheckDuplicatesTask> maybeRegisterCheckDuplicates(Project rootProject, DefaultCompilationUnit compilationUnit) {
            TaskProvider taskProvider;
            String taskName = ModelNames.INSTANCE.checkApolloDuplicates(compilationUnit);
            try {
                TaskProvider taskProvider2 = rootProject.getTasks().named(taskName);
                if (taskProvider2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.gradle.api.tasks.TaskProvider<com.apollographql.apollo.gradle.internal.ApolloCheckDuplicatesTask>");
                }
                taskProvider = taskProvider2;
            }
            catch (Exception e) {
                Configuration configuration2 = (Configuration)rootProject.getConfigurations().create(ModelNames.INSTANCE.duplicatesConsumerConfiguration(compilationUnit), (Action)new Action<Configuration>(rootProject, compilationUnit){
                    final /* synthetic */ Project $rootProject;
                    final /* synthetic */ DefaultCompilationUnit $compilationUnit;

                    public final void execute(Configuration it) {
                        Configuration configuration2 = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)configuration2, (String)"it");
                        configuration2.setCanBeResolved(true);
                        it.setCanBeConsumed(false);
                        it.attributes((Action)new Action<AttributeContainer>(this){
                            final /* synthetic */ maybeRegisterCheckDuplicates.configuration.1 this$0;

                            public final void execute(AttributeContainer it) {
                                it.attribute(Usage.USAGE_ATTRIBUTE, (Object)this.this$0.$rootProject.getObjects().named(Usage.class, "apollo-metadata"));
                                it.attribute(ApolloAttributes.INSTANCE.getAPOLLO_VARIANT_ATTRIBUTE(), (Object)this.this$0.$rootProject.getObjects().named(ApolloAttributes.Variant.class, this.this$0.$compilationUnit.getVariantName()));
                                it.attribute(ApolloAttributes.INSTANCE.getAPOLLO_SERVICE_ATTRIBUTE(), (Object)this.this$0.$rootProject.getObjects().named(ApolloAttributes.Service.class, this.this$0.$compilationUnit.getServiceName()));
                            }
                            {
                                this.this$0 = var1_1;
                            }
                        });
                    }
                    {
                        this.$rootProject = project;
                        this.$compilationUnit = defaultCompilationUnit;
                    }
                });
                TaskProvider taskProvider3 = rootProject.getTasks().register(taskName, ApolloCheckDuplicatesTask.class, (Action)new Action<ApolloCheckDuplicatesTask>(rootProject, compilationUnit, configuration2){
                    final /* synthetic */ Project $rootProject;
                    final /* synthetic */ DefaultCompilationUnit $compilationUnit;
                    final /* synthetic */ Configuration $configuration;

                    public final void execute(ApolloCheckDuplicatesTask it) {
                        it.getOutputFile().set(BuildDirLayout.INSTANCE.duplicatesCheck$apollo_gradle_plugin(this.$rootProject, this.$compilationUnit));
                        it.getMetadataFiles().from(new Object[]{this.$configuration});
                    }
                    {
                        this.$rootProject = project;
                        this.$compilationUnit = defaultCompilationUnit;
                        this.$configuration = configuration2;
                    }
                });
                Intrinsics.checkExpressionValueIsNotNull((Object)taskProvider3, (String)"rootProject.tasks.regist\u2026(configuration)\n        }");
                taskProvider = taskProvider3;
            }
            return taskProvider;
        }

        private final TaskProvider<ApolloGenerateSourcesTask> registerCodeGenTask(Project project, DefaultCompilationUnit compilationUnit, Configuration consumerConfiguration) {
            TaskProvider taskProvider = project.getTasks().register(ModelNames.INSTANCE.generateApolloSources(compilationUnit), ApolloGenerateSourcesTask.class, (Action)new Action<ApolloGenerateSourcesTask>(compilationUnit, project, consumerConfiguration){
                final /* synthetic */ DefaultCompilationUnit $compilationUnit;
                final /* synthetic */ Project $project;
                final /* synthetic */ Configuration $consumerConfiguration;

                /*
                 * WARNING - void declaration
                 */
                public final void execute(ApolloGenerateSourcesTask task) {
                    void compilerParams;
                    ApolloGenerateSourcesTask apolloGenerateSourcesTask = task;
                    Intrinsics.checkExpressionValueIsNotNull((Object)((Object)apolloGenerateSourcesTask), (String)"task");
                    apolloGenerateSourcesTask.setGroup("apollo");
                    task.setDescription("Generate Apollo models for " + this.$compilationUnit.getName() + " GraphQL queries");
                    DirectoryProperty directoryProperty = this.$compilationUnit.resolveParams(this.$project);
                    CompilerParams compilerParams2 = (CompilerParams)directoryProperty.component1();
                    SourceDirectorySet graphqlSourceDirectorySet = (SourceDirectorySet)directoryProperty.component2();
                    task.getGraphqlFiles().setFrom((Iterable)graphqlSourceDirectorySet);
                    task.getRootFolders().set(this.$project.provider((Callable)new Callable<List<? extends String>>(this, graphqlSourceDirectorySet){
                        final /* synthetic */ registerCodeGenTask.1 this$0;
                        final /* synthetic */ SourceDirectorySet $graphqlSourceDirectorySet;

                        /*
                         * WARNING - void declaration
                         */
                        public final List<String> call() {
                            void $this$mapTo$iv$iv;
                            Set set = this.$graphqlSourceDirectorySet.getSrcDirs();
                            Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"graphqlSourceDirectorySet.srcDirs");
                            Iterable $this$map$iv = set;
                            boolean $i$f$map = false;
                            Iterable iterable = $this$map$iv;
                            Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                            boolean $i$f$mapTo = false;
                            for (T item$iv$iv : $this$mapTo$iv$iv) {
                                void it;
                                File file = (File)item$iv$iv;
                                Collection collection = destination$iv$iv;
                                boolean bl = false;
                                void v1 = it;
                                Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"it");
                                File file2 = this.this$0.$project.getProjectDir();
                                Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"project.projectDir");
                                String string = FilesKt.relativeTo((File)v1, (File)file2).getPath();
                                collection.add(string);
                            }
                            return CollectionsKt.sorted((Iterable)((List)destination$iv$iv));
                        }
                        {
                            this.this$0 = var1_1;
                            this.$graphqlSourceDirectorySet = sourceDirectorySet;
                        }
                    }));
                    task.getSchemaFile().set((Provider)compilerParams.getSchemaFile());
                    Property<OperationOutputGenerator> property = compilerParams.getOperationOutputGenerator();
                    Object object = compilerParams.getOperationIdGenerator().orElse((Object)new OperationIdGenerator.Sha256()).get();
                    Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"compilerParams.operation\u2026Generator.Sha256()).get()");
                    Object object2 = property.getOrElse((Object)new OperationOutputGenerator.DefaultOperationOuputGenerator((OperationIdGenerator)object));
                    Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"compilerParams.operation\u2026)\n            )\n        )");
                    task.setOperationOutputGenerator((OperationOutputGenerator)object2);
                    task.getNullableValueType().set((Provider)compilerParams.getNullableValueType());
                    task.getUseSemanticNaming().set((Provider)compilerParams.getUseSemanticNaming());
                    task.getGenerateModelBuilder().set((Provider)compilerParams.getGenerateModelBuilder());
                    task.getUseJavaBeansSemanticNaming().set((Provider)compilerParams.getUseJavaBeansSemanticNaming());
                    task.getSuppressRawTypesWarning().set((Provider)compilerParams.getSuppressRawTypesWarning());
                    task.getGenerateKotlinModels().set((Object)this.$compilationUnit.generateKotlinModels());
                    task.getWarnOnDeprecatedUsages().set((Provider)compilerParams.getWarnOnDeprecatedUsages());
                    task.getFailOnWarnings().set((Provider)compilerParams.getFailOnWarnings());
                    task.getGenerateVisitorForPolymorphicDatatypes().set((Provider)compilerParams.getGenerateVisitorForPolymorphicDatatypes());
                    task.getCustomTypeMapping().set((Provider)compilerParams.getCustomTypeMapping());
                    directoryProperty = task.getOutputDir();
                    boolean bl = false;
                    boolean bl2 = false;
                    DirectoryProperty $this$apply = directoryProperty;
                    boolean bl3 = false;
                    $this$apply.set(BuildDirLayout.INSTANCE.sources$apollo_gradle_plugin(this.$project, this.$compilationUnit));
                    $this$apply.disallowChanges();
                    Object object3 = compilerParams.getGenerateOperationOutput().getOrElse((Object)false);
                    Intrinsics.checkExpressionValueIsNotNull((Object)object3, (String)"compilerParams.generateO\u2026onOutput.getOrElse(false)");
                    if (((Boolean)object3).booleanValue()) {
                        directoryProperty = task.getOperationOutputFile();
                        bl = false;
                        bl2 = false;
                        $this$apply = directoryProperty;
                        boolean bl4 = false;
                        $this$apply.set(BuildDirLayout.INSTANCE.operationOuput$apollo_gradle_plugin(this.$project, this.$compilationUnit));
                        $this$apply.disallowChanges();
                    }
                    directoryProperty = task.getMetadataOutputFile();
                    bl = false;
                    bl2 = false;
                    $this$apply = directoryProperty;
                    boolean bl5 = false;
                    $this$apply.set(BuildDirLayout.INSTANCE.metadata$apollo_gradle_plugin(this.$project, this.$compilationUnit));
                    $this$apply.disallowChanges();
                    task.getGenerateMetadata().set(compilerParams.getGenerateApolloMetadata().orElse(this.$project.provider((Callable)new Callable<Boolean>(this){
                        final /* synthetic */ registerCodeGenTask.1 this$0;

                        public final Boolean call() {
                            return !this.this$0.$consumerConfiguration.isEmpty();
                        }
                        {
                            this.this$0 = var1_1;
                        }
                    })));
                    task.getMetadataFiles().from(new Object[]{this.$consumerConfiguration});
                    task.getRootPackageName().set((Provider)compilerParams.getRootPackageName());
                    task.getGenerateAsInternal().set((Provider)compilerParams.getGenerateAsInternal());
                    task.getKotlinMultiPlatformProject().set((Object)ApolloPlugin.Companion.isKotlinMultiplatform(this.$project));
                    task.getSealedClassesForEnumsMatching().set((Provider)compilerParams.getSealedClassesForEnumsMatching());
                    task.getAlwaysGenerateTypesMatching().set((Provider)compilerParams.getAlwaysGenerateTypesMatching());
                    task.getPackageName().set(compilerParams.getPackageName().getOrNull());
                    task.getProjectName().set((Object)this.$project.getName());
                    DirectoryProperty directoryProperty2 = task.getProjectRootDir();
                    Project project = this.$project.getRootProject();
                    Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project.rootProject");
                    directoryProperty2.set(project.getRootDir());
                }
                {
                    this.$compilationUnit = defaultCompilationUnit;
                    this.$project = project;
                    this.$consumerConfiguration = configuration2;
                }
            });
            Intrinsics.checkExpressionValueIsNotNull((Object)taskProvider, (String)"project.tasks.register(M\u2026tProject.rootDir)\n      }");
            return taskProvider;
        }

        private final void registerDownloadSchemaTasks(Project project, DefaultApolloExtension apolloExtension) {
            Iterable $this$forEach$iv = apolloExtension.getServices();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                DefaultService service = (DefaultService)element$iv;
                boolean bl = false;
                DefaultIntrospection introspection = service.getIntrospection();
                if (introspection == null) continue;
                project.getTasks().register(ModelNames.INSTANCE.downloadApolloSchema(service), ApolloDownloadSchemaTask.class, (Action)new Action<ApolloDownloadSchemaTask>(introspection, service){
                    final /* synthetic */ DefaultIntrospection $introspection;
                    final /* synthetic */ DefaultService $service;

                    /*
                     * WARNING - void declaration
                     */
                    public final void execute(ApolloDownloadSchemaTask task) {
                        Collection<String> collection;
                        void $this$mapTo$iv$iv;
                        void $this$map$iv;
                        Provider sourceSetName = this.$introspection.getSourceSetName().orElse((Object)"main");
                        ApolloDownloadSchemaTask apolloDownloadSchemaTask = task;
                        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)apolloDownloadSchemaTask), (String)"task");
                        apolloDownloadSchemaTask.setGroup("apollo");
                        task.getSchemaRelativeToProject().set(this.$service.getSchemaPath().map((Transformer)new Transformer<String, String>(sourceSetName){
                            final /* synthetic */ Provider $sourceSetName;

                            public final String transform(String it) {
                                return "src/" + (String)this.$sourceSetName.get() + "/graphql/" + it;
                            }
                            {
                                this.$sourceSetName = provider2;
                            }
                        }));
                        task.getEndpoint().set(this.$introspection.getEndpointUrl().map((Transformer)new Transformer<String, String>(this){
                            final /* synthetic */ registerDownloadSchemaTasks.1.1 this$0;

                            public final String transform(String it) {
                                String string = it;
                                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it");
                                HttpUrl.Builder builder = HttpUrl.Companion.get(string).newBuilder();
                                boolean bl = false;
                                boolean bl2 = false;
                                HttpUrl.Builder $this$apply = builder;
                                boolean bl3 = false;
                                Iterable $this$forEach$iv = ((Map)this.this$0.$introspection.getQueryParameters().get()).entrySet();
                                boolean $i$f$forEach = false;
                                for (T element$iv : $this$forEach$iv) {
                                    Map.Entry it2 = (Map.Entry)element$iv;
                                    boolean bl4 = false;
                                    K k = it2.getKey();
                                    Intrinsics.checkExpressionValueIsNotNull(k, (String)"it.key");
                                    $this$apply.addQueryParameter((String)k, (String)it2.getValue());
                                }
                                return builder.build().toString();
                            }
                            {
                                this.this$0 = var1_1;
                            }
                        }));
                        Object object = this.$introspection.getHeaders().get();
                        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"introspection.headers.get()");
                        Map map = (Map)object;
                        ApolloDownloadSchemaTask apolloDownloadSchemaTask2 = task;
                        boolean $i$f$map = false;
                        void var5_6 = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList<E>($this$map$iv.size());
                        boolean $i$f$mapTo = false;
                        void var8_9 = $this$mapTo$iv$iv;
                        boolean bl = false;
                        Iterator<Map.Entry<K, V>> iterator = var8_9.entrySet().iterator();
                        while (iterator.hasNext()) {
                            void it;
                            Map.Entry<K, V> item$iv$iv;
                            Map.Entry<K, V> entry = item$iv$iv = iterator.next();
                            collection = destination$iv$iv;
                            boolean bl2 = false;
                            String string = (String)it.getKey() + ": " + (String)it.getValue();
                            collection.add(string);
                        }
                        collection = (List)destination$iv$iv;
                        apolloDownloadSchemaTask2.setHeader((List<String>)collection);
                    }
                    {
                        this.$introspection = defaultIntrospection;
                        this.$service = defaultService;
                    }
                });
            }
            project.getTasks().register(ModelNames.INSTANCE.downloadApolloSchema(), ApolloDownloadSchemaCliTask.class, (Action)new Action<ApolloDownloadSchemaCliTask>(apolloExtension){
                final /* synthetic */ DefaultApolloExtension $apolloExtension;

                public final void execute(ApolloDownloadSchemaCliTask task) {
                    ApolloDownloadSchemaCliTask apolloDownloadSchemaCliTask = task;
                    Intrinsics.checkExpressionValueIsNotNull((Object)((Object)apolloDownloadSchemaCliTask), (String)"task");
                    apolloDownloadSchemaCliTask.setGroup("apollo");
                    NamedDomainObjectContainer<DefaultCompilationUnit> namedDomainObjectContainer = this.$apolloExtension.getCompilationUnits$apollo_gradle_plugin();
                    Intrinsics.checkExpressionValueIsNotNull(namedDomainObjectContainer, (String)"apolloExtension.compilationUnits");
                    task.setCompilationUnits(namedDomainObjectContainer);
                }
                {
                    this.$apolloExtension = defaultApolloExtension;
                }
            });
            project.getTasks().register(ModelNames.INSTANCE.pushApolloSchema(), ApolloPushSchemaTask.class, (Action)registerDownloadSchemaTasks.3.INSTANCE);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Map<String, String> toMap(@NotNull String s) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
            Iterable $this$map$iv = StringsKt.split$default((CharSequence)s, (String[])new String[]{"&"}, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                List keyValue = StringsKt.split$default((CharSequence)((CharSequence)it), (String[])new String[]{"="}, (boolean)false, (int)0, (int)6, null);
                String key = URLDecoder.decode((String)keyValue.get(0), "UTF-8");
                String value = URLDecoder.decode((String)keyValue.get(1), "UTF-8");
                Pair pair = TuplesKt.to((Object)key, (Object)value);
                collection.add(pair);
            }
            return MapsKt.toMap((Iterable)((List)destination$iv$iv));
        }

        private final void afterEvaluate(Project project, DefaultApolloExtension apolloExtension) {
            TaskProvider<Task> checkVersionsTask = this.registerCheckVersionsTask(project);
            this.registerCompilationUnits(project, apolloExtension, checkVersionsTask);
            this.registerDownloadSchemaTasks(project, apolloExtension);
            project.getTasks().register(ModelNames.INSTANCE.convertApolloSchema(), ApolloConvertSchemaTask.class, (Action)afterEvaluate.1.INSTANCE);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<Dep> getDeps(@NotNull ConfigurationContainer configurations) {
            void $this$flatMapTo$iv$iv;
            Intrinsics.checkParameterIsNotNull((Object)configurations, (String)"configurations");
            Iterable $this$flatMap$iv = (Iterable)configurations;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                void $this$mapTo$iv$iv;
                Dependency it;
                Iterable $this$filterTo$iv$iv;
                Configuration configuration2 = (Configuration)element$iv$iv;
                boolean bl = false;
                Configuration configuration3 = configuration2;
                Intrinsics.checkExpressionValueIsNotNull((Object)configuration3, (String)"configuration");
                ResolvableDependencies resolvableDependencies = configuration3.getIncoming();
                Intrinsics.checkExpressionValueIsNotNull((Object)resolvableDependencies, (String)"configuration.incoming");
                DependencySet dependencySet = resolvableDependencies.getDependencies();
                Intrinsics.checkExpressionValueIsNotNull((Object)dependencySet, (String)"configuration.incoming.dependencies");
                Iterable $this$filter$iv = (Iterable)dependencySet;
                boolean $i$f$filter = false;
                Iterable iterable2 = $this$filter$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv2 : $this$filterTo$iv$iv) {
                    it = (Dependency)element$iv$iv2;
                    boolean bl2 = false;
                    Dependency dependency = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)dependency, (String)"it");
                    if (!Intrinsics.areEqual((Object)dependency.getGroup(), (Object)"com.apollographql.apollo")) continue;
                    destination$iv$iv2.add(element$iv$iv2);
                }
                Iterable $this$map$iv = (List)destination$iv$iv2;
                boolean $i$f$map = false;
                $this$filterTo$iv$iv = $this$map$iv;
                destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void dependency;
                    it = (Dependency)item$iv$iv;
                    Collection collection = destination$iv$iv2;
                    boolean bl3 = false;
                    void v4 = dependency;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v4, (String)"dependency");
                    String string = v4.getName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"dependency.name");
                    Dep dep = new Dep(string, dependency.getVersion());
                    collection.add(dep);
                }
                Iterable list$iv$iv = (List)destination$iv$iv2;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        @NotNull
        public final TaskProvider<Task> registerCheckVersionsTask(@NotNull Project project) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            TaskProvider taskProvider = project.getTasks().register(ModelNames.INSTANCE.checkApolloVersions(), (Action)new Action<Task>(project){
                final /* synthetic */ Project $project;

                /*
                 * WARNING - void declaration
                 */
                public final void execute(Task it) {
                    void $this$mapNotNullTo$iv$iv;
                    Provider<RegularFile> outputFile = BuildDirLayout.INSTANCE.versionCheck$apollo_gradle_plugin(this.$project);
                    Project project = this.$project.getRootProject();
                    Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project.rootProject");
                    ScriptHandler scriptHandler = project.getBuildscript();
                    Intrinsics.checkExpressionValueIsNotNull((Object)scriptHandler, (String)"project.rootProject.buildscript");
                    ConfigurationContainer configurationContainer = scriptHandler.getConfigurations();
                    Intrinsics.checkExpressionValueIsNotNull((Object)configurationContainer, (String)"project.rootProject.buildscript.configurations");
                    Collection collection = ApolloPlugin.Companion.getDeps(configurationContainer);
                    ScriptHandler scriptHandler2 = this.$project.getBuildscript();
                    Intrinsics.checkExpressionValueIsNotNull((Object)scriptHandler2, (String)"project.buildscript");
                    ConfigurationContainer configurationContainer2 = scriptHandler2.getConfigurations();
                    Intrinsics.checkExpressionValueIsNotNull((Object)configurationContainer2, (String)"project.buildscript.configurations");
                    Collection collection2 = CollectionsKt.plus((Collection)collection, (Iterable)ApolloPlugin.Companion.getDeps(configurationContainer2));
                    ConfigurationContainer configurationContainer3 = this.$project.getConfigurations();
                    Intrinsics.checkExpressionValueIsNotNull((Object)configurationContainer3, (String)"project.configurations");
                    List allDeps = CollectionsKt.plus((Collection)collection2, (Iterable)ApolloPlugin.Companion.getDeps(configurationContainer3));
                    Iterable $this$mapNotNull$iv = allDeps;
                    boolean $i$f$mapNotNull = false;
                    Iterable iterable = $this$mapNotNull$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$mapNotNullTo = false;
                    void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach = false;
                    Iterator<T> iterator = $this$forEach$iv$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        String string;
                        T element$iv$iv$iv;
                        T element$iv$iv = element$iv$iv$iv = iterator.next();
                        boolean bl = false;
                        Dep it2 = (Dep)element$iv$iv;
                        boolean bl2 = false;
                        if (it2.getVersion() == null) continue;
                        boolean bl3 = false;
                        boolean bl4 = false;
                        String it$iv$iv = string;
                        boolean bl5 = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    List allVersions = CollectionsKt.sorted((Iterable)CollectionsKt.distinct((Iterable)((List)destination$iv$iv)));
                    Task task = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)task, (String)"it");
                    task.getInputs().property("allVersions", (Object)allVersions);
                    it.getOutputs().file(outputFile);
                    it.doLast((Action)new Action<Task>(allVersions, allDeps, outputFile){
                        final /* synthetic */ List $allVersions;
                        final /* synthetic */ List $allDeps;
                        final /* synthetic */ Provider $outputFile;

                        /*
                         * WARNING - void declaration
                         */
                        public final void execute(Task it) {
                            boolean bl = this.$allVersions.size() <= 1;
                            boolean bl2 = false;
                            boolean bl3 = false;
                            if (!bl) {
                                void $this$mapTo$iv$iv;
                                boolean bl4 = false;
                                Iterable $this$map$iv = this.$allDeps;
                                boolean $i$f$map = false;
                                Iterable iterable = $this$map$iv;
                                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                                boolean $i$f$mapTo = false;
                                for (T item$iv$iv : $this$mapTo$iv$iv) {
                                    void it2;
                                    Dep dep = (Dep)item$iv$iv;
                                    Collection collection = destination$iv$iv;
                                    boolean bl5 = false;
                                    String string = it2.getName() + ':' + it2.getVersion();
                                    collection.add(string);
                                }
                                String found = CollectionsKt.joinToString$default((Iterable)CollectionsKt.distinct((Iterable)((List)destination$iv$iv)), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
                                String string = "All apollo versions should be the same. Found:\n" + found;
                                throw (Throwable)new IllegalStateException(string.toString());
                            }
                            String version = (String)CollectionsKt.firstOrNull((List)this.$allVersions);
                            Object object = this.$outputFile.get();
                            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"outputFile.get()");
                            File file = ((RegularFile)object).getAsFile();
                            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"outputFile.get().asFile");
                            file.getParentFile().mkdirs();
                            Object object2 = this.$outputFile.get();
                            Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"outputFile.get()");
                            File file2 = ((RegularFile)object2).getAsFile();
                            Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"outputFile.get().asFile");
                            FilesKt.writeText$default((File)file2, (String)("All versions are consistent: " + version), null, (int)2, null);
                        }
                        {
                            this.$allVersions = list;
                            this.$allDeps = list2;
                            this.$outputFile = provider2;
                        }
                    });
                }
                {
                    this.$project = project;
                }
            });
            Intrinsics.checkExpressionValueIsNotNull((Object)taskProvider, (String)"project.tasks.register(M\u2026rsion\")\n        }\n      }");
            return taskProvider;
        }

        private Companion() {
        }

        public static final /* synthetic */ void access$afterEvaluate(Companion $this, Project project, DefaultApolloExtension apolloExtension) {
            $this.afterEvaluate(project, apolloExtension);
        }

        public static final /* synthetic */ TaskProvider access$registerCodeGenTask(Companion $this, Project project, DefaultCompilationUnit compilationUnit, Configuration consumerConfiguration) {
            return $this.registerCodeGenTask(project, compilationUnit, consumerConfiguration);
        }

        public static final /* synthetic */ TaskProvider access$maybeRegisterCheckDuplicates(Companion $this, Project rootProject, DefaultCompilationUnit compilationUnit) {
            return $this.maybeRegisterCheckDuplicates(rootProject, compilationUnit);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\n\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u001f\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/apollographql/apollo/gradle/internal/ApolloPlugin$Companion$Dep;", "", "name", "", "version", "(Ljava/lang/String;Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "getVersion", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "apollo-gradle-plugin"})
        public static final class Dep {
            @NotNull
            private final String name;
            @Nullable
            private final String version;

            @NotNull
            public final String getName() {
                return this.name;
            }

            @Nullable
            public final String getVersion() {
                return this.version;
            }

            public Dep(@NotNull String name, @Nullable String version) {
                Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
                this.name = name;
                this.version = version;
            }

            @NotNull
            public final String component1() {
                return this.name;
            }

            @Nullable
            public final String component2() {
                return this.version;
            }

            @NotNull
            public final Dep copy(@NotNull String name, @Nullable String version) {
                Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
                return new Dep(name, version);
            }

            public static /* synthetic */ Dep copy$default(Dep dep, String string, String string2, int n, Object object) {
                if ((n & 1) != 0) {
                    string = dep.name;
                }
                if ((n & 2) != 0) {
                    string2 = dep.version;
                }
                return dep.copy(string, string2);
            }

            @NotNull
            public String toString() {
                return "Dep(name=" + this.name + ", version=" + this.version + ")";
            }

            public int hashCode() {
                String string = this.name;
                String string2 = this.version;
                return (string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0);
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof Dep)) break block3;
                        Dep dep = (Dep)object;
                        if (!Intrinsics.areEqual((Object)this.name, (Object)dep.name) || !Intrinsics.areEqual((Object)this.version, (Object)dep.version)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
    }
}

