/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.gradle.internal;

import com.squareup.moshi.JsonWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.BufferedSink;
import okio.Okio;
import okio.Sink;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J:\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lcom/apollographql/apollo/gradle/internal/SchemaDownloader;", "", "()V", "introspectionQuery", "", "getIntrospectionQuery", "()Ljava/lang/String;", "download", "", "endpoint", "schema", "Ljava/io/File;", "headers", "", "readTimeoutSeconds", "", "connectTimeoutSeconds", "apollo-gradle-plugin"})
public final class SchemaDownloader {
    @NotNull
    private static final String introspectionQuery;
    public static final SchemaDownloader INSTANCE;

    public final void download(@NotNull String endpoint, @NotNull File schema, @NotNull Map<String, String> headers, long readTimeoutSeconds, long connectTimeoutSeconds) {
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        JsonWriter jsonWriter = JsonWriter.of((BufferedSink)Okio.buffer((Sink)Okio.sink((OutputStream)byteArrayOutputStream)));
        boolean bl = false;
        boolean bl2 = false;
        JsonWriter $this$apply = jsonWriter;
        boolean bl3 = false;
        $this$apply.beginObject();
        $this$apply.name("query");
        $this$apply.value(introspectionQuery);
        $this$apply.endObject();
        $this$apply.flush();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"byteArrayOutputStream.toByteArray()");
        RequestBody body = RequestBody.Companion.create$default((RequestBody.Companion)RequestBody.Companion, (byte[])byArray, (MediaType)MediaType.Companion.parse("application/json"), (int)0, (int)0, (int)6, null);
        Request.Builder builder = new Request.Builder().post(body);
        boolean bl4 = false;
        boolean bl5 = false;
        Request.Builder $this$apply2 = builder;
        boolean bl6 = false;
        Iterable $this$forEach$iv = headers.entrySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry it = (Map.Entry)element$iv;
            boolean bl7 = false;
            $this$apply2.addHeader((String)it.getKey(), (String)it.getValue());
        }
        Request request = builder.url(endpoint).build();
        Response response = new OkHttpClient.Builder().connectTimeout(connectTimeoutSeconds, TimeUnit.SECONDS).readTimeout(readTimeoutSeconds, TimeUnit.SECONDS).build().newCall(request).execute();
        if (!response.isSuccessful()) {
            ResponseBody responseBody = response.body();
            throw (Throwable)new Exception("cannot get schema: " + response.code() + ":\n" + (responseBody != null ? responseBody.string() : null));
        }
        File file = schema.getParentFile();
        if (file != null) {
            file.mkdirs();
        }
        ResponseBody responseBody = response.body();
        Intrinsics.checkNotNull((Object)responseBody);
        FilesKt.writeText$default((File)schema, (String)responseBody.string(), null, (int)2, null);
    }

    @NotNull
    public final String getIntrospectionQuery() {
        return introspectionQuery;
    }

    private SchemaDownloader() {
    }

    static {
        SchemaDownloader schemaDownloader;
        INSTANCE = schemaDownloader = new SchemaDownloader();
        introspectionQuery = "query IntrospectionQuery {\n  __schema {\n    queryType { name }\n    mutationType { name }\n    subscriptionType { name }\n    types {\n      ...FullType\n    }\n    directives {\n      name\n      description\n      locations\n      args {\n        ...InputValue\n      }\n    }\n  }\n}\n\nfragment FullType on __Type {\n  kind\n  name\n  description\n  fields(includeDeprecated: true) {\n    name\n    description\n    args {\n      ...InputValue\n    }\n    type {\n      ...TypeRef\n    }\n    isDeprecated\n    deprecationReason\n  }\n  inputFields {\n    ...InputValue\n  }\n  interfaces {\n    ...TypeRef\n  }\n  enumValues(includeDeprecated: true) {\n    name\n    description\n    isDeprecated\n    deprecationReason\n  }\n  possibleTypes {\n    ...TypeRef\n  }\n}\n\nfragment InputValue on __InputValue {\n  name\n  description\n  type { ...TypeRef }\n  defaultValue\n}\n\nfragment TypeRef on __Type {\n  kind\n  name\n  ofType {\n    kind\n    name\n    ofType {\n      kind\n      name\n      ofType {\n        kind\n        name\n        ofType {\n          kind\n          name\n          ofType {\n            kind\n            name\n            ofType {\n              kind\n              name\n              ofType {\n                kind\n                name\n              }\n            }\n          }\n        }\n      }\n    }\n  }\n}";
    }
}

