/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.gradle;

import com.apollographql.apollo.gradle.Utils;
import com.google.common.collect.Lists;
import com.moowork.gradle.node.npm.NpmTask;
import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.JsonWriter;
import com.squareup.moshi.Moshi;
import java.io.File;
import java.io.IOException;
import okio.BufferedSink;
import okio.Okio;
import okio.Sink;
import okio.Source;
import org.gradle.api.Task;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.OutputDirectory;

public class ApolloCodeGenInstallTask
extends NpmTask {
    static final String NAME = "installApolloCodegen";
    private static final String INSTALL_DIR = "apollo-codegen/node_modules/apollo-codegen";
    @OutputDirectory
    private File installDir;
    File apolloPackageFile;

    public ApolloCodeGenInstallTask() {
        this.setGroup("apollo");
        this.setDescription("Runs npm install for apollo-codegen");
        this.installDir = this.getProject().file((Object)(this.getProject().getBuildDir() + File.separator + INSTALL_DIR));
        File workingDir = new File(this.getProject().getBuildDir(), "apollo-codegen");
        this.setWorkingDir(workingDir);
        this.apolloPackageFile = this.getProject().file((Object)(workingDir + File.separator + "package.json"));
        final boolean isSameCodegenVersion = this.isSameApolloCodegenVersion(this.getApolloVersion());
        if (!isSameCodegenVersion) {
            Utils.deleteDirectory(this.installDir);
        }
        this.getOutputs().upToDateWhen((Spec)new Spec<Task>(){

            public boolean isSatisfiedBy(Task element) {
                return ApolloCodeGenInstallTask.this.apolloPackageFile.isFile() && isSameCodegenVersion;
            }
        });
    }

    public void exec() {
        if (!this.apolloPackageFile.isFile()) {
            this.writePackageFile(this.apolloPackageFile);
        }
        this.setArgs(Lists.newArrayList((Object[])new String[]{"install", "apollo-codegen@0.19.1", "--save", "--save-exact"}));
        this.getLogging().captureStandardOutput(LogLevel.INFO);
        super.exec();
    }

    private String getApolloVersion() {
        File packageFile = new File(this.getProject().getBuildDir(), "apollo-codegen/node_modules/apollo-codegen/package.json");
        if (!packageFile.isFile()) {
            return null;
        }
        Moshi moshi = new Moshi.Builder().build();
        JsonAdapter adapter = moshi.adapter(PackageJson.class);
        try {
            PackageJson packageJson = (PackageJson)adapter.fromJson(Okio.buffer((Source)Okio.source((File)packageFile)));
            return packageJson.version;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private boolean isSameApolloCodegenVersion(String packageVersion) {
        return packageVersion != null && packageVersion.equals("0.19.1");
    }

    private void writePackageFile(File apolloPackageFile) {
        try {
            JsonWriter writer = JsonWriter.of((BufferedSink)Okio.buffer((Sink)Okio.sink((File)apolloPackageFile)));
            writer.beginObject();
            writer.name("name").value("apollo-android");
            writer.name("version").value("0.0.1");
            writer.name("description").value("Generates Java code based on a GraphQL schema and query documents. Uses apollo-codegen under the hood.");
            writer.name("name").value("apollo-android");
            writer.name("repository");
            writer.beginObject();
            writer.name("type").value("git");
            writer.name("url").value("git+https://github.com/apollostack/apollo-android.git");
            writer.endObject();
            writer.name("author").value("Apollo");
            writer.name("license").value("MIT");
            writer.endObject();
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public File getInstallDir() {
        return this.installDir;
    }

    private static class PackageJson {
        String version;

        private PackageJson() {
        }
    }
}

