/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.gradle.internal;

import com.android.build.gradle.AppExtension;
import com.android.build.gradle.BaseExtension;
import com.android.build.gradle.LibraryExtension;
import com.android.build.gradle.api.ApplicationVariant;
import com.android.build.gradle.api.BaseVariant;
import com.android.build.gradle.api.LibraryVariant;
import com.android.builder.model.ApiVersion;
import com.android.builder.model.SourceProvider;
import com.android.builder.model.Version;
import com.apollographql.apollo.gradle.internal.AndroidProjectKt;
import com.apollographql.apollo.gradle.internal.KotlinProjectKt;
import java.io.File;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.Directory;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.dsl.KotlinProjectExtension;
import org.jetbrains.kotlin.gradle.plugin.KotlinSourceSet;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000H\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\b\u001a\u0012\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u0003H\u0002\u001a4\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u000e\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\r\u001a,\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u000e\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\r\u001a,\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00032\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u000e\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\r\"\u001a\u0010\u0013\u001a\u0004\u0018\u00010\u0014*\u00020\u00158@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\"\u001a\u0010\u0018\u001a\u0004\u0018\u00010\u0014*\u00020\u00158@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0017\"\u0018\u0010\u001a\u001a\u00020\b*\u00020\u00158@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006\u001d"}, d2={"getMainVariants", "Lorg/gradle/api/NamedDomainObjectContainer;", "Lcom/android/build/gradle/api/BaseVariant;", "Lorg/gradle/api/Project;", "connectToAndroidSourceSet", "", "project", "sourceSetName", "", "outputDir", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/Directory;", "taskProvider", "Lorg/gradle/api/tasks/TaskProvider;", "Lorg/gradle/api/Task;", "connectToAndroidVariant", "variant", "", "connectToAllAndroidVariants", "minSdk", "", "Lcom/android/build/gradle/BaseExtension;", "getMinSdk", "(Lcom/android/build/gradle/BaseExtension;)Ljava/lang/Integer;", "targetSdk", "getTargetSdk", "pluginVersion", "getPluginVersion", "(Lcom/android/build/gradle/BaseExtension;)Ljava/lang/String;", "apollo-gradle-plugin-external"})
@SourceDebugExtension(value={"SMAP\nAndroidPluginFacade.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AndroidPluginFacade.kt\ncom/apollographql/apollo/gradle/internal/AndroidPluginFacadeKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,102:1\n1755#2,3:103\n*S KotlinDebug\n*F\n+ 1 AndroidPluginFacade.kt\ncom/apollographql/apollo/gradle/internal/AndroidPluginFacadeKt\n*L\n62#1:103,3\n*E\n"})
public final class AndroidPluginFacadeKt {
    private static final NamedDomainObjectContainer<BaseVariant> getMainVariants(Project $this$getMainVariants) {
        BaseExtension extension;
        NamedDomainObjectContainer container = $this$getMainVariants.getProject().container(BaseVariant.class);
        Project project = $this$getMainVariants.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        BaseExtension baseExtension = extension = AndroidProjectKt.getAndroidExtensionOrThrow(project);
        if (baseExtension instanceof LibraryExtension) {
            ((LibraryExtension)extension).getLibraryVariants().configureEach(arg_0 -> AndroidPluginFacadeKt.getMainVariants$lambda$1(arg_0 -> AndroidPluginFacadeKt.getMainVariants$lambda$0(container, arg_0), arg_0));
        } else if (baseExtension instanceof AppExtension) {
            ((AppExtension)extension).getApplicationVariants().configureEach(arg_0 -> AndroidPluginFacadeKt.getMainVariants$lambda$3(arg_0 -> AndroidPluginFacadeKt.getMainVariants$lambda$2(container, arg_0), arg_0));
        } else {
            throw new IllegalStateException(("Unsupported extension: " + extension).toString());
        }
        Intrinsics.checkNotNull((Object)container);
        return container;
    }

    public static final void connectToAndroidSourceSet(@NotNull Project project, @NotNull String sourceSetName, @NotNull Provider<Directory> outputDir, @NotNull TaskProvider<? extends Task> taskProvider) {
        SourceDirectorySet kotlinSourceSet;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)sourceSetName, (String)"sourceSetName");
        Intrinsics.checkNotNullParameter(outputDir, (String)"outputDir");
        Intrinsics.checkNotNullParameter(taskProvider, (String)"taskProvider");
        KotlinProjectExtension kotlinProjectExtension = KotlinProjectKt.getKotlinProjectExtension(project);
        SourceDirectorySet sourceDirectorySet = kotlinProjectExtension != null && (kotlinProjectExtension = kotlinProjectExtension.getSourceSets()) != null && (kotlinProjectExtension = (KotlinSourceSet)kotlinProjectExtension.getByName(sourceSetName)) != null ? kotlinProjectExtension.getKotlin() : (kotlinSourceSet = null);
        if (kotlinSourceSet != null) {
            kotlinSourceSet.srcDir(outputDir);
        }
        AndroidPluginFacadeKt.getMainVariants(project).configureEach(arg_0 -> AndroidPluginFacadeKt.connectToAndroidSourceSet$lambda$6(arg_0 -> AndroidPluginFacadeKt.connectToAndroidSourceSet$lambda$5(kotlinSourceSet, taskProvider, outputDir, sourceSetName, arg_0), arg_0));
    }

    public static final void connectToAndroidVariant(@NotNull Object variant, @NotNull Provider<Directory> outputDir, @NotNull TaskProvider<? extends Task> taskProvider) {
        Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
        Intrinsics.checkNotNullParameter(outputDir, (String)"outputDir");
        Intrinsics.checkNotNullParameter(taskProvider, (String)"taskProvider");
        if (!(variant instanceof BaseVariant)) {
            boolean bl = false;
            String string = "Apollo: variant must be an instance of com.android.build.gradle.api.BaseVariant (found " + variant + ")";
            throw new IllegalStateException(string.toString());
        }
        ((BaseVariant)variant).registerJavaGeneratingTask(taskProvider, (Collection)CollectionsKt.listOf((Object)((Directory)outputDir.get()).getAsFile()));
    }

    public static final void connectToAllAndroidVariants(@NotNull Project project, @NotNull Provider<Directory> outputDir, @NotNull TaskProvider<? extends Task> taskProvider) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(outputDir, (String)"outputDir");
        Intrinsics.checkNotNullParameter(taskProvider, (String)"taskProvider");
        AndroidPluginFacadeKt.getMainVariants(project).configureEach(arg_0 -> AndroidPluginFacadeKt.connectToAllAndroidVariants$lambda$9(arg_0 -> AndroidPluginFacadeKt.connectToAllAndroidVariants$lambda$8(outputDir, taskProvider, arg_0), arg_0));
    }

    @Nullable
    public static final Integer getMinSdk(@NotNull BaseExtension $this$minSdk) {
        Intrinsics.checkNotNullParameter((Object)$this$minSdk, (String)"<this>");
        ApiVersion apiVersion = $this$minSdk.getDefaultConfig().getMinSdkVersion();
        return apiVersion != null ? Integer.valueOf(apiVersion.getApiLevel()) : null;
    }

    @Nullable
    public static final Integer getTargetSdk(@NotNull BaseExtension $this$targetSdk) {
        Intrinsics.checkNotNullParameter((Object)$this$targetSdk, (String)"<this>");
        ApiVersion apiVersion = $this$targetSdk.getDefaultConfig().getTargetSdkVersion();
        return apiVersion != null ? Integer.valueOf(apiVersion.getApiLevel()) : null;
    }

    @NotNull
    public static final String getPluginVersion(@NotNull BaseExtension $this$pluginVersion) {
        Intrinsics.checkNotNullParameter((Object)$this$pluginVersion, (String)"<this>");
        String string = Version.ANDROID_GRADLE_PLUGIN_VERSION;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ANDROID_GRADLE_PLUGIN_VERSION");
        return string;
    }

    private static final Unit getMainVariants$lambda$0(NamedDomainObjectContainer $container, LibraryVariant variant) {
        $container.add((Object)variant);
        return Unit.INSTANCE;
    }

    private static final void getMainVariants$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit getMainVariants$lambda$2(NamedDomainObjectContainer $container, ApplicationVariant variant) {
        $container.add((Object)variant);
        return Unit.INSTANCE;
    }

    private static final void getMainVariants$lambda$3(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit connectToAndroidSourceSet$lambda$5(SourceDirectorySet $kotlinSourceSet, TaskProvider $taskProvider, Provider $outputDir, String $sourceSetName, BaseVariant it) {
        boolean bl;
        block6: {
            List list = it.getSourceSets();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getSourceSets(...)");
            Iterable $this$any$iv = list;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    SourceProvider it2 = (SourceProvider)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it2.getName(), (Object)$sourceSetName)) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
        }
        if (bl) {
            File[] fileArray;
            if ($kotlinSourceSet == null) {
                fileArray = new File[]{((Directory)$outputDir.get()).getAsFile()};
                it.registerJavaGeneratingTask($taskProvider, fileArray);
            } else {
                fileArray = new File[]{((Directory)$outputDir.get()).getAsFile()};
                it.addJavaSourceFoldersToModel(fileArray);
            }
        }
        return Unit.INSTANCE;
    }

    private static final void connectToAndroidSourceSet$lambda$6(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit connectToAllAndroidVariants$lambda$8(Provider $outputDir, TaskProvider $taskProvider, BaseVariant it) {
        Intrinsics.checkNotNull((Object)it);
        AndroidPluginFacadeKt.connectToAndroidVariant(it, (Provider<Directory>)$outputDir, (TaskProvider<? extends Task>)$taskProvider);
        return Unit.INSTANCE;
    }

    private static final void connectToAllAndroidVariants$lambda$9(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }
}

