/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.debugserver.internal.graphql;

import com.apollographql.apollo.ApolloClient;
import com.apollographql.apollo.api.ExecutionContext;
import com.apollographql.apollo.debugserver.internal.graphql.ApolloDebugServerExecutableSchemaBuilderKt;
import com.apollographql.apollo.debugserver.internal.graphql.Query;
import com.apollographql.apollo.execution.ExecutableSchema;
import com.apollographql.apollo.execution.GraphQLRequest;
import com.apollographql.apollo.execution.GraphQLRequestKt;
import com.apollographql.apollo.execution.GraphQLResponse;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import okio.Buffer;
import okio.BufferedSource;
import okio.Sink;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001B!\u0012\u0018\u0010\u0002\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00040\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0006R \u0010\u0002\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\t\u001a\u00020\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0011"}, d2={"Lcom/apollographql/apollo/debugserver/internal/graphql/GraphQL;", "", "apolloClients", "Ljava/util/concurrent/atomic/AtomicReference;", "", "Lcom/apollographql/apollo/ApolloClient;", "", "<init>", "(Ljava/util/concurrent/atomic/AtomicReference;)V", "executableSchema", "Lcom/apollographql/apollo/execution/ExecutableSchema;", "getExecutableSchema", "()Lcom/apollographql/apollo/execution/ExecutableSchema;", "executableSchema$delegate", "Lkotlin/Lazy;", "executeGraphQL", "jsonBody", "apollo-debug-server"})
public final class GraphQL {
    @NotNull
    private final AtomicReference<Map<ApolloClient, String>> apolloClients;
    @NotNull
    private final Lazy executableSchema$delegate;

    public GraphQL(@NotNull AtomicReference<Map<ApolloClient, String>> apolloClients) {
        Intrinsics.checkNotNullParameter(apolloClients, (String)"apolloClients");
        this.apolloClients = apolloClients;
        this.executableSchema$delegate = LazyKt.lazy(() -> GraphQL.executableSchema_delegate$lambda$0(this));
    }

    private final ExecutableSchema getExecutableSchema() {
        Lazy lazy = this.executableSchema$delegate;
        return (ExecutableSchema)lazy.getValue();
    }

    @NotNull
    public final String executeGraphQL(@NotNull String jsonBody) {
        Intrinsics.checkNotNullParameter((Object)jsonBody, (String)"jsonBody");
        Object graphQLRequestResult = GraphQLRequestKt.parseAsGraphQLRequest((BufferedSource)((BufferedSource)new Buffer().writeUtf8(jsonBody)));
        if (!Result.isSuccess-impl((Object)graphQLRequestResult)) {
            Throwable throwable = Result.exceptionOrNull-impl((Object)graphQLRequestResult);
            Intrinsics.checkNotNull((Object)throwable);
            String string = throwable.getMessage();
            Intrinsics.checkNotNull((Object)string);
            return string;
        }
        GraphQLResponse graphQlResponse2 = (GraphQLResponse)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super GraphQLResponse>, Object>(this, graphQLRequestResult, null){
            int label;
            final /* synthetic */ GraphQL this$0;
            final /* synthetic */ Object $graphQLRequestResult;
            {
                this.this$0 = $receiver;
                this.$graphQLRequestResult = $graphQLRequestResult;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        ExecutableSchema executableSchema = GraphQL.access$getExecutableSchema(this.this$0);
                        Object object3 = this.$graphQLRequestResult;
                        ResultKt.throwOnFailure((Object)object3);
                        this.label = 1;
                        Object object4 = executableSchema.execute((GraphQLRequest)object3, ExecutionContext.Empty, (Continuation)this);
                        if (object4 != object2) return object4;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object4 = $result;
                        return object4;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super GraphQLResponse> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
        Buffer buffer = new Buffer();
        graphQlResponse2.serialize((Sink)buffer);
        return buffer.readUtf8();
    }

    private static final ExecutableSchema executableSchema_delegate$lambda$0(GraphQL this$0) {
        return ApolloDebugServerExecutableSchemaBuilderKt.ApolloDebugServerExecutableSchemaBuilder().queryRoot(() -> GraphQL.executableSchema_delegate$lambda$0$0(this$0)).build();
    }

    private static final Object executableSchema_delegate$lambda$0$0(GraphQL this$0) {
        return new Query(this$0.apolloClients);
    }

    public static final /* synthetic */ ExecutableSchema access$getExecutableSchema(GraphQL $this) {
        return $this.getExecutableSchema();
    }
}

