/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.debugserver;

import com.apollographql.apollo.ApolloClient;
import com.apollographql.apollo.debugserver.internal.server.Server;
import com.apollographql.apollo.debugserver.internal.server.Server_jvmKt;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00072\b\b\u0002\u0010\u000e\u001a\u00020\bJ\u000e\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0007J\b\u0010\u0010\u001a\u00020\fH\u0002R \u0010\u0004\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/apollographql/apollo/debugserver/ApolloDebugServer;", "", "<init>", "()V", "apolloClients", "Ljava/util/concurrent/atomic/AtomicReference;", "", "Lcom/apollographql/apollo/ApolloClient;", "", "server", "Lcom/apollographql/apollo/debugserver/internal/server/Server;", "registerApolloClient", "", "apolloClient", "id", "unregisterApolloClient", "startOrStopServer", "apollo-debug-server"})
public final class ApolloDebugServer {
    @NotNull
    public static final ApolloDebugServer INSTANCE = new ApolloDebugServer();
    @NotNull
    private static final AtomicReference<Map<ApolloClient, String>> apolloClients = new AtomicReference<Map>(MapsKt.emptyMap());
    @Nullable
    private static Server server;

    private ApolloDebugServer() {
    }

    public final void registerApolloClient(@NotNull ApolloClient apolloClient, @NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)apolloClient, (String)"apolloClient");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        if (apolloClients.get().containsKey(apolloClient)) {
            throw new IllegalStateException(("Client '" + apolloClient + "' already registered").toString());
        }
        if (apolloClients.get().containsValue(id)) {
            throw new IllegalStateException(("Name '" + id + "' already registered").toString());
        }
        Map<ApolloClient, String> map = apolloClients.get();
        Intrinsics.checkNotNullExpressionValue(map, (String)"get(...)");
        apolloClients.set(MapsKt.plus(map, (Pair)TuplesKt.to((Object)apolloClient, (Object)id)));
        this.startOrStopServer();
    }

    public static /* synthetic */ void registerApolloClient$default(ApolloDebugServer apolloDebugServer, ApolloClient apolloClient, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = "client";
        }
        apolloDebugServer.registerApolloClient(apolloClient, string);
    }

    public final void unregisterApolloClient(@NotNull ApolloClient apolloClient) {
        Intrinsics.checkNotNullParameter((Object)apolloClient, (String)"apolloClient");
        Map<ApolloClient, String> map = apolloClients.get();
        Intrinsics.checkNotNullExpressionValue(map, (String)"get(...)");
        apolloClients.set(MapsKt.minus(map, (Object)apolloClient));
        this.startOrStopServer();
    }

    private final void startOrStopServer() {
        if (apolloClients.get().isEmpty()) {
            Server server = ApolloDebugServer.server;
            if (server != null) {
                server.stop();
            }
            ApolloDebugServer.server = null;
        } else if (server == null) {
            Server server;
            Server $this$startOrStopServer_u24lambda_u240 = server = Server_jvmKt.createServer(apolloClients);
            boolean bl = false;
            $this$startOrStopServer_u24lambda_u240.start();
            ApolloDebugServer.server = server;
        }
    }
}

