/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.compiler;

import com.apollographql.apollo.ast.ApolloParser;
import com.apollographql.apollo.ast.ExecutableValidationResult;
import com.apollographql.apollo.ast.ForeignSchema;
import com.apollographql.apollo.ast.GQLDefinition;
import com.apollographql.apollo.ast.GQLDocument;
import com.apollographql.apollo.ast.GQLFragmentDefinition;
import com.apollographql.apollo.ast.GQLOperationDefinition;
import com.apollographql.apollo.ast.GQLResult;
import com.apollographql.apollo.ast.GQLSchemaDefinition;
import com.apollographql.apollo.ast.GQLTypeDefinition;
import com.apollographql.apollo.ast.GqldocumentKt;
import com.apollographql.apollo.ast.Issue;
import com.apollographql.apollo.ast.IssueKt;
import com.apollographql.apollo.ast.ParserOptions;
import com.apollographql.apollo.ast.QueryDocumentMinifier;
import com.apollographql.apollo.ast.Schema;
import com.apollographql.apollo.ast.SourceLocation;
import com.apollographql.apollo.ast.SourceLocationKt;
import com.apollographql.apollo.ast.internal.SchemaValidationOptions;
import com.apollographql.apollo.compiler.ApolloCompilerKt;
import com.apollographql.apollo.compiler.CodegenMetadata;
import com.apollographql.apollo.compiler.CodegenOptions;
import com.apollographql.apollo.compiler.CodegenSchema;
import com.apollographql.apollo.compiler.CodegenSchemaOptions;
import com.apollographql.apollo.compiler.ExecutableDocumentTransform;
import com.apollographql.apollo.compiler.FileUtils;
import com.apollographql.apollo.compiler.InputFile;
import com.apollographql.apollo.compiler.IrOptions;
import com.apollographql.apollo.compiler.IssueGroup;
import com.apollographql.apollo.compiler.LayoutFactory;
import com.apollographql.apollo.compiler.OperationOutputGenerator;
import com.apollographql.apollo.compiler.OptionsKt;
import com.apollographql.apollo.compiler.TargetLanguage;
import com.apollographql.apollo.compiler.Transform;
import com.apollographql.apollo.compiler.UsedCoordinates;
import com.apollographql.apollo.compiler.codegen.LayoutImplKt;
import com.apollographql.apollo.compiler.codegen.SchemaAndOperationsLayout;
import com.apollographql.apollo.compiler.codegen.SchemaLayout;
import com.apollographql.apollo.compiler.codegen.SourceOutput;
import com.apollographql.apollo.compiler.codegen.SourceOutputKt;
import com.apollographql.apollo.compiler.codegen.java.JavaCodegen;
import com.apollographql.apollo.compiler.codegen.java.JavaOutput;
import com.apollographql.apollo.compiler.codegen.java.JavaOutputKt;
import com.apollographql.apollo.compiler.codegen.kotlin.KotlinCodegen;
import com.apollographql.apollo.compiler.codegen.kotlin.KotlinOutput;
import com.apollographql.apollo.compiler.codegen.kotlin.KotlinOutputKt;
import com.apollographql.apollo.compiler.internal.-checkApolloDuplicateTargetNames;
import com.apollographql.apollo.compiler.internal.-checkApolloInlineFragmentsHaveTypeCondition;
import com.apollographql.apollo.compiler.internal.-checkApolloReservedEnumValueNames;
import com.apollographql.apollo.compiler.internal.-checkCapitalizedFields;
import com.apollographql.apollo.compiler.internal.ApolloExecutableDocumentTransform;
import com.apollographql.apollo.compiler.internal.CheckConditionalFragmentKt;
import com.apollographql.apollo.compiler.internal.CheckKeyFieldsKt;
import com.apollographql.apollo.compiler.ir.IrOperation;
import com.apollographql.apollo.compiler.ir.IrOperations;
import com.apollographql.apollo.compiler.ir.IrOperationsBuilder;
import com.apollographql.apollo.compiler.ir.IrSchema;
import com.apollographql.apollo.compiler.ir.IrSchemaBuilder;
import com.apollographql.apollo.compiler.operationoutput.OperationDescriptor;
import com.apollographql.apollo.compiler.pqm.PersistedQueryManifestKt;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00a4\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u00019B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J4\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0006JT\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00042\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u00062\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u00062\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\u0010\b\u001a\u0004\u0018\u00010\tJ\u008e\u0001\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0010\u001a\u00020\u00042\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 2\b\u0010!\u001a\u0004\u0018\u00010\"2\u000e\u0010#\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010$2\u000e\u0010%\u001a\n\u0012\u0004\u0012\u00020&\u0018\u00010$2\u000e\u0010'\u001a\n\u0012\u0004\u0012\u00020(\u0018\u00010$2\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010)\u001a\u0004\u0018\u00010*J\u009c\u0001\u0010\u001a\u001a\u00020\u001b2\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 2\b\u0010!\u001a\u0004\u0018\u00010\"2\u000e\u0010#\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010$2\u000e\u0010%\u001a\n\u0012\u0004\u0012\u00020&\u0018\u00010$2\u000e\u0010'\u001a\n\u0012\u0004\u0012\u00020(\u0018\u00010$2\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010)\u001a\u0004\u0018\u00010*J\u0082\u0001\u0010+\u001a\u00020\u001b2\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010,\u001a\u00020\u000f2\u0006\u0010-\u001a\u00020.2\f\u0010/\u001a\b\u0012\u0004\u0012\u0002000\u00062\u0006\u0010\u001d\u001a\u00020\u001e2\b\u00101\u001a\u0004\u0018\u0001022\b\u0010!\u001a\u0004\u0018\u00010\"2\u000e\u0010#\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010$2\u000e\u0010%\u001a\n\u0012\u0004\u0012\u00020&\u0018\u00010$2\u000e\u0010'\u001a\n\u0012\u0004\u0012\u00020(\u0018\u00010$2\b\u0010)\u001a\u0004\u0018\u00010*JH\u00103\u001a\u00020\u001b2\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u00104\u001a\u00020.2\u0006\u0010\u001d\u001a\u00020\u001e2\b\u00105\u001a\u0004\u0018\u0001062\u000e\u0010%\u001a\n\u0012\u0004\u0012\u00020&\u0018\u00010$2\u000e\u0010'\u001a\n\u0012\u0004\u0012\u00020(\u0018\u00010$J\u0012\u00107\u001a\b\u0012\u0004\u0012\u0002080\u0006*\u00020*H\u0002\u00a8\u0006:"}, d2={"Lcom/apollographql/apollo/compiler/ApolloCompiler;", "", "()V", "buildCodegenSchema", "Lcom/apollographql/apollo/compiler/CodegenSchema;", "schemaFiles", "", "Lcom/apollographql/apollo/compiler/InputFile;", "logger", "Lcom/apollographql/apollo/compiler/ApolloCompiler$Logger;", "codegenSchemaOptions", "Lcom/apollographql/apollo/compiler/CodegenSchemaOptions;", "foreignSchemas", "Lcom/apollographql/apollo/ast/ForeignSchema;", "buildIrOperations", "Lcom/apollographql/apollo/compiler/ir/IrOperations;", "codegenSchema", "executableFiles", "upstreamCodegenModels", "", "upstreamFragmentDefinitions", "Lcom/apollographql/apollo/ast/GQLFragmentDefinition;", "options", "Lcom/apollographql/apollo/compiler/IrOptions;", "documentTransform", "Lcom/apollographql/apollo/compiler/ExecutableDocumentTransform;", "buildSchemaAndOperationsSources", "Lcom/apollographql/apollo/compiler/codegen/SourceOutput;", "irOptions", "codegenOptions", "Lcom/apollographql/apollo/compiler/CodegenOptions;", "layoutFactory", "Lcom/apollographql/apollo/compiler/LayoutFactory;", "operationOutputGenerator", "Lcom/apollographql/apollo/compiler/OperationOutputGenerator;", "irOperationsTransform", "Lcom/apollographql/apollo/compiler/Transform;", "javaOutputTransform", "Lcom/apollographql/apollo/compiler/codegen/java/JavaOutput;", "kotlinOutputTransform", "Lcom/apollographql/apollo/compiler/codegen/kotlin/KotlinOutput;", "operationManifestFile", "Ljava/io/File;", "buildSchemaAndOperationsSourcesFromIr", "irOperations", "downstreamUsedCoordinates", "Lcom/apollographql/apollo/compiler/UsedCoordinates;", "upstreamCodegenMetadata", "Lcom/apollographql/apollo/compiler/CodegenMetadata;", "layout", "Lcom/apollographql/apollo/compiler/codegen/SchemaAndOperationsLayout;", "buildSchemaSources", "usedCoordinates", "schemaLayout", "Lcom/apollographql/apollo/compiler/codegen/SchemaLayout;", "definitions", "Lcom/apollographql/apollo/ast/GQLDefinition;", "Logger", "apollo-compiler"})
@SourceDebugExtension(value={"SMAP\nApolloCompiler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ApolloCompiler.kt\ncom/apollographql/apollo/compiler/ApolloCompiler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,613:1\n1557#2:614\n1628#2,3:615\n1863#2:618\n808#2,11:619\n808#2,11:630\n1755#2,3:641\n1864#2:644\n1557#2:645\n1628#2,3:646\n1557#2:649\n1628#2,3:650\n1053#2:653\n1368#2:654\n1454#2,5:655\n1863#2,2:662\n1053#2:664\n1863#2:665\n1863#2,2:666\n1864#2:668\n1863#2,2:669\n808#2,11:671\n1202#2,2:682\n1230#2,4:684\n1863#2,2:688\n1863#2,2:690\n1557#2:692\n1628#2,3:693\n216#3,2:660\n*S KotlinDebug\n*F\n+ 1 ApolloCompiler.kt\ncom/apollographql/apollo/compiler/ApolloCompiler\n*L\n64#1:614\n64#1:615,3\n76#1:618\n79#1:619,11\n80#1:630,11\n80#1:641,3\n76#1:644\n90#1:645\n90#1:646,3\n94#1:649\n94#1:650,3\n101#1:653\n103#1:654\n103#1:655,5\n138#1:662,2\n200#1:664\n200#1:665\n204#1:666,2\n200#1:668\n253#1:669,2\n286#1:671,11\n286#1:682,2\n286#1:684,4\n291#1:688,2\n305#1:690,2\n394#1:692\n394#1:693,3\n108#1:660,2\n*E\n"})
public final class ApolloCompiler {
    @NotNull
    public static final ApolloCompiler INSTANCE = new ApolloCompiler();

    private ApolloCompiler() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final CodegenSchema buildCodegenSchema(@NotNull List<InputFile> schemaFiles, @Nullable Logger logger, @NotNull CodegenSchemaOptions codegenSchemaOptions, @NotNull List<ForeignSchema> foreignSchemas) {
        void $this$flatMapTo$iv$iv;
        InputFile it;
        Iterable $this$mapTo$iv$iv;
        Collection destination$iv$iv;
        Object $this$map$iv;
        boolean $i$f$map;
        Object element$iv;
        Object $this$any$iv;
        Pair it2;
        Object object;
        void $this$mapTo$iv$iv2;
        Intrinsics.checkNotNullParameter(schemaFiles, (String)"schemaFiles");
        Intrinsics.checkNotNullParameter((Object)codegenSchemaOptions, (String)"codegenSchemaOptions");
        Intrinsics.checkNotNullParameter(foreignSchemas, (String)"foreignSchemas");
        Iterable $this$map$iv2 = schemaFiles;
        boolean $i$f$map2 = false;
        Iterable iterable = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            InputFile inputFile = (InputFile)item$iv$iv;
            object = destination$iv$iv2;
            boolean bl = false;
            object.add(TuplesKt.to((Object)it2.getNormalizedPath(), (Object)ApolloParser.toGQLDocument$default((File)it2.getFile(), null, (boolean)true, (int)1, null)));
        }
        List schemaDocuments = (List)destination$iv$iv2;
        if (schemaDocuments.isEmpty()) {
            throw new IllegalStateException("No schema found. Apollo needs a `.graphqls` or a `.json` schema.".toString());
        }
        List mainSchemaDocuments = new ArrayList();
        List otherSchemaDocuments = new ArrayList();
        Object mainSchemaNormalizedPath = null;
        Iterable $this$forEach$iv = schemaDocuments;
        boolean $i$f$forEach = false;
        for (Object element$iv2 : $this$forEach$iv) {
            GQLDocument document;
            block25: {
                block24: {
                    boolean bl;
                    block23: {
                        Object element$iv$iv;
                        Object $this$filterIsInstanceTo$iv$iv;
                        it2 = (Pair)element$iv2;
                        boolean bl2 = false;
                        document = (GQLDocument)it2.getSecond();
                        Iterable $this$filterIsInstance$iv = document.getDefinitions();
                        boolean $i$f$filterIsInstance = false;
                        Iterable iterable2 = $this$filterIsInstance$iv;
                        Collection destination$iv$iv3 = new ArrayList();
                        boolean $i$f$filterIsInstanceTo = false;
                        Iterator iterator = $this$filterIsInstanceTo$iv$iv.iterator();
                        while (iterator.hasNext()) {
                            element$iv$iv = iterator.next();
                            if (!(element$iv$iv instanceof GQLSchemaDefinition)) continue;
                            destination$iv$iv3.add(element$iv$iv);
                        }
                        if (!((Collection)((List)destination$iv$iv3)).isEmpty()) break block24;
                        $this$filterIsInstance$iv = document.getDefinitions();
                        $i$f$filterIsInstance = false;
                        $this$filterIsInstanceTo$iv$iv = $this$filterIsInstance$iv;
                        destination$iv$iv3 = new ArrayList();
                        $i$f$filterIsInstanceTo = false;
                        iterator = $this$filterIsInstanceTo$iv$iv.iterator();
                        while (iterator.hasNext()) {
                            element$iv$iv = iterator.next();
                            if (!(element$iv$iv instanceof GQLTypeDefinition)) continue;
                            destination$iv$iv3.add(element$iv$iv);
                        }
                        $this$any$iv = (List)destination$iv$iv3;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            $this$filterIsInstanceTo$iv$iv = $this$any$iv.iterator();
                            while ($this$filterIsInstanceTo$iv$iv.hasNext()) {
                                element$iv = $this$filterIsInstanceTo$iv$iv.next();
                                GQLTypeDefinition it3 = (GQLTypeDefinition)element$iv;
                                boolean bl3 = false;
                                if (!Intrinsics.areEqual((Object)it3.getName(), (Object)"Query")) continue;
                                bl = true;
                                break block23;
                            }
                            bl = false;
                        }
                    }
                    if (!bl) break block25;
                }
                mainSchemaDocuments.add(document);
                mainSchemaNormalizedPath = it2.getFirst();
                continue;
            }
            otherSchemaDocuments.add(document);
        }
        if (mainSchemaDocuments.size() > 1) {
            $this$forEach$iv = mainSchemaDocuments;
            object = new StringBuilder().append("Multiple schemas found:\n");
            $i$f$map = false;
            Object object2 = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                $this$any$iv = (GQLDocument)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                SourceLocation sourceLocation = it.getSourceLocation();
                collection.add(sourceLocation != null ? sourceLocation.getFilePath() : null);
            }
            $this$map$iv = ((StringBuilder)object).append(CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null)).append("\nUse different services for different schemas").toString();
            throw new IllegalStateException($this$map$iv.toString());
        }
        if (mainSchemaDocuments.isEmpty()) {
            $this$map$iv = schemaFiles;
            object = new StringBuilder().append("Schema(s) found:\n");
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo3 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (InputFile)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getNormalizedPath());
            }
            $this$map$iv = ((StringBuilder)object).append(CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null)).append("\nBut none of them contain type definitions.").toString();
            throw new IllegalStateException($this$map$iv.toString());
        }
        GQLDocument mainSchemaDocument = (GQLDocument)CollectionsKt.single((List)mainSchemaDocuments);
        Iterable $this$sortedBy$iv = otherSchemaDocuments;
        boolean $i$f$sortedBy = false;
        List otherSchemaDocumentSorted = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                String string;
                String string2;
                GQLDocument it = (GQLDocument)a;
                boolean bl = false;
                Object object = it.getSourceLocation();
                if (object != null && (object = object.getFilePath()) != null) {
                    String string3 = File.pathSeparator;
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"pathSeparator");
                    string2 = StringsKt.substringAfterLast$default((String)object, (String)string3, null, (int)2, null);
                } else {
                    string2 = null;
                }
                it = (GQLDocument)b;
                Comparable comparable = (Comparable)((Object)string2);
                bl = false;
                Object object2 = it.getSourceLocation();
                if (object2 != null && (object2 = object2.getFilePath()) != null) {
                    String string4 = File.pathSeparator;
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"pathSeparator");
                    string = StringsKt.substringAfterLast$default((String)object2, (String)string4, null, (int)2, null);
                } else {
                    string = null;
                }
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)((Comparable)((Object)string)));
            }
        });
        Iterable $this$flatMap$iv = CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)mainSchemaDocument), (Iterable)otherSchemaDocumentSorted);
        boolean $i$f$flatMap = false;
        Iterable bl2 = $this$flatMap$iv;
        Collection destination$iv$iv4 = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            GQLDocument it4 = (GQLDocument)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it4.getDefinitions();
            CollectionsKt.addAll((Collection)destination$iv$iv4, (Iterable)list$iv$iv);
        }
        List schemaDefinitions = (List)destination$iv$iv4;
        StringBuilder $this$buildCodegenSchema_u24lambda_u248 = $i$f$flatMap = new StringBuilder();
        boolean bl = false;
        if (!codegenSchemaOptions.getScalarTypeMapping().isEmpty()) {
            Object element$iv$iv;
            StringBuilder stringBuilder = $this$buildCodegenSchema_u24lambda_u248.append("extend schema @link(url: \"https://specs.apollo.dev/kotlin_compiler_options/v0.0/\")");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.append('\n'), (String)"append(...)");
            Map<String, String> $this$forEach$iv2 = codegenSchemaOptions.getScalarTypeMapping();
            boolean $i$f$forEach2 = false;
            element$iv$iv = $this$forEach$iv2.entrySet().iterator();
            while (element$iv$iv.hasNext()) {
                Object it5 = element$iv = (Map.Entry)element$iv$iv.next();
                boolean bl4 = false;
                $this$buildCodegenSchema_u24lambda_u248.append("extend scalar " + (String)it5.getKey() + " @kotlin_compiler_options__map(to: \"" + (String)it5.getValue() + '\"');
                String adapterInitializer = codegenSchemaOptions.getScalarAdapterMapping().get(it5.getKey());
                if (adapterInitializer != null) {
                    $this$buildCodegenSchema_u24lambda_u248.append(", with: \"" + adapterInitializer + '\"');
                }
                $this$buildCodegenSchema_u24lambda_u248.append(")\n");
            }
        }
        String string = $i$f$flatMap.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String sdl = string;
        List scalarExtensions = ApolloParser.toGQLDocument$default((String)sdl, null, (int)1, null).getDefinitions();
        GQLDocument schemaDocument = new GQLDocument(CollectionsKt.plus((Collection)schemaDefinitions, (Iterable)scalarExtensions), null);
        GQLResult result = ApolloParser.validateAsSchema((GQLDocument)schemaDocument, (SchemaValidationOptions)new SchemaValidationOptions(true, CollectionsKt.plus((Collection)GqldocumentKt.builtinForeignSchemas(), (Iterable)foreignSchemas)));
        IssueGroup issueGroup = ApolloCompilerKt.group(result.getIssues(), true, true);
        IssueKt.checkEmpty(issueGroup.getErrors());
        Iterable $this$forEach$iv3 = issueGroup.getWarnings();
        boolean $i$f$forEach3 = false;
        for (Object element$iv3 : $this$forEach$iv3) {
            Issue it6 = (Issue)element$iv3;
            boolean bl5 = false;
            Logger logger2 = logger;
            if (logger2 == null) {
                logger2 = OptionsKt.getDefaultLogger();
            }
            logger2.warning("w: " + SourceLocationKt.pretty((SourceLocation)it6.getSourceLocation()) + ": Apollo: " + it6.getMessage());
        }
        Object object3 = result.getValue();
        Intrinsics.checkNotNull((Object)object3);
        Schema schema = (Schema)object3;
        String string2 = (String)mainSchemaNormalizedPath;
        if (string2 == null) {
            string2 = "";
        }
        Boolean bl6 = codegenSchemaOptions.getGenerateDataBuilders();
        return new CodegenSchema(schema, string2, bl6 != null ? bl6 : false);
    }

    private final List<GQLDefinition> definitions(File $this$definitions) {
        List definitions = new ArrayList();
        List parseIssues = new ArrayList();
        GQLResult parseResult = ApolloParser.parseAsGQLDocument((File)$this$definitions, (ParserOptions)new ParserOptions.Builder().build());
        if (!((Collection)parseResult.getIssues()).isEmpty()) {
            parseIssues.addAll(parseResult.getIssues());
        } else {
            Object object = parseResult.getValue();
            Intrinsics.checkNotNull((Object)object);
            definitions.addAll(((GQLDocument)object).getDefinitions());
        }
        IssueKt.checkEmpty((List)parseIssues);
        return definitions;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final IrOperations buildIrOperations(@NotNull CodegenSchema codegenSchema, @NotNull List<InputFile> executableFiles, @NotNull List<String> upstreamCodegenModels, @NotNull List<GQLFragmentDefinition> upstreamFragmentDefinitions, @NotNull IrOptions options, @Nullable ExecutableDocumentTransform documentTransform, @Nullable Logger logger) {
        GQLFragmentDefinition gQLFragmentDefinition;
        void $this$associateByTo$iv$iv;
        void $this$filterIsInstanceTo$iv$iv;
        Set<String> alwaysGenerateTypesMatching;
        void $this$forEach$iv;
        Intrinsics.checkNotNullParameter((Object)codegenSchema, (String)"codegenSchema");
        Intrinsics.checkNotNullParameter(executableFiles, (String)"executableFiles");
        Intrinsics.checkNotNullParameter(upstreamCodegenModels, (String)"upstreamCodegenModels");
        Intrinsics.checkNotNullParameter(upstreamFragmentDefinitions, (String)"upstreamFragmentDefinitions");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Schema schema = codegenSchema.getSchema();
        Map operationNameToNormalizedPath = new LinkedHashMap();
        Map fragmentNameToNormalizedPath = new LinkedHashMap();
        List definitions = new ArrayList();
        Iterable $this$sortedBy$iv = executableFiles;
        boolean $i$f$sortedBy = false;
        $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                InputFile it = (InputFile)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getNormalizedPath());
                it = (InputFile)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getNormalizedPath())));
            }
        });
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            InputFile normalizedFile = (InputFile)element$iv;
            boolean bl = false;
            List<GQLDefinition> fileDefinitions = INSTANCE.definitions(normalizedFile.getFile());
            definitions.addAll((Collection)fileDefinitions);
            Iterable $this$forEach$iv2 = fileDefinitions;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                GQLDefinition it = (GQLDefinition)element$iv2;
                boolean bl2 = false;
                GQLDefinition gQLDefinition = it;
                if (gQLDefinition instanceof GQLOperationDefinition) {
                    Map map = operationNameToNormalizedPath;
                    String string = ((GQLOperationDefinition)it).getName();
                    if (string == null) {
                        string = "";
                    }
                    String string2 = string;
                    String string3 = normalizedFile.getNormalizedPath();
                    map.put(string2, string3);
                    continue;
                }
                if (!(gQLDefinition instanceof GQLFragmentDefinition)) continue;
                fragmentNameToNormalizedPath.put(((GQLFragmentDefinition)it).getName(), normalizedFile.getNormalizedPath());
            }
        }
        ExecutableValidationResult validationResult = ApolloParser.validateAsExecutable((GQLDocument)new GQLDocument(CollectionsKt.plus((Collection)definitions, (Iterable)upstreamFragmentDefinitions), null), (Schema)schema);
        List allIssues = new ArrayList();
        allIssues.addAll(validationResult.getIssues());
        String codegenModels = OptionsKt.defaultCodegenModels(options.getCodegenModels(), upstreamCodegenModels);
        if (Intrinsics.areEqual((Object)codegenModels, (Object)"responseBased") || Intrinsics.areEqual((Object)codegenModels, (Object)"experimental_operationBasedWithInterfaces")) {
            allIssues.addAll((Collection)CheckConditionalFragmentKt.checkConditionalFragments(definitions));
        }
        allIssues.addAll((Collection)-checkApolloReservedEnumValueNames.checkApolloReservedEnumValueNames(schema));
        allIssues.addAll((Collection)-checkApolloDuplicateTargetNames.checkApolloTargetNameClashes(schema));
        allIssues.addAll((Collection)-checkApolloInlineFragmentsHaveTypeCondition.checkApolloInlineFragmentsHaveTypeCondition(definitions));
        Boolean bl = options.getFlattenModels();
        boolean flattenModels = bl != null ? bl : OptionsKt.flattenModels(codegenModels);
        Boolean bl3 = options.getDecapitalizeFields();
        boolean decapitalizeFields = bl3 != null ? bl3 : false;
        Boolean bl4 = options.getWarnOnDeprecatedUsages();
        boolean warnOnDeprecatedUsages = bl4 != null ? bl4 : true;
        Boolean bl5 = options.getFailOnWarnings();
        boolean failOnWarnings = bl5 != null ? bl5 : false;
        Boolean bl6 = options.getFieldsOnDisjointTypesMustMerge();
        boolean fieldsOnDisjointTypesMustMerge = bl6 != null ? bl6 : true;
        Boolean bl7 = options.getGenerateOptionalOperationVariables();
        boolean generateOptionalOperationVariables = bl7 != null ? bl7 : true;
        Set<String> set = options.getAlwaysGenerateTypesMatching();
        if (set == null) {
            set = alwaysGenerateTypesMatching = OptionsKt.getDefaultAlwaysGenerateTypesMatching();
        }
        if (!decapitalizeFields) {
            allIssues.addAll((Collection)-checkCapitalizedFields.checkCapitalizedFields(definitions, flattenModels));
        }
        IssueGroup issueGroup = ApolloCompilerKt.group(allIssues, warnOnDeprecatedUsages, fieldsOnDisjointTypesMustMerge);
        IssueKt.checkEmpty(issueGroup.getErrors());
        Iterable $this$forEach$iv3 = issueGroup.getWarnings();
        boolean $i$f$forEach3 = false;
        for (Object element$iv : $this$forEach$iv3) {
            Issue it = (Issue)element$iv;
            boolean bl8 = false;
            Logger logger2 = logger;
            if (logger2 == null) {
                logger2 = OptionsKt.getDefaultLogger();
            }
            logger2.warning("w: " + SourceLocationKt.pretty((SourceLocation)it.getSourceLocation()) + ": Apollo: " + it.getMessage());
        }
        if (failOnWarnings && !((Collection)issueGroup.getWarnings()).isEmpty()) {
            throw new IllegalStateException("Apollo: Warnings found and 'failOnWarnings' is true, aborting.");
        }
        try {
            Class.forName("com.apollographql.cache.apollocompilerplugin.ApolloCacheCompilerPlugin");
            $i$f$forEach3 = true;
        }
        catch (ClassNotFoundException _) {
            $i$f$forEach3 = false;
        }
        boolean hasCacheCompilerPlugin = $i$f$forEach3;
        String string = options.getAddTypename();
        if (string == null) {
            string = "ifFragments";
        }
        GQLDocument document = new ApolloExecutableDocumentTransform(string, !hasCacheCompilerPlugin).transform(schema, new GQLDocument(definitions, null), upstreamFragmentDefinitions);
        if (documentTransform != null) {
            document = documentTransform.transform(schema, document, upstreamFragmentDefinitions);
        }
        Iterable $this$filterIsInstance$iv = document.getDefinitions();
        boolean $i$f$filterIsInstance = false;
        Iterable bl8 = $this$filterIsInstance$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof GQLFragmentDefinition)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$associateBy$iv = CollectionsKt.plus((Collection)((List)destination$iv$iv), (Iterable)upstreamFragmentDefinitions);
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associateBy$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            gQLFragmentDefinition = (GQLFragmentDefinition)element$iv$iv;
            Map map = destination$iv$iv2;
            boolean bl9 = false;
            map.put(it.getName(), element$iv$iv);
        }
        Map allFragmentDefinitions = destination$iv$iv2;
        if (schema.hasTypeWithTypePolicy()) {
            Iterable $this$forEach$iv4 = document.getDefinitions();
            boolean $i$f$forEach4 = false;
            for (Object element$iv : $this$forEach$iv4) {
                Object element$iv$iv;
                GQLDefinition it = (GQLDefinition)element$iv;
                boolean bl10 = false;
                element$iv$iv = it;
                if (element$iv$iv instanceof GQLOperationDefinition) {
                    CheckKeyFieldsKt.checkKeyFields((GQLOperationDefinition)it, schema, (Map<String, GQLFragmentDefinition>)allFragmentDefinitions);
                    continue;
                }
                if (!(element$iv$iv instanceof GQLFragmentDefinition)) continue;
                CheckKeyFieldsKt.checkKeyFields((GQLFragmentDefinition)it, schema, (Map<String, GQLFragmentDefinition>)allFragmentDefinitions);
            }
        }
        List operations = new ArrayList();
        List fragments = new ArrayList();
        Iterable $this$forEach$iv5 = document.getDefinitions();
        boolean $i$f$forEach5 = false;
        for (Object element$iv : $this$forEach$iv5) {
            GQLDefinition it = (GQLDefinition)element$iv;
            boolean bl11 = false;
            gQLFragmentDefinition = it;
            if (gQLFragmentDefinition instanceof GQLOperationDefinition) {
                operations.add(it);
                continue;
            }
            if (!(gQLFragmentDefinition instanceof GQLFragmentDefinition)) continue;
            fragments.add(it);
        }
        return new IrOperationsBuilder(schema, operations, operationNameToNormalizedPath, fragments, fragmentNameToNormalizedPath, allFragmentDefinitions, codegenModels, generateOptionalOperationVariables, flattenModels, decapitalizeFields, alwaysGenerateTypesMatching, codegenSchema.getGenerateDataBuilders(), validationResult.getFragmentVariableUsages()).build();
    }

    @NotNull
    public final SourceOutput buildSchemaSources(@NotNull CodegenSchema codegenSchema, @NotNull UsedCoordinates usedCoordinates, @NotNull CodegenOptions codegenOptions, @Nullable SchemaLayout schemaLayout, @Nullable Transform<JavaOutput> javaOutputTransform2, @Nullable Transform<KotlinOutput> kotlinOutputTransform2) {
        Intrinsics.checkNotNullParameter((Object)codegenSchema, (String)"codegenSchema");
        Intrinsics.checkNotNullParameter((Object)usedCoordinates, (String)"usedCoordinates");
        Intrinsics.checkNotNullParameter((Object)codegenOptions, (String)"codegenOptions");
        IrSchema irSchema = IrSchemaBuilder.INSTANCE.build(codegenSchema.getSchema(), usedCoordinates);
        TargetLanguage targetLanguage = OptionsKt.defaultTargetLanguage(codegenOptions.getTargetLanguage(), CollectionsKt.emptyList());
        OptionsKt.validate(codegenOptions);
        SchemaLayout schemaLayout2 = schemaLayout;
        if (schemaLayout2 == null) {
            schemaLayout2 = LayoutImplKt.SchemaAndOperationsLayout(codegenSchema, codegenOptions.getPackageName(), codegenOptions.getRootPackageName(), codegenOptions.getUseSemanticNaming(), codegenOptions.getDecapitalizeFields(), codegenOptions.getGeneratedSchemaName());
        }
        SchemaLayout layout = schemaLayout2;
        return targetLanguage == TargetLanguage.JAVA ? JavaOutputKt.toSourceOutput(JavaCodegen.INSTANCE.buildSchemaSources(codegenSchema, irSchema, codegenOptions, layout, javaOutputTransform2)) : KotlinOutputKt.toSourceOutput(KotlinCodegen.INSTANCE.buildSchemaSources(codegenSchema, targetLanguage, irSchema, codegenOptions, layout, kotlinOutputTransform2));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final SourceOutput buildSchemaAndOperationsSourcesFromIr(@NotNull CodegenSchema codegenSchema, @NotNull IrOperations irOperations, @NotNull UsedCoordinates downstreamUsedCoordinates, @NotNull List<CodegenMetadata> upstreamCodegenMetadata, @NotNull CodegenOptions codegenOptions, @Nullable SchemaAndOperationsLayout layout, @Nullable OperationOutputGenerator operationOutputGenerator, @Nullable Transform<IrOperations> irOperationsTransform2, @Nullable Transform<JavaOutput> javaOutputTransform2, @Nullable Transform<KotlinOutput> kotlinOutputTransform2, @Nullable File operationManifestFile) {
        SchemaAndOperationsLayout schemaAndOperationsLayout;
        Map<String, OperationDescriptor> operationOutput;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)codegenSchema, (String)"codegenSchema");
        Intrinsics.checkNotNullParameter((Object)irOperations, (String)"irOperations");
        Intrinsics.checkNotNullParameter((Object)downstreamUsedCoordinates, (String)"downstreamUsedCoordinates");
        Intrinsics.checkNotNullParameter(upstreamCodegenMetadata, (String)"upstreamCodegenMetadata");
        Intrinsics.checkNotNullParameter((Object)codegenOptions, (String)"codegenOptions");
        IrOperations irOperations2 = ApolloCompilerKt.maybeTransform(irOperations, irOperationsTransform2);
        TargetLanguage targetLanguage = OptionsKt.defaultTargetLanguage(codegenOptions.getTargetLanguage(), upstreamCodegenMetadata);
        OptionsKt.validate(codegenOptions);
        Iterable $this$map$iv = irOperations2.getOperations();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IrOperation irOperation = (IrOperation)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = it.getName();
            String string2 = QueryDocumentMinifier.minify((String)it.getSourceWithFragments());
            String string3 = it.getOperationType().getName().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
            collection.add(new OperationDescriptor(string, string2, string3));
        }
        List it = (List)destination$iv$iv;
        boolean bl = false;
        OperationOutputGenerator operationOutputGenerator2 = operationOutputGenerator;
        if (operationOutputGenerator2 == null) {
            operationOutputGenerator2 = OptionsKt.getDefaultOperationOutputGenerator();
        }
        if (!((operationOutput = operationOutputGenerator2.generate(it)).size() == irOperations2.getOperations().size())) {
            boolean $i$a$-check-ApolloCompiler$buildSchemaAndOperationsSourcesFromIr$32 = false;
            String $i$a$-check-ApolloCompiler$buildSchemaAndOperationsSourcesFromIr$32 = StringsKt.trimMargin$default((String)("The number of operation IDs (" + operationOutput.size() + ") should match the number of operations (" + irOperations2.getOperations().size() + ").\n        |Check that all your IDs are unique.\n      "), null, (int)1, null);
            throw new IllegalStateException($i$a$-check-ApolloCompiler$buildSchemaAndOperationsSourcesFromIr$32.toString());
        }
        String operationManifestFormat = codegenOptions.getOperationManifestFormat();
        String string = operationManifestFormat;
        if (string == null) {
            string = OptionsKt.getDefaultOperationManifestFormat();
        }
        if (!Intrinsics.areEqual((Object)string, (Object)"none")) {
            if (!(operationManifestFile != null)) {
                boolean $i$a$-check-ApolloCompiler$buildSchemaAndOperationsSourcesFromIr$42 = false;
                String $i$a$-check-ApolloCompiler$buildSchemaAndOperationsSourcesFromIr$42 = "Apollo: no operationManifestFile set to output '" + operationManifestFormat + "' operation manifest";
                throw new IllegalStateException($i$a$-check-ApolloCompiler$buildSchemaAndOperationsSourcesFromIr$42.toString());
            }
            String $i$a$-check-ApolloCompiler$buildSchemaAndOperationsSourcesFromIr$32 = operationManifestFormat;
            if (Intrinsics.areEqual((Object)$i$a$-check-ApolloCompiler$buildSchemaAndOperationsSourcesFromIr$32, (Object)"operationOutput")) {
                FileUtils.writeOperationOutput(operationOutput, operationManifestFile);
            } else if (Intrinsics.areEqual((Object)$i$a$-check-ApolloCompiler$buildSchemaAndOperationsSourcesFromIr$32, (Object)"persistedQueryManifest")) {
                FileUtils.writePersistedQueryManifest(PersistedQueryManifestKt.toPersistedQueryManifest(operationOutput), operationManifestFile);
            }
        }
        if ((schemaAndOperationsLayout = layout) == null) {
            schemaAndOperationsLayout = LayoutImplKt.SchemaAndOperationsLayout(codegenSchema, codegenOptions.getPackageName(), codegenOptions.getRootPackageName(), codegenOptions.getUseSemanticNaming(), codegenOptions.getDecapitalizeFields(), codegenOptions.getGeneratedSchemaName());
        }
        SchemaAndOperationsLayout layout2 = schemaAndOperationsLayout;
        SourceOutput sourceOutput = null;
        if (upstreamCodegenMetadata.isEmpty()) {
            sourceOutput = SourceOutputKt.plus(sourceOutput, this.buildSchemaSources(codegenSchema, downstreamUsedCoordinates.mergeWith(irOperations2.getUsedCoordinates()), codegenOptions, layout2, javaOutputTransform2, kotlinOutputTransform2));
        }
        if (targetLanguage == TargetLanguage.JAVA) {
            SourceOutput sourceOutput2 = sourceOutput;
            sourceOutput = SourceOutputKt.plus(sourceOutput, JavaOutputKt.toSourceOutput(JavaCodegen.INSTANCE.buildOperationsSources(codegenSchema, irOperations2, operationOutput, CollectionsKt.plus((Collection)upstreamCodegenMetadata, (Iterable)CollectionsKt.listOfNotNull((Object)(sourceOutput2 != null ? sourceOutput2.getCodegenMetadata() : null))), codegenOptions, layout2, javaOutputTransform2)));
        } else {
            SourceOutput sourceOutput3 = sourceOutput;
            sourceOutput = SourceOutputKt.plus(sourceOutput, KotlinOutputKt.toSourceOutput(KotlinCodegen.INSTANCE.buildOperationSources(codegenSchema, targetLanguage, irOperations2, operationOutput, CollectionsKt.plus((Collection)upstreamCodegenMetadata, (Iterable)CollectionsKt.listOfNotNull((Object)(sourceOutput3 != null ? sourceOutput3.getCodegenMetadata() : null))), codegenOptions, layout2, kotlinOutputTransform2)));
        }
        return sourceOutput;
    }

    @NotNull
    public final SourceOutput buildSchemaAndOperationsSources(@NotNull List<InputFile> schemaFiles, @NotNull List<InputFile> executableFiles, @NotNull CodegenSchemaOptions codegenSchemaOptions, @NotNull IrOptions irOptions, @NotNull CodegenOptions codegenOptions, @Nullable LayoutFactory layoutFactory, @Nullable OperationOutputGenerator operationOutputGenerator, @Nullable Transform<IrOperations> irOperationsTransform2, @Nullable Transform<JavaOutput> javaOutputTransform2, @Nullable Transform<KotlinOutput> kotlinOutputTransform2, @Nullable ExecutableDocumentTransform documentTransform, @Nullable Logger logger, @Nullable File operationManifestFile) {
        Intrinsics.checkNotNullParameter(schemaFiles, (String)"schemaFiles");
        Intrinsics.checkNotNullParameter(executableFiles, (String)"executableFiles");
        Intrinsics.checkNotNullParameter((Object)codegenSchemaOptions, (String)"codegenSchemaOptions");
        Intrinsics.checkNotNullParameter((Object)irOptions, (String)"irOptions");
        Intrinsics.checkNotNullParameter((Object)codegenOptions, (String)"codegenOptions");
        CodegenSchema codegenSchema = this.buildCodegenSchema(schemaFiles, logger, codegenSchemaOptions, CollectionsKt.emptyList());
        return this.buildSchemaAndOperationsSources(codegenSchema, executableFiles, irOptions, codegenOptions, layoutFactory, operationOutputGenerator, irOperationsTransform2, javaOutputTransform2, kotlinOutputTransform2, documentTransform, logger, operationManifestFile);
    }

    @NotNull
    public final SourceOutput buildSchemaAndOperationsSources(@NotNull CodegenSchema codegenSchema, @NotNull List<InputFile> executableFiles, @NotNull IrOptions irOptions, @NotNull CodegenOptions codegenOptions, @Nullable LayoutFactory layoutFactory, @Nullable OperationOutputGenerator operationOutputGenerator, @Nullable Transform<IrOperations> irOperationsTransform2, @Nullable Transform<JavaOutput> javaOutputTransform2, @Nullable Transform<KotlinOutput> kotlinOutputTransform2, @Nullable ExecutableDocumentTransform documentTransform, @Nullable Logger logger, @Nullable File operationManifestFile) {
        Intrinsics.checkNotNullParameter((Object)codegenSchema, (String)"codegenSchema");
        Intrinsics.checkNotNullParameter(executableFiles, (String)"executableFiles");
        Intrinsics.checkNotNullParameter((Object)irOptions, (String)"irOptions");
        Intrinsics.checkNotNullParameter((Object)codegenOptions, (String)"codegenOptions");
        List list = CollectionsKt.emptyList();
        Object object = CollectionsKt.emptyList();
        IrOperations irOperations = this.buildIrOperations(codegenSchema, executableFiles, list, (List<GQLFragmentDefinition>)object, irOptions, documentTransform, logger);
        object = new UsedCoordinates();
        List list2 = CollectionsKt.emptyList();
        LayoutFactory layoutFactory2 = layoutFactory;
        SchemaAndOperationsLayout schemaAndOperationsLayout = layoutFactory2 != null ? layoutFactory2.create(codegenSchema) : null;
        SourceOutput sourceOutput = this.buildSchemaAndOperationsSourcesFromIr(codegenSchema, irOperations, (UsedCoordinates)object, list2, codegenOptions, schemaAndOperationsLayout, operationOutputGenerator, irOperationsTransform2, javaOutputTransform2, kotlinOutputTransform2, operationManifestFile);
        return sourceOutput;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0006\u00c0\u0006\u0001"}, d2={"Lcom/apollographql/apollo/compiler/ApolloCompiler$Logger;", "", "warning", "", "message", "", "apollo-compiler"})
    public static interface Logger {
        public void warning(@NotNull String var1);
    }
}

