/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.api.http;

import com.apollographql.apollo.api.ApolloRequest;
import com.apollographql.apollo.api.CustomScalarAdapters;
import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.api.Query;
import com.apollographql.apollo.api.RequestParameters;
import com.apollographql.apollo.api.RequestParametersKt;
import com.apollographql.apollo.api.Subscription;
import com.apollographql.apollo.api.http.CacheUrlOverride;
import com.apollographql.apollo.api.http.DefaultHttpRequestComposerKt;
import com.apollographql.apollo.api.http.HttpBody;
import com.apollographql.apollo.api.http.HttpHeader;
import com.apollographql.apollo.api.http.HttpKt;
import com.apollographql.apollo.api.http.HttpMethod;
import com.apollographql.apollo.api.http.HttpRequest;
import com.apollographql.apollo.api.http.HttpRequestComposer;
import com.apollographql.apollo.api.http.internal.UrlEncodeKt;
import com.apollographql.apollo.api.json.-JsonWriters;
import com.apollographql.apollo.api.json.BufferedSinkJsonWriter;
import com.apollographql.apollo.api.json.JsonWriter;
import com.apollographql.apollo.api.json.MapJsonWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ReplaceWith;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import okio.BufferedSink;
import okio.ByteString;
import okio.HashingSink;
import okio.Okio;
import okio.Sink;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0013\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0006\u0010\bJ \u0010\t\u001a\u00020\n\"\b\b\u0000\u0010\u000b*\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u000eH\u0016J\f\u0010\u000f\u001a\u00020\u0003*\u00020\u0010H\u0002R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/apollographql/apollo/api/http/DefaultHttpRequestComposer;", "Lcom/apollographql/apollo/api/http/HttpRequestComposer;", "serverUrl", "", "enablePostCaching", "", "<init>", "(Ljava/lang/String;Z)V", "(Ljava/lang/String;)V", "compose", "Lcom/apollographql/apollo/api/http/HttpRequest;", "D", "Lcom/apollographql/apollo/api/Operation$Data;", "apolloRequest", "Lcom/apollographql/apollo/api/ApolloRequest;", "sha256", "", "Companion", "apollo-api"})
public final class DefaultHttpRequestComposer
implements HttpRequestComposer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final String serverUrl;
    private final boolean enablePostCaching;
    @NotNull
    private static final String HEADER_APOLLO_REQUIRE_PREFLIGHT = "Apollo-Require-Preflight";
    @NotNull
    private static final String HEADER_ACCEPT_NAME = "Accept";
    @NotNull
    private static final String HEADER_ACCEPT_VALUE_DEFER = "multipart/mixed;deferSpec=20220824, application/graphql-response+json, application/json";
    @NotNull
    private static final String HEADER_ACCEPT_VALUE_MULTIPART = "multipart/mixed;subscriptionSpec=1.0, application/graphql-response+json, application/json";

    public DefaultHttpRequestComposer(@Nullable String serverUrl, boolean enablePostCaching) {
        this.serverUrl = serverUrl;
        this.enablePostCaching = enablePostCaching;
    }

    public DefaultHttpRequestComposer(@Nullable String serverUrl) {
        this(serverUrl, false);
    }

    @Override
    @NotNull
    public <D extends Operation.Data> HttpRequest compose(@NotNull ApolloRequest<D> apolloRequest) {
        HttpRequest.Builder builder;
        List list;
        Intrinsics.checkNotNullParameter(apolloRequest, (String)"apolloRequest");
        List $this$compose_u24lambda_u240 = list = (List)new ArrayList();
        boolean bl = false;
        if (apolloRequest.getHttpHeaders() != null) {
            $this$compose_u24lambda_u240.addAll((Collection)apolloRequest.getHttpHeaders());
        }
        if (HttpKt.get($this$compose_u24lambda_u240, "accept") == null) {
            $this$compose_u24lambda_u240.add(new HttpHeader("accept", apolloRequest.getOperation() instanceof Subscription ? "multipart/mixed;subscriptionSpec=1.0, application/graphql-response+json, application/json" : "application/graphql-response+json, application/json"));
        }
        List requestHeaders = list;
        RequestParameters requestParameters = RequestParametersKt.toRequestParameters(apolloRequest);
        String string = apolloRequest.getUrl();
        if (string == null && (string = this.serverUrl) == null) {
            throw new IllegalStateException(("ApolloRequest.url is missing for request '" + apolloRequest.getOperation().name() + "', did you call ApolloClient.Builder.serverUrl(url)?").toString());
        }
        String url = string;
        HttpMethod httpMethod = apolloRequest.getHttpMethod();
        if (httpMethod == null) {
            httpMethod = HttpMethod.Post;
        }
        switch (WhenMappings.$EnumSwitchMapping$0[httpMethod.ordinal()]) {
            case 1: {
                builder = new HttpRequest.Builder(HttpMethod.Get, Companion.appendQueryParameters(url, DefaultHttpRequestComposerKt.access$asGetParameters(RequestParametersKt.toMap(requestParameters)))).addHeader(HEADER_APOLLO_REQUIRE_PREFLIGHT, "true");
                break;
            }
            case 2: {
                HttpRequest.Builder builder2;
                HttpBody body = RequestParametersKt.toHttpBody(requestParameters);
                HttpRequest.Builder $this$compose_u24lambda_u241 = builder2 = new HttpRequest.Builder(HttpMethod.Post, url);
                boolean bl2 = false;
                $this$compose_u24lambda_u241.body(body);
                if (StringsKt.startsWith$default((String)body.getContentType(), (String)"multipart/form-data", (boolean)false, (int)2, null)) {
                    $this$compose_u24lambda_u241.addHeader(HEADER_APOLLO_REQUIRE_PREFLIGHT, "true");
                }
                Operation<D> operation = apolloRequest.getOperation();
                if (this.enablePostCaching && operation instanceof Query) {
                    Map cacheParameters = new LinkedHashMap();
                    if (!requestParameters.getVariables().isEmpty()) {
                        cacheParameters.put("variablesHash", this.sha256(requestParameters.getVariables()));
                    }
                    cacheParameters.put("operationName", ((Query)operation).name());
                    cacheParameters.put("operationId", ((Query)operation).id());
                    $this$compose_u24lambda_u241.addExecutionContext(new CacheUrlOverride(Companion.appendQueryParameters(url, cacheParameters)));
                }
                builder = builder2;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        HttpRequest.Builder httpRequestBuilder = builder;
        return httpRequestBuilder.addHeaders(requestHeaders).addExecutionContext(apolloRequest.getExecutionContext()).build();
    }

    private final String sha256(Object $this$sha256) {
        HashingSink hashingSink = HashingSink.Companion.sha256(Okio.blackhole());
        BufferedSink buffer = Okio.buffer((Sink)((Sink)hashingSink));
        -JsonWriters.writeAny(new BufferedSinkJsonWriter(buffer, null, 2, null), $this$sha256);
        buffer.flush();
        return hashingSink.hash().hex();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0010\u001a\u00020\u0005*\u00020\u00052\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0012H\u0007JB\u0010\u0013\u001a\u00020\u0014\"\b\b\u0000\u0010\u0015*\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00150\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001c2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0005H\u0007JK\u0010\u0013\u001a\u00020\u0014\"\b\b\u0000\u0010\u0015*\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00150\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001e\u001a\u0004\u0018\u00010\u00052\u0017\u0010\u001f\u001a\u0013\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\"0 \u00a2\u0006\u0002\b#H\u0007J8\u0010$\u001a\u00020%\"\b\b\u0000\u0010\u0015*\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00150\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020\u001cH\u0007J@\u0010$\u001a\u00020%\"\b\b\u0000\u0010\u0015*\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00150\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001cH\u0007J.\u0010'\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0012\"\b\b\u0000\u0010\u0015*\u00020\u00162\f\u0010(\u001a\b\u0012\u0004\u0012\u0002H\u00150)H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0006\u001a\u00020\u00058\u0006X\u0087D\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0007\u0010\u0003\u001a\u0004\b\b\u0010\tR\u001c\u0010\n\u001a\u00020\u00058\u0006X\u0087D\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u000b\u0010\u0003\u001a\u0004\b\f\u0010\tR\u001c\u0010\r\u001a\u00020\u00058\u0006X\u0087D\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u000e\u0010\u0003\u001a\u0004\b\u000f\u0010\t\u00a8\u0006*"}, d2={"Lcom/apollographql/apollo/api/http/DefaultHttpRequestComposer$Companion;", "", "<init>", "()V", "HEADER_APOLLO_REQUIRE_PREFLIGHT", "", "HEADER_ACCEPT_NAME", "getHEADER_ACCEPT_NAME$annotations", "getHEADER_ACCEPT_NAME", "()Ljava/lang/String;", "HEADER_ACCEPT_VALUE_DEFER", "getHEADER_ACCEPT_VALUE_DEFER$annotations", "getHEADER_ACCEPT_VALUE_DEFER", "HEADER_ACCEPT_VALUE_MULTIPART", "getHEADER_ACCEPT_VALUE_MULTIPART$annotations", "getHEADER_ACCEPT_VALUE_MULTIPART", "appendQueryParameters", "parameters", "", "buildPostBody", "Lcom/apollographql/apollo/api/http/HttpBody;", "D", "Lcom/apollographql/apollo/api/Operation$Data;", "operation", "Lcom/apollographql/apollo/api/Operation;", "customScalarAdapters", "Lcom/apollographql/apollo/api/CustomScalarAdapters;", "autoPersistQueries", "", "sendEnhancedClientAwarenessExtensions", "query", "extensionsWriter", "Lkotlin/Function1;", "Lcom/apollographql/apollo/api/json/JsonWriter;", "", "Lkotlin/ExtensionFunctionType;", "buildParamsMap", "Lokio/ByteString;", "sendDocument", "composePayload", "apolloRequest", "Lcom/apollographql/apollo/api/ApolloRequest;", "apollo-api"})
    @SourceDebugExtension(value={"SMAP\nDefaultHttpRequestComposer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultHttpRequestComposer.kt\ncom/apollographql/apollo/api/http/DefaultHttpRequestComposer$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 JsonWriters.kt\ncom/apollographql/apollo/api/json/-JsonWriters\n*L\n1#1,350:1\n1869#2,2:351\n93#3,3:353\n*S KotlinDebug\n*F\n+ 1 DefaultHttpRequestComposer.kt\ncom/apollographql/apollo/api/http/DefaultHttpRequestComposer$Companion\n*L\n154#1:351,2\n211#1:353,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getHEADER_ACCEPT_NAME() {
            return HEADER_ACCEPT_NAME;
        }

        @Deprecated(message="This was made public by mistake and will be removed in a future version, please use your own constants instead")
        public static /* synthetic */ void getHEADER_ACCEPT_NAME$annotations() {
        }

        @NotNull
        public final String getHEADER_ACCEPT_VALUE_DEFER() {
            return HEADER_ACCEPT_VALUE_DEFER;
        }

        @Deprecated(message="This was made public by mistake and will be removed in a future version, please use your own constants instead")
        public static /* synthetic */ void getHEADER_ACCEPT_VALUE_DEFER$annotations() {
        }

        @NotNull
        public final String getHEADER_ACCEPT_VALUE_MULTIPART() {
            return HEADER_ACCEPT_VALUE_MULTIPART;
        }

        @Deprecated(message="This was made public by mistake and will be removed in a future version, please use your own constants instead")
        public static /* synthetic */ void getHEADER_ACCEPT_VALUE_MULTIPART$annotations() {
        }

        @Deprecated(message="appendQueryParameters was not supposed to be exposed and will be removed in a future version. Use a dedicated URL parsing library instead.")
        @NotNull
        public final String appendQueryParameters(@NotNull String $this$appendQueryParameters, @NotNull Map<String, String> parameters) {
            StringBuilder stringBuilder;
            Intrinsics.checkNotNullParameter((Object)$this$appendQueryParameters, (String)"<this>");
            Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
            StringBuilder $this$appendQueryParameters_u24lambda_u240 = stringBuilder = new StringBuilder();
            boolean bl = false;
            $this$appendQueryParameters_u24lambda_u240.append($this$appendQueryParameters);
            boolean hasQuestionMark = false;
            hasQuestionMark = StringsKt.contains$default((CharSequence)$this$appendQueryParameters, (CharSequence)"?", (boolean)false, (int)2, null);
            Iterable $this$forEach$iv = parameters.entrySet();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                StringBuilder stringBuilder2;
                Map.Entry it = (Map.Entry)element$iv;
                boolean bl2 = false;
                if (hasQuestionMark) {
                    stringBuilder2 = $this$appendQueryParameters_u24lambda_u240.append('&');
                } else {
                    hasQuestionMark = true;
                    stringBuilder2 = $this$appendQueryParameters_u24lambda_u240.append('?');
                }
                $this$appendQueryParameters_u24lambda_u240.append(UrlEncodeKt.urlEncode((String)it.getKey()));
                $this$appendQueryParameters_u24lambda_u240.append('=');
                $this$appendQueryParameters_u24lambda_u240.append(UrlEncodeKt.urlEncode((String)it.getValue()));
            }
            return stringBuilder.toString();
        }

        @Deprecated(message="Use buildPostBody(operation, customScalarAdapters, query, extensionsWriter) instead", level=DeprecationLevel.ERROR)
        @NotNull
        public final <D extends Operation.Data> HttpBody buildPostBody(@NotNull Operation<D> operation, @NotNull CustomScalarAdapters customScalarAdapters, boolean autoPersistQueries, boolean sendEnhancedClientAwarenessExtensions, @Nullable String query) {
            Intrinsics.checkNotNullParameter(operation, (String)"operation");
            Intrinsics.checkNotNullParameter((Object)customScalarAdapters, (String)"customScalarAdapters");
            if (query != null && !Intrinsics.areEqual((Object)query, (Object)operation.document())) {
                boolean bl = false;
                String string = "The query parameter must match the operation document";
                throw new IllegalArgumentException(string.toString());
            }
            return RequestParametersKt.toHttpBody(RequestParametersKt.toRequestParameters(((ApolloRequest.Builder)((ApolloRequest.Builder)((ApolloRequest.Builder)new ApolloRequest.Builder<D>(operation).addExecutionContext(customScalarAdapters)).sendDocument(query != null)).sendApqExtensions(autoPersistQueries)).sendEnhancedClientAwareness(sendEnhancedClientAwarenessExtensions).build()));
        }

        /*
         * WARNING - void declaration
         */
        @Deprecated(message="Use `toRequestParameters()` instead.", replaceWith=@ReplaceWith(expression="apolloRequest.toRequestParameters().toHttpBody()", imports={}))
        @NotNull
        public final <D extends Operation.Data> HttpBody buildPostBody(@NotNull Operation<D> operation, @NotNull CustomScalarAdapters customScalarAdapters, @Nullable String query, @NotNull Function1<? super JsonWriter, Unit> extensionsWriter) {
            void $this$buildPostBody_u24lambda_u242;
            Intrinsics.checkNotNullParameter(operation, (String)"operation");
            Intrinsics.checkNotNullParameter((Object)customScalarAdapters, (String)"customScalarAdapters");
            Intrinsics.checkNotNullParameter(extensionsWriter, (String)"extensionsWriter");
            if (query != null && !Intrinsics.areEqual((Object)query, (Object)operation.document())) {
                boolean $i$a$-require-DefaultHttpRequestComposer$Companion$buildPostBody$32 = false;
                String $i$a$-require-DefaultHttpRequestComposer$Companion$buildPostBody$32 = "The query parameter must match the operation document";
                throw new IllegalArgumentException($i$a$-require-DefaultHttpRequestComposer$Companion$buildPostBody$32.toString());
            }
            boolean $i$f$buildJsonMap = false;
            MapJsonWriter writer$iv = new MapJsonWriter();
            JsonWriter jsonWriter = writer$iv;
            Object object = ((ApolloRequest.Builder)new ApolloRequest.Builder<D>(operation).addExecutionContext(customScalarAdapters)).sendDocument(query != null);
            boolean bl = false;
            extensionsWriter.invoke((Object)$this$buildPostBody_u24lambda_u242);
            Object object2 = writer$iv.root();
            Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
            return RequestParametersKt.toHttpBody(RequestParametersKt.toRequestParameters(((ApolloRequest.Builder)object).extensions((Map)object2).build()));
        }

        @Deprecated(message="Use `toRequestParameters()` instead.", replaceWith=@ReplaceWith(expression="apolloRequest.toRequestParameters().toByteString()", imports={}))
        @NotNull
        public final <D extends Operation.Data> ByteString buildParamsMap(@NotNull Operation<D> operation, @NotNull CustomScalarAdapters customScalarAdapters, boolean autoPersistQueries, boolean sendDocument) {
            Intrinsics.checkNotNullParameter(operation, (String)"operation");
            Intrinsics.checkNotNullParameter((Object)customScalarAdapters, (String)"customScalarAdapters");
            return this.buildParamsMap(operation, customScalarAdapters, autoPersistQueries, sendDocument, false);
        }

        @Deprecated(message="Use `toRequestParameters()` instead.", replaceWith=@ReplaceWith(expression="apolloRequest.toRequestParameters().toByteString()", imports={}))
        @NotNull
        public final <D extends Operation.Data> ByteString buildParamsMap(@NotNull Operation<D> operation, @NotNull CustomScalarAdapters customScalarAdapters, boolean autoPersistQueries, boolean sendDocument, boolean sendEnhancedClientAwarenessExtensions) {
            Intrinsics.checkNotNullParameter(operation, (String)"operation");
            Intrinsics.checkNotNullParameter((Object)customScalarAdapters, (String)"customScalarAdapters");
            return RequestParametersKt.toByteString(RequestParametersKt.toRequestParameters(((ApolloRequest.Builder)((ApolloRequest.Builder)((ApolloRequest.Builder)new ApolloRequest.Builder<D>(operation).addExecutionContext(customScalarAdapters)).sendApqExtensions(autoPersistQueries)).sendDocument(sendDocument)).sendEnhancedClientAwareness(sendEnhancedClientAwarenessExtensions).build()));
        }

        @Deprecated(message="Use `toRequestParameters()` instead.", replaceWith=@ReplaceWith(expression="apolloRequest.toRequestParameters().toMap()", imports={}))
        @NotNull
        public final <D extends Operation.Data> Map<String, Object> composePayload(@NotNull ApolloRequest<D> apolloRequest) {
            Intrinsics.checkNotNullParameter(apolloRequest, (String)"apolloRequest");
            return RequestParametersKt.toMap(RequestParametersKt.toRequestParameters(apolloRequest));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[HttpMethod.values().length];
            try {
                nArray[HttpMethod.Get.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HttpMethod.Post.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

