/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.api.http;

import com.apollographql.apollo.api.ApolloRequest;
import com.apollographql.apollo.api.CustomScalarAdapters;
import com.apollographql.apollo.api.Executable;
import com.apollographql.apollo.api.Executables;
import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.api.Query;
import com.apollographql.apollo.api.Subscription;
import com.apollographql.apollo.api.Upload;
import com.apollographql.apollo.api.http.CacheUrlOverride;
import com.apollographql.apollo.api.http.HttpBody;
import com.apollographql.apollo.api.http.HttpHeader;
import com.apollographql.apollo.api.http.HttpKt;
import com.apollographql.apollo.api.http.HttpMethod;
import com.apollographql.apollo.api.http.HttpRequest;
import com.apollographql.apollo.api.http.HttpRequestComposer;
import com.apollographql.apollo.api.http.UploadsHttpBody;
import com.apollographql.apollo.api.http.internal.UrlEncodeKt;
import com.apollographql.apollo.api.json.-JsonWriters;
import com.apollographql.apollo.api.json.BufferedSinkJsonWriter;
import com.apollographql.apollo.api.json.JsonWriter;
import com.apollographql.apollo.api.json.MapJsonWriter;
import com.apollographql.apollo.api.json.internal.FileUploadAwareJsonWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ReplaceWith;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import okio.Buffer;
import okio.BufferedSink;
import okio.ByteString;
import okio.HashingSink;
import okio.Okio;
import okio.Sink;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0013\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0006\u0010\bJ \u0010\t\u001a\u00020\n\"\b\b\u0000\u0010\u000b*\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u000eH\u0016J\f\u0010\u000f\u001a\u00020\u0003*\u00020\u0010H\u0002R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/apollographql/apollo/api/http/DefaultHttpRequestComposer;", "Lcom/apollographql/apollo/api/http/HttpRequestComposer;", "serverUrl", "", "enablePostCaching", "", "<init>", "(Ljava/lang/String;Z)V", "(Ljava/lang/String;)V", "compose", "Lcom/apollographql/apollo/api/http/HttpRequest;", "D", "Lcom/apollographql/apollo/api/Operation$Data;", "apolloRequest", "Lcom/apollographql/apollo/api/ApolloRequest;", "sha256", "", "Companion", "apollo-api"})
public final class DefaultHttpRequestComposer
implements HttpRequestComposer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final String serverUrl;
    private final boolean enablePostCaching;
    @NotNull
    private static final String HEADER_APOLLO_REQUIRE_PREFLIGHT = "Apollo-Require-Preflight";
    @NotNull
    private static final String HEADER_ACCEPT_NAME = "Accept";
    @NotNull
    private static final String HEADER_ACCEPT_VALUE_DEFER = "multipart/mixed;deferSpec=20220824, application/graphql-response+json, application/json";
    @NotNull
    private static final String HEADER_ACCEPT_VALUE_MULTIPART = "multipart/mixed;subscriptionSpec=1.0, application/graphql-response+json, application/json";

    public DefaultHttpRequestComposer(@Nullable String serverUrl, boolean enablePostCaching) {
        this.serverUrl = serverUrl;
        this.enablePostCaching = enablePostCaching;
    }

    public DefaultHttpRequestComposer(@Nullable String serverUrl) {
        this(serverUrl, false);
    }

    @Override
    @NotNull
    public <D extends Operation.Data> HttpRequest compose(@NotNull ApolloRequest<D> apolloRequest) {
        HttpRequest.Builder builder;
        List list;
        Intrinsics.checkNotNullParameter(apolloRequest, (String)"apolloRequest");
        Operation<D> operation = apolloRequest.getOperation();
        CustomScalarAdapters customScalarAdapters = (CustomScalarAdapters)apolloRequest.getExecutionContext().get(CustomScalarAdapters.Key);
        if (customScalarAdapters == null) {
            customScalarAdapters = CustomScalarAdapters.Empty;
        }
        CustomScalarAdapters customScalarAdapters2 = customScalarAdapters;
        List $this$compose_u24lambda_u240 = list = (List)new ArrayList();
        boolean bl = false;
        if (apolloRequest.getHttpHeaders() != null) {
            $this$compose_u24lambda_u240.addAll((Collection)apolloRequest.getHttpHeaders());
        }
        if (HttpKt.get($this$compose_u24lambda_u240, "accept") == null) {
            $this$compose_u24lambda_u240.add(new HttpHeader("accept", apolloRequest.getOperation() instanceof Subscription ? "multipart/mixed;subscriptionSpec=1.0, application/graphql-response+json, application/json" : "application/graphql-response+json, application/json"));
        }
        List requestHeaders = list;
        Boolean bl2 = apolloRequest.getSendApqExtensions();
        boolean sendApqExtensions = bl2 != null ? bl2 : false;
        boolean sendEnhancedClientAwarenessExtensions = apolloRequest.getSendEnhancedClientAwareness();
        Boolean bl3 = apolloRequest.getSendDocument();
        boolean sendDocument = bl3 != null ? bl3 : true;
        String string = apolloRequest.getUrl();
        if (string == null && (string = this.serverUrl) == null) {
            throw new IllegalStateException(("ApolloRequest.url is missing for request '" + apolloRequest.getOperation().name() + "', did you call ApolloClient.Builder.serverUrl(url)?").toString());
        }
        String url = string;
        HttpMethod httpMethod = apolloRequest.getHttpMethod();
        if (httpMethod == null) {
            httpMethod = HttpMethod.Post;
        }
        switch (WhenMappings.$EnumSwitchMapping$0[httpMethod.ordinal()]) {
            case 1: {
                builder = new HttpRequest.Builder(HttpMethod.Get, DefaultHttpRequestComposer.Companion.buildGetUrl(url, operation, customScalarAdapters2, sendApqExtensions, sendDocument, sendEnhancedClientAwarenessExtensions)).addHeader(HEADER_APOLLO_REQUIRE_PREFLIGHT, "true");
                break;
            }
            case 2: {
                HttpRequest.Builder builder2;
                String query = sendDocument ? operation.document() : null;
                HttpBody body = Companion.buildPostBody(operation, customScalarAdapters2, query, (Function1<? super JsonWriter, Unit>)DefaultHttpRequestComposer.Companion.extensionsWriter(operation.id(), sendApqExtensions, sendEnhancedClientAwarenessExtensions));
                HttpRequest.Builder $this$compose_u24lambda_u241 = builder2 = new HttpRequest.Builder(HttpMethod.Post, url);
                boolean bl4 = false;
                $this$compose_u24lambda_u241.body(body);
                if (StringsKt.startsWith$default((String)body.getContentType(), (String)"multipart/form-data", (boolean)false, (int)2, null)) {
                    $this$compose_u24lambda_u241.addHeader(HEADER_APOLLO_REQUIRE_PREFLIGHT, "true");
                }
                if (this.enablePostCaching && operation instanceof Query) {
                    Map cacheParameters = new LinkedHashMap();
                    Executable.Variables variables = Executables.variables(operation, customScalarAdapters2);
                    if (!variables.getValueMap().isEmpty()) {
                        cacheParameters.put("variablesHash", this.sha256(variables.getValueMap()));
                    }
                    cacheParameters.put("operationName", ((Query)operation).name());
                    cacheParameters.put("operationId", ((Query)operation).id());
                    $this$compose_u24lambda_u241.addExecutionContext(new CacheUrlOverride(Companion.appendQueryParameters(url, cacheParameters)));
                }
                builder = builder2;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        HttpRequest.Builder httpRequestBuilder = builder;
        return httpRequestBuilder.addHeaders(requestHeaders).addExecutionContext(apolloRequest.getExecutionContext()).build();
    }

    private final String sha256(Object $this$sha256) {
        HashingSink hashingSink = HashingSink.Companion.sha256(Okio.blackhole());
        BufferedSink buffer = Okio.buffer((Sink)((Sink)hashingSink));
        -JsonWriters.writeAny(new BufferedSinkJsonWriter(buffer, null, 2, null), $this$sha256);
        buffer.flush();
        return hashingSink.hash().hex();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JH\u0010\u0010\u001a\u00020\u0005\"\b\b\u0000\u0010\u0011*\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00052\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00110\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u0019H\u0002J_\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u001e0\u001d\"\b\b\u0000\u0010\u0011*\u00020\u00122\u0006\u0010\u001f\u001a\u00020 2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00110\u00152\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010!\u001a\u0004\u0018\u00010\u00052\u0017\u0010\"\u001a\u0013\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020$0#\u00a2\u0006\u0002\b%H\u0002JV\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u001e0\u001d\"\b\b\u0000\u0010\u0011*\u00020\u00122\u0006\u0010\u001f\u001a\u00020 2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00110\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u00192\b\u0010!\u001a\u0004\u0018\u00010\u0005H\u0002J1\u0010\"\u001a\u0013\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020$0#\u00a2\u0006\u0002\b%2\u0006\u0010&\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u0019H\u0002JL\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u001d\"\b\b\u0000\u0010\u0011*\u00020\u00122\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00110\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010(\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010)\u001a\u00020\u0019H\u0002J\u001e\u0010*\u001a\u00020\u0005*\u00020\u00052\u0012\u0010+\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u001dJB\u0010,\u001a\u00020-\"\b\b\u0000\u0010\u0011*\u00020\u00122\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00110\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010(\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u00192\b\u0010!\u001a\u0004\u0018\u00010\u0005H\u0007JI\u0010,\u001a\u00020-\"\b\b\u0000\u0010\u0011*\u00020\u00122\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00110\u00152\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010!\u001a\u0004\u0018\u00010\u00052\u0017\u0010\"\u001a\u0013\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020$0#\u00a2\u0006\u0002\b%J8\u0010.\u001a\u00020/\"\b\b\u0000\u0010\u0011*\u00020\u00122\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00110\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010(\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019H\u0007J>\u0010.\u001a\u00020/\"\b\b\u0000\u0010\u0011*\u00020\u00122\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00110\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010(\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u0019J,\u00100\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u001d\"\b\b\u0000\u0010\u0011*\u00020\u00122\f\u00101\u001a\b\u0012\u0004\u0012\u0002H\u001102R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0006\u001a\u00020\u00058\u0006X\u0087D\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0007\u0010\u0003\u001a\u0004\b\b\u0010\tR\u001c\u0010\n\u001a\u00020\u00058\u0006X\u0087D\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u000b\u0010\u0003\u001a\u0004\b\f\u0010\tR\u001c\u0010\r\u001a\u00020\u00058\u0006X\u0087D\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u000e\u0010\u0003\u001a\u0004\b\u000f\u0010\t\u00a8\u00063"}, d2={"Lcom/apollographql/apollo/api/http/DefaultHttpRequestComposer$Companion;", "", "<init>", "()V", "HEADER_APOLLO_REQUIRE_PREFLIGHT", "", "HEADER_ACCEPT_NAME", "getHEADER_ACCEPT_NAME$annotations", "getHEADER_ACCEPT_NAME", "()Ljava/lang/String;", "HEADER_ACCEPT_VALUE_DEFER", "getHEADER_ACCEPT_VALUE_DEFER$annotations", "getHEADER_ACCEPT_VALUE_DEFER", "HEADER_ACCEPT_VALUE_MULTIPART", "getHEADER_ACCEPT_VALUE_MULTIPART$annotations", "getHEADER_ACCEPT_VALUE_MULTIPART", "buildGetUrl", "D", "Lcom/apollographql/apollo/api/Operation$Data;", "url", "operation", "Lcom/apollographql/apollo/api/Operation;", "customScalarAdapters", "Lcom/apollographql/apollo/api/CustomScalarAdapters;", "sendApqExtensions", "", "sendDocument", "sendEnhancedClientAwarenessExtensions", "composePostParams", "", "Lcom/apollographql/apollo/api/Upload;", "writer", "Lcom/apollographql/apollo/api/json/JsonWriter;", "query", "extensionsWriter", "Lkotlin/Function1;", "", "Lkotlin/ExtensionFunctionType;", "apqId", "composeGetParams", "autoPersistQueries", "sendEnhancedClientAwareness", "appendQueryParameters", "parameters", "buildPostBody", "Lcom/apollographql/apollo/api/http/HttpBody;", "buildParamsMap", "Lokio/ByteString;", "composePayload", "apolloRequest", "Lcom/apollographql/apollo/api/ApolloRequest;", "apollo-api"})
    @SourceDebugExtension(value={"SMAP\nDefaultHttpRequestComposer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultHttpRequestComposer.kt\ncom/apollographql/apollo/api/http/DefaultHttpRequestComposer$Companion\n+ 2 JsonWriters.kt\ncom/apollographql/apollo/api/json/-JsonWriters\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,477:1\n49#2,2:478\n49#2,4:480\n51#2,2:484\n66#2,7:486\n49#2,4:493\n73#2:497\n66#2,7:498\n49#2,2:505\n49#2,4:507\n49#2,4:511\n51#2,2:515\n73#2:517\n82#2,3:520\n77#2,8:523\n77#2,8:531\n93#2,3:539\n49#2,2:542\n49#2,4:544\n49#2,4:548\n51#2,2:552\n1869#3,2:518\n*S KotlinDebug\n*F\n+ 1 DefaultHttpRequestComposer.kt\ncom/apollographql/apollo/api/http/DefaultHttpRequestComposer$Companion\n*L\n169#1:478,2\n175#1:480,4\n169#1:484,2\n249#1:486,7\n251#1:493,4\n249#1:497\n265#1:498,7\n266#1:505,2\n269#1:507,4\n276#1:511,4\n266#1:515,2\n265#1:517\n331#1:520,3\n362#1:523,8\n375#1:531,8\n392#1:539,3\n213#1:542,2\n216#1:544,4\n224#1:548,4\n213#1:552,2\n298#1:518,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getHEADER_ACCEPT_NAME() {
            return HEADER_ACCEPT_NAME;
        }

        @Deprecated(message="This was made public by mistake and will be removed in a future version, please use your own constants instead")
        public static /* synthetic */ void getHEADER_ACCEPT_NAME$annotations() {
        }

        @NotNull
        public final String getHEADER_ACCEPT_VALUE_DEFER() {
            return HEADER_ACCEPT_VALUE_DEFER;
        }

        @Deprecated(message="This was made public by mistake and will be removed in a future version, please use your own constants instead")
        public static /* synthetic */ void getHEADER_ACCEPT_VALUE_DEFER$annotations() {
        }

        @NotNull
        public final String getHEADER_ACCEPT_VALUE_MULTIPART() {
            return HEADER_ACCEPT_VALUE_MULTIPART;
        }

        @Deprecated(message="This was made public by mistake and will be removed in a future version, please use your own constants instead")
        public static /* synthetic */ void getHEADER_ACCEPT_VALUE_MULTIPART$annotations() {
        }

        private final <D extends Operation.Data> String buildGetUrl(String url, Operation<D> operation, CustomScalarAdapters customScalarAdapters, boolean sendApqExtensions, boolean sendDocument, boolean sendEnhancedClientAwarenessExtensions) {
            return this.appendQueryParameters(url, this.composeGetParams(operation, customScalarAdapters, sendApqExtensions, sendDocument, sendEnhancedClientAwarenessExtensions));
        }

        private final <D extends Operation.Data> Map<String, Upload> composePostParams(JsonWriter writer, Operation<D> operation, CustomScalarAdapters customScalarAdapters, String query, Function1<? super JsonWriter, Unit> extensionsWriter) {
            Map<String, Upload> uploads = null;
            JsonWriter $this$writeObject$iv = writer;
            boolean $i$f$writeObject = false;
            $this$writeObject$iv.beginObject();
            JsonWriter $this$composePostParams_u24lambda_u240 = $this$writeObject$iv;
            boolean bl = false;
            $this$composePostParams_u24lambda_u240.name("operationName");
            $this$composePostParams_u24lambda_u240.value(operation.name());
            $this$composePostParams_u24lambda_u240.name("variables");
            FileUploadAwareJsonWriter uploadAwareWriter = new FileUploadAwareJsonWriter($this$composePostParams_u24lambda_u240);
            JsonWriter $this$writeObject$iv2 = uploadAwareWriter;
            boolean $i$f$writeObject2 = false;
            $this$writeObject$iv2.beginObject();
            JsonWriter $this$composePostParams_u24lambda_u240_u240 = $this$writeObject$iv2;
            boolean bl2 = false;
            operation.serializeVariables($this$composePostParams_u24lambda_u240_u240, customScalarAdapters, false);
            $this$writeObject$iv2.endObject();
            uploads = uploadAwareWriter.collectedUploads();
            if (query != null) {
                $this$composePostParams_u24lambda_u240.name("query");
                $this$composePostParams_u24lambda_u240.value(query);
            }
            extensionsWriter.invoke((Object)$this$composePostParams_u24lambda_u240);
            $this$writeObject$iv.endObject();
            return uploads;
        }

        private final <D extends Operation.Data> Map<String, Upload> composePostParams(JsonWriter writer, Operation<D> operation, CustomScalarAdapters customScalarAdapters, boolean sendApqExtensions, boolean sendEnhancedClientAwarenessExtensions, String query) {
            return this.composePostParams(writer, operation, customScalarAdapters, query, this.extensionsWriter(operation.id(), sendApqExtensions, sendEnhancedClientAwarenessExtensions));
        }

        private final Function1<JsonWriter, Unit> extensionsWriter(String apqId, boolean sendApqExtensions, boolean sendEnhancedClientAwarenessExtensions) {
            if (!sendApqExtensions && !sendEnhancedClientAwarenessExtensions) {
                return Companion::extensionsWriter$lambda$0;
            }
            return arg_0 -> Companion.extensionsWriter$lambda$1(sendApqExtensions, sendEnhancedClientAwarenessExtensions, apqId, arg_0);
        }

        private final <D extends Operation.Data> Map<String, String> composeGetParams(Operation<D> operation, CustomScalarAdapters customScalarAdapters, boolean autoPersistQueries, boolean sendDocument, boolean sendEnhancedClientAwareness) {
            boolean $i$f$writeObject;
            JsonWriter $this$writeObject$iv;
            Map queryParams = new LinkedHashMap();
            queryParams.put("operationName", operation.name());
            String indent$iv = null;
            boolean $i$f$buildJsonString = false;
            Buffer buffer$iv = new Buffer();
            JsonWriter $this$composeGetParams_u24lambda_u240 = new BufferedSinkJsonWriter((BufferedSink)buffer$iv, indent$iv);
            boolean bl = false;
            FileUploadAwareJsonWriter uploadAwareWriter = new FileUploadAwareJsonWriter($this$composeGetParams_u24lambda_u240);
            JsonWriter $this$writeObject$iv2 = uploadAwareWriter;
            boolean $i$f$writeObject2 = false;
            $this$writeObject$iv2.beginObject();
            JsonWriter $this$composeGetParams_u24lambda_u240_u240 = $this$writeObject$iv2;
            boolean bl2 = false;
            operation.serializeVariables($this$composeGetParams_u24lambda_u240_u240, customScalarAdapters, false);
            $this$writeObject$iv2.endObject();
            if (!uploadAwareWriter.collectedUploads().isEmpty()) {
                boolean $i$a$-check-DefaultHttpRequestComposer$Companion$composeGetParams$variables$1$32 = false;
                String $i$a$-check-DefaultHttpRequestComposer$Companion$composeGetParams$variables$1$32 = "FileUpload and Http GET are not supported at the same time";
                throw new IllegalStateException($i$a$-check-DefaultHttpRequestComposer$Companion$composeGetParams$variables$1$32.toString());
            }
            String variables = buffer$iv.readUtf8();
            queryParams.put("variables", variables);
            if (sendDocument) {
                queryParams.put("query", operation.document());
            }
            String indent$iv2 = null;
            boolean $i$f$buildJsonString2 = false;
            Buffer buffer$iv2 = new Buffer();
            JsonWriter $this$composeGetParams_u24lambda_u241 = new BufferedSinkJsonWriter((BufferedSink)buffer$iv2, indent$iv2);
            boolean bl3 = false;
            $this$writeObject$iv2 = $this$composeGetParams_u24lambda_u241;
            $i$f$writeObject2 = false;
            $this$writeObject$iv2.beginObject();
            JsonWriter $this$composeGetParams_u24lambda_u241_u240 = $this$writeObject$iv2;
            boolean bl4 = false;
            if (autoPersistQueries) {
                $this$composeGetParams_u24lambda_u241_u240.name("persistedQuery");
                $this$writeObject$iv = $this$composeGetParams_u24lambda_u241_u240;
                $i$f$writeObject = false;
                $this$writeObject$iv.beginObject();
                JsonWriter $this$composeGetParams_u24lambda_u241_u240_u240 = $this$writeObject$iv;
                boolean bl5 = false;
                $this$composeGetParams_u24lambda_u241_u240_u240.name("version").value(1);
                $this$composeGetParams_u24lambda_u241_u240_u240.name("sha256Hash").value(operation.id());
                $this$writeObject$iv.endObject();
            }
            if (sendEnhancedClientAwareness) {
                $this$composeGetParams_u24lambda_u241_u240.name("clientLibrary");
                $this$writeObject$iv = $this$composeGetParams_u24lambda_u241_u240;
                $i$f$writeObject = false;
                $this$writeObject$iv.beginObject();
                JsonWriter $this$composeGetParams_u24lambda_u241_u240_u241 = $this$writeObject$iv;
                boolean bl6 = false;
                $this$composeGetParams_u24lambda_u241_u240_u241.name("name").value("apollo-kotlin");
                $this$composeGetParams_u24lambda_u241_u240_u241.name("version").value("5.0.0-alpha.3");
                $this$writeObject$iv.endObject();
            }
            $this$writeObject$iv2.endObject();
            String extensions = buffer$iv2.readUtf8();
            if (!(((CharSequence)extensions).length() == 0)) {
                queryParams.put("extensions", extensions);
            }
            return queryParams;
        }

        @NotNull
        public final String appendQueryParameters(@NotNull String $this$appendQueryParameters, @NotNull Map<String, String> parameters) {
            StringBuilder stringBuilder;
            Intrinsics.checkNotNullParameter((Object)$this$appendQueryParameters, (String)"<this>");
            Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
            StringBuilder $this$appendQueryParameters_u24lambda_u240 = stringBuilder = new StringBuilder();
            boolean bl = false;
            $this$appendQueryParameters_u24lambda_u240.append($this$appendQueryParameters);
            boolean hasQuestionMark = false;
            hasQuestionMark = StringsKt.contains$default((CharSequence)$this$appendQueryParameters, (CharSequence)"?", (boolean)false, (int)2, null);
            Iterable $this$forEach$iv = parameters.entrySet();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                StringBuilder stringBuilder2;
                Map.Entry it = (Map.Entry)element$iv;
                boolean bl2 = false;
                if (hasQuestionMark) {
                    stringBuilder2 = $this$appendQueryParameters_u24lambda_u240.append('&');
                } else {
                    hasQuestionMark = true;
                    stringBuilder2 = $this$appendQueryParameters_u24lambda_u240.append('?');
                }
                $this$appendQueryParameters_u24lambda_u240.append(UrlEncodeKt.urlEncode((String)it.getKey()));
                $this$appendQueryParameters_u24lambda_u240.append('=');
                $this$appendQueryParameters_u24lambda_u240.append(UrlEncodeKt.urlEncode((String)it.getValue()));
            }
            return stringBuilder.toString();
        }

        @Deprecated(message="Use buildPostBody(operation, customScalarAdapters, query, extensionsWriter) instead", level=DeprecationLevel.ERROR)
        @NotNull
        public final <D extends Operation.Data> HttpBody buildPostBody(@NotNull Operation<D> operation, @NotNull CustomScalarAdapters customScalarAdapters, boolean autoPersistQueries, boolean sendEnhancedClientAwarenessExtensions, @Nullable String query) {
            Intrinsics.checkNotNullParameter(operation, (String)"operation");
            Intrinsics.checkNotNullParameter((Object)customScalarAdapters, (String)"customScalarAdapters");
            return this.buildPostBody(operation, customScalarAdapters, query, this.extensionsWriter(operation.id(), autoPersistQueries, sendEnhancedClientAwarenessExtensions));
        }

        @NotNull
        public final <D extends Operation.Data> HttpBody buildPostBody(@NotNull Operation<D> operation, @NotNull CustomScalarAdapters customScalarAdapters, @Nullable String query, @NotNull Function1<? super JsonWriter, Unit> extensionsWriter) {
            Intrinsics.checkNotNullParameter(operation, (String)"operation");
            Intrinsics.checkNotNullParameter((Object)customScalarAdapters, (String)"customScalarAdapters");
            Intrinsics.checkNotNullParameter(extensionsWriter, (String)"extensionsWriter");
            Map uploads = null;
            String indent$iv = null;
            boolean $i$f$buildJsonByteString = false;
            Buffer buffer$iv = new Buffer();
            JsonWriter $this$buildPostBody_u24lambda_u240 = new BufferedSinkJsonWriter((BufferedSink)buffer$iv, indent$iv);
            boolean bl = false;
            uploads = Companion.composePostParams($this$buildPostBody_u24lambda_u240, operation, customScalarAdapters, query, (Function1<? super JsonWriter, Unit>)extensionsWriter);
            ByteString operationByteString = buffer$iv.readByteString();
            return uploads.isEmpty() ? (HttpBody)new HttpBody(operationByteString){
                private final String contentType;
                private final long contentLength;
                final /* synthetic */ ByteString $operationByteString;
                {
                    this.$operationByteString = $operationByteString;
                    this.contentType = "application/json";
                    this.contentLength = $operationByteString.size();
                }

                public String getContentType() {
                    return this.contentType;
                }

                public long getContentLength() {
                    return this.contentLength;
                }

                public void writeTo(BufferedSink bufferedSink) {
                    Intrinsics.checkNotNullParameter((Object)bufferedSink, (String)"bufferedSink");
                    bufferedSink.write(this.$operationByteString);
                }
            } : (HttpBody)new UploadsHttpBody(uploads, operationByteString);
        }

        @Deprecated(message="Use new function with additional parameters instead.", replaceWith=@ReplaceWith(expression="buildParamsMap(operation = operation, customScalarAdapters = customScalarAdapters, autoPersistQueries = autoPersistQueries, sendDocument = sendDocument, sendEnhancedClientAwarenessExtensions = true)", imports={}))
        @NotNull
        public final <D extends Operation.Data> ByteString buildParamsMap(@NotNull Operation<D> operation, @NotNull CustomScalarAdapters customScalarAdapters, boolean autoPersistQueries, boolean sendDocument) {
            Intrinsics.checkNotNullParameter(operation, (String)"operation");
            Intrinsics.checkNotNullParameter((Object)customScalarAdapters, (String)"customScalarAdapters");
            String indent$iv = null;
            boolean $i$f$buildJsonByteString = false;
            Buffer buffer$iv = new Buffer();
            JsonWriter $this$buildParamsMap_u24lambda_u240 = new BufferedSinkJsonWriter((BufferedSink)buffer$iv, indent$iv);
            boolean bl = false;
            String query = sendDocument ? operation.document() : null;
            Companion.composePostParams($this$buildParamsMap_u24lambda_u240, operation, customScalarAdapters, autoPersistQueries, true, query);
            return buffer$iv.readByteString();
        }

        @NotNull
        public final <D extends Operation.Data> ByteString buildParamsMap(@NotNull Operation<D> operation, @NotNull CustomScalarAdapters customScalarAdapters, boolean autoPersistQueries, boolean sendDocument, boolean sendEnhancedClientAwarenessExtensions) {
            Intrinsics.checkNotNullParameter(operation, (String)"operation");
            Intrinsics.checkNotNullParameter((Object)customScalarAdapters, (String)"customScalarAdapters");
            String indent$iv = null;
            boolean $i$f$buildJsonByteString = false;
            Buffer buffer$iv = new Buffer();
            JsonWriter $this$buildParamsMap_u24lambda_u241 = new BufferedSinkJsonWriter((BufferedSink)buffer$iv, indent$iv);
            boolean bl = false;
            String query = sendDocument ? operation.document() : null;
            Companion.composePostParams($this$buildParamsMap_u24lambda_u241, operation, customScalarAdapters, autoPersistQueries, sendEnhancedClientAwarenessExtensions, query);
            return buffer$iv.readByteString();
        }

        @NotNull
        public final <D extends Operation.Data> Map<String, Object> composePayload(@NotNull ApolloRequest<D> apolloRequest) {
            Intrinsics.checkNotNullParameter(apolloRequest, (String)"apolloRequest");
            Operation<D> operation = apolloRequest.getOperation();
            Boolean bl = apolloRequest.getSendApqExtensions();
            boolean sendApqExtensions = bl != null ? bl : false;
            boolean sendEnhancedClientAwarenessExtensions = apolloRequest.getSendEnhancedClientAwareness();
            Boolean bl2 = apolloRequest.getSendDocument();
            boolean sendDocument = bl2 != null ? bl2 : true;
            CustomScalarAdapters customScalarAdapters = (CustomScalarAdapters)apolloRequest.getExecutionContext().get(CustomScalarAdapters.Key);
            if (customScalarAdapters == null) {
                customScalarAdapters = CustomScalarAdapters.Empty;
            }
            CustomScalarAdapters customScalarAdapters2 = customScalarAdapters;
            String query = sendDocument ? operation.document() : null;
            boolean $i$f$buildJsonMap = false;
            MapJsonWriter writer$iv = new MapJsonWriter();
            JsonWriter $this$composePayload_u24lambda_u240 = writer$iv;
            boolean bl3 = false;
            Companion.composePostParams($this$composePayload_u24lambda_u240, operation, customScalarAdapters2, sendApqExtensions, sendEnhancedClientAwarenessExtensions, query);
            Object object = writer$iv.root();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
            return (Map)object;
        }

        private static final Unit extensionsWriter$lambda$0(JsonWriter jsonWriter) {
            Intrinsics.checkNotNullParameter((Object)jsonWriter, (String)"<this>");
            return Unit.INSTANCE;
        }

        private static final Unit extensionsWriter$lambda$1(boolean $sendApqExtensions, boolean $sendEnhancedClientAwarenessExtensions, String $apqId, JsonWriter jsonWriter) {
            boolean $i$f$writeObject;
            JsonWriter $this$writeObject$iv;
            Intrinsics.checkNotNullParameter((Object)jsonWriter, (String)"<this>");
            jsonWriter.name("extensions");
            JsonWriter $this$writeObject$iv2 = jsonWriter;
            boolean $i$f$writeObject2 = false;
            $this$writeObject$iv2.beginObject();
            JsonWriter $this$extensionsWriter_u24lambda_u241_u240 = $this$writeObject$iv2;
            boolean bl = false;
            if ($sendApqExtensions) {
                $this$extensionsWriter_u24lambda_u241_u240.name("persistedQuery");
                $this$writeObject$iv = $this$extensionsWriter_u24lambda_u241_u240;
                $i$f$writeObject = false;
                $this$writeObject$iv.beginObject();
                JsonWriter $this$extensionsWriter_u24lambda_u241_u240_u240 = $this$writeObject$iv;
                boolean bl2 = false;
                $this$extensionsWriter_u24lambda_u241_u240_u240.name("version").value(1);
                $this$extensionsWriter_u24lambda_u241_u240_u240.name("sha256Hash").value($apqId);
                $this$writeObject$iv.endObject();
            }
            if ($sendEnhancedClientAwarenessExtensions) {
                $this$extensionsWriter_u24lambda_u241_u240.name("clientLibrary");
                $this$writeObject$iv = $this$extensionsWriter_u24lambda_u241_u240;
                $i$f$writeObject = false;
                $this$writeObject$iv.beginObject();
                JsonWriter $this$extensionsWriter_u24lambda_u241_u240_u241 = $this$writeObject$iv;
                boolean bl3 = false;
                $this$extensionsWriter_u24lambda_u241_u240_u241.name("name").value("apollo-kotlin");
                $this$extensionsWriter_u24lambda_u241_u240_u241.name("version").value("5.0.0-alpha.3");
                $this$writeObject$iv.endObject();
            }
            $this$writeObject$iv2.endObject();
            return Unit.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[HttpMethod.values().length];
            try {
                nArray[HttpMethod.Get.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HttpMethod.Post.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

