/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.api;

import com.apollographql.apollo.api.BLabel;
import com.apollographql.apollo.api.BPossibleTypes;
import com.apollographql.apollo.api.BTerm;
import com.apollographql.apollo.api.BVariable;
import com.apollographql.apollo.api.BooleanExpression;
import com.apollographql.apollo.api.DeferredFragmentIdentifier;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000V\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\u001a;\u0010\u0000\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\b\b\u0000\u0010\u0002*\u00020\u00032\u001e\u0010\u0004\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u0002H\u00020\u00010\u0005\"\b\u0012\u0004\u0012\u0002H\u00020\u0001\u00a2\u0006\u0002\u0010\u0006\u001a;\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\b\b\u0000\u0010\u0002*\u00020\u00032\u001e\u0010\u0004\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u0002H\u00020\u00010\u0005\"\b\u0012\u0004\u0012\u0002H\u00020\u0001\u00a2\u0006\u0002\u0010\u0006\u001a$\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\b\b\u0000\u0010\u0002*\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\u001a\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u00012\u0006\u0010\u000b\u001a\u00020\f\u001a\u0018\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00012\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\f\u001a%\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u00012\u0012\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u0005\"\u00020\f\u00a2\u0006\u0002\u0010\u0012\u001a0\u0010\u0013\u001a\u00020\u0014\"\b\b\u0000\u0010\u0002*\u00020\u0003*\b\u0012\u0004\u0012\u0002H\u00020\u00012\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u00020\u00140\u0016H\u0000\u001aJ\u0010\u0013\u001a\u00020\u0014*\b\u0012\u0004\u0012\u00020\u00170\u00012\u000e\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\f2\u000e\u0010\u001b\u001a\n\u0012\u0004\u0012\u00020\u001c\u0018\u00010\u00192\u000e\u0010\u001d\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u001e\u001a0\u0010\u001f\u001a\u00020\u00142\u000e\u0010\u001b\u001a\n\u0012\u0004\u0012\u00020\u001c\u0018\u00010\u00192\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00030\u001e2\b\u0010\r\u001a\u0004\u0018\u00010\fH\u0002\u001a\u0012\u0010 \u001a\u00020\u0014*\b\u0012\u0004\u0012\u00020\u001c0\u0019H\u0002\u00a8\u0006!"}, d2={"or", "Lcom/apollographql/apollo/api/BooleanExpression;", "T", "", "other", "", "([Lcom/apollographql/apollo/api/BooleanExpression;)Lcom/apollographql/apollo/api/BooleanExpression;", "and", "not", "variable", "Lcom/apollographql/apollo/api/BVariable;", "name", "", "label", "Lcom/apollographql/apollo/api/BLabel;", "possibleTypes", "Lcom/apollographql/apollo/api/BPossibleTypes;", "typenames", "([Ljava/lang/String;)Lcom/apollographql/apollo/api/BooleanExpression;", "evaluate", "", "block", "Lkotlin/Function1;", "Lcom/apollographql/apollo/api/BTerm;", "variables", "", "typename", "deferredFragmentIdentifiers", "Lcom/apollographql/apollo/api/DeferredFragmentIdentifier;", "path", "", "shouldParseFragment", "isPending", "apollo-api"})
@JvmName(name="BooleanExpressions")
@SourceDebugExtension(value={"SMAP\nBooleanExpression.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BooleanExpression.kt\ncom/apollographql/apollo/api/BooleanExpressions\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,124:1\n1761#2,3:125\n1740#2,3:128\n1761#2,3:131\n*S KotlinDebug\n*F\n+ 1 BooleanExpression.kt\ncom/apollographql/apollo/api/BooleanExpressions\n*L\n61#1:125,3\n62#1:128,3\n100#1:131,3\n*E\n"})
public final class BooleanExpressions {
    @NotNull
    public static final <T> BooleanExpression<T> or(BooleanExpression<? extends T> ... other) {
        Intrinsics.checkNotNullParameter(other, (String)"other");
        return new BooleanExpression.Or(CollectionsKt.toSet((Iterable)ArraysKt.toList((Object[])other)));
    }

    @NotNull
    public static final <T> BooleanExpression<T> and(BooleanExpression<? extends T> ... other) {
        Intrinsics.checkNotNullParameter(other, (String)"other");
        return new BooleanExpression.And(CollectionsKt.toSet((Iterable)ArraysKt.toList((Object[])other)));
    }

    @NotNull
    public static final <T> BooleanExpression<T> not(@NotNull BooleanExpression<? extends T> other) {
        Intrinsics.checkNotNullParameter(other, (String)"other");
        return new BooleanExpression.Not<T>(other);
    }

    @NotNull
    public static final BooleanExpression<BVariable> variable(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return new BooleanExpression.Element<BVariable>(new BVariable(name));
    }

    @NotNull
    public static final BooleanExpression<BLabel> label(@Nullable String label) {
        return new BooleanExpression.Element<BLabel>(new BLabel(label));
    }

    public static /* synthetic */ BooleanExpression label$default(String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        return BooleanExpressions.label(string);
    }

    @NotNull
    public static final BooleanExpression<BPossibleTypes> possibleTypes(String ... typenames) {
        Intrinsics.checkNotNullParameter((Object)typenames, (String)"typenames");
        return new BooleanExpression.Element<BPossibleTypes>(new BPossibleTypes(ArraysKt.toSet((Object[])typenames)));
    }

    public static final <T> boolean evaluate(@NotNull BooleanExpression<? extends T> $this$evaluate, @NotNull Function1<? super T, Boolean> block) {
        boolean bl;
        block18: {
            Intrinsics.checkNotNullParameter($this$evaluate, (String)"<this>");
            Intrinsics.checkNotNullParameter(block, (String)"block");
            BooleanExpression<? extends T> booleanExpression = $this$evaluate;
            if (Intrinsics.areEqual(booleanExpression, (Object)BooleanExpression.True.INSTANCE)) {
                bl = true;
            } else if (Intrinsics.areEqual(booleanExpression, (Object)BooleanExpression.False.INSTANCE)) {
                bl = false;
            } else if (booleanExpression instanceof BooleanExpression.Not) {
                bl = !BooleanExpressions.evaluate(((BooleanExpression.Not)$this$evaluate).getOperand(), block);
            } else if (booleanExpression instanceof BooleanExpression.Or) {
                Iterable $this$any$iv = ((BooleanExpression.Or)$this$evaluate).getOperands();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        BooleanExpression it = (BooleanExpression)element$iv;
                        boolean bl2 = false;
                        if (!BooleanExpressions.evaluate(it, block)) continue;
                        bl = true;
                        break block18;
                    }
                    bl = false;
                }
            } else if (booleanExpression instanceof BooleanExpression.And) {
                Iterable $this$all$iv = ((BooleanExpression.And)$this$evaluate).getOperands();
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        BooleanExpression it = (BooleanExpression)element$iv;
                        boolean bl3 = false;
                        if (BooleanExpressions.evaluate(it, block)) continue;
                        bl = false;
                        break block18;
                    }
                    bl = true;
                }
            } else if (booleanExpression instanceof BooleanExpression.Element) {
                bl = (Boolean)block.invoke(((BooleanExpression.Element)$this$evaluate).getValue());
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    public static final boolean evaluate(@NotNull BooleanExpression<? extends BTerm> $this$evaluate, @Nullable Set<String> variables, @Nullable String typename, @Nullable Set<DeferredFragmentIdentifier> deferredFragmentIdentifiers, @Nullable List<? extends Object> path) {
        Intrinsics.checkNotNullParameter($this$evaluate, (String)"<this>");
        List<? extends Object> list = path;
        List croppedPath = list != null ? CollectionsKt.drop((Iterable)list, (int)1) : null;
        return BooleanExpressions.evaluate($this$evaluate, arg_0 -> BooleanExpressions.evaluate$lambda$2(variables, deferredFragmentIdentifiers, croppedPath, typename, arg_0));
    }

    private static final boolean shouldParseFragment(Set<DeferredFragmentIdentifier> deferredFragmentIdentifiers, List<? extends Object> path, String label) {
        if (deferredFragmentIdentifiers == null) {
            return true;
        }
        DeferredFragmentIdentifier identifier = new DeferredFragmentIdentifier(path, label);
        return BooleanExpressions.isPending(deferredFragmentIdentifiers) ? !deferredFragmentIdentifiers.contains(identifier) : deferredFragmentIdentifiers.contains(identifier);
    }

    private static final boolean isPending(Set<DeferredFragmentIdentifier> $this$isPending) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = $this$isPending;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    DeferredFragmentIdentifier it = (DeferredFragmentIdentifier)element$iv;
                    boolean bl2 = false;
                    if (!(it == DeferredFragmentIdentifier.Companion.getPending())) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final boolean evaluate$lambda$2(Set $variables, Set $deferredFragmentIdentifiers, List $croppedPath, String $typename, BTerm it) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        BTerm bTerm = it;
        if (bTerm instanceof BVariable) {
            Set set = $variables;
            bl = !(set != null ? set.contains(((BVariable)it).getName()) : false);
        } else if (bTerm instanceof BLabel) {
            List list = $croppedPath;
            Intrinsics.checkNotNull((Object)list);
            bl = BooleanExpressions.shouldParseFragment($deferredFragmentIdentifiers, list, ((BLabel)it).getLabel());
        } else if (bTerm instanceof BPossibleTypes) {
            bl = CollectionsKt.contains((Iterable)((BPossibleTypes)it).getPossibleTypes(), (Object)$typename);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }
}

