/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.api.http;

import com.apollographql.apollo.api.ApolloRequest;
import com.apollographql.apollo.api.CustomScalarAdapters;
import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.api.Subscription;
import com.apollographql.apollo.api.Upload;
import com.apollographql.apollo.api.http.HttpBody;
import com.apollographql.apollo.api.http.HttpHeader;
import com.apollographql.apollo.api.http.HttpMethod;
import com.apollographql.apollo.api.http.HttpRequest;
import com.apollographql.apollo.api.http.HttpRequestComposer;
import com.apollographql.apollo.api.http.UploadsHttpBody;
import com.apollographql.apollo.api.http.internal.UrlEncodeKt;
import com.apollographql.apollo.api.json.BufferedSinkJsonWriter;
import com.apollographql.apollo.api.json.JsonWriter;
import com.apollographql.apollo.api.json.MapJsonWriter;
import com.apollographql.apollo.api.json.internal.FileUploadAwareJsonWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ReplaceWith;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import okio.Buffer;
import okio.BufferedSink;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u0007\"\b\b\u0000\u0010\b*\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\b0\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/apollographql/apollo/api/http/DefaultHttpRequestComposer;", "Lcom/apollographql/apollo/api/http/HttpRequestComposer;", "serverUrl", "", "<init>", "(Ljava/lang/String;)V", "compose", "Lcom/apollographql/apollo/api/http/HttpRequest;", "D", "Lcom/apollographql/apollo/api/Operation$Data;", "apolloRequest", "Lcom/apollographql/apollo/api/ApolloRequest;", "Companion", "apollo-api"})
public final class DefaultHttpRequestComposer
implements HttpRequestComposer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String serverUrl;
    @NotNull
    private static final String HEADER_APOLLO_REQUIRE_PREFLIGHT = "Apollo-Require-Preflight";
    @NotNull
    private static final String HEADER_ACCEPT_NAME = "Accept";
    @NotNull
    private static final String HEADER_ACCEPT_VALUE_DEFER = "multipart/mixed;deferSpec=20220824, application/graphql-response+json, application/json";
    @NotNull
    private static final String HEADER_ACCEPT_VALUE_MULTIPART = "multipart/mixed;subscriptionSpec=1.0, application/graphql-response+json, application/json";

    public DefaultHttpRequestComposer(@NotNull String serverUrl) {
        Intrinsics.checkNotNullParameter((Object)serverUrl, (String)"serverUrl");
        this.serverUrl = serverUrl;
    }

    @Override
    @NotNull
    public <D extends Operation.Data> HttpRequest compose(@NotNull ApolloRequest<D> apolloRequest) {
        HttpRequest.Builder builder;
        List list;
        Intrinsics.checkNotNullParameter(apolloRequest, (String)"apolloRequest");
        Operation<D> operation = apolloRequest.getOperation();
        CustomScalarAdapters customScalarAdapters = (CustomScalarAdapters)apolloRequest.getExecutionContext().get(CustomScalarAdapters.Key);
        if (customScalarAdapters == null) {
            customScalarAdapters = CustomScalarAdapters.Empty;
        }
        CustomScalarAdapters customScalarAdapters2 = customScalarAdapters;
        List $this$compose_u24lambda_u240 = list = (List)new ArrayList();
        boolean bl = false;
        boolean bl2 = apolloRequest.getOperation() instanceof Subscription ? $this$compose_u24lambda_u240.add(new HttpHeader(HEADER_ACCEPT_NAME, HEADER_ACCEPT_VALUE_MULTIPART)) : $this$compose_u24lambda_u240.add(new HttpHeader(HEADER_ACCEPT_NAME, HEADER_ACCEPT_VALUE_DEFER));
        if (apolloRequest.getHttpHeaders() != null) {
            $this$compose_u24lambda_u240.addAll((Collection)apolloRequest.getHttpHeaders());
        }
        List requestHeaders = list;
        Boolean bl3 = apolloRequest.getSendApqExtensions();
        boolean sendApqExtensions = bl3 != null ? bl3 : false;
        boolean sendEnhancedClientAwarenessExtensions = apolloRequest.getSendEnhancedClientAwareness();
        Boolean bl4 = apolloRequest.getSendDocument();
        boolean sendDocument = bl4 != null ? bl4 : true;
        HttpMethod httpMethod = apolloRequest.getHttpMethod();
        if (httpMethod == null) {
            httpMethod = HttpMethod.Post;
        }
        switch (WhenMappings.$EnumSwitchMapping$0[httpMethod.ordinal()]) {
            case 1: {
                builder = new HttpRequest.Builder(HttpMethod.Get, DefaultHttpRequestComposer.Companion.buildGetUrl(this.serverUrl, operation, customScalarAdapters2, sendApqExtensions, sendDocument, sendEnhancedClientAwarenessExtensions)).addHeader(HEADER_APOLLO_REQUIRE_PREFLIGHT, "true");
                break;
            }
            case 2: {
                String query = sendDocument ? operation.document() : null;
                HttpBody body = Companion.buildPostBody(operation, customScalarAdapters2, query, (Function1<? super JsonWriter, Unit>)DefaultHttpRequestComposer.Companion.extensionsWriter(operation.id(), sendApqExtensions, sendEnhancedClientAwarenessExtensions));
                HttpRequest.Builder it = new HttpRequest.Builder(HttpMethod.Post, this.serverUrl).body(body);
                boolean bl5 = false;
                if (StringsKt.startsWith$default((String)body.getContentType(), (String)"multipart/form-data", (boolean)false, (int)2, null)) {
                    builder = it.addHeader(HEADER_APOLLO_REQUIRE_PREFLIGHT, "true");
                    break;
                }
                builder = it;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        HttpRequest.Builder httpRequestBuilder = builder;
        return httpRequestBuilder.addHeaders(requestHeaders).addExecutionContext(apolloRequest.getExecutionContext()).build();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JH\u0010\u000e\u001a\u00020\u0005\"\b\b\u0000\u0010\u000f*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00052\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u0017H\u0002J_\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u001c0\u001b\"\b\b\u0000\u0010\u000f*\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u001e2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u00132\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u001f\u001a\u0004\u0018\u00010\u00052\u0017\u0010 \u001a\u0013\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\"0!\u00a2\u0006\u0002\b#H\u0002JV\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u001c0\u001b\"\b\b\u0000\u0010\u000f*\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u001e2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u00172\b\u0010\u001f\u001a\u0004\u0018\u00010\u0005H\u0002J1\u0010 \u001a\u0013\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\"0!\u00a2\u0006\u0002\b#2\u0006\u0010$\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u0017H\u0002JL\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u001b\"\b\b\u0000\u0010\u000f*\u00020\u00102\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010&\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010'\u001a\u00020\u0017H\u0002J\u001e\u0010(\u001a\u00020\u0005*\u00020\u00052\u0012\u0010)\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u001bJB\u0010*\u001a\u00020+\"\b\b\u0000\u0010\u000f*\u00020\u00102\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010&\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u00172\b\u0010\u001f\u001a\u0004\u0018\u00010\u0005H\u0007JI\u0010*\u001a\u00020+\"\b\b\u0000\u0010\u000f*\u00020\u00102\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u00132\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u001f\u001a\u0004\u0018\u00010\u00052\u0017\u0010 \u001a\u0013\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\"0!\u00a2\u0006\u0002\b#J8\u0010,\u001a\u00020-\"\b\b\u0000\u0010\u000f*\u00020\u00102\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010&\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017H\u0007J>\u0010,\u001a\u00020-\"\b\b\u0000\u0010\u000f*\u00020\u00102\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010&\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u0017J,\u0010.\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u001b\"\b\b\u0000\u0010\u000f*\u00020\u00102\f\u0010/\u001a\b\u0012\u0004\u0012\u0002H\u000f00R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u0005X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0014\u0010\n\u001a\u00020\u0005X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007R\u0014\u0010\f\u001a\u00020\u0005X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0007\u00a8\u00061"}, d2={"Lcom/apollographql/apollo/api/http/DefaultHttpRequestComposer$Companion;", "", "<init>", "()V", "HEADER_APOLLO_REQUIRE_PREFLIGHT", "", "getHEADER_APOLLO_REQUIRE_PREFLIGHT$apollo_api", "()Ljava/lang/String;", "HEADER_ACCEPT_NAME", "getHEADER_ACCEPT_NAME", "HEADER_ACCEPT_VALUE_DEFER", "getHEADER_ACCEPT_VALUE_DEFER", "HEADER_ACCEPT_VALUE_MULTIPART", "getHEADER_ACCEPT_VALUE_MULTIPART", "buildGetUrl", "D", "Lcom/apollographql/apollo/api/Operation$Data;", "serverUrl", "operation", "Lcom/apollographql/apollo/api/Operation;", "customScalarAdapters", "Lcom/apollographql/apollo/api/CustomScalarAdapters;", "sendApqExtensions", "", "sendDocument", "sendEnhancedClientAwarenessExtensions", "composePostParams", "", "Lcom/apollographql/apollo/api/Upload;", "writer", "Lcom/apollographql/apollo/api/json/JsonWriter;", "query", "extensionsWriter", "Lkotlin/Function1;", "", "Lkotlin/ExtensionFunctionType;", "apqId", "composeGetParams", "autoPersistQueries", "sendEnhancedClientAwareness", "appendQueryParameters", "parameters", "buildPostBody", "Lcom/apollographql/apollo/api/http/HttpBody;", "buildParamsMap", "Lokio/ByteString;", "composePayload", "apolloRequest", "Lcom/apollographql/apollo/api/ApolloRequest;", "apollo-api"})
    @SourceDebugExtension(value={"SMAP\nDefaultHttpRequestComposer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultHttpRequestComposer.kt\ncom/apollographql/apollo/api/http/DefaultHttpRequestComposer$Companion\n+ 2 JsonWriters.kt\ncom/apollographql/apollo/api/json/-JsonWriters\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,434:1\n49#2,2:435\n49#2,4:437\n51#2,2:441\n65#2,8:443\n49#2,4:451\n73#2:455\n65#2,8:456\n49#2,2:464\n49#2,4:466\n49#2,4:470\n51#2,2:474\n73#2:476\n82#2,3:479\n76#2,9:482\n76#2,9:491\n93#2,3:500\n49#2,2:503\n49#2,4:505\n49#2,4:509\n51#2,2:513\n1863#3,2:477\n*S KotlinDebug\n*F\n+ 1 DefaultHttpRequestComposer.kt\ncom/apollographql/apollo/api/http/DefaultHttpRequestComposer$Companion\n*L\n126#1:435,2\n132#1:437,4\n126#1:441,2\n206#1:443,8\n208#1:451,4\n206#1:455\n222#1:456,8\n223#1:464,2\n226#1:466,4\n233#1:470,4\n223#1:474,2\n222#1:476\n288#1:479,3\n319#1:482,9\n332#1:491,9\n349#1:500,3\n170#1:503,2\n173#1:505,4\n181#1:509,4\n170#1:513,2\n255#1:477,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getHEADER_APOLLO_REQUIRE_PREFLIGHT$apollo_api() {
            return HEADER_APOLLO_REQUIRE_PREFLIGHT;
        }

        @NotNull
        public final String getHEADER_ACCEPT_NAME() {
            return HEADER_ACCEPT_NAME;
        }

        @NotNull
        public final String getHEADER_ACCEPT_VALUE_DEFER() {
            return HEADER_ACCEPT_VALUE_DEFER;
        }

        @NotNull
        public final String getHEADER_ACCEPT_VALUE_MULTIPART() {
            return HEADER_ACCEPT_VALUE_MULTIPART;
        }

        private final <D extends Operation.Data> String buildGetUrl(String serverUrl, Operation<D> operation, CustomScalarAdapters customScalarAdapters, boolean sendApqExtensions, boolean sendDocument, boolean sendEnhancedClientAwarenessExtensions) {
            return this.appendQueryParameters(serverUrl, this.composeGetParams(operation, customScalarAdapters, sendApqExtensions, sendDocument, sendEnhancedClientAwarenessExtensions));
        }

        private final <D extends Operation.Data> Map<String, Upload> composePostParams(JsonWriter writer, Operation<D> operation, CustomScalarAdapters customScalarAdapters, String query, Function1<? super JsonWriter, Unit> extensionsWriter) {
            Map<String, Upload> uploads = null;
            JsonWriter $this$writeObject$iv = writer;
            boolean $i$f$writeObject = false;
            $this$writeObject$iv.beginObject();
            JsonWriter $this$composePostParams_u24lambda_u241 = $this$writeObject$iv;
            boolean bl = false;
            $this$composePostParams_u24lambda_u241.name("operationName");
            $this$composePostParams_u24lambda_u241.value(operation.name());
            $this$composePostParams_u24lambda_u241.name("variables");
            FileUploadAwareJsonWriter uploadAwareWriter = new FileUploadAwareJsonWriter($this$composePostParams_u24lambda_u241);
            JsonWriter $this$writeObject$iv2 = uploadAwareWriter;
            boolean $i$f$writeObject2 = false;
            $this$writeObject$iv2.beginObject();
            JsonWriter $this$composePostParams_u24lambda_u241_u24lambda_u240 = $this$writeObject$iv2;
            boolean bl2 = false;
            operation.serializeVariables($this$composePostParams_u24lambda_u241_u24lambda_u240, customScalarAdapters, false);
            $this$writeObject$iv2.endObject();
            uploads = uploadAwareWriter.collectedUploads();
            if (query != null) {
                $this$composePostParams_u24lambda_u241.name("query");
                $this$composePostParams_u24lambda_u241.value(query);
            }
            extensionsWriter.invoke((Object)$this$composePostParams_u24lambda_u241);
            $this$writeObject$iv.endObject();
            return uploads;
        }

        private final <D extends Operation.Data> Map<String, Upload> composePostParams(JsonWriter writer, Operation<D> operation, CustomScalarAdapters customScalarAdapters, boolean sendApqExtensions, boolean sendEnhancedClientAwarenessExtensions, String query) {
            return this.composePostParams(writer, operation, customScalarAdapters, query, this.extensionsWriter(operation.id(), sendApqExtensions, sendEnhancedClientAwarenessExtensions));
        }

        private final Function1<JsonWriter, Unit> extensionsWriter(String apqId, boolean sendApqExtensions, boolean sendEnhancedClientAwarenessExtensions) {
            if (!sendApqExtensions && !sendEnhancedClientAwarenessExtensions) {
                return Companion::extensionsWriter$lambda$2;
            }
            return arg_0 -> Companion.extensionsWriter$lambda$6(sendApqExtensions, sendEnhancedClientAwarenessExtensions, apqId, arg_0);
        }

        private final <D extends Operation.Data> Map<String, String> composeGetParams(Operation<D> operation, CustomScalarAdapters customScalarAdapters, boolean autoPersistQueries, boolean sendDocument, boolean sendEnhancedClientAwareness) {
            boolean $i$f$writeObject;
            JsonWriter $this$writeObject$iv;
            Map queryParams = new LinkedHashMap();
            queryParams.put("operationName", operation.name());
            String indent$iv = null;
            boolean $i$f$buildJsonString = false;
            Buffer buffer$iv = new Buffer();
            JsonWriter $this$composeGetParams_u24lambda_u249 = new BufferedSinkJsonWriter((BufferedSink)buffer$iv, indent$iv);
            boolean bl = false;
            FileUploadAwareJsonWriter uploadAwareWriter = new FileUploadAwareJsonWriter($this$composeGetParams_u24lambda_u249);
            JsonWriter $this$writeObject$iv2 = uploadAwareWriter;
            boolean $i$f$writeObject2 = false;
            $this$writeObject$iv2.beginObject();
            JsonWriter $this$composeGetParams_u24lambda_u249_u24lambda_u247 = $this$writeObject$iv2;
            boolean bl2 = false;
            operation.serializeVariables($this$composeGetParams_u24lambda_u249_u24lambda_u247, customScalarAdapters, false);
            $this$writeObject$iv2.endObject();
            if (!uploadAwareWriter.collectedUploads().isEmpty()) {
                boolean $i$a$-check-DefaultHttpRequestComposer$Companion$composeGetParams$variables$1$32 = false;
                String $i$a$-check-DefaultHttpRequestComposer$Companion$composeGetParams$variables$1$32 = "FileUpload and Http GET are not supported at the same time";
                throw new IllegalStateException($i$a$-check-DefaultHttpRequestComposer$Companion$composeGetParams$variables$1$32.toString());
            }
            String variables = buffer$iv.readUtf8();
            queryParams.put("variables", variables);
            if (sendDocument) {
                queryParams.put("query", operation.document());
            }
            String indent$iv2 = null;
            boolean $i$f$buildJsonString2 = false;
            Buffer buffer$iv2 = new Buffer();
            JsonWriter $this$composeGetParams_u24lambda_u2413 = new BufferedSinkJsonWriter((BufferedSink)buffer$iv2, indent$iv2);
            boolean bl3 = false;
            $this$writeObject$iv2 = $this$composeGetParams_u24lambda_u2413;
            $i$f$writeObject2 = false;
            $this$writeObject$iv2.beginObject();
            JsonWriter $this$composeGetParams_u24lambda_u2413_u24lambda_u2412 = $this$writeObject$iv2;
            boolean bl4 = false;
            if (autoPersistQueries) {
                $this$composeGetParams_u24lambda_u2413_u24lambda_u2412.name("persistedQuery");
                $this$writeObject$iv = $this$composeGetParams_u24lambda_u2413_u24lambda_u2412;
                $i$f$writeObject = false;
                $this$writeObject$iv.beginObject();
                JsonWriter $this$composeGetParams_u24lambda_u2413_u24lambda_u2412_u24lambda_u2410 = $this$writeObject$iv;
                boolean bl5 = false;
                $this$composeGetParams_u24lambda_u2413_u24lambda_u2412_u24lambda_u2410.name("version").value(1);
                $this$composeGetParams_u24lambda_u2413_u24lambda_u2412_u24lambda_u2410.name("sha256Hash").value(operation.id());
                $this$writeObject$iv.endObject();
            }
            if (sendEnhancedClientAwareness) {
                $this$composeGetParams_u24lambda_u2413_u24lambda_u2412.name("clientLibrary");
                $this$writeObject$iv = $this$composeGetParams_u24lambda_u2413_u24lambda_u2412;
                $i$f$writeObject = false;
                $this$writeObject$iv.beginObject();
                JsonWriter $this$composeGetParams_u24lambda_u2413_u24lambda_u2412_u24lambda_u2411 = $this$writeObject$iv;
                boolean bl6 = false;
                $this$composeGetParams_u24lambda_u2413_u24lambda_u2412_u24lambda_u2411.name("name").value("apollo-kotlin");
                $this$composeGetParams_u24lambda_u2413_u24lambda_u2412_u24lambda_u2411.name("version").value("5.0.0-alpha.2");
                $this$writeObject$iv.endObject();
            }
            $this$writeObject$iv2.endObject();
            String extensions = buffer$iv2.readUtf8();
            if (!(((CharSequence)extensions).length() == 0)) {
                queryParams.put("extensions", extensions);
            }
            return queryParams;
        }

        @NotNull
        public final String appendQueryParameters(@NotNull String $this$appendQueryParameters, @NotNull Map<String, String> parameters) {
            StringBuilder stringBuilder;
            Intrinsics.checkNotNullParameter((Object)$this$appendQueryParameters, (String)"<this>");
            Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
            StringBuilder $this$appendQueryParameters_u24lambda_u2415 = stringBuilder = new StringBuilder();
            boolean bl = false;
            $this$appendQueryParameters_u24lambda_u2415.append($this$appendQueryParameters);
            boolean hasQuestionMark = false;
            hasQuestionMark = StringsKt.contains$default((CharSequence)$this$appendQueryParameters, (CharSequence)"?", (boolean)false, (int)2, null);
            Iterable $this$forEach$iv = parameters.entrySet();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                StringBuilder stringBuilder2;
                Map.Entry it = (Map.Entry)element$iv;
                boolean bl2 = false;
                if (hasQuestionMark) {
                    stringBuilder2 = $this$appendQueryParameters_u24lambda_u2415.append('&');
                } else {
                    hasQuestionMark = true;
                    stringBuilder2 = $this$appendQueryParameters_u24lambda_u2415.append('?');
                }
                $this$appendQueryParameters_u24lambda_u2415.append(UrlEncodeKt.urlEncode((String)it.getKey()));
                $this$appendQueryParameters_u24lambda_u2415.append('=');
                $this$appendQueryParameters_u24lambda_u2415.append(UrlEncodeKt.urlEncode((String)it.getValue()));
            }
            String string = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }

        @Deprecated(message="Use buildPostBody(operation, customScalarAdapters, query, extensionsWriter) instead", level=DeprecationLevel.ERROR)
        @NotNull
        public final <D extends Operation.Data> HttpBody buildPostBody(@NotNull Operation<D> operation, @NotNull CustomScalarAdapters customScalarAdapters, boolean autoPersistQueries, boolean sendEnhancedClientAwarenessExtensions, @Nullable String query) {
            Intrinsics.checkNotNullParameter(operation, (String)"operation");
            Intrinsics.checkNotNullParameter((Object)customScalarAdapters, (String)"customScalarAdapters");
            return this.buildPostBody(operation, customScalarAdapters, query, this.extensionsWriter(operation.id(), autoPersistQueries, sendEnhancedClientAwarenessExtensions));
        }

        @NotNull
        public final <D extends Operation.Data> HttpBody buildPostBody(@NotNull Operation<D> operation, @NotNull CustomScalarAdapters customScalarAdapters, @Nullable String query, @NotNull Function1<? super JsonWriter, Unit> extensionsWriter) {
            Intrinsics.checkNotNullParameter(operation, (String)"operation");
            Intrinsics.checkNotNullParameter((Object)customScalarAdapters, (String)"customScalarAdapters");
            Intrinsics.checkNotNullParameter(extensionsWriter, (String)"extensionsWriter");
            Map uploads = null;
            String indent$iv = null;
            boolean $i$f$buildJsonByteString = false;
            Buffer buffer$iv = new Buffer();
            JsonWriter $this$buildPostBody_u24lambda_u2416 = new BufferedSinkJsonWriter((BufferedSink)buffer$iv, indent$iv);
            boolean bl = false;
            uploads = Companion.composePostParams($this$buildPostBody_u24lambda_u2416, operation, customScalarAdapters, query, (Function1<? super JsonWriter, Unit>)extensionsWriter);
            ByteString operationByteString = buffer$iv.readByteString();
            return uploads.isEmpty() ? (HttpBody)new HttpBody(operationByteString){
                private final String contentType;
                private final long contentLength;
                final /* synthetic */ ByteString $operationByteString;
                {
                    this.$operationByteString = $operationByteString;
                    this.contentType = "application/json";
                    this.contentLength = $operationByteString.size();
                }

                public String getContentType() {
                    return this.contentType;
                }

                public long getContentLength() {
                    return this.contentLength;
                }

                public void writeTo(BufferedSink bufferedSink) {
                    Intrinsics.checkNotNullParameter((Object)bufferedSink, (String)"bufferedSink");
                    bufferedSink.write(this.$operationByteString);
                }
            } : (HttpBody)new UploadsHttpBody(uploads, operationByteString);
        }

        @Deprecated(message="Use new function with additional parameters instead.", replaceWith=@ReplaceWith(expression="buildParamsMap(operation = operation, customScalarAdapters = customScalarAdapters, autoPersistQueries = autoPersistQueries, sendDocument = sendDocument, sendEnhancedClientAwarenessExtensions = true)", imports={}))
        @NotNull
        public final <D extends Operation.Data> ByteString buildParamsMap(@NotNull Operation<D> operation, @NotNull CustomScalarAdapters customScalarAdapters, boolean autoPersistQueries, boolean sendDocument) {
            Intrinsics.checkNotNullParameter(operation, (String)"operation");
            Intrinsics.checkNotNullParameter((Object)customScalarAdapters, (String)"customScalarAdapters");
            String indent$iv = null;
            boolean $i$f$buildJsonByteString = false;
            Buffer buffer$iv = new Buffer();
            JsonWriter $this$buildParamsMap_u24lambda_u2417 = new BufferedSinkJsonWriter((BufferedSink)buffer$iv, indent$iv);
            boolean bl = false;
            String query = sendDocument ? operation.document() : null;
            Companion.composePostParams($this$buildParamsMap_u24lambda_u2417, operation, customScalarAdapters, autoPersistQueries, true, query);
            return buffer$iv.readByteString();
        }

        @NotNull
        public final <D extends Operation.Data> ByteString buildParamsMap(@NotNull Operation<D> operation, @NotNull CustomScalarAdapters customScalarAdapters, boolean autoPersistQueries, boolean sendDocument, boolean sendEnhancedClientAwarenessExtensions) {
            Intrinsics.checkNotNullParameter(operation, (String)"operation");
            Intrinsics.checkNotNullParameter((Object)customScalarAdapters, (String)"customScalarAdapters");
            String indent$iv = null;
            boolean $i$f$buildJsonByteString = false;
            Buffer buffer$iv = new Buffer();
            JsonWriter $this$buildParamsMap_u24lambda_u2418 = new BufferedSinkJsonWriter((BufferedSink)buffer$iv, indent$iv);
            boolean bl = false;
            String query = sendDocument ? operation.document() : null;
            Companion.composePostParams($this$buildParamsMap_u24lambda_u2418, operation, customScalarAdapters, autoPersistQueries, sendEnhancedClientAwarenessExtensions, query);
            return buffer$iv.readByteString();
        }

        @NotNull
        public final <D extends Operation.Data> Map<String, Object> composePayload(@NotNull ApolloRequest<D> apolloRequest) {
            Intrinsics.checkNotNullParameter(apolloRequest, (String)"apolloRequest");
            Operation<D> operation = apolloRequest.getOperation();
            Boolean bl = apolloRequest.getSendApqExtensions();
            boolean sendApqExtensions = bl != null ? bl : false;
            boolean sendEnhancedClientAwarenessExtensions = apolloRequest.getSendEnhancedClientAwareness();
            Boolean bl2 = apolloRequest.getSendDocument();
            boolean sendDocument = bl2 != null ? bl2 : true;
            CustomScalarAdapters customScalarAdapters = (CustomScalarAdapters)apolloRequest.getExecutionContext().get(CustomScalarAdapters.Key);
            if (customScalarAdapters == null) {
                customScalarAdapters = CustomScalarAdapters.Empty;
            }
            CustomScalarAdapters customScalarAdapters2 = customScalarAdapters;
            String query = sendDocument ? operation.document() : null;
            boolean $i$f$buildJsonMap = false;
            MapJsonWriter writer$iv = new MapJsonWriter();
            JsonWriter $this$composePayload_u24lambda_u2419 = writer$iv;
            boolean bl3 = false;
            Companion.composePostParams($this$composePayload_u24lambda_u2419, operation, customScalarAdapters2, sendApqExtensions, sendEnhancedClientAwarenessExtensions, query);
            Object object = writer$iv.root();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
            return (Map)object;
        }

        private static final Unit extensionsWriter$lambda$2(JsonWriter jsonWriter) {
            Intrinsics.checkNotNullParameter((Object)jsonWriter, (String)"<this>");
            return Unit.INSTANCE;
        }

        private static final Unit extensionsWriter$lambda$6(boolean $sendApqExtensions, boolean $sendEnhancedClientAwarenessExtensions, String $apqId, JsonWriter jsonWriter) {
            boolean $i$f$writeObject;
            JsonWriter $this$writeObject$iv;
            Intrinsics.checkNotNullParameter((Object)jsonWriter, (String)"<this>");
            jsonWriter.name("extensions");
            JsonWriter $this$writeObject$iv2 = jsonWriter;
            boolean $i$f$writeObject2 = false;
            $this$writeObject$iv2.beginObject();
            JsonWriter $this$extensionsWriter_u24lambda_u246_u24lambda_u245 = $this$writeObject$iv2;
            boolean bl = false;
            if ($sendApqExtensions) {
                $this$extensionsWriter_u24lambda_u246_u24lambda_u245.name("persistedQuery");
                $this$writeObject$iv = $this$extensionsWriter_u24lambda_u246_u24lambda_u245;
                $i$f$writeObject = false;
                $this$writeObject$iv.beginObject();
                JsonWriter $this$extensionsWriter_u24lambda_u246_u24lambda_u245_u24lambda_u243 = $this$writeObject$iv;
                boolean bl2 = false;
                $this$extensionsWriter_u24lambda_u246_u24lambda_u245_u24lambda_u243.name("version").value(1);
                $this$extensionsWriter_u24lambda_u246_u24lambda_u245_u24lambda_u243.name("sha256Hash").value($apqId);
                $this$writeObject$iv.endObject();
            }
            if ($sendEnhancedClientAwarenessExtensions) {
                $this$extensionsWriter_u24lambda_u246_u24lambda_u245.name("clientLibrary");
                $this$writeObject$iv = $this$extensionsWriter_u24lambda_u246_u24lambda_u245;
                $i$f$writeObject = false;
                $this$writeObject$iv.beginObject();
                JsonWriter $this$extensionsWriter_u24lambda_u246_u24lambda_u245_u24lambda_u244 = $this$writeObject$iv;
                boolean bl3 = false;
                $this$extensionsWriter_u24lambda_u246_u24lambda_u245_u24lambda_u244.name("name").value("apollo-kotlin");
                $this$extensionsWriter_u24lambda_u246_u24lambda_u245_u24lambda_u244.name("version").value("5.0.0-alpha.2");
                $this$writeObject$iv.endObject();
            }
            $this$writeObject$iv2.endObject();
            return Unit.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[HttpMethod.values().length];
            try {
                nArray[HttpMethod.Get.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HttpMethod.Post.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

