/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.web.lang;

import com.apicatalog.web.lang.LanguageTag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.IntPredicate;
import java.util.regex.Pattern;

final class LanguageTagParser {
    private static final IntPredicate ASCII_ALPHA = ch -> 97 <= ch && ch <= 122 || 65 <= ch && ch <= 90;
    private static final IntPredicate ASCII_DIGIT = ch -> 48 <= ch && ch <= 57;
    private static final IntPredicate ASCII_ALPHA_NUM = ASCII_DIGIT.or(ASCII_ALPHA);
    private static final Pattern LANG_DEL_RE = Pattern.compile("-");
    private final String languageTag;
    private final String[] tags;
    private int tagIndex;
    private boolean verifierMode;
    private String language;
    private Collection<String> languageExtensions;
    private String script;
    private String region;
    private Collection<LanguageTag.Extension> extensions;
    private Collection<String> variants;
    private Collection<String> privateUse;

    LanguageTagParser(String languageTag, String[] tags, boolean verifierMode) {
        this.languageTag = languageTag;
        this.tags = tags;
        this.verifierMode = verifierMode;
        this.tagIndex = 0;
    }

    public static final LanguageTagParser create(String languageTag) {
        return LanguageTagParser.create(languageTag, false);
    }

    public static final boolean isWellFormed(String languageTag) {
        try {
            return languageTag != null && !languageTag.isBlank() && LanguageTagParser.create(languageTag, true).parse() == null;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    private static final LanguageTagParser create(String languageTag, boolean verifierMode) {
        if (languageTag == null) {
            throw new IllegalArgumentException();
        }
        String stripped = Objects.requireNonNull(languageTag, "The parameter 'laguageTag' must not be null").trim();
        if (stripped.length() == 0 || ASCII_ALPHA.negate().test(stripped.codePointAt(0)) || ASCII_ALPHA_NUM.negate().test(stripped.codePointAt(stripped.length() - 1))) {
            return new LanguageTagParser(languageTag, null, verifierMode);
        }
        String[] tags = LANG_DEL_RE.split(stripped);
        if (tags == null || tags.length == 0) {
            return new LanguageTagParser(languageTag, null, verifierMode);
        }
        return new LanguageTagParser(languageTag, tags, verifierMode);
    }

    LanguageTag parse() throws IllegalArgumentException {
        if (this.tags == null || this.tags.length == 0) {
            throw new IllegalArgumentException("The language tag [" + this.languageTag + "] is null or blank.");
        }
        this.tagIndex = 0;
        if (this.acceptAlpha(2, 3, this::setLanguage)) {
            if (this.acceptAlpha(3, this::addLanguageExtension)) {
                this.acceptAlpha(3, this::addLanguageExtension);
                this.acceptAlpha(3, this::addLanguageExtension);
            }
        } else if (!this.acceptAlpha(4, 8, this::setLanguage)) {
            if (this.acceptPrivateUse()) {
                if (this.tagIndex != this.tags.length) {
                    throw new IllegalArgumentException("The language tag [" + this.languageTag + "] is not well-formed.");
                }
                return this.verifierMode ? null : new LanguageTag(this.language, this.languageExtensions, this.script, this.region, this.extensions, this.variants, this.privateUse);
            }
            throw new IllegalArgumentException("The language tag [" + this.languageTag + "] is not well-formed.");
        }
        this.acceptAlpha(4, this::setScript);
        if (!this.acceptAlpha(2, this::setRegion)) {
            this.acceptDigit(3, this::setRegion);
        }
        while (this.acceptAlphaNun(5, 8, this::addVariant) || this.digitRange(0, 1) && this.alphaNumRange(1, 3) && this.accept(4, this::addVariant)) {
        }
        while (this.acceptDigit(1) || this.alphaRange(0, 1) && !this.tags[this.tagIndex].equalsIgnoreCase("x") && this.accept(1)) {
            char extensionCode = this.tags[this.tagIndex - 1].charAt(0);
            ArrayList<String> extensionTags = this.verifierMode ? List.of() : new ArrayList<String>();
            if (!this.acceptAlphaNun(2, 8, extensionTags::add)) {
                --this.tagIndex;
                break;
            }
            while (this.acceptAlphaNun(2, 8, extensionTags::add)) {
            }
            if (this.verifierMode) continue;
            this.addExtension(new LanguageTag.Extension(extensionCode, extensionTags));
        }
        this.acceptPrivateUse();
        if (this.tagIndex != this.tags.length) {
            throw new IllegalArgumentException("The language tag [" + this.languageTag + "] is not well-formed.");
        }
        return this.verifierMode ? null : new LanguageTag(this.language, this.languageExtensions, this.script, this.region, this.extensions, this.variants, this.privateUse);
    }

    private boolean acceptPrivateUse() {
        if (this.alphaRange(0, 1) && this.tags[this.tagIndex].equalsIgnoreCase("x") && this.accept(1)) {
            if (!this.acceptAlphaNun(1, 8, this::addPrivateUse)) {
                --this.tagIndex;
            } else {
                while (this.acceptAlphaNun(1, 8, this::addPrivateUse)) {
                }
                return true;
            }
        }
        return false;
    }

    private boolean acceptAlpha(int length, Consumer<String> consumer) {
        return this.acceptAlpha(length, length, consumer);
    }

    private boolean acceptAlpha(int min, int max, Consumer<String> consumer) {
        return this.accept(min, max, ASCII_ALPHA, consumer);
    }

    private boolean acceptDigit(int length) {
        return this.acceptDigit(length, length, null);
    }

    private boolean acceptDigit(int length, Consumer<String> consumer) {
        return this.acceptDigit(length, length, consumer);
    }

    private boolean acceptDigit(int min, int max, Consumer<String> consumer) {
        return this.accept(min, max, ASCII_DIGIT, consumer);
    }

    private boolean acceptAlphaNun(int min, int max, Consumer<String> consumer) {
        return this.accept(min, max, ASCII_ALPHA_NUM, consumer);
    }

    private boolean accept(int min, int max, IntPredicate predicate, Consumer<String> consumer) {
        if (this.tagIndex < this.tags.length && this.tags[this.tagIndex].length() >= min && this.tags[this.tagIndex].length() <= max && this.tags[this.tagIndex].chars().allMatch(predicate)) {
            if (!this.verifierMode && consumer != null) {
                consumer.accept(this.tags[this.tagIndex]);
            }
            ++this.tagIndex;
            return true;
        }
        return false;
    }

    private boolean accept(int length) {
        return this.accept(length, null);
    }

    private boolean accept(int length, Consumer<String> consumer) {
        if (this.tagIndex < this.tags.length && this.tags[this.tagIndex].length() == length) {
            if (!this.verifierMode && consumer != null) {
                consumer.accept(this.tags[this.tagIndex]);
            }
            ++this.tagIndex;
            return true;
        }
        return false;
    }

    private boolean alphaRange(int index, int length) {
        return this.range(index, length, ASCII_ALPHA);
    }

    private boolean alphaNumRange(int index, int length) {
        return this.range(index, length, ASCII_ALPHA_NUM);
    }

    private boolean digitRange(int index, int length) {
        return this.range(index, length, ASCII_DIGIT);
    }

    private boolean range(int index, int length, IntPredicate predicate) {
        return this.tagIndex < this.tags.length && index < this.tags[this.tagIndex].length() && index + length <= this.tags[this.tagIndex].length() && this.tags[this.tagIndex].substring(index, index + length).chars().allMatch(predicate);
    }

    private void setLanguage(String language) {
        this.language = language;
    }

    private void addLanguageExtension(String languageExtension) {
        if (this.languageExtensions == null) {
            this.languageExtensions = new ArrayList<String>();
        }
        this.languageExtensions.add(languageExtension);
    }

    private void setScript(String script) {
        this.script = script;
    }

    private void setRegion(String region) {
        this.region = region;
    }

    private void addVariant(String variant) {
        if (this.variants == null) {
            this.variants = new ArrayList<String>();
        }
        this.variants.add(variant);
    }

    private void addExtension(LanguageTag.Extension extension) {
        if (this.extensions == null) {
            this.extensions = new ArrayList<LanguageTag.Extension>();
        }
        this.extensions.add(extension);
    }

    private void addPrivateUse(String privateTag) {
        if (this.privateUse == null) {
            this.privateUse = new ArrayList<String>();
        }
        this.privateUse.add(privateTag);
    }
}

