/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.loader;

import com.apicatalog.jsonld.Document;
import com.apicatalog.jsonld.JsonLdException;
import com.apicatalog.jsonld.loader.DocumentLoader;
import java.net.URI;
import java.util.LinkedHashMap;
import java.util.Map;

public final class UriRewriter
implements DocumentLoader {
    private final Map<URI, URI> rewrite;
    private final Map<String, String> rebase;
    private final DocumentLoader loader;

    private UriRewriter(Map<URI, URI> rewrite, Map<String, String> rebase, DocumentLoader loader) {
        this.rewrite = rewrite;
        this.rebase = rebase;
        this.loader = loader;
    }

    public static final Builder newBuilder(DocumentLoader loader) {
        return new Builder(Map.of(), Map.of(), loader);
    }

    public static final Builder copyOf(UriRewriter rewriter) {
        return new Builder(rewriter.rewrite, rewriter.rebase, rewriter.loader);
    }

    @Override
    public Document loadDocument(URI url, DocumentLoader.Options options) throws JsonLdException {
        URI target = this.rewrite.get(url);
        if (target != null) {
            Document document = this.loader.loadDocument(target, options);
            if (document != null && document.url() != null && target.equals(document.url())) {
                return Document.of(document.content(), document.contentType(), document.profile(), url, document.context());
            }
            return document;
        }
        Map.Entry<String, String> base = null;
        for (Map.Entry<String, String> entry : this.rebase.entrySet()) {
            if (!url.toString().startsWith(entry.getKey())) continue;
            base = entry;
            break;
        }
        if (base != null) {
            String relativeTarget = url.toString().substring(((String)base.getKey()).length());
            Document document = this.loader.loadDocument(URI.create(base.getValue() + relativeTarget), options);
            if (document != null && document.url() != null && document.url().toString().startsWith(base.getValue())) {
                String relativeSource = document.url().toString().substring(base.getValue().length());
                return Document.of(document.content(), document.contentType(), document.profile(), URI.create(base.getKey() + relativeSource), document.context());
            }
            return document;
        }
        return this.loader.loadDocument(url, options);
    }

    public static final class Builder {
        private final Map<URI, URI> rewrite;
        private final Map<String, String> rebase;
        private DocumentLoader loader;

        Builder(Map<URI, URI> resources, Map<String, String> rebase, DocumentLoader loader) {
            this.rewrite = new LinkedHashMap<URI, URI>(resources);
            this.rebase = new LinkedHashMap<String, String>(rebase);
            this.loader = loader;
        }

        public Builder rewrite(String from, String to) {
            return this.rewrite(URI.create(from), URI.create(to));
        }

        public Builder rewrite(URI from, URI to) {
            this.rewrite.put(from, to);
            return this;
        }

        public Builder rebase(String from, String to) {
            this.rebase.put(from, to);
            return this;
        }

        public Builder loader(DocumentLoader loader) {
            this.loader = loader;
            return this;
        }

        public UriRewriter build() {
            return new UriRewriter(Map.copyOf(this.rewrite), Map.copyOf(this.rebase), this.loader);
        }
    }
}

