/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.loader;

import com.apicatalog.jsonld.JsonLdException;
import com.apicatalog.jsonld.loader.HttpLoader;
import com.apicatalog.jsonld.loader.HttpLoaderClient;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.net.http.HttpTimeoutException;
import java.time.Duration;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;

final class NativeHttpClient
implements HttpLoaderClient {
    private final HttpClient httpClient;
    private Duration timeout;
    private Collection<Map.Entry<String, String>> headers;

    NativeHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
        this.timeout = null;
        this.headers = null;
    }

    @Override
    public HttpLoaderClient.Response send(URI targetUri, Collection<String> requestProfiles) throws JsonLdException {
        HttpRequest.Builder request = HttpRequest.newBuilder().GET().uri(targetUri).header("Accept", HttpLoader.acceptHeader(requestProfiles));
        if (this.headers != null && !this.headers.isEmpty()) {
            this.headers.forEach(h -> request.header((String)h.getKey(), (String)h.getValue()));
        }
        if (this.timeout != null && !this.timeout.isNegative() && !this.timeout.isZero()) {
            request.timeout(this.timeout);
        }
        try {
            return new HttpResponseImpl(this.httpClient.send(request.build(), HttpResponse.BodyHandlers.ofInputStream()));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new JsonLdException(JsonLdException.ErrorCode.LOADING_DOCUMENT_FAILED, (Throwable)e);
        }
        catch (HttpTimeoutException e) {
            throw new JsonLdException(JsonLdException.ErrorCode.LOADING_DOCUMENT_TIMEOUT, (Throwable)e);
        }
        catch (IOException e) {
            throw new JsonLdException(JsonLdException.ErrorCode.LOADING_DOCUMENT_FAILED, (Throwable)e);
        }
    }

    @Override
    public HttpLoaderClient timeout(Duration timeout) {
        this.timeout = timeout;
        return this;
    }

    @Override
    public HttpLoaderClient headers(Collection<Map.Entry<String, String>> headers) {
        this.headers = headers;
        return this;
    }

    private static class HttpResponseImpl
    implements HttpLoaderClient.Response {
        private final HttpResponse<InputStream> response;

        HttpResponseImpl(HttpResponse<InputStream> response) {
            this.response = response;
        }

        @Override
        public InputStream body() {
            return this.response.body();
        }

        @Override
        public Collection<String> links() {
            return this.response.headers().map().get("link");
        }

        @Override
        public Optional<String> contentType() {
            return this.response.headers().firstValue("content-type");
        }

        @Override
        public Optional<String> location() {
            return this.response.headers().firstValue("location");
        }

        @Override
        public int statusCode() {
            return this.response.statusCode();
        }

        @Override
        public void close() {
        }
    }
}

