/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.loader;

import com.apicatalog.jsonld.Document;
import com.apicatalog.jsonld.JsonLdException;
import com.apicatalog.jsonld.loader.DocumentLoader;
import com.apicatalog.jsonld.loader.LruCache;
import java.net.URI;

public final class CacheLoader
implements DocumentLoader {
    private final DocumentLoader loader;
    private final Cache<Key, Document> cache;

    public CacheLoader(DocumentLoader loader, int cacheSize) {
        this(loader, new LruCache<Key, Document>(cacheSize));
    }

    public CacheLoader(DocumentLoader loader, Cache<Key, Document> cache) {
        this.loader = loader;
        this.cache = cache;
    }

    @Override
    public Document loadDocument(URI url, DocumentLoader.Options options) throws JsonLdException {
        Key key = new Key(url, options);
        Document result = this.cache.get(key);
        if (result == null) {
            result = this.loader.loadDocument(url, options);
            this.cache.put(key, result);
        }
        return result;
    }

    public static interface Cache<K, V> {
        public boolean containsKey(K var1);

        public V get(K var1);

        public void put(K var1, V var2);
    }

    private record Key(URI url, DocumentLoader.Options options) {
    }
}

