/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.framing;

import com.apicatalog.jsonld.JsonLdException;
import com.apicatalog.jsonld.framing.Frame;
import com.apicatalog.jsonld.framing.FramingState;
import com.apicatalog.jsonld.lang.Keywords;
import com.apicatalog.jsonld.lang.LdAdapter;
import com.apicatalog.tree.io.java.NativeAdapter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class FrameMatcher {
    private FramingState state;
    private Frame frame;
    private boolean requireAll;

    private FrameMatcher(FramingState state, Frame frame, boolean requireAll) {
        this.state = state;
        this.frame = frame;
        this.requireAll = requireAll;
    }

    public static final FrameMatcher with(FramingState state, Frame frame, boolean requireAll) {
        return new FrameMatcher(state, frame, requireAll);
    }

    public List<String> match(Collection<String> subjects) throws JsonLdException {
        if (this.frame.isWildCard()) {
            return new ArrayList<String>(subjects);
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String subject : subjects) {
            if (!this.match(this.state.getGraphMap().find(this.state.getGraphName(), subject).orElse(Map.of()))) continue;
            result.add(subject);
        }
        return result;
    }

    public boolean match(Map<?, ?> node) throws JsonLdException {
        int count = 0;
        boolean nonKeywordProperty = false;
        for (String property : this.frame.keys()) {
            Collection<Object> nodeValues;
            Collection array;
            Frame propertyFrame;
            Object propertyValue;
            Object nodeValue;
            block52: {
                block54: {
                    block53: {
                        block48: {
                            block51: {
                                block50: {
                                    block49: {
                                        nodeValue = node.get(property);
                                        if (!"@id".equals(property)) break block48;
                                        nodeValue = nodeValue instanceof Collection ? nodeValue : List.of(nodeValue);
                                        propertyValue = this.frame.get(property);
                                        if (!(propertyValue instanceof Collection)) break block49;
                                        Collection array2 = (Collection)propertyValue;
                                        if (array2.stream().anyMatch(((Collection)nodeValue)::contains)) break block50;
                                    }
                                    if (!this.frame.isWildCard("@id") && !this.frame.isNone("@id")) break block51;
                                }
                                if (this.requireAll) {
                                    ++count;
                                    continue;
                                }
                                return true;
                            }
                            return false;
                        }
                        if (!"@type".equals(property)) break block52;
                        if (nodeValue != null && !((Collection)nodeValue).isEmpty() && this.frame.isWildCard(property) || (nodeValue == null || ((Collection)nodeValue).isEmpty()) && this.frame.isNone(property) || this.frame.isDefaultObject(property)) break block53;
                        if (nodeValue == null) break block54;
                        if (!this.frame.asCollection(property).stream().anyMatch(((Collection)nodeValue)::contains)) break block54;
                    }
                    if (this.requireAll) {
                        ++count;
                        continue;
                    }
                    return true;
                }
                return false;
            }
            if (Keywords.matchForm(property)) continue;
            nonKeywordProperty = true;
            propertyValue = this.frame.get(property);
            Frame frame = propertyFrame = propertyValue instanceof Collection && !(array = (Collection)propertyValue).isEmpty() ? Frame.of(array) : null;
            if (nodeValue instanceof Collection) {
                Collection array3 = (Collection)nodeValue;
                v1 = array3;
            } else {
                v1 = nodeValues = nodeValue != null ? List.of(nodeValue) : List.of();
            }
            if (nodeValues.isEmpty() && propertyFrame != null && propertyFrame.containsOnly("@default")) continue;
            if (nodeValues.isEmpty() && this.frame.isNone(property)) {
                if (this.requireAll) {
                    ++count;
                    continue;
                }
                return true;
            }
            if (!nodeValues.isEmpty() && this.frame.isNone(property)) {
                return false;
            }
            if (!nodeValues.isEmpty() && propertyFrame != null && propertyFrame.isWildCard()) {
                if (this.requireAll) {
                    ++count;
                    continue;
                }
                return true;
            }
            if (propertyFrame == null) {
                if (nodeValues.isEmpty()) {
                    if (this.requireAll) {
                        ++count;
                        continue;
                    }
                    return true;
                }
            } else if (propertyFrame.isList()) {
                Map nodeValueMap;
                Object object;
                Object listValue = propertyFrame.get("@list");
                if (!nodeValues.isEmpty() && (object = nodeValues.iterator().next()) instanceof Map && LdAdapter.isList(nodeValueMap = (Map)object)) {
                    Map map;
                    Map first = (Map)nodeValues.iterator().next();
                    Object nodeListValue = first.get("@list");
                    Object e = ((Collection)listValue).iterator().next();
                    if (e instanceof Map && LdAdapter.isValueNode(map = (Map)e)) {
                        frame = Frame.of(listValue);
                        match = false;
                        var17_18 = NativeAdapter.asCollection(nodeListValue).iterator();
                        while (var17_18.hasNext() && !(match = frame.matchValue(value = var17_18.next()))) {
                        }
                        if (match) {
                            if (this.requireAll) {
                                ++count;
                                continue;
                            }
                            return true;
                        }
                    } else if (LdAdapter.isNode(((Collection)listValue).iterator().next()) || LdAdapter.isReference(((Collection)listValue).iterator().next())) {
                        frame = Frame.of(listValue);
                        match = false;
                        var17_18 = NativeAdapter.asCollection(nodeListValue).iterator();
                        while (var17_18.hasNext() && !(match = frame.matchNode(this.state, value = var17_18.next(), this.requireAll))) {
                        }
                        if (match) {
                            if (this.requireAll) {
                                ++count;
                                continue;
                            }
                            return true;
                        }
                    }
                }
            } else if (propertyFrame.isValuePattern()) {
                if (nodeValues.stream().anyMatch(propertyFrame::matchValue)) {
                    if (this.requireAll) {
                        ++count;
                        continue;
                    }
                    return true;
                }
            } else if (propertyFrame.isReference()) {
                boolean match = false;
                if (!nodeValues.isEmpty()) {
                    Object values;
                    Iterator<Object> iterator = nodeValues.iterator();
                    while (iterator.hasNext() && !(match = propertyFrame.matchNode(this.state, values = iterator.next(), this.requireAll))) {
                    }
                }
                if (match) {
                    if (this.requireAll) {
                        ++count;
                        continue;
                    }
                    return true;
                }
            } else if (!nodeValues.isEmpty()) {
                if (this.requireAll) {
                    ++count;
                    continue;
                }
                return true;
            }
            if (!this.requireAll) continue;
            return false;
        }
        return !nonKeywordProperty || count > 0;
    }
}

