/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.flattening;

import com.apicatalog.jsonld.flattening.BlankNodeIdGenerator;
import com.apicatalog.jsonld.lang.Keywords;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public final class NodeMap {
    private final Map<String, Map<String, Map<String, Object>>> index = new LinkedHashMap<String, Map<String, Map<String, Object>>>();
    private final BlankNodeIdGenerator generator;

    public NodeMap() {
        this(new BlankNodeIdGenerator());
    }

    public NodeMap(BlankNodeIdGenerator generator) {
        this.index.put("@default", new LinkedHashMap());
        this.generator = generator;
    }

    public void set(String graphName, String subject, String property, Object value) {
        this.index.computeIfAbsent(graphName, x -> new LinkedHashMap()).computeIfAbsent(subject, x -> new LinkedHashMap()).put(property, value);
    }

    public Optional<Map<String, Map<String, Object>>> find(String graphName) {
        return Optional.ofNullable(this.index.get(graphName));
    }

    public Optional<Map<String, ?>> find(String graphName, String subject) {
        return Optional.ofNullable(this.index.get(graphName)).map(g -> (Map)g.get(subject));
    }

    public Object get(String graphName, String subject, String property) {
        return Optional.ofNullable(this.index.get(graphName)).map(g -> (Map)g.get(subject)).map(s -> s.get(property)).orElse(null);
    }

    public boolean contains(String graphName, String subject, String property) {
        return Optional.ofNullable(this.index.get(graphName)).map(g -> (Map)g.get(subject)).map(s -> s.containsKey(property)).orElse(false);
    }

    public String createIdentifier(String name) {
        return this.generator.createIdentifier(name);
    }

    public String createIdentifier() {
        return this.generator.createIdentifier();
    }

    public Collection<String> graphs() {
        return this.index.keySet();
    }

    public Collection<String> subjects(String graphName) {
        return this.index.getOrDefault(graphName, Map.of()).keySet();
    }

    public Collection<String> properties(String graphName, String subject) {
        return this.index.getOrDefault(graphName, Map.of()).getOrDefault(subject, Map.of()).keySet();
    }

    public boolean contains(String id) {
        return this.index.containsKey(id);
    }

    public String toString() {
        return Objects.toString(this.index);
    }

    public void merge() {
        NodeMap result = new NodeMap();
        for (Map.Entry<String, Map<String, Map<String, Object>>> graphEntry : this.index.entrySet()) {
            for (Map.Entry<String, Map<String, Object>> subject : graphEntry.getValue().entrySet()) {
                if (result.find("@merged", subject.getKey()).isEmpty()) {
                    result.set("@merged", subject.getKey(), "@id", subject.getKey());
                }
                for (Map.Entry<String, Object> property : subject.getValue().entrySet()) {
                    ArrayList mergedValues;
                    if (!"@type".equals(property.getKey()) && Keywords.matchForm(property.getKey())) {
                        result.set("@merged", subject.getKey(), property.getKey(), property.getValue());
                        continue;
                    }
                    Object object = result.get("@merged", subject.getKey(), property.getKey());
                    if (object instanceof Collection) {
                        Collection values = (Collection)object;
                        if (values instanceof ArrayList) {
                            ArrayList list;
                            ArrayList typedList;
                            mergedValues = typedList = (list = (ArrayList)values);
                        } else {
                            mergedValues = new ArrayList(values);
                            result.set("@merged", subject.getKey(), property.getKey(), mergedValues);
                        }
                    } else {
                        mergedValues = new ArrayList();
                        result.set("@merged", subject.getKey(), property.getKey(), mergedValues);
                    }
                    object = property.getValue();
                    if (object instanceof Collection) {
                        Collection properties = (Collection)object;
                        mergedValues.addAll(properties);
                        continue;
                    }
                    mergedValues.add(property.getValue());
                }
            }
        }
        if (result.index.get("@merged") != null) {
            this.index.put("@merged", result.index.get("@merged"));
        }
    }
}

