/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.expansion;

import com.apicatalog.jsonld.JsonLdException;
import com.apicatalog.jsonld.Options;
import com.apicatalog.jsonld.context.Context;
import com.apicatalog.jsonld.context.TermDefinition;
import com.apicatalog.jsonld.expansion.ObjectExpansion;
import com.apicatalog.jsonld.expansion.ValueExpansion;
import com.apicatalog.jsonld.lang.LdAdapter;
import com.apicatalog.jsonld.processor.ExecutionEvents;
import com.apicatalog.tree.io.NodeType;
import com.apicatalog.tree.io.TreeAdapter;
import com.apicatalog.tree.io.TreeIO;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class Expansion {
    public static final Object expand(Context activeContext, Object node, TreeAdapter nodeAdapter, String activeProperty, String term, String expandedTerm, Params params) throws JsonLdException {
        if (nodeAdapter.isNull(node)) {
            return null;
        }
        NodeType nodeType = nodeAdapter.type(node);
        if (nodeType == NodeType.COLLECTION) {
            return Expansion.array(activeContext, node, nodeAdapter, activeProperty, term, expandedTerm, params);
        }
        TreeIO propertyContext = activeContext.findTerm(activeProperty).map(TermDefinition::getLocalContext).orElse(null);
        if (params.runtime().collectsContextKeys() && propertyContext != null && propertyContext.isMap()) {
            params.runtime().onContextKeys(propertyContext.keyStream().map(arg_0 -> ((TreeAdapter)propertyContext.adapter()).asString(arg_0)).toList());
        }
        if (nodeType.isScalar()) {
            Map<String, ?> scalar = Expansion.scalar(activeContext, activeProperty, propertyContext, node, nodeAdapter, params);
            if ("@set".equals(expandedTerm)) {
                params.runtime().term(term, null);
            }
            return scalar;
        }
        params.runtime().tick();
        return new ObjectExpansion(propertyContext, node, nodeAdapter, new Params(params.frameExpansion && !"@default".equals(activeProperty), params.fromMap, params.baseUrl, params.options, params.runtime)).term(term).expand(activeContext, activeProperty);
    }

    static final Map<String, ?> scalar(Context context, String property, TreeIO propertyContext, Object node, TreeAdapter nodeAdapter, Params params) throws JsonLdException {
        if (property == null || "@graph".equals(property)) {
            return null;
        }
        if (propertyContext != null) {
            return ValueExpansion.expand(context.newContext(params.options().loader(), params.runtime()).build(propertyContext, context.findTerm(property).map(TermDefinition::getBaseUrl).orElse(null)), property, node, nodeAdapter, params);
        }
        return ValueExpansion.expand(context, property, node, nodeAdapter, params);
    }

    static final Collection<?> array(Context context, Object node, TreeAdapter nodeAdapter, String property, String term, String expandedTerm, Params params) throws JsonLdException {
        boolean indexedSingleton;
        if (nodeAdapter.isEmptyCollection(node)) {
            return List.of();
        }
        boolean bl = indexedSingleton = "@index".equals(expandedTerm) && (nodeAdapter.type(node) != NodeType.COLLECTION || nodeAdapter.isSingleElement(node));
        if (!indexedSingleton) {
            params.runtime().beginList(term);
        }
        ArrayList result = new ArrayList();
        int counter = 0;
        for (Object item : nodeAdapter.asIterable(node)) {
            params.runtime().tick();
            Map<String, ?> expanded = Expansion.expand(context, item, nodeAdapter, property, indexedSingleton ? term : Integer.toString(counter++), null, params);
            if (expanded instanceof Collection) {
                Collection list = (Collection)((Object)expanded);
                if (context.findTerm(property).map(TermDefinition::getContainerMapping).filter(c -> c.contains("@list")).isPresent()) {
                    expanded = LdAdapter.toList(list);
                }
            }
            if (expanded instanceof Collection) {
                Collection collection = (Collection)((Object)expanded);
                collection.stream().filter(Objects::nonNull).forEach(result::add);
                continue;
            }
            if (expanded == null) continue;
            result.add(expanded);
        }
        if (!indexedSingleton) {
            params.runtime().endList(term);
        }
        return result;
    }

    public record Params(boolean frameExpansion, boolean fromMap, URI baseUrl, Options options, ExecutionEvents runtime) {
    }
}

