/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.web.uri;

import com.apicatalog.web.uri.UriUtils;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;

public final class UriResolver {
    private UriResolver() {
    }

    public static final String resolve(URI base, String relative) {
        if (base == null) {
            return relative;
        }
        return UriResolver.resolve(base, UriUtils.create(relative));
    }

    public static final String resolve(URI base, URI relative) {
        if (relative == null) {
            return base != null ? base.toString() : null;
        }
        if (base == null) {
            return relative.toString();
        }
        String[] components = UriResolver.resolveAsComponents(base, relative);
        return UriUtils.recompose(components[0], components[1], components[2], components[3], components[4]);
    }

    public static final URI resolveAsUri(URI base, String relative) {
        if (relative == null || relative.isBlank()) {
            return base;
        }
        if (base == null) {
            return UriUtils.create(relative);
        }
        return UriResolver.resolveAsUri(base, UriUtils.create(relative));
    }

    public static final URI resolveAsUri(URI base, URI relative) {
        if (relative == null) {
            return base;
        }
        if (base == null) {
            return relative;
        }
        String[] components = UriResolver.resolveAsComponents(base, relative);
        try {
            if (components[0] != null && components[1] == null) {
                return new URI(components[0], components[2].trim().isEmpty() ? "." : components[2], components[4]);
            }
            return new URI(components[0], components[1], components[2], components[3], components[4]);
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(e);
        }
    }

    private static final String[] resolveAsComponents(URI base, URI relative) {
        String basePath = base.getPath();
        String baseAuthority = base.getAuthority();
        String componentPath = relative.getPath();
        if (baseAuthority == null && base.getSchemeSpecificPart().startsWith("///")) {
            baseAuthority = "";
        }
        if (basePath == null && base.getSchemeSpecificPart() != null) {
            basePath = base.getSchemeSpecificPart();
        }
        if (componentPath == null && relative.getSchemeSpecificPart() != null) {
            componentPath = relative.getSchemeSpecificPart();
        }
        String[] target = new String[5];
        target[4] = relative.getFragment();
        if (relative.getScheme() != null && !relative.getScheme().isBlank()) {
            target[0] = relative.getScheme();
            target[1] = relative.getAuthority();
            target[2] = UriResolver.removeDotSegments(componentPath);
            target[3] = relative.getQuery();
        } else {
            if (relative.getAuthority() != null && !relative.getAuthority().isBlank()) {
                target[1] = relative.getAuthority();
                target[2] = UriResolver.removeDotSegments(componentPath);
                target[3] = relative.getQuery();
            } else {
                if (componentPath != null && !componentPath.isBlank()) {
                    target[2] = componentPath.startsWith("/") ? UriResolver.removeDotSegments(componentPath) : (basePath != null && !basePath.isBlank() ? UriResolver.removeDotSegments(UriResolver.merge(basePath, componentPath)) : "/" + UriResolver.removeDotSegments(componentPath));
                    target[3] = relative.getQuery();
                } else {
                    target[2] = basePath;
                    target[3] = relative.getQuery() != null ? relative.getQuery() : base.getQuery();
                }
                target[1] = baseAuthority;
            }
            target[0] = base.getScheme();
        }
        return target;
    }

    private static final String removeDotSegments(String path) {
        if (path == null) {
            return null;
        }
        Object input = path;
        ArrayList<Object> output = new ArrayList<Object>();
        while (input != null && !((String)input).isBlank()) {
            if (((String)input).startsWith("../")) {
                input = ((String)input).substring(3);
                continue;
            }
            if (((String)input).startsWith("./")) {
                input = ((String)input).substring(2);
                continue;
            }
            if (((String)input).startsWith("/./")) {
                input = "/" + ((String)input).substring(3);
                continue;
            }
            if ("/.".equals(input)) {
                input = "/";
                continue;
            }
            if (((String)input).startsWith("/../")) {
                input = "/" + ((String)input).substring(4);
                if (output.isEmpty()) continue;
                output.remove(output.size() - 1);
                continue;
            }
            if ("/..".equals(input)) {
                input = "/";
                if (output.isEmpty()) continue;
                output.remove(output.size() - 1);
                continue;
            }
            if ("..".equals(input) || ".".equals(input)) {
                input = "";
                continue;
            }
            int nextSlashIndex = ((String)input).indexOf(47, 1);
            if (nextSlashIndex != -1) {
                output.add(((String)input).substring(0, nextSlashIndex));
                input = ((String)input).substring(nextSlashIndex);
                continue;
            }
            output.add(input);
            input = "";
        }
        return String.join((CharSequence)"", output);
    }

    private static final String merge(String basePath, String path) {
        if (basePath == null) {
            return "/" + path;
        }
        int rightMostSlash = basePath.lastIndexOf(47);
        if (rightMostSlash == -1) {
            return path;
        }
        return basePath.substring(0, rightMostSlash + 1) + path;
    }
}

