/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.web.media;

import com.apicatalog.web.media.MediaTypeParser;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public record MediaType(String type, String subtype, Map<String, List<String>> parameters) {
    private static final String TYPE_APPLICATION = "application";
    private static final String TYPE_TEXT = "text";
    private static final String WILDCARD = "*";
    public static final MediaType HTML = new MediaType("text", "html");
    public static final MediaType JSON_LD = new MediaType("application", "ld+json");
    public static final MediaType JSON = new MediaType("application", "json");
    public static final MediaType XHTML = new MediaType("application", "xhtml+xml");
    public static final MediaType N_QUADS = new MediaType("application", "n-quads");
    public static final MediaType CBOR_LD = new MediaType("application", "ld+cbor");
    public static final MediaType CBOR = new MediaType("application", "cbor");
    public static final MediaType YAML_LD = new MediaType("application", "ld+yaml");
    public static final MediaType YAML = new MediaType("application", "yaml");
    public static final MediaType ANY = new MediaType("*", "*");

    public MediaType {
        Objects.requireNonNull(type);
        Objects.requireNonNull(subtype);
        parameters = parameters == null ? Map.of() : Map.copyOf(parameters);
    }

    public MediaType(String type, String subtype) {
        this(type, subtype, null);
    }

    public static final MediaType of(String value) {
        if (Objects.requireNonNull(value).isBlank()) {
            return null;
        }
        return MediaTypeParser.parse(value);
    }

    public boolean match(MediaType mediaType) {
        return mediaType != null && this.match(mediaType.type, mediaType.subtype);
    }

    public boolean match(String type, String subtype) {
        return !(!WILDCARD.equals(this.type) && !WILDCARD.equals(type) && !Objects.equals(this.type, type) || !WILDCARD.equals(this.subtype) && !WILDCARD.equals(subtype) && !Objects.equals(this.subtype, subtype));
    }

    @Override
    public String toString() {
        if (this.parameters.isEmpty()) {
            return this.type + "/" + this.subtype;
        }
        StringBuilder builder = new StringBuilder(this.type).append('/').append(this.subtype);
        this.parameters.forEach((name, values) -> {
            for (String value : values) {
                boolean needsQuotes;
                boolean bl = needsQuotes = value.indexOf(32) >= 0 || !value.matches("[A-Za-z0-9!#$%&'*+.^_`|~-]+");
                if (needsQuotes) {
                    builder.append("; ").append((String)name).append("=\"").append(value).append('\"');
                    continue;
                }
                builder.append("; ").append((String)name).append('=').append(value);
            }
        });
        return builder.toString();
    }

    public Set<String> parameterNames() {
        return this.parameters.keySet();
    }

    public List<String> parameters(String name) {
        return Optional.ofNullable(this.parameters.get(name)).map(List::copyOf).orElse(List.of());
    }

    public Optional<String> findFirstParameter(String name) {
        return Optional.ofNullable(this.parameters.get(name)).map(p -> (String)p.get(0));
    }
}

