/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.processor;

import com.apicatalog.jsonld.Document;
import com.apicatalog.jsonld.JsonLdException;
import com.apicatalog.jsonld.Options;
import com.apicatalog.jsonld.flattening.NodeMap;
import com.apicatalog.jsonld.flattening.NodeMapBuilder;
import com.apicatalog.jsonld.processor.Execution;
import com.apicatalog.jsonld.processor.Expander;
import com.apicatalog.jsonld.tordf.JsonLdToQuads;
import com.apicatalog.rdf.api.RdfQuadConsumer;
import com.apicatalog.tree.io.TreeIO;
import java.util.Collection;

public final class RdfEmitter {
    private RdfEmitter() {
    }

    public void provide(Document document, RdfQuadConsumer consumer, Options options, Execution runtime) throws JsonLdException {
        RdfEmitter.toRdf(document, consumer, options, runtime);
    }

    public static final void toRdf(Document input, RdfQuadConsumer consumer, Options options, Execution runtime) throws JsonLdException {
        Options expansionOptions = Options.copyOf(options);
        expansionOptions.mode(options.mode());
        expansionOptions.base(options.base());
        expansionOptions.expandContext(options.expandContext());
        Collection<?> expanded = Expander.expand(input, expansionOptions, runtime);
        RdfEmitter.toRdf(expanded, consumer, options, runtime);
    }

    public static final void toRdf(TreeIO input, RdfQuadConsumer consumer, Options options, Execution runtime) throws JsonLdException {
        Options expansionOptions = Options.copyOf(options);
        expansionOptions.mode(options.mode());
        expansionOptions.base(options.base());
        expansionOptions.expandContext(options.expandContext());
        Collection<?> expanded = Expander.expand(input, Expander.context(null, null, options, runtime), options.base(), expansionOptions, runtime);
        RdfEmitter.toRdf(expanded, consumer, options, runtime);
    }

    public static final void toRdf(Collection<?> expanded, RdfQuadConsumer consumer, Options options, Execution runtime) throws JsonLdException {
        JsonLdToQuads.with(new NodeMapBuilder(expanded, new NodeMap()).build()).produceGeneralizedRdf(options.isProduceGeneralizedRdf()).rdfJsonLiteralWriter(options.rdfJsonLiteralWriter()).rdfDirection(options.rdfDirection()).uriValidation(options.uriValidation()).provide(consumer);
    }
}

