/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.processor;

import com.apicatalog.jsonld.JsonLdException;
import com.apicatalog.jsonld.Options;
import com.apicatalog.jsonld.processor.TypeMapCollector;
import java.time.Duration;
import java.util.function.Consumer;

public class Execution {
    protected Consumer<String> contextKeyCollector;
    protected Counter nodeCounter;
    protected Counter ttl;

    protected Execution(Counter ttl, Counter nodeCounter, Consumer<String> contextKeyCollector) {
        this.ttl = ttl;
        this.nodeCounter = nodeCounter;
        this.contextKeyCollector = contextKeyCollector;
    }

    public static Execution of(Options options) {
        return new Execution(options.timeout() != null ? new Ticker(options.timeout())::tick : null, null, null);
    }

    @Deprecated
    public void tick() throws JsonLdException {
        if (this.ttl != null) {
            this.ttl.increment();
        }
    }

    public Execution start() throws JsonLdException {
        if (this.ttl != null) {
            this.ttl.increment();
        }
        return this;
    }

    public void onBeforeMap(String parentKey) throws JsonLdException {
        if (this.nodeCounter != null) {
            this.nodeCounter.increment();
        }
    }

    public void onAfterMap(String parentKey) throws JsonLdException {
    }

    public void onTypeKey(String type) throws JsonLdException {
    }

    public void onContextKey(String key) {
        this.contextKeyCollector.accept(key);
    }

    public TypeMapCollector typeMapper() {
        return null;
    }

    public boolean collectsContextKeys() {
        return this.contextKeyCollector != null;
    }

    public Execution contextKeyCollector(Consumer<String> consumer) {
        this.contextKeyCollector = consumer;
        return this;
    }

    @FunctionalInterface
    public static interface Counter {
        public void increment() throws JsonLdException;
    }

    static class Ticker {
        private final long ttl;
        private long ticker;

        private Ticker(Duration ttl) {
            this.ttl = ttl.toMillis();
            this.ticker = 0L;
        }

        void tick() throws JsonLdException {
            if (this.ticker == 0L) {
                this.ticker = System.currentTimeMillis();
                return;
            }
            long now = System.currentTimeMillis();
            long elapsed = this.ttl - (now - this.ticker);
            if (elapsed <= 0L) {
                this.ticker = 0L;
                throw new JsonLdException(JsonLdException.ErrorCode.PROCESSING_TIMEOUT_EXCEEDED);
            }
        }
    }

    static class NodeThrottle {
        private final int maxNodes;
        private int counter;

        private NodeThrottle(int maxNodes) {
            this.maxNodes = maxNodes;
            this.counter = 0;
        }

        void increment() throws JsonLdException {
            if (++this.counter >= this.maxNodes) {
                throw new JsonLdException(JsonLdException.ErrorCode.UNSPECIFIED);
            }
        }
    }
}

