/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.processor;

import com.apicatalog.jsonld.Document;
import com.apicatalog.jsonld.JsonLdException;
import com.apicatalog.jsonld.Options;
import com.apicatalog.jsonld.compaction.Compaction;
import com.apicatalog.jsonld.compaction.UriCompaction;
import com.apicatalog.jsonld.context.Context;
import com.apicatalog.jsonld.processor.Execution;
import com.apicatalog.jsonld.processor.Expander;
import com.apicatalog.tree.io.TreeIO;
import java.net.URI;
import java.util.Collection;
import java.util.Map;

public final class Compactor {
    private Compactor() {
    }

    public static final Collection<?> expand(TreeIO input, Options options, Execution runtime) throws JsonLdException {
        Options expansionOptions = Options.copyOf(options).ordered(false).extractAllScripts(false);
        return Expander.expand(input, Expander.context(null, null, options, runtime), Expander.baseUrl(null, options), expansionOptions, runtime);
    }

    public static final Map<String, ?> compact(Document input, Document context, Options options, Execution runtime) throws JsonLdException {
        Collection<?> expandedInput = Expander.expand(input, Options.copyOf(options).ordered(false).extractAllScripts(false), runtime);
        return Compactor.compact(expandedInput, input.url(), context.content(), options, runtime);
    }

    public static final Map<String, ?> compact(Object expanded, URI baseUrl, TreeIO context, Options options, Execution runtime) throws JsonLdException {
        URI contextBase = baseUrl;
        if (contextBase == null) {
            contextBase = options.base();
        }
        TreeIO localContext = Context.unwrap(context);
        Context.Builder builder = new Context.Builder(options.mode()).runtime(runtime).loader(options.loader()).update(localContext, contextBase);
        if (builder.baseUri() == null) {
            if (options.base() != null) {
                builder.baseUri(options.base());
            } else if (options.isCompactToRelative()) {
                builder.baseUri(baseUrl);
            }
        }
        return Compactor.compact(expanded, builder.build(), localContext, options, runtime);
    }

    static final Map<String, ?> compact(Object expanded, Context context, TreeIO contextSource, Options options, Execution runtime) throws JsonLdException {
        Map map;
        Context activeContext = context;
        Object compactedOutput = Compaction.with(activeContext, options, runtime).compactArrays(options.isCompactArrays()).ordered(options.isOrdered()).compact(expanded);
        if (compactedOutput instanceof Collection) {
            Collection col = (Collection)compactedOutput;
            if (col.isEmpty()) {
                return Map.of();
            }
            if (!TreeIO.isEmptyOrNull((TreeIO)contextSource)) {
                return Map.of("@context", contextSource, UriCompaction.withVocab(context, "@graph", options), compactedOutput);
            }
            return Map.of(UriCompaction.withVocab(context, "@graph", options), compactedOutput);
        }
        if (compactedOutput == null || compactedOutput instanceof Map && (map = (Map)compactedOutput).isEmpty()) {
            return Map.of();
        }
        if (compactedOutput instanceof Map) {
            Map typedMap = map = (Map)compactedOutput;
            if (contextSource != null) {
                return Context.inject(typedMap, contextSource);
            }
            return typedMap;
        }
        throw new IllegalStateException();
    }
}

