/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.loader;

import com.apicatalog.jsonld.Document;
import com.apicatalog.jsonld.JsonLdException;
import com.apicatalog.jsonld.loader.DocumentLoader;
import com.apicatalog.jsonld.loader.FileLoader;
import com.apicatalog.tree.io.TreeIO;
import com.apicatalog.tree.io.TreeIOException;
import com.apicatalog.tree.io.TreeParser;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;

public final class ClasspathLoader
implements DocumentLoader {
    private final TreeParser parser;

    public ClasspathLoader(TreeParser reader) {
        this.parser = reader;
    }

    @Override
    public Document loadDocument(URI url, DocumentLoader.Options options) throws JsonLdException {
        Document document;
        block9: {
            if (!"classpath".equalsIgnoreCase(url.getScheme())) {
                throw new JsonLdException(JsonLdException.ErrorCode.LOADING_DOCUMENT_FAILED, "Unsupported URL scheme [" + url.getScheme() + "]. Only classpath: scheme is accepted.");
            }
            InputStream is = ClasspathLoader.class.getResourceAsStream(url.getPath());
            try {
                TreeIO node = this.parser.parse(is);
                document = Document.of(node, FileLoader.fromFileExtension(url.getPath()), url);
                if (is == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (TreeIOException | IOException e) {
                    throw new JsonLdException(JsonLdException.ErrorCode.LOADING_DOCUMENT_FAILED, e);
                }
            }
            is.close();
        }
        return document;
    }
}

