/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.framing;

import com.apicatalog.jsonld.Document;
import com.apicatalog.jsonld.JsonLdException;
import com.apicatalog.jsonld.Options;
import com.apicatalog.jsonld.framing.FrameMatcher;
import com.apicatalog.jsonld.framing.FramingState;
import com.apicatalog.jsonld.framing.ValuePatternMatcher;
import com.apicatalog.jsonld.lang.Embed;
import com.apicatalog.jsonld.lang.Keywords;
import com.apicatalog.jsonld.lang.LdAdapter;
import com.apicatalog.jsonld.processor.Execution;
import com.apicatalog.jsonld.processor.Expander;
import com.apicatalog.tree.io.TreeIO;
import com.apicatalog.web.uri.UriUtils;
import com.apicatalog.web.uri.UriValidationPolicy;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public final class Frame {
    public static final Frame EMPTY = new Frame(Map.of(), Set.of());
    private final Map<String, ?> expanded;
    private final Collection<String> frameGraphs;

    private Frame(Map<String, ?> expanded, Collection<String> frameGraphs) {
        this.expanded = expanded;
        this.frameGraphs = frameGraphs;
    }

    public static final Frame of(Document frame, Options options, Execution runtime) throws JsonLdException {
        return Frame.of(Expander.expandFrame(frame, Options.copyOf(options).ordered(false), runtime), Frame.keysOf(frame.content()));
    }

    public static final Frame of(TreeIO frame, Options options, Execution runtime) throws JsonLdException {
        return Frame.of(Expander.expandFrame(frame, Expander.context(null, null, options, runtime), Expander.baseUrl(null, options), Options.copyOf(options).ordered(false), runtime), Frame.keysOf(frame));
    }

    public static final URI contextBase(Document frame, Options options) {
        return frame.context() != null ? frame.url() : options.base();
    }

    static final Frame of(Object expanded) throws JsonLdException {
        return Frame.of(expanded, List.of());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static final Frame of(Object expanded, Collection<String> frameGraphs) throws JsonLdException {
        Map frameMap;
        if (expanded instanceof Collection) {
            Map map;
            Map typedMap;
            Object e;
            Collection array = (Collection)expanded;
            if (array.size() != 1 || !((e = array.iterator().next()) instanceof Map)) throw new JsonLdException(JsonLdException.ErrorCode.INVALID_FRAME, "Frame is not JSON object nor an array containing JSON object [" + String.valueOf(expanded) + "]");
            frameMap = typedMap = (map = (Map)e);
        } else if (expanded instanceof Map) {
            Map map;
            Map typedMap;
            frameMap = typedMap = (map = (Map)expanded);
        } else {
            if (expanded != null) throw new JsonLdException(JsonLdException.ErrorCode.INVALID_FRAME, "Frame is not JSON object. [" + String.valueOf(expanded) + "]");
            return EMPTY;
        }
        if (frameMap.containsKey("@id") && !Frame.validateFrameId(frameMap)) {
            throw new JsonLdException(JsonLdException.ErrorCode.INVALID_FRAME, "Frame @id value is not valid [@id = " + String.valueOf(frameMap.get("@id")) + "].");
        }
        if (!frameMap.containsKey("@type") || Frame.validateFrameType(frameMap)) return new Frame(frameMap, frameGraphs);
        throw new JsonLdException(JsonLdException.ErrorCode.INVALID_FRAME, "Frame @type value is not valid [@type = " + String.valueOf(frameMap.get("@type")) + "].");
    }

    public Embed getEmbed(Embed defaultValue) throws JsonLdException {
        if (this.expanded.containsKey("@embed")) {
            Map map;
            Object embed = this.expanded.get("@embed");
            if (embed == null) {
                return defaultValue;
            }
            if (embed instanceof Map && LdAdapter.isValueNode(map = (Map)embed)) {
                embed = LdAdapter.findValue(embed).orElseThrow(() -> new JsonLdException(JsonLdException.ErrorCode.INVALID_KEYWORD_EMBED_VALUE));
            }
            if (embed instanceof String) {
                String stringValue = (String)embed;
                if (Keywords.noneMatch(stringValue, "@always", "@once", "@never")) {
                    throw new JsonLdException(JsonLdException.ErrorCode.INVALID_KEYWORD_EMBED_VALUE, "The value for @embed is not one recognized for the object embed flag [@embed = " + stringValue + "].");
                }
                return Embed.valueOf(stringValue.substring(1).toUpperCase());
            }
            if (Boolean.FALSE.equals(embed)) {
                return Embed.NEVER;
            }
            if (Boolean.TRUE.equals(embed)) {
                return Embed.ONCE;
            }
            throw new JsonLdException(JsonLdException.ErrorCode.INVALID_KEYWORD_EMBED_VALUE, "The value for @embed is not one recognized for the object embed flag [@embed = " + String.valueOf(embed) + "].");
        }
        return defaultValue;
    }

    public boolean isExplicit(boolean defaultValue) throws JsonLdException {
        return Frame.getBoolean(this.expanded, "@explicit", defaultValue);
    }

    public boolean isRequireAll(boolean defaultValue) throws JsonLdException {
        return Frame.getBoolean(this.expanded, "@requireAll", defaultValue);
    }

    public static final boolean getBoolean(Map<?, ?> frame, String key, boolean defaultValue) throws JsonLdException {
        if (frame.containsKey(key)) {
            Object bool;
            Map map;
            Object value = frame.get(key);
            if (value == null) {
                return defaultValue;
            }
            if (value instanceof Map && LdAdapter.isValueNode(map = (Map)value)) {
                value = LdAdapter.findValue(value).orElseThrow(() -> new JsonLdException(JsonLdException.ErrorCode.INVALID_FRAME));
            }
            if (value instanceof String) {
                bool = (String)value;
                if ("true".equalsIgnoreCase((String)bool)) {
                    return true;
                }
                if ("false".equalsIgnoreCase((String)bool)) {
                    return false;
                }
            }
            if (value instanceof Boolean) {
                bool = (Boolean)value;
                return (Boolean)bool;
            }
            throw new JsonLdException(JsonLdException.ErrorCode.INVALID_FRAME);
        }
        return defaultValue;
    }

    private static final boolean validateFrameId(Map<?, ?> frame) {
        String uri;
        Collection idArray;
        Object id = frame.get("@id");
        if (id instanceof Collection && !(idArray = (Collection)id).isEmpty()) {
            Map map;
            Object e;
            return idArray.size() == 1 && (e = idArray.iterator().next()) instanceof Map && (map = (Map)e).isEmpty() || idArray.stream().noneMatch(item -> {
                String uri;
                return !(item instanceof String) || UriUtils.isNotAbsoluteUri(uri = (String)item, UriValidationPolicy.Full);
            });
        }
        return id instanceof String && UriUtils.isAbsoluteUri(uri = (String)id, UriValidationPolicy.Full);
    }

    private static final boolean validateFrameType(Map<?, ?> frame) {
        String stringType;
        Map map;
        Collection array;
        Collection typeArray;
        Object type = frame.get("@type");
        if (type instanceof Collection && !(typeArray = (Collection)type).isEmpty()) {
            Map map2;
            Object e;
            return typeArray.size() == 1 && (e = typeArray.iterator().next()) instanceof Map && ((map2 = (Map)e).isEmpty() || map2.containsKey("@default")) || typeArray.stream().noneMatch(item -> {
                String uri;
                return !(item instanceof String) || UriUtils.isNotAbsoluteUri(uri = (String)item, UriValidationPolicy.Full);
            });
        }
        return type instanceof Collection && (array = (Collection)type).isEmpty() || type instanceof Map && (map = (Map)type).isEmpty() || type instanceof String && ("@json".equals(stringType = (String)type) || UriUtils.isAbsoluteUri(stringType, UriValidationPolicy.Full));
    }

    public Set<String> keys() {
        return this.expanded.keySet();
    }

    public Object get(String property) {
        return this.expanded.get(property);
    }

    public boolean contains(String property) {
        return this.expanded.containsKey(property);
    }

    public boolean containsOnly(String property) {
        return this.expanded.containsKey(property) && ValuePatternMatcher.isWildcard(this.expanded, property);
    }

    public boolean isWildCard() {
        return ValuePatternMatcher.isWildcard(this.expanded, new String[0]);
    }

    public boolean isWildCard(String property) {
        return this.expanded.containsKey(property) && ValuePatternMatcher.isWildcard(this.expanded.get(property), new String[0]);
    }

    public boolean isNone(String property) {
        return this.expanded.containsKey(property) && ValuePatternMatcher.isNone(this.expanded.get(property));
    }

    public Collection<?> asCollection(String property) {
        Collection<Object> collection;
        Object value = this.expanded.get(property);
        if (value instanceof Collection) {
            Collection col = (Collection)value;
            collection = col;
        } else {
            collection = value != null ? List.of(value) : List.of();
        }
        return collection;
    }

    public String toString() {
        return this.expanded.toString();
    }

    public boolean isValuePattern() {
        return LdAdapter.isValueNode(this.expanded);
    }

    public boolean matchValue(Object value) {
        Map map;
        return value instanceof Map && ValuePatternMatcher.match(this.expanded, map = (Map)value);
    }

    public boolean isDefaultObject(String property) {
        Collection array;
        Object obj;
        return LdAdapter.isDefault(this.expanded.get(property)) || (obj = this.expanded.get(property)) instanceof Collection && (array = (Collection)obj).size() == 1 && LdAdapter.isDefault(array.iterator().next());
    }

    public boolean isPattern() {
        return LdAdapter.isNode(this.expanded);
    }

    public boolean isReference() {
        return LdAdapter.isReference(this.expanded);
    }

    public boolean matchNode(FramingState state, Object value, boolean requireAll) throws JsonLdException {
        Map map;
        if (value instanceof Map && (map = (Map)value).containsKey("@id")) {
            Optional<Map> valueObject = state.getGraphMap().find(state.getGraphName()).map(graph -> (Map)graph.get((String)map.get("@id")));
            return valueObject.isPresent() && FrameMatcher.with(state, this, requireAll).match(valueObject.get());
        }
        return false;
    }

    public boolean isList() {
        return LdAdapter.isList(this.expanded);
    }

    public boolean isDefault(String graphKey) {
        for (String key : this.frameGraphs) {
            if (!key.equals(graphKey)) continue;
            return true;
        }
        return false;
    }

    private static Collection<String> keysOf(TreeIO frame) {
        return frame.isMap() ? frame.keyStream().map(String.class::cast).toList() : List.of();
    }
}

